/**
 * \file
 * <!--
 * This file is part of BeRTOS.
 *
 * Bertos is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 * As a special exception, you may use this file as part of a free software
 * library without restriction.  Specifically, if other files instantiate
 * templates or use macros or inline functions from this file, or you compile
 * this file and link it with other files to produce an executable, this
 * file does not by itself cause the resulting executable to be covered by
 * the GNU General Public License.  This exception does not however
 * invalidate any other reasons why the executable file might be covered by
 * the GNU General Public License.
 *
 * Copyright 2009 Develer S.r.l. (http://www.develer.com/)
 *
 * -->
 *
 * \brief NMEA parser test.
 *
 * \author Daniele Basile <asterix@develer.com>
 *
 * notest:avr
 */

#include "nmea.h"

#include <struct/kfile_mem.h>

#include <cfg/debug.h>
#define LOG_LEVEL  3
#define LOG_FORMAT NMEA_LOG_FORMAT
#include <cfg/log.h>

#include <cfg/test.h>

#include <string.h> //strncmp

static nmeap_context_t nmea;	   /* parser context */
static NmeaRmc rmc;
static NmeaGga gga;
static NmeaGsv gsv;
static NmeaVtg vtg;

static KFileMem mem;

static uint8_t nmea_test[] =
{
/* For these first sentences, we have a test_vector */
"$GPRMC,170525.949,A,4351.0843,N,01108.8687,E,0.00,237.67,051009,,,A*61\r\n"      /* acquired */
"$GPVTG,237.67,T,,,0.00,N,0.00,K,A*77\r\n"                                        /* acquired */
"$GPGSV,3,1,09,3,78,302,37,6,87,031,,7,05,292,37,14,05,135,*48\r\n"               /* acquired */
"$GPGGA,170527.949,4351.0842,N,01108.8685,E,1,05,02.6,57.4,M,45.2,M,,*5C\r\n"     /* acquired */
"$GPGGA,170527.949,4351.0842,N,01108.8685,E,1,05,02.6,-57.4,M,45.2,M,,*71\r\n"    /* acquired */
"$GPGGA,170527.949,4351.0842,S,01108.8685,W,1,05,02.6,-57.4,M,-45.2,M,,*53\r\n"

"$GPGGA,100019.604,4351.1480,N,01108.8750,E,1,03,16.8,0.0,M,45.2,M,,*64\r\n"
"$GPRMC,100019.604,A,4351.1480,N,01108.8750,E,2.03,134.29,131009,,,A*6F\r\n"
"$GPVTG,134.29,T,,,2.03,N,3.75,K,A*7D\r\n"
"$GPGGA,100020.604,4351.1491,N,01108.8751,E,1,03,16.8,0.0,M,45.2,M,,*6F\r\n"
"$GPGSA,A,2,09,27,29,,,,,,,,,,16.8,16.8,0.0*34\r\n"
"$GPGSV,3,1,09,2,34,087,,4,20,052,,9,32,142,31,14,38,267,*49\r\n"
"$GPGSV,3,2,09,26,35,232,,27,25,143,34,29,42,214,35,30,68,313,*73\r\n"
"$GPGSV,3,3,09,31,09,314,,,,,,,,,,,,,*4D\r\n"
"$GPRMC,100020.604,A,4351.1491,N,01108.8751,E,2.11,134.29,131009,,,A*67\r\n"
"$GPVTG,134.29,T,,,2.11,N,3.91,K,A*74\r\n"
"$GPGGA,100021.603,4351.1486,N,01108.8751,E,1,03,16.8,0.0,M,45.2,M,,*6F\r\n"
"$GPRMC,100021.603,A,4351.1486,N,01108.8751,E,2.18,134.29,131009,,,A*6E\r\n"
"$GPVTG,134.29,T,,,2.18,N,4.05,K,A*77\r\n"
"$GPGGA,100022.603,4351.1470,N,01108.8750,E,1,03,16.8,0.0,M,45.2,M,,*64\r\n"
"$GPRMC,100022.603,A,4351.1470,N,01108.8750,E,2.17,134.29,131009,,,A*6A\r\n"
"$GPVTG,134.29,T,,,2.17,N,4.01,K,A*7C\r\n"
"$GPGGA,100023.603,4351.1453,N,01108.8747,E,1,03,16.8,0.0,M,45.2,M,,*62\r\n"
"$GPGSA,A,2,09,27,29,,,,,,,,,,16.8,16.8,0.0*34\r\n"
"$GPGSV,3,1,09,2,34,087,,4,20,052,,9,32,142,31,14,38,267,*49\r\n"
"$GPGSV,3,2,09,26,35,232,,27,25,143,33,29,42,214,36,30,68,313,*77\r\n"
"$GPGSV,3,3,09,31,09,314,,,,,,,,,,,,,*4D\r\n"
"$GPRMC,100023.603,A,4351.1453,N,01108.8747,E,2.28,134.29,131009,,,A*60\r\n"
"$GPVTG,134.29,T,,,2.28,N,4.22,K,A*71\r\n"
"$GPGGA,100024.603,4351.1450,N,01108.8746,E,1,03,16.8,0.0,M,45.2,M,,*67\r\n"
"$GPRMC,100024.603,A,4351.1450,N,01108.8746,E,2.28,134.29,131009,,,A*65\r\n"
"$GPVTG,134.29,T,,,2.28,N,4.22,K,A*71\r\n$GPGG25.603,4351.1442,N,01108.8745,E,1,03,16.8,0.0,M,45.2,M,,*66\n"
"$GPRMC,100025.603,A,4351.1442,N,01108.8745,E,2.40,134.29,131009,,,A*6A\r\n"
"$GPVTG,134.29,T,,,2.40,N,4.45,K,A*7E\r\n"
"$GPGGA,100026.602,4351.1433,N,01108.8744,E,1,03,16.8,0.0,M,45.2,M,,*63\r\n"
"$GPGSA,A,2,09,27,29,,,,,,,,,,16.8,16.8,0.0*34\r\n"
"$GPGSV,3,1,09,2,34,087,,4,20,052,,9,32,142,31,14,38,267,*49\r\n"
"$GPGSV,3,2,09,26,35,232,,27,25,143,33,29,42,214,36,30,68,313,*77\r\n"
"$GPGSV,3,3,09,31,09,314,,,,,,,,,,,,,*4D\r\n"
"$GPRMC,100026.602,A,4351.1433,N,01108.8744,E,2.48,187.14,131009,,,A*61\r\n"
"$GPVTG,187.14,T,,,2.48,N,4.59,K,A*7D\r\n"
"$GPGGA,100027.602,4351.1425,N,01108.8743,E,1,03,16.8,0.0,M,45.2,M,,*62\r\n"
"$GPRMC,100027.602,A,4351.1425,N,01108.8743,E,2.39,185.89,131009,,,A*60\r\n"
"$GPVTG,185.89,T,,,2.39,N,4.42,K,A*77\r\n"
"$GPGGA,100028.602,4351.1424,N,01108.8743,E,1,03,16.8,0.0,M,45.2,M,,*6C\r\n"
"$GPRMC,100028.602,A,4351.1424,N,01108.8743,E,2.18,187.33,131009,,,A*6E\r\n"
"$GPVTG,187.33,T,,,2.18,N,4.04,K,A*75\r\n"
"$GPGGA,100029.602,4351.1399,N,01108.8739,E,1,03,16.8,0.0,M,45.2,M,,*61\r\n"
"$GPGSA,A,2,09,27,29,,,,,,,,,,16.8,16.8,0.0*34\r\n"
"$GPGSV,3,1,09,2,34,087,,4,20,052,,9,32,142,31,14,38,267,*49\r\n"
"$GPGSV,3,2,09,26,35,232,,27,25,143,34,29,42,214,35,30,68,313,*73\r\n"
"$GPGSV,3,3,09,31,09,314,,,,,,,,,,,,,*4D\r\n"
"$GPRMC,100029.602,A,4351.1399,N,01108.8739,E,1.98,188.78,131009,,,A*68\r\n"
"$GPVTG,188.78,T,,,1.98,N,3.67,K,A*7C\r\n"
"$GPGGA,100030.602,4351.1393,N,01108.8738,E,1,03,16.8,0.0,M,45.2,M,,*6ds2\r\n"
"$GPRMC,100030.602,A,4351.1393,N,01108.8738,E,1.90,188.62,131009,,,A*68\r\n"
"$GPVTG,188.62,T,,,1.90,N,3.53,K,A*78\r\n"
"$GPGGA,100031.601,4351.1389,N,01108.8737,E,1,03,16.8,0.0,M,45.2,M,,*64\r\n"
"$GPRMC,100031.601,A,adfsd4351.1389,N,01108.8737,E,1.82,188.25,131009,,,A*6E\r\n"
"$GPVTG,188.25,T,,,1.82,N,3.37,K,A*7A\r"
"$GadafPGGA,100032.601,4351.1384,N,01108.8737,E,1,03,16.8,0.0,M,45.2,M,,*6A\r\n"
"$GPGSA,A,2,09,27,29,,,,,,,,,,16.8,16.8,0.0*34\r\n"
"$GPGSV,3,1,09,2,34,087,,4,20,052,,9,32,142,30,14,38,267,*48\r\n"
"$GPGSV,3,2,09,26,35,232,,27,25,143,33,29,42,214,35,30,68,313,*74\r\n"
"$GPGSV,3,3,09,31,09,314,,,,,,,,,,,,,*4D\r\n"
"$GPRMC,100032.601,A,4351.1384,N,01108.8737,E,1.76,187.49,131009,,,A*6E\r\n"
"$GPVTG,187.49,T,,,1.76,N,3.27,K,A*75\r\n"
"$GPGGA,100033.601,4351.1379,N,01108.8735,E,1,02,16.8,0.0,M,45.2,M,,*6A\r\n"
"$GPRMC,100033.601,A,4351.1379,N,01108.8735,E,1.72,187.49,131009,,,A*6B\r\n"
"$GPVTG,187.49,T,,,1.72,N,3.18,K,A*7D\r\n"
"$GPGGA,100034.601,4351.1376,N,01108.8735,E,1,03,16.8,0.0,M,45.2,M,,*63\r\n"
"$GPRMC,100034.601,A,4351.1376,N,01108.8735,E,1.49,187.49,131009,,,A*6B\r\n"
"$GPVTG,187.49,T,,,1.49,N,2.76,K,A*7C\r\n"
"$GPGGA,100035.600,4351.1374,N,01108.8735,E,1,03,16.8,0.0,M,45.2,M,,*61\r\n"
"$GPGSA,A,2,09,27,29,,,,,,,,,,16.8,16.8,0.0*34\r\n"
"$GPGSV,3,1,09,2,34,087,,4,20,052,,9,32,142,30,14,38,267,*48\r\n"
"$GPGSV,3,2,09,26,35,232,,27,25,143,33,29,42,214,36,30,68,313,*77\r\n"
"$GPGSV,3,3,09,31,09,314,,,,,,,,,,,,,*4D\r\n"
"$GPRMC,100035.600,A,4351.1374,N,01108.8735,E,1.22,187.49,131009,,,A*64\r\n"
"$GPVTG,187.49,T,,,1.22,N,2.26,K,A*74\r\n"
"$GPGGA,100036.600,4351.1374,N,01108.8736,E,1,03,16.8,0.0,M,45.2,M,,*61\r\n"
"$GPRMC,100036.600,A,4351.1374,N,01108.8736,E,0.00,187.49,131009,,,A*65\r\n"
"$GPVTG,187.49,T,,,0.00,N,0.00,K,A*73\r\n"
"$GPGGA,100037.600,4351.1373,N,01108.8734,E,1,03,16.8,-0.0,M,45.2,M,,*48\r\n"
"$GPRMC,100037.600,A,4351.1373,N,01108.8734,E,0.00,187.49,131009,,,A*61\r\n"
"$GPVTG,187.49,T,,,0.00,N,0.00,K,A*73\r\n"
"$GPGGA,100038.600,4351.1371,N,01108.8734,E,1,03,16.8,-0.0,M,45.2,M,,*45\r\n"
"$GPGSA,A,2,09,27,29,,,,,,,,,,16.8,16.8,0.0*34\r\n"
"$GPGSV,3,1,09,2,34,087,,4,20,052,,9,32,142,30,14,38,267,*48\r\n"
"$GPGSV,3,2,09,26,35,232,,27,25,143,34,29,42,214,36,30,68,313,*70\r\n"
"$GPGSV,3,3,09,31,09,314,,,,,,,,,,,,,*4D\r\n"
"$GPRMC,100038.600,A,4351.1371,N,01108.8734,E,0.00,187.49,131009,,,A*6C\r\n"
"$GPVTG,187.49,T,,,0.00,N,0.00,K,A*73\r\n"
"$GPGGA,100039.600,4351.1370,N,01108.8734,E,1,03,16.8,-0.0,M,45.2,M,,*45\r\n"
"$GPRMC,100039.600,A,4351.1370,N,01108.8734,E,0.00,187.49,131009,,,A*6C\r\n"
"$GPVTG,187.49,T,,,0.00,N,0.00,K,A*73\r\n"
"$GPGGA,100040.599,4351.1368,N,01108.8733,E,1,03,16.8,-0.0,M,45.2,M,,*46\r\n"
"$GPRMC,100040.599,A,4351.1368,N,01108.8733,E,0.00,187.49,131009,,,A*6F\r\n"
"$GPVTG,187.49,T,,,0.00,N,0.00,K,A*73\r\n"
"$GPGGA,100041.599,4351.1367,N,01108.8733,E,1,03,16.8,-0.0,M,45.2,M,,*48\r\n"
"$GPGSA,A,2,09,27,29,,,,,,,,,,16.8,16.8,0.0*34\r\n"
"$GPGSV,3,1,09,2,34,087,,4,20,052,,9,32,142,30,14,38,267,*48\r\n"
"$GPGSV,3,2,09,26,35,232,,27,25,143,34,29,42,214,36,30,68,313,30*73\r\n"
"$GPGSV,3,3,09,31,09,314,,,,,,,,,,,,,*4D\r\n"
"$GPRMC,100041.599,A,4351.1367,N,01108.8733,E,1.04,187.49,131009,,,A*64\r\n"
"$GPVTG,187.49,T,,,1.04,N,1.93,K,A*7D\r\n"
"$GPGGA,100042.599,4351.1365,N,01108.8732,E,1,03,16.8,-0.0,M,45.2,M,,*48\r\n"
"$GPRMC,100042.599,A,4351.1365,N,01108.8732,E,1.10,187.49,131009,,,A*61\r\n"
"$GPVTG,187.49,T,,,1.10,N,2.04,K,A*75\r\n"
"$GPGGA,100043.599,4351.1361,N,01108.ad2,E,1,03,16.8,-0.0,M,45.2,M,,*4D\r\n"
"$GPRMC,100043.599,A,4351.1361,N,01108.8732,E,1.12,187.49,131009,,,A*66\r\n"
"$GPVTG,187.49,T,,,1.12,N,2.07,K,A*74\r\n"
"$GPGGA,100044.599,4351.1358,N,01108.8732,E,1,03,16.8,-0.0,M,45.2,M,,*40\r\n"
"$GPGSA,A,2,09,27,29,,,,,,,,,,16.8,16.8,0.0*34\r\n"
"$GPGSV,3,1,09,2,34,087,,4,20,052,,9,32,142,30,14,38,267,*48\r\n"
"$GPGSV,3,2,09,26,35,232,,27,25,143,34,29,42,214,36,30,68,313,30*73\r\n"
"$GPGSV,3,3,09,31,09,314,,,,,,,,,,,,,*4D\r\n"
"$GPRMC,100044.599,A,4351.1358,N,01108.8732,E,1.06,187.49,131009,,,A*6E\r\n"
"$GPVTG,187.49,T,,,1.06,N,1.95,K,A*79\r\n"
"$GPGGA,100045.598,4351.1357,N,01108.8731,E,1,03,16.8,-0.0,M,45.2,M,,*4C\r\n"
"$GPRMC,100045.598,A,4351.1357,N,01108.8731,E,0.00,187.49,131009,,,A*65\r\n"
"$GPVTG,187.49,T,,,0.00,N,0.00,K,A*73\r\n"
"$GPGGA,100046.598,4351.1356,N,01108.8731,E,1,03,16.8,-0.0,M,45.2,M,,*4E\r\n"
"$GPRMC,100046.598,A,4351.1356,N,01108.8731,E,0.00,187.49,131009,,,A*67\r\n"
"$GPVTG,187.49,T,,,0.00,N,0.00,K,A*73\r\n"
"$GPGGA,100047.598,4351.1356,N,01108.8731,E,1,03,16.8,-0.0,M,45.2,M,,*4F\r\n"
"$GPGSA,A,2,09,27,29,,,,,,,,,,16.8,16.8,0.0*34\r\n"
"$GPGSV,3,1,09,2,34,087,,4,20,052,,9,32,143,29,14,38,267,*41\r\n"
"$GPGSV,3,2,09,26,35,232,,27,25,143,34,29,42,214,36,30,68,313,30*73\r\n"
"$GPGSV,3,3,09,31,09,314,,,,,,,,,,,,,*4D\r\n"
"$GPRMC,"
"$GPVTG,187.49,T,,,0.00,N,0.00,K,A*73\r\n"
"$GPGGA,100048.598,4351.1355,N,01108.8732,E,1,03,16.8,-0.0,M,45.2,M,,*40\r\n"
"$GPRMC,100048.598,A,4351.1355,N,01108.8732,E,0.00,187.49,131009,,,A*69\r\n"
"$GPVTG,187.49,T,,,0.00,N,0.00,K,A*73\r\n"
"$GPGGA,100049.597,4351.1356,N,01108.8731,E,1,03,16.9,-0.0,M,45.2,M,,*4F\r\n"
"$GPRMC,100049.597,A,4351.1356,N,01108.8731,E,0.00,187.49,131009,,,A*67\r\n"
"$GPVTG,187.49,T,,,0.00,N,0.00,K,A*73\r\n"
"$GPGGA,100050.597,4351.1354,N,01108.8732,E,1,03,16.9,-0.0,M,45.2,M,,*46\r\n"
"$GPGSA,A,2,09,27,29,,,,,,,,,,16.9,16.9,0.0*34\r\n"
"$GPGSV,3,1,09,2,34,087,,4,20,052,,9,32,143,29,14,38,266,*40\r\n"
"$GPGSV,3,2,09,26,35,232,,27,25,143,34,29,42,214,35,30,69,313,30*71\r\n"
"$GPGSV,3,3,09,31,10,314,,,,,,,,,,,,,*45\r\n"
"$GPRMC,100050.597,A,4351.1354,N,01108.8732,E,0.00,187.49,131009,,,A*6E\r\n"
"$GPVTG,187.49,T,,,0.00,N,0.00,K,A*73\r\n"
"$GPGGA,100051.597,4351.1354,N,01108.8731,E,1,03,16.9,-0.0,M,45.2,M,,*44\r\n"
"$GPRMC,100051.597,A,4351.1354,N,01108.8731,E,0.00,187.49,131009,,,A*6C\r\n"
"$GPVTG,187.49,T,,,0.00,N,0.00,K,A*73\r\n"
"$GPGGA,100052.597,4351.1353,N,01108.8731,E,1,03,16.9,-0.0,M,45.2,M,,*40\r\n"
"$GPRMC,100052.597,A,4351.1353,N,01108.8731,E,0.00,187.49,131009,,,A*68\r\n"
"$GPVTG,187.49,T,,,0.00,N,0.00,K,A*73\r\n"
"$GPGGA,100053.597,4351.1352,N,01108.8731,E,1,03,16.9,-0.0,M,45.2,M,,*40\r\n"
"$GPGSA,A,2,09,27,29,,,,,,,,,,16.9,16.9,0.0*34\r\n"
"$GPGSV,3,1,09,2,34,087,,4,20,052,,9,32,143,29,14,38,266,*40\r\n"
"$GPGSV,3,2,09,26,35,232,,27,25,143,34,29,42,214,35,30,69,313,30*71\r\n"
"$GPGSV,3,3,09,31,10,314,,,,,,,,,,,,,*45\r\n"
"$GPRMC,100053.597,A,4351.1352,N,01108.8731,E,0.00,187.49,131009,,,A*68\r\n"
"$GPVTG,187.49,T,,,0.00,N,0.00,K,A*73\r\n"
"$GPGGA,100054.596,4351.1351,N,01108.8730,E,1,03,16.9,-0.0,M,45.2,M,,*44\r\n"
"$GPRMC,100054.596,A,4351.1351,N,01108.8730,E,0.00,187.49,131009,,,A*6C\r\n"
"$GPVTG,187.49,T,,,0.00,N,0.00,K,A*73\r\n"
"$GPGGA,100055.596,4351.1349,N,01108.8731,E,1,03,16.9,-0.0,M,45.2,M,,*4D\r\n"
"$GPRMC,100055.596,A,4351.1349,N,01108.8731,E,0.00,187.49,131009,,,A*65\r\n"
"$GPVTG,187.49,T,,,0.00,N,0.00,K,A*73\r\n"
"$GPGGA,100056.596,4351.1347,N,01108.8730,E,1,03,16.9,-0.0,M,45.2,M,,*41\r\n"
"$GPGSA,A,2,09,27,29,,,,,,,,,,16.9,16.9,0.0*34\r\n"
"$GPGSV,3,1,09,2,34,087,,4,20,052,,9,32,143,29,14,38,266,*40\r\n"
"$GPGSV,3,2,09,26,35,232,,27,25,143,34,29,42,214,35,30,69,313,30*71\r\n"
"$GPGSV,3,3,09,31,10,314,,,,,,,,,,,,,*45\r\n"
"$GPRMC,100056.596,A,4351.1347,N,01108.8730,E,0.00,187.49,131009,,,A*69\r\n"
"$GPVTG,187.49,T,,,0.00,N,0.00,K,A*73\r\n"
"$GPGGA,100057.596,4351.1344,N,01108.8729,E,1,03,16.9,-0.0,M,45.2,M,,*4B\r\n"
"$GPRMC,100057.596,A,4351.1344,N,01108.8729,E,0.00,187.49,131009,,,A*63\r\n"
"$GPVTG,187.49,T,,,0.00,N,0.00,K,A*73\r\n"
"$GPGGA,100058.595,4351.1343,N,01108.8730,E,1,03,16.9,-0.0,M,45.2,M,,*48\r\n"
"$GPRMC,100058.595,A,4351.1343,N,01108.8730,E,1.01,187.49,131009,,,A*60\r\n"
"$GPVTG,187.49,T,,,1.01,N,1.86,K,A*7C\r\n"
"$GPGGA,100059.595,4351.1341,N,01108.8729,E,1,03,16.9,0.0,M,45.2,M,,*6E\r\n"
"$GPGSA,A,2,09,27,29,,,,,,,,,,16.9,16.9,0.0*34\r\n"
"$GPGSV,3,1,09,2,34,087,,4,20,052,,9,31,143,30,14,38,266,*4B\r\n"
"$GPGSV,3,2,09,26,35,232,,27,25,143,34,29,42,214,36,30,69,313,30*72\r\n"
"$GPGSV,3,3,09,31,10,314,,,,,,,,,,,,,*45\r\n"
"$GPRMC,100059.595,A,4351.1341,N,01108.8729,E,1.28,187.49,131009,,,A*60\r\n"
"$GPVTG,187.49,T,,,1.28,N,2.37,K,A*7E\r\n"
"$GPGGA,100100.595,4351.1337,N,01108.8728,E,1,03,16.9,0.0,M,45.2,M,,*63\r\n"
"$GPRMC,100100.595,A,4351.1337,N,01108.8728,E,1.38,187.49,131009,,,A*6C\r\n"
"$GPVTG,187.49,T,,,1.38,N,2.55,K,A*7B\r\n"
"$GPGGA,100101.595,4351.1334,N,01108.8728,E,1,03,16.9,0.0,M,45.2,M,,*61\r\n"
"$GPRMC,100101.595,A,4351.1334,N,01108.8728,E,1.51,187.49,131009,,,A*61\r\n"
"$GPVTG,187.49,T,,,1.51,N,2.79,K,A*7A\r\n"
"$GPGGA,100102.595,4351.1331,N,01108.8727,E,1,03,16.9,0.0,M,45.2,M,,*68\r\n"
"$GPGSA,A,2,09,27,29,,,,,,,,,,16.9,16.9,0.0*34\r\n"
"$GPGSV,3,1,10,2,34,086,,4,20,052,,9,31,143,30,12,62,057,*4B\r\n"
"$GPGSV,3,2,10,14,38,266,,26,35,232,,27,25,143,34,29,42,214,35*7B\r\n"
"$GPGSV,3,3,10,30,69,313,30,31,10,314,,,,,,,,,*73\r\n"
"$GPRMC,100102.595,A,4351.1331,N,01108.8727,E,1.57,187.49,131009,,,A*6E\r\n"
"$GPVTG,187.49,T,,,1.57,N,2.91,K,A*7A\r\n"
"$GPGGA,100103.594,4351.1328,N,01108.8727,E,1,03,16.9,0.0,M,45.2,M,,*60\r\n"
"$GPRMC,100103.594,A,4351.1328,N,01108.8727,E,1.54,187.49,131009,,,A*65\r\n"
"$GPVTG,187.49,T,,,1.54,N,2.86,K,A*7F\r\n"
"$GPGGA,100104.594,4351.1326,N,01108.8727,E,1,03,16.9,0.0,M,45.2,M,,*69\r\n"
"$GPRMC,100104.594,A,4351.1326,N,01108.8727,E,1.38,187.49,131009,,,A*66\r\n"
"$GPVTG,187.49,T,,,1.38,N,2.56,K,A*78\r\n"
"$GPGGA,100105.594,4351.1322,N,01108.8726,E,1,03,16.9,0.0,M,45.2,M,,*6D\r\n"
"$GPGSA,A,2,09,27,29,,,,,,,,,,16.9,16.9,0.0*34\r\n"
"$GPGSV,3,1,10,2,34,086,,4,20,052,,9,31,143,29,12,62,057,*43\r\n"
"$GPGSV,3,2,10,14,38,266,,26,35,232,,27,25,143,34,29,42,214,36*78\r\n"
"$GPGSV,3,3,10,30,69,313,30,31,10,314,,,,,,,,,*73\r\n"
"$GPRMC,100105.594,A,4351.1322,N,01108.8726,E,1.36,187.49,131009,,,A*6C\r\n"
"$GPVTG,187.49,T,,,1.36,N,2.53,K,A*73\r\n"
"$GPGGA,100106.594,4351.1318,N,01108.8726,E,1,03,16.9,0.0,M,45.2,M,,*67\r\n"
"$GPRMC,100106.594,A,4351.1318,N,01108.8726,E,1.47,187.49,131009,,,A*60\r\n"
"$GPVTG,187.49,T,,,1.47,N,2.73,K,A*77\r\n"
"$GPGGA,100107.594,4351.1313,N,01108.8725,E,1,03,16.9,0.0,M,45.2,M,,*6E\r\n"
"$GPRMC,100107.594,A,4351.1313,N,01108.8725,E,1.64,187.49,131009,,,A*68\r\n"
"$GPVTG,187.49,T,,,1.64,N,3.03,K,A*70\r\n"
"$GPGGA,100108.593,4351.1310,N,01108.8724,E,1,03,16.9,0.0,M,45.2,M,,*64\r\n"
"$GPGSA,A,2,09,27,29,,,,,,,,,,16.9,16.9,0.0*34\r\n"
"$GPGSV,3,1,10,2,34,086,,4,20,052,,9,31,143,29,12,62,057,*43\r\n"
"$GPGSV,3,2,10,14,38,266,,26,35,232,,27,25,143,34,29,42,214,36*78\r\n"
"$GPGSV,3,3,10,30,69,313,30,31,10,314,,,,,,,,,*73\r\n"
"$GPRMC,100108.593,A,4351.1310,N,01108.8724,E,1.66,187.49,131009,,,A*60\r\n"
"$GPVTG,187.49,T,,,1.66,N,3.07,K,A*76\r\n"
"$GPGGA,100109.593,4351.1304,N,01108.8723,E,1,03,16.9,0.0,M,45.2,M,,*67\r\n"
"$GPRMC,100109.593,A,4351.1304,N,01108.8723,E,1.72,187.49,131009,,,A*66\r\n"
"$GPVTG,187.49,T,,,1.72,N,3.18,K,A*7D\r\n"
"$GPGGA,100110.593,4351.1301,N,01108.8722,E,1,03,16.9,0.0,M,45.2,M,,*6B\r\n"
"$GPRMC,100110.593,A,4351.1301,N,01108.8722,E,1.72,187.49,131009,,,A*6A\r\n"
"$GPVTG,187.49,T,,,1.72,N,3.18,K,A*7D\r\n"
"$GPGGA,100111.593,4351.1297,N,01108.8722,E,1,03,16.9,0.0,M,45.2,M,,*64\r\n"
"$GPGSA,A,2,09,27,29,,,,,,,,,,16.9,16.9,0.0*34\r\n"
"$GPGSV,3,1,10,2,34,086,,4,20,052,,9,31,143,29,12,62,057,*43\r\n"
"$GPGSV,3,2,10,14,38,266,,26,35,231,,27,25,143,34,29,42,214,35*78\r\n"
"$GPGSV,3,3,10,30,69,313,30,31,10,314,,,,,,,,,*73\r\n"
"$GPRMC,100111.593,A,4351.1297,N,01108.8722,E,1.65,187.49,131009,,,A*63\r\n"
"$GPVTG,187.49,T,,,1.65,N,3.05,K,A*77\r\n"
"$GPGGA,100112.592,4351.1295,N,01108.8722,E,1,03,16.9,0.0,M,45.2,M,,*64\r\n"
"$GPRMC,100112.592,A,4351.1295,N,01108.8722,E,1.50,187.49,131009,,,A*65\r\n"
"$GPVTG,187.49,T,,,1.50,N,2.78,K,A*7A\r\n"
"$GPGGA,100113.592,4351.1291,N,01108.8721,E,1,03,16.9,0.0,M,45.2,M,,*62\r\n"
"$GPRMC,100113.592,A,4351.1291,N,01108.8721,E,1.38,187.49,131009,,,A*6D\r\n"
"$GPVTG,187.49,T,,,1.38,N,2.55,K,A*7B\r\n"
"$GPGGA,100114.592,4351.1288,N,01108.8721,E,1,03,16.9,0.0,M,45.2,M,,*6D\r\n"
"$GPGSA,A,2,09,27,29,,,,,,,,,,16.9,16.9,0.0*34\r\n"
"$GPGSV,3,1,10,2,34,086,,4,20,052,,9,31,143,29,12,62,057,*43\r\n"
"$GPGSV,3,2,10,14,38,266,,26,35,231,,27,25,143,34,29,43,214,35*79\r\n"
"$GPGSV,3,3,10,30,69,313,30,31,10,314,,,,,,,,,*73\r\n"
"$GPRMC,100114.592,A,4351.1288,N,01108.8721,E,1.24,187.49,131009,,,A*6F\r\n"
"$GPVTG,187.49,T,,,1.24,N,2.29,K,A*7D\r\n"
"$GPGGA,100115.592,4351.1285,N,01108.8719,E,1,03,16.9,0.0,M,45.2,M,,*6A\r\n"
"$GPRMC,100115.592,A,4351.1285,N,01108.8719,E,1.01,187.49,131009,,,A*6F\r\n"
"$GPVTG,187.49,T,,,1.01,N,1.87,K,A*7D\r\n"
"$GPGGA,100116.592,4351.1283,N,01108.8719,E,1,03,16.9,0.0,M,45.2,M,,*6F\r\n"
"$GPRMC,100116.592,A,4351.1283,N,01108.8719,E,0.00,187.49,131009,,,A*6A\r\n"
"$GPVTG,187.49,T,,,0.00,N,0.00,K,A*73\r\n"
"$GPGGA,100117.591,4351.1282,N,01108.8719,E,1,03,16.9,0.0,M,45.2,M,,*6C\r\n"
"$GPGSA,A,2,09,27,29,,,,,,,,,,16.9,16.9,0.0*34\r\n"
"$GPGSV,3,1,10,2,34,086,,4,20,052,,9,31,143,29,12,62,057,*43\r\n"
"$GPGSV,3,2,10,14,38,266,,26,35,231,,27,25,143,34,29,43,214,35*79\r\n"
"$GPGSV,3,3,10,30,69,313,30,31,10,314,,,,,,,,,*73\r\n"
"$GPRMC,100117.591,A,4351.1282,N,01108.8719,E,0.00,187.49,131009,,,A*69\r\n"
"$GPVTG,187.49,T,,,0.00,N,0.00,K,A*73\r\n"
"$GPGGA,100118.591,4351.1280,N,01108.8718,E,1,03,16.9,-0.0,M,45.2,M,,*4D\r\n"
"$GPRMC,100118.591,A,4351.1280,N,01108.8718,E,0.00,187.49,131009,,,A*65\r\n"
"$GPVTG,187.49,T,,,0.00,N,0.00,K,A*73\r\n"
"$GPGGA,100119.591,4351.1278,N,01108.8718,E,1,03,17.1,-0.0,M,45.2,M,,*42\r\n"
"$GPRMC,100119.591,A,4351.1278,N,01108.8718,E,0.00,187.49,131009,,,A*63\r\n"
"$GPVTG,187.49,T,,,0.00,N,0.00,K,A*73\r\n"
"$GPGGA,100120.591,4351.1278,N,01108.8717,E,1,03,17.1,-0.0,M,45.2,M,,*47\r\n"
"$GPGSA,A,2,09,27,29,,,,,,,,,,17.1,17.1,0.0*34\r\n"
"$GPGSV,3,1,10,2,34,086,,4,20,052,,9,31,143,28,12,62,057,*42\r\n"
"$GPGSV,3,2,10,14,38,266,,26,35,231,,27,25,143,34,29,43,214,35*79\r\n"
"$GPGSV,3,3,10,30,69,313,30,31,10,314,,,,,,,,,*73\r\n"
"$GPRMC,100120.591,A,4351.1278,N,01108.8717,E,0.00,187.49,131009,,,A*66\r\n"
"$GPVTG,187.49,T,,,0.00,N,0.00,K,A*73\r\n"
"$GPGGA,100121.590,4351.1276,N,01108.8717,E,1,02,17.1,-0.0,M,45.2,M,,*48\r\n"
"$GPRMC,100121.590,A,4351.1276,N,01108.8717,E,0.00,187.49,131009,,,A*68\r\n"
"$GPVTG,187.49,T,,,0.00,N,0.00,K,A*73\r\n"
"$GPGGA,100122.590,4351.1275,N,01108.8717,E,1,03,17.1,-0.0,M,45.2,M,,*49\r\n"
"$GPRMC,100122.590,A,4351.1275,N,01108.8717,E,0.00,187.49,131009,,,A*68\r\n"
"$GPVTG,187.49,T,,,0.00,N,0.00,K,A*73\r\n"
"$GPGGA,100123.590,4351.1275,N,01108.8717,E,1,03,17.1,-0.0,M,45.2,M,,*48\r\n"
"$GPGSA,A,2,09,27,29,,,,,,,,,,17.1,17.1,0.0*34\r\n"
"$GPGSV,3,1,10,2,34,086,,4,20,052,,9,31,143,29,12,62,057,*43\r\n"
"$GPGSV,3,2,10,14,38,266,,26,35,231,,27,25,143,34,29,43,214,36*7A\r\n"
"$GPGSV,3,3,10,30,69,313,30,31,10,314,,,,,,,,,*73\r\n"
"$GPRMC,100123.590,A,4351.1275,N,01108.8717,E,0.00,187.49,131009,,,A*69\r\n"
"$GPVTG,187.49,T,,,0.00,N,0.00,K,A*73\r\n"
"$GPGGA,100124.590,4351.1274,N,01108.8717,E,1,03,17.1,-0.0,M,45.2,M,,*4E\r\n"
"$GPRMC,100124.590,A,4351.1274,N,01108.8717,E,0.00,187.49,131009,,,A*6F\r\n"
"$GPVTG,187.49,T,,,0.00,N,0.00,K,A*73\r\n"
"$GPGGA,100125.590,4351.1272,N,01108.8717,E,1,03,17.1,-0.0,M,45.2,M,,*49\r\n"
"$GPRMC,100125.590,A,4351.1272,N,01108.8717,E,0.00,187.49,131009,,,A*68\r\n"
"$GPVTG,187.49,T,,,0.00,N,0.00,K,A*73\r\n"
"$GPGGA,100126.589,4351.1271,N,01108.8716,E,1,03,17.1,-0.0,M,45.2,M,,*40\r\n"
"$GPGSA,A,2,09,27,29,,,,,,,,,,17.1,17.1,0.0*34\r\n"
"$GPGSV,3,1,10,2,34,086,,4,20,052,,9,31,143,28,12,62,057,*42\r\n"
"$GPGSV,3,2,10,14,38,266,,26,35,231,,27,24,143,34,29,43,214,35*78\r\n"
"$GPGSV,3,3,10,30,69,313,30,31,10,314,,,,,,,,,*73\r\n"
"$GPRMC,100126.589,A,4351.1271,N,01108.8716,E,0.00,187.49,131009,,,A*61\r\n"
"$GPVTG,187.49,T,,,0.00,N,0.00,K,A*73\r\n"
"$GPGGA,100127.589,4351.1270,N,01108.8715,E,1,03,17.1,-0.0,M,45.2,M,,*43\r\n"
"$GPRMC,100127.589,A,4351.1270,N,01108.8715,E,0.00,187.49,131009,,,A*62\r\n"
"$GPVTG,187.49,T,,,0.00,N,0.00,K,A*73\r\n"
"$GPGGA,100128.589,4351.1269,N,01108.8715,E,1,03,17.1,-0.0,M,45.2,M,,*44\r\n"
"$GPRMC,100128.589,A,4351.1269,N,01108.8715,E,0.00,187.49,131009,,,A*65\r\n"
"$GPVTG,187.49,T,,,0.00,N,0.00,K,A*73\r\n"
"$GPGGA,100129.589,4351.1268,N,01108.8715,E,1,03,17.1,-0.0,M,45.2,M,,*44\r\n"
"$GPGSA,A,2,09,27,29,,,,,,,,,,17.1,17.1,0.0*34\r\n"
"$GPGSV,3,1,10,2,34,086,,4,20,052,,9,31,143,28,12,62,058,*4D\r\n"
"$GPGSV,3,2,10,14,37,266,,26,34,231,,27,24,143,34,29,43,214,35*76\r\n"
"$GPGSV,3,3,10,30,69,314,29,31,10,314,,,,,,,,,*7C\r\n"
"$GPRMC,100129.589,A,4351.1268,N,01108.8715,E,0.00,187.49,131009,,,A*65\r\n"
"$GPVTG,187.49,T,,,0.00,N,0.00,K,A*73\r\n"
"$GPGGA,100130.589,4351.1266,N,01108.8715,E,1,03,17.1,-0.0,M,45.2,M,,*42\r\n"
"$GPRMC,100130.589,A,4351.1266,N,01108.8715,E,0.00,187.49,131009,,,A*63\r\n"
"$GPVTG,187.49,T,,,0.00,N,0.00,K,A*73\r\n"
"$GPGGA,100131.588,4351.1265,N,01108.8714,E,1,03,17.1,-0.0,M,45.2,M,,*40\r\n"
"$GPRMC,100131.588,A,4351.1265,N,01108.8714,E,0.00,187.49,131009,,,A*61\r\n"
"$GPVTG,187.49,T,,,0.00,N,0.00,K,A*73\r\n"
"$GPGGA,100132.588,4351.1264,N,01108.8714,E,1,03,17.1,-0.0,M,45.2,M,,*42\r\n"
"$GPGSA,A,2,09,27,29,,,,,,,,,,17.1,17.1,0.0*34\r\n"
"$GPGSV,3,1,10,2,34,086,,4,20,052,,9,31,143,28,12,62,058,*4D\r\n"
"$GPGSV,3,2,10,14,37,266,,26,34,231,,27,24,143,33,29,43,214,35*71\r\n"
"$GPGSV,3,3,10,30,69,314,29,31,10,314,,,,,,,,,*7C\r\n"
"$GPRMC,100132.588,A,4351.1264,N,01108.8714,E,0.00,187.49,131009,,,A*63\r\n"
"$GPVTG,187.49,T,,,0.00,N,0.00,K,A*73\r\n"
"$GPGGA,100133.588,4351.1264,N,01108.8715,E,1,03,17.1,-0.0,M,45.2,M,,*42\r\n"
"$GPRMC,100133.588,A,4351.1264,N,01108.8715,E,0.00,187.49,131009,,,A*63\r\n"
"$GPVTG,187.49,T,,,0.00,N,0.00,K,A*73\r\n"
"$GPGGA,100134.588,4351.1262,N,01108.8714,E,1,03,17.1,-0.0,M,45.2,M,,*42\r\n"
"$GPRMC,100134.588,A,4351.1262,N,01108.8714,E,0.00,187.49,131009,,,A*63\r\n"
"$GPVTG,187.49,T,,,0.00,N,0.00,K,A*73\r\n"
"$GPGGA,100135.587,4351.1263,N,01108.8715,E,1,03,17.1,-0.0,M,45.2,M,,*4C\r\n"
"$GPGSA,A,2,09,27,29,,,,,,,,,,17.1,17.1,0.0*34\r\n"
"$GPGSV,3,1,10,2,34,086,,4,20,052,,9,31,143,27,12,62,058,*42\r\n"
"$GPGSV,3,2,10,14,37,266,,26,34,231,,27,24,143,33,29,43,214,35*71\r\n"
"$GPGSV,3,3,10,30,69,314,29,31,10,314,,,,,,,,,*7C\r\n"
"$GPRMC,100135.587,A,4351.1263,N,01108.8715,E,0.00,187.49,131009,,,A*6D\r\n"
"$GPVTG,187.49,T,,,0.00,N,0.00,K,A*73\r\n"
"$GPGGA,100136.587,4351.1263,N,01108.8714,E,1,03,17.1,-0.0,M,45.2,M,,*4E\r\n"
"$GPRMC,100136.587,A,4351.1263,N,01108.8714,E,0.00,187.49,131009,,,A*6F\r\n"
"$GPVTG,187.49,T,,,0.00,N,0.00,K,A*73\r\n"
"$GPGGA,100137.587,4351.1263,N,01108.8714,E,1,03,17.1,-0.0,M,45.2,M,,*4F\r\n"
"$GPRMC,100137.587,A,4351.1263,N,01108.8714,E,0.00,187.49,131009,,,A*6E\r\n"
"$GPVTG,187.49,T,,,0.00,N,0.00,K,A*73\r\n"
"$GPGGA,100138.587,4351.1263,N,01108.8714,E,1,03,17.1,-0.0,M,45.2,M,,*40\r\n"
"$GPGSA,A,2,09,27,29,,,,,,,,,,17.1,17.1,0.0*34\r\n"
"$GPGSV,3,1,10,2,34,086,,4,20,052,,9,31,143,27,12,62,058,*42\r\n"
"$GPGSV,3,2,10,14,37,266,,26,34,231,,27,24,143,33,29,43,215,34*71\r\n"
"$GPGSV,3,3,10,30,69,314,29,31,10,314,,,,,,,,,*7C\r\n"
"$GPRMC,100138.587,A,4351.1263,N,01108.8714,E,0.00,187.49,131009,,,A*61\r\n"
"$GPVTG,187.49,T,,,0.00,N,0.00,K,A*73\r\n"
"$GPGGA,100139.587,4351.1263,N,01108.8714,E,1,03,17.1,-0.0,M,45.2,M,,*41\r\n"
"$GPRMC,100139.587,A,4351.1263,N,01108.8714,E,0.00,187.49,131009,,,A*60\r\n"
"$GPVTG,187.49,T,,,0.00,N,0.00,K,A*73\r\n"
"$GPGGA,100140.586,4351.1263,N,01108.8714,E,1,03,17.1,-0.0,M,45.2,M,,*4E\r\n"
"$GPRMC,100140.586,A,4351.1263,N,01108.8714,E,0.00,187.49,131009,,,A*6F\r\n"
"$GPVTG,187.49,T,,,0.00,N,0.00,K,A*73\r\n"
"$GPGGA,100141.586,4351.1263,N,01108.8714,E,1,03,17.1,-0.0,M,45.2,M,,*4F\r\n"
"$GPGSA,A,2,09,27,29,,,,,,,,,,17.1,17.1,0.0*34\r\n"
"$GPGSV,3,1,10,2,34,086,,4,20,052,,9,31,143,27,12,62,058,*42\r\n"
"$GPGSV,3,2,10,14,37,266,,26,34,231,,27,24,143,33,29,43,215,34*71\r\n"
"$GPGSV,3,3,10,30,69,314,29,31,10,314,,,,,,,,,*7C\r\n"
"$GPRMC,100141.586,A,4351.1263,N,01108.8714,E,0.00,187.49,131009,,,A*6E\r\n"
"$GPVTG,187.49,T,,,0.00,N,0.00,K,A*73\r\n"
"$GPGGA,100142.586,4351.1262,N,01108.8714,E,1,03,17.1,-0.0,M,45.2,M,,*4D\r\n"
"$GPRMC,100142.586,A,4351.1262,N,01108.8714,E,0.00,187.49,131009,,,A*6C\r\n"
"$GPVTG,187.49,T,,,0.00,N,0.00,K,A*73\r\n"
"$GPGGA,100143.586,4351.1263,N,01108.8713,E,1,03,17.1,-0.0,M,45.2,M,,*4A\r\n"
"$GPRMC,100143.586,A,4351.1263,N,01108.8713,E,0.00,187.49,131009,,,A*6B\r\n"
"$GPVTG,187.49,T,,,0.00,N,0.00,K,A*73\r\n"
"$GPGGA,100144.585,4351.1263,N,01108.8713,E,1,03,17.1,-0.0,M,45.2,M,,*4E\r\n"
"$GPGSA,A,2,09,27,29,,,,,,,,,,17.1,17.1,0.0*34\r\n"
"$GPGSV,3,1,10,2,34,086,,4,20,052,,9,31,143,27,12,62,058,*42\r\n"
"$GPGSV,3,2,10,14,37,266,,26,34,231,,27,24,143,33,29,43,215,34*71\r\n"
"$GPGSV,3,3,10,30,69,314,29,31,10,314,,,,,,,,,*7C\r\n"
"$GPRMC,100144.585,A,4351.1263,N,01108.8713,E,0.00,187.49,131009,,,A*6F\r\n"
"$GPVTG,187.49,T,,,0.00,N,0.00,K,A*73\r\n"
"$GPGGA,100145.585,4351.1263,N,01108.8713,E,1,03,17.1,-0.0,M,45.2,M,,*4F\r\n"
"$GPRMC,100145.585,A,4351.1263,N,01108.8713,E,0.00,187.49,131009,,,A*6E\r\n"
"$GPVTG,187.49,T,,,0.00,N,0.00,K,A*73\r\n"
"$GPGGA,100146.585,4351.1262,N,01108.8712,E,1,03,17.1,-0.0,M,45.2,M,,*4C\r\n"
"$GPRMC,100146.585,A,4351.1262,N,01108.8712,E,0.00,187.49,131009,,,A*6D\r\n"
"$GPVTG,187.49,T,,,0.00,N,0.00,K,A*73\r\n"
"$GPGGA,100147.585,4351.1262,N,01108.8712,E,1,03,17.1,-0.0,M,45.2,M,,*4D\r\n"
"$GPGSA,A,2,09,27,29,,,,,,,,,,17.1,17.1,0.0*34\r\n"
"$GPGSV,3,1,10,2,34,086,,4,20,052,,9,31,143,27,12,62,058,*42\r\n"
"$GPGSV,3,2,10,14,37,266,,26,34,231,,27,24,143,33,29,43,215,34*71\r\n"
"$GPGSV,3,3,10,30,69,314,30,31,10,314,,,,,,,,,*74\r\n"
"$GPRMC,100147.585,A,4351.1262,N,01108.8712,E,0.00,187.49,131009,,,A*6C\r\n"
"$GPVTG,187.49,T,,,0.00,N,0.00,K,A*73\r\n"
"$GPGGA,100148.585,4351.1263,N,01108.8712,E,1,03,17.1,-0.0,M,45.2,M,,*43\r\n"
"$GPRMC,100148.585,A,4351.1263,N,01108.8712,E,0.00,187.49,131009,,,A*62\r\n"
"$GPVTG,187.49,T,,,0.00,N,0.00,K,A*73\r\n"
"$GPGGA,100149.584,4351.1262,N,01108.8712,E,1,03,17.1,-0.0,M,45.2,M,,*42\r\n"
"$GPRMC,100149.584,A,4351.1262,N,01108.8712,E,0.00,187.49,131009,,,A*63\r\n"
"$GPVTG,187.49,T,,,0.00,N,0.00,K,A*73\r\n"
"$GPGGA,100150.584,4351.1263,N,01108.8712,E,1,03,17.2,-0.0,M,45.2,M,,*48\r\n"
"$GPGSA,A,2,09,27,29,,,,,,,,,,17.2,17.2,0.0*34\r\n"
"$GPGSV,3,1,10,2,34,086,,4,20,052,,9,31,143,27,12,62,058,*42\r\n"
"$GPGSV,3,2,10,14,37,266,,26,34,231,,27,24,143,33,29,43,215,34*71\r\n"
"$GPGSV,3,3,10,30,69,314,29,31,10,314,,,,,,,,,*7C\r\n"
"$GPRMC,100150.584,A,4351.1263,N,01108.8712,E,0.00,187.49,131009,,,A*6A\r\n"
"$GPVTG,187.49,T,,,0.00,N,0.00,K,A*73\r\n"
"$GPGGA,100151.584,4351.1261,N,01108.8712,E,1,03,17.2,-0.0,M,45.2,M,,*4B\r\n"
"$GPRMC,100151.584,A,4351.1261,N,01108.8712,E,0.00,187.49,131009,,,A*69\r\n"
"$GPVTG,187.49,T,,,0.00,N,0.00,K,A*73\r\n"
"$GPGGA,100152.584,4351.1259,N,01108.8713,E,1,03,17.2,-0.0,M,45.2,M,,*42\r\n"
"$GPRMC,100152.584,A,4351.1259,N,01108.8713,E,0.00,187.49,131009,,,A*60\r\n"
"$GPVTG,187.49,T,,,0.00,N,0.00,K,A*73\r\n"
"$GPGGA,10015,N,01108.8713,E,1,03,17.2,-0.0,M,45.2,M,,*48\r"
"$GPGSA,A,2,09,27,29,,,,,,,,,,17.2,17.2,0.0*34\r\n"
"$GPGSV,3,1,10,2,34,086,,4,20,052,,9,31,143,27,12,62,058,*42\r\n"
"266,,26,34,231,,27,24,143,33,29,43,215,35*70\r\n"
"*74\r\n"
"$GPRMC,100153.584,A,4351.1261,N,01108.8713,E,0.00,187.49,131009,,,A*6A\r\n"
"$GPVTG,187.49,T,,,0.00,N,0.00,K,A*73\r\n"
"$GPGGA,100154.583,4351.1260,N,01108.8713,E,1,03,17.2,0.0,M,45.2,M,,*64\r\n"
"$GPRMC,100154.583,A,4351.1260,N,01108.8713,E,0.00,187.49,131009,,,A*6B\r\n"
"$GPVTG,187.49,T,,,0.00,N,0.00,K,A*73\r\n"
"$GPGGA,100155.583,4351.1259,N,01108.8712,E,1,03,17.2,0.0,M,45.2,M,,*6E\r\n"
"$GPRMC,100155.583,A,4351.1259,N,01108.8712,E,0.00,187.49,131009,,,A*61\r\n"
"$GPVTG,187.49,T,,,0.00,N,0.00,K,A*73\r\n"
"$GPGGA,100156.583,4351.1258,N,01108.8712,E,1,03,17.2,0.0,M,45.2,M,,*6C\r\n"
"$GPGSA,A,2,09,27,29,,,,,,,,,,17.2,17.2,0.0*34\r\n"
"$GPGSV,3,1,10,2,34,086,,4,20,052,,9,31,143,28,12,62,058,*4D\r\n"
"$GPGSV,3,2,10,14,37,266,,26,34,231,,27,24,143,33,29,43,215,35*70\r\n"
"$GPGSV,3,3,10,30,69,314,30,31,10,314,,,,,,,,,*74\r\n"
"$GPRMC,100156.583,A,4351.1258,N,01108.8712,E,0.00,187.49,131009,,,A*63\r\n"
"$GPVTG,187.49,T,,,0.00,N,0.00,K,A*73\r\n"
"$GPGGA,100157.583,4351.1257,N,01108.8712,E,1,03,17.2,0.0,M,45.2,M,,*62\r\n"
"$GPRMC,100157.583,A,4351.1257,N,01108.8712,E,0.00,187.49,131009,,,A*6D\r\n"
"$GPVTG,187.49,T,,,0.00,N,0.00,K,A*73\r\n"
"$GPGGA,100158.582,4351.1256,N,01108.8712,E,1,03,17.2,-0.0,M,45.2,M,,*40\r\n"
"$GPRMC,100158.582,A,4351.1256,N,01108.8712,E,0.00,187.49,131009,,,A*62\r\n"
"$GPVTG,187.49,T,,,0.00,N,0.00,K,A*73\r\n"
"$GPGGA,100159.582,4351.1255,N,01108.8712,E,1,03,17.2,0.0,M,45.2,M,,*6F\r\n"
"$GPGSA,A,2,09,27,29,,,,,,,,,,17.2,17.2,0.0*34\r\n"
"$GPGSV,3,1,10,2,34,086,,4,20,052,,9,31,143,27,12,62,058,*42\r\n"
"$GPGSV,3,2,10,14,37,266,,26,34,231,,27,24,143,33,29,43,215,35*70\r\n"
"$GPGSV,3,3,10,30,69,314,30,31,10,314,,,,,,,,,*74\r\n"
"$GPRMC,100159.582,A,4351.1255,N,01108.8712,E,0.00,187.49,131009,,,A*60\r\n"
"$GPVTG,187.49,T,,,0.00,N,0.00,K,A*73\r\n"
"$GPGGA,100200.582,4351.1255,N,01108.8712,E,1,03,17.2,0.0,M,45.2,M,,*60\r\n"
"$GPRMC,100200.582,A,4351.1255,N,01108.8712,E,0.00,187.49,131009,,,A*6F\r\n"
"$GPVTG,187.49,T,,,0.00,N,0.00,K,A*73\r\n"
"$GPGGA,100201.582,4351.1256,N,01108.8712,E,1,03,17.2,-0.0,M,45.2,M,,*4F\r\n"
"$GPRMC,100201.582,A,4351.1256,N,01108.8712,E,0.00,187.49,131009,,,A*6D\r\n"
"$GPVTG,187.49,T,,,0.00,N,0.00,K,A*73\r\n"
"$GPGGA,100202.582,4351.1256,N,01108.8712,E,1,03,17.2,-0.0,M,45.2,M,,*4C\r\n"
"$GPGSA,A,2,09,27,29,,,,,,,,,,17.2,17.2,0.0*34\r\n"
"$GPGSV,3,1,10,2,34,086,,4,20,052,,9,31,143,27,12,62,058,*42\r\n"
"$GPGSV,3,2,10,14,37,266,,26,34,231,,27,24,143,33,29,43,215,35*70\r\n"
"$GPGSV,3,3,10,30,69,314,30,31,10,314,,,,,,,,,*74\r\n"
"$GPRMC,100202.582,A,4351.1256,N,01108.8712,E,0.00,187.49,131009,,,A*6E\r\n"
"$GPVTG,187.49,T,,,0.00,N,0.00,K,A*73\r\n"
"$GPGGA,100203.581,4351.1249,N,01108.8711,E,1,03,17.2,-0.0,M,45.2,M,,*43\r\n"
"$GPRMC,100203.581,A,4351.1249,N,01108.8711,E,0.00,187.49,131009,,,A*61\r\n"
"$GPVTG,187.49,T,,,0.00,N,0.00,K,A*73\r\n"
"$GPGGA,100204.581,4351.1250,N,01108.8712,E,1,03,17.2,-0.0,M,45.2,M,,*4F\r\n"
"$GPRMC,100204.581,A,4351.1250,N,01108.8712,E,0.00,187.49,131009,,,A*6D\r\n"
"$GPVTG,187.49,T,,,0.00,N,0.00,K,A*73\r\n"
"$GPGGA,100205.581,4351.1253,N,01108.8713,E,1,03,17.2,-0.0,M,45.2,M,,*4C\r\n"
"$GPGSA,A,2,09,27,29,,,,,,,,,,17.2,17.2,0.0*34\r\n"
"$GPGSV,3,1,10,2,34,086,,4,20,052,,9,31,143,26,12,62,058,*43\r\n"
"$GPGSV,3,2,10,14,37,266,,26,34,231,,27,24,143,33,29,43,215,36*73\r\n"
"$GPGSV,3,3,10,30,69,314,30,31,10,314,,,,,,,,,*74\r\n"
"$GPRMC,100205.581,A,4351.1253,N,01108.8713,E,0.00,187.49,131009,,,A*6E\r\n"
"$GPVTG,187.49,T,,,0.00,N,0.00,K,A*73\r\n"
"$GPGSV,3,3,10,30,69,315,30,31,10,314,,,,,,,,,*75\r\n"
"$GPRMC,100211.580,A,4351.1260,N,01108.8712,E,0.00,187.49,131009,,,A*6B\r\n"
"$GPVTG,187.49,T,,,0.00,N,0.00,K,A*73\r\n"
"$GPGGA,100212.579,4351.1260,N,01108.8712,E,1,03,17.2,-0.0,M,45.2,M,,*4C\r\n"
"$GPRMC,100212.579,A,4351.1260,N,01108.8712,E,0.00,187.49,131009,,,A*6E\r\n"
"$GPVTG,187.49,T,,,0.00,N,0.00,K,A*73\r\n"
"$GPGGA,100213.579,4351.1255,N,01108.8711,E,1,03,17.2,-0.0,M,45.2,M,,*48\r\n"
"$GPRMC,100213.579,A,4351.1255,N,01108.8711,E,0.00,187.49,131009,,,A*6A\r\n"
"$GPVTG,187.49,T,,,0.00,N,0.00,K,A*73\r\n"
"$GPGGA,100214.579,4351.1258,N,01108.8711,E,1,03,17.2,-0.0,M,45.2,M,,*42\r\n"
"$GPGSA,A,2,09,27,29,,,,,,,,,,17.2,17.2,0.0*34\r\n"
"$GPGSV,3,1,10,2,34,086,,4,20,052,,9,31,143,25,12,62,058,*40\r\n"
"$GPGSV,3,2,10,14,37,266,,26,34,231,,27,24,143,33,29,43,215,35*70\r\n"
"$GPGSV,3,3,10,30,69,315,30,31,10,314,,,,,,,,,*75\r\n"
"$GPRMC,100214.579,A,4351.1258,N,01108.8711,E,0.00,187.49,131009,,,A*60\r\n"
"$GPVTG,187.49,T,,,0.00,N,0.00,K,A*73\r\n"
"$GPGGA,100215.579,4351.1260,N,01108.8711,E,1,03,17.2,-0.0,M,45.2,M,,*48\r\n"
"$GPRMC,100215.579,A,4351.1260,N,01108.8711,E,0.00,187.49,131009,,,A*6A\r\n"
"$GPVTG,187.49,T,,,0.00,N,0.00,K,A*73\r\n"
"$GPGGA,100216.579,4351.1261,N,01108.8711,E,1,03,17.2,-0.0,M,45.2,M,,*4A\r\n"
"$GPRMC,100216.579,A,4351.1261,N,01108.8711,E,0.00,187.49,131009,,,A*68\r\n"
"$GPVTG,187.49,T,,,0.00,N,0.00,K,A*73\r\n"
"$GPGGA,100217.578,4351.1263,N,01108.8712,E,1,03,17.2,-0.0,M,45.2,M,,*4B\r\n"
"$GPGSA,A,2,09,27,29,,,,,,,,,,17.2,17.2,0.0*34\r\n"
"$GPGSV,3,1,10,2,34,086,,4,20,052,,9,31,143,25,12,62,058,*40\r\n"
"$GPGSV,3,2,10,14,37,266,,26,34,231,,27,24,143,33,29,43,215,35*70\r\n"
"$GPGSV,3,3,10,30,69,315,31,31,10,314,,,,,,,,,*74\r\n"
"$GPRMC,100217.578,A,4351.1263,N,01108.8712,E,0.00,187.49,131009,,,A*69\r\n"
"$GPVTG,187.49,T,,,0.00,N,0.00,K,A*73\r\n"
"$GPGGA,100218.578,4351.1263,N,01108.8712,E,1,03,17.2,-0.0,M,45.2,M,,*44\r\n"
"$GPRMC,100218.578,A,4351.1263,N,01108.8712,E,0.00,187.49,131009,,,A*66\r\n"
"$GPVTG,187.49,T,,,0.00,N,0.00,K,A*73\r\n"
"$GPGGA,100219.578,4351.1261,N,01108.8711,E,1,03,17.2,-0.0,M,45.2,M,,*44\r\n"
"$GPRMC,100219.578,A,4351.1261,N,01108.8711,E,0.00,187.49,131009,,,A*66\r\n"
"$GPVTG,187.49,T,,,0.00,N,0.00,K,A*73\r\n"
"$GPGGA,100220.578,4351.1264,N,01108.8712,E,1,03,17.4,-0.0,M,45.2,M,,*4E\r\n"
"$GPGSA,A,2,09,27,29,,,,,,,,,,17.4,17.4,0.0*34\r\n"
"$GPGSV,3,1,10,2,34,086,,4,20,052,,9,31,143,26,12,62,058,*43\r\n"
"$GPGSV,3,2,10,14,37,266,,26,34,231,,27,24,143,33,29,43,215,35*70\r\n"
"$GPGSV,3,3,10,30,69,315,31,31,10,314,,,,,,,,,*74\r\n"
"$GPRMC,100220.578,A,4351.1264,N,01108.8712,E,0.00,187.49,131009,,,A*6A\r\n"
"$GPVTG,187.49,T,,,0.00,N,0.00,K,A*73\r\n"
"$GPGGA,100221.577,4351.1265,N,01108.8713,E,1,03,17.4,-0.0,M,45.2,M,,*40\r\n"
"$GPRMC,100221.577,A,4351.1265,N,01108.8713,E,0.00,187.49,131009,,,A*64\r\n"
"$GPVTG,187.49,T,,,0.00,N,0.00,K,A*73\r\n"
"$GPGGA,100222.577,4351.1266,N,01108.8713,E,1,03,17.4,-0.0,M,45.2,M,,*40\r\n"
"$GPRMC,100222.577,A,4351.1266,N,01108.8713,E,0.00,187.49,131009,,,A*64\r\n"
"$GPVTG,187.49,T,,,0.00,N,0.00,K,A*73\r\n"
"$GPGGA,100223.577,4351.1267,N,01108.8714,E,1,03,17.4,-0.0,M,45.2,M,,*47\r\n"
"$GPGSA,A,2,09,27,29,,,,,,,,,,17.4,17.4,0.0*34\r\n"
"$GPGSV,3,1,10,2,34,086,,4,20,052,,9,31,143,26,12,62,058,*43\r\n"
"$GPGSV,3,2,10,14,37,266,,26,34,231,,27,24,143,32,29,43,215,36*72\r\n"
"$GPGSV,3,3,10,30,69,315,31,31,10,314,,,,,,,,,*74\r\n"
"$GPRMC,100223.577,A,4351.1267,N,01108.8714,E,0.00,187.49,131009,,,A*63\r\n"
"$GPVTG,187.49,T,,,0.00,N,0.00,K,A*73\r\n"
"$GPGGA,100224.577,4351.1271,N,01108.8713,E,1,03,17.4,-0.0,M,45.2,M,,*40\r\n"
"$GPRMC,100224.577,A,4351.1271,N,01108.8713,E,0.00,187.49,131009,,,A*64\r\n"
"$GPVTG,187.49,T,,,0.00,N,0.00,K,A*73\r\n"
"$GPGGA,100225.577,4351.1273,N,01108.8714,E,1,03,17.4,-0.0,M,45.2,M,,*44\r\n"
"$GPRMC,100225.577,A,4351.1273,N,01108.8714,E,0.00,187.49,131009,,,A*60\r\n"
"$GPVTG,187.49,T,,,0.00,N,0.00,K,A*73\r\n"
"$GPGGA,100226.576,4351.1274,N,01108.8714,E,1,03,17.4,-0.0,M,45.2,M,,*41\r\n"
"$GPGSA,A,2,09,27,29,,,,,,,,,,17.4,17.4,0.0*34\r\n"
"$GPGSV,3,1,10,2,34,086,,4,20,052,,9,31,143,25,12,62,058,*40\r\n"
"$GPGSV,3,2,10,14,37,266,,26,34,231,,27,24,143,32,29,43,215,35*71\r\n"
"$GPGSV,3,3,10,30,69,315,30,31,10,314,,,,,,,,,*75\r\n"
"$GPRMC,100226.576,A,4351.1274,N,01108.8714,E,0.00,187.49,131009,,,A*65\r\n"
"$GPVTG,187.49,T,,,0.00,N,0.00,K,A*73\r\n"
"$GPGGA,100227.576,4351.1274,N,01108.8714,E,1,03,17.4,-0.0,M,45.2,M,,*40\r\n"
"$GPRMC,100227.576,A,4351.1274,N,01108.8714,E,0.00,187.49,131009,,,A*64\r\n"
"$GPVTG,187.49,T,,,0.00,N,0.00,K,A*73\r\n"
"$GPGGA,100228.576,4351.1276,N,01108.8715,E,1,03,17.4,-0.0,M,45.2,M,,*4C\r\n"
"$GPRMC,100228.576,A,4351.1276,N,01108.8715,E,0.00,187.49,131009,,,A*68\r\n"
"$GPVTG,187.49,T,,,0.00,N,0.00,K,A*73\r\n"
"$GPGGA,100229.576,4351.1280,N,01108.8715,E,1,03,17.4,-0.0,M,45.2,M,,*44\r\n"
"$GPGSA,A,2,09,27,29,,,,,,,,,,17.4,17.4,0.0*34\r\n"
"$GPGSV,3,1,10,2,34,086,,4,20,052,,9,31,143,26,12,62,058,*43\r\n"
"$GPGSV,3,2,10,14,37,266,,26,34,231,,27,24,143,33,29,43,215,35*70\r\n"
"$GPGSV,3,3,10,30,69,315,31,31,10,314,,,,,,,,,*74\r\n"
"$GPRMC,100229.576,A,4351.1280,N,01108.8715,E,0.00,187.49,131009,,,A*60\r\n"
"$GPVTG,187.49,T,,,0.00,N,0.00,K,A*73\r\n"
"$GPGGA,100230.576,4351.1282,N,01108.8715,E,1,03,17.4,-0.0,M,45.2,M,,*4E\r\n"
"$GPRMC,100230.576,A,4351.1282,N,01108.8715,E,0.00,187.49,131009,,,A*6A\r\n"
"$GPVTG,187.49,T,,,0.00,N,0.00,K,A*73\r\n"
"$GPGGA,100231.575,4351.1294,N,01108.8718,E,1,03,17.4,-0.0,M,45.2,M,,*46\r\n"
"$GPRMC,100231.575,A,4351.1294,N,01108.8718,E,0.00,187.49,131009,,,A*62\r\n"
"$GPVTG,187.49,T,,,0.00,N,0.00,K,A*73\r\n"
"$GPGGA,100232.575,4351.1295,N,01108.8718,E,1,03,17.4,-0.0,M,45.2,M,,*44\r\n"
"$GPGSA,A,2,09,27,29,,,,,,,,,,17.4,17.4,0.0*34\r\n"
"$GPGSV,3,1,10,2,34,086,,4,20,052,,9,31,143,27,12,62,058,*42\r\n"
"$GPGSV,3,2,10,14,37,266,,26,34,231,,27,24,143,32,29,43,215,34*70\r\n"
"$GPGSV,3,3,10,30,69,315,30,31,10,314,,,,,,,,,*75\r\n"
"$GPRMC,100232.575,A,4351.1295,N,01108.8718,E,0.00,187.49,131009,,,A*60\r\n"
"$GPVTG,187.49,T,,,0.00,N,0.00,K,A*73\r\n"
"$GPGGA,100233.575,4351.1297,N,01108.8718,E,1,03,17.4,0.0,M,45.2,M,,*6A\r\n"
"$GPRMC,100233.575,A,4351.1297,N,01108.8718,E,0.00,187.49,131009,,,A*63\r\n"
"$GPVTG,187.49,T,,,0.00,N,0.00,K,A*73\r\n"
"$GPGGA,100234.575,4351.1301,N,01108.8719,E,1,03,17.4,-0.0,M,45.2,M,,*4F\r\n"
"$GPRMC,100234.575,A,4351.1301,N,01108.8719,E,0.00,187.49,131009,,,A*6B\r\n"
"$GPVTG,187.49,T,,,0.00,N,0.00,K,A*73\r\n"
"$GPGGA,100235.574,4351.1305,N,01108.8719,E,1,03,17.4,-0.0,M,45.2,M,,*4B\r\n"
"$GPGSA,A,2,09,27,29,,,,,,,,,,17.4,17.4,0.0*34\r\n"
"$GPGSV,3,1,10,2,34,086,,4,20,052,,9,31,143,27,12,62,058,*42\r\n"
"$GPGSV,3,2,10,14,37,266,,26,34,231,,27,24,143,32,29,43,215,34*70\r\n"
"$GPGSV,3,3,10,30,69,315,30,31,10,314,,,,,,,,,*75\r\n"
"$GPRMC,100235.574,A,4351.1305,N,01108.8719,E,0.00,187.49,131009,,,A*6F\r\n"
"$GPVTG,187.49,T,,,0.00,N,0.00,K,A*73\r\n"
"$GPGGA,100236.574,4351.1308,N,01108.8720,E,1,03,17.4,-0.0,M,45.2,M,,*4F\r\n"
"$GPRMC,100236.574,A,4351.1308,N,01108.8720,E,0.00,187.49,131009,,,A*6B\r\n"
"$GPVTG,187.49,T,,,0.00,N,0.00,K,A*73\r\n"
"$GPGGA,100237.574,4351.1311,N,01108.8720,E,1,03,17.4,-0.0,M,45.2,M,,*46\r\n"
"$GPRMC,100237.574,A,4351.1311,N,01108.8720,E,0.00,187.49,131009,,,A*62\r\n"
"$GPVTG,187.49,T,,,0.00,N,0.00,K,A*73\r\n"
"$GPGGA,100238.574,4351.1314,N,01108.8721,E,1,03,17.4,-0.0,M,45.2,M,,*4D\r\n"
"$GPGSA,A,2,09,27,29,,,,,,,,,,17.4,17.4,0.0*34\r\n"
"$GPGSV,3,1,10,2,34,086,,4,20,052,,9,31,143,26,12,62,058,*43\r\n"
"$GPGSV,3,2,10,14,37,266,,26,34,231,,27,24,143,32,29,43,215,34*70\r\n"
"$GPGSV,3,3,10,30,69,315,30,31,10,314,,,,,,,,,*75\r\n"
"$GP351.1314,N,01108.8721,E,0.00,187.49,131009,,,A*69\r"
"$GPVTG,187.49,T,,,0.00,N,0.00,K,A*73\r\n"
"$GPGGA,100239.574,4351.1316,N,01108.8722,E,1,03,17.4,-0.0,M,45.2,M,,*4D\r\n"
"$GPGGA,100206.581,4351.1256,N,01108.8711,E,1,03,17.2,-0.0,M,45.2,M,,*48\r\n"
"$GPRMC,100206.581,A,4351.1256,N,01108.8711,E,0.00,187.49,131009,,,A*6A\r\n"
"$GPVTG,187.49,T,,,0.00,N,0.00,K,A*73\r\n"
"$GPGGA,100207.581,4351.1257,N,01108.8711,E,1,03,17.2,-0.0,M,45.2,M,,*48\r\n"
"$GPRMC,100207.581,A,4351.1257,N,01108.8711,E,0.00,187.49,131009,,,A*6A\r\n"
"$GPVTG,187.49,T,,,0.00,N,0.00,K,A*73\r\n"
"$GPGGA,100208.580,4351.1258,N,01108.8712,E,1,03,17.2,-0.0,M,45.2,M,,*4A\r\n"
"$GPGSA,A,2,09,27,29,,,,,,,,,,17.2,17.2,0.0*34\r\n"
"$GPGSV,3,1,10,2,34,086,,4,20,052,,9,31,143,26,12,62,058,*43\r\n"
"$GPGSV,3,2,10,14,37,266,,26,34,231,,27,24,143,33,29,43,215,35*70\r\n"
"$GPGSV,3,3,10,30,69,314,30,31,10,314,,,,,,,,,*74\r\n"
"$GPRMC,100208.580,A,4351.1258,N,01108.8712,E,0.00,187.49,131009,,,A*68\r\n"
"$GPVTG,187.49,T,,,0.00,N,0.00,K,A*73\r\n"
"$GPGGA,100209.580,4351.1258,N,01108.8712,E,1,03,17.2,-0.0,M,45.2,M,,*4B\r\n"
"$GPRMC,100209.580,A,4351.1258,N,01108.8712,E,0.00,187.49,131009,,,A*69\r\n"
"$GPVTG,187.49,T,,,0.00,N,0.00,K,A*73\r\n"
"$GPGGA,100210.580,4351.1258,N,01108.8712,E,1,03,17.2,-0.0,M,45.2,M,,*43\r\n"
"$GPRMC,100210.580,A,4351.1258,N,01108.8712,E,0.00,187.49,131009,,,A*61\r\n"
"$GPVTG,187.49,T,,,0.00,N,0.00,K,A*73\r\n"
"$GPGGA,100211.580,4351.1260,N,01108.8712,E,1,03,17.2,-0.0,M,45.2,M,,*49\r\n"
"$GPGSA,A,2,09,27,29,,,,,,,,,,17.2,17.2,0.0*34\r\n"
"$GPGSV,3,1,10,2,34,086,,4,20,052,,9,31,143,26,12,62,058,*43\r\n"
"$GPGSV,3,2,10,14,37,266,,26,34,231,,27,24,143,33,29,43,215,35*70\r\n"
"$GPGSV,3,3,10,30,69,315,30,31,10,314,,,,,,,,,*75\r\n"
"$GPRMC,100211.580,A,4351.1260,N,01108.8712,E,0.00,187.49,131009,,,A*6B\r\n"
"$GPVTG,187.49,T,,,0.00,N,0.00,K,A*73\r\n"
"$GPGGA,100212.579,4351.1260,N,01108.8712,E,1,03,17.2,-0.0,M,45.2,M,,*4C\r\n"
"$GPRMC,100212.579,A,4351.1260,N,01108.8712,E,0.00,187.49,131009,,,A*6E\r\n"
"$GPVTG,187.49,T,,,0.00,N,0.00,K,A*73\r\n"
"$GPGGA,100213.579,4351.1255,N,01108.8711,E,1,03,17.2,-0.0,M,45.2,M,,*48\r\n"
"$GPRMC,100213.579,A,4351.1255,N,01108.8711,E,0.00,187.49,131009,,,A*6A\r\n"
"$GPVTG,187.49,T,,,0.00,N,0.00,K,A*73\r\n"
"$GPGGA,100214.579,4351.1258,N,01108.8711,E,1,03,17.2,-0.0,M,45.2,M,,*42\r\n"
"$GPGSA,A,2,09,27,29,,,,,,,,,,17.2,17.2,0.0*34\r\n"
"$GPGSV,3,1,10,2,34,086,,4,20,052,,9,31,143,25,12,62,058,*40\r\n"
"$GPGSV,3,2,10,14,37,266,,26,34,231,,27,24,143,33,29,43,215,35*70\r\n"
"$GPGSV,3,3,10,30,69,315,30,31,10,314,,,,,,,,,*75\r\n"
"$GPRMC,100214.579,A,4351.1258,N,01108.8711,E,0.00,187.49,131009,,,A*60\r\n"
"$GPVTG,187.49,T,,,0.00,N,0.00,K,A*73\r\n"
"$GPGGA,100215.579,4351.1260,N,01108.8711,E,1,03,17.2,-0.0,M,45.2,M,,*48\r\n"
"$GPRMC,100215.579,A,4351.1260,N,01108.8711,E,0.00,187.49,131009,,,A*6A\r\n"
"$GPVTG,187.49,T,,,0.00,N,0.00,K,A*73\r\n"
"$GPGGA,100216.579,4351.1261,N,01108.8711,E,1,03,17.2,-0.0,M,45.2,M,,*4A\r\n"
"$GPRMC,100216.579,A,4351.1261,N,01108.8711,E,0.00,187.49,131009,,,A*68\r\n"
"$GPVTG,187.49,T,,,0.00,N,0.00,K,A*73\r\n"
"$GPGGA,100217.578,4351.1263,N,01108.8712,E,1,03,17.2,-0.0,M,45.2,M,,*4B\r\n"
"$GPGSA,A,2,09,27,29,,,,,,,,,,17.2,17.2,0.0*34\r\n"
"$GPGSV,3,1,10,2,34,086,,4,20,052,,9,31,143,25,12,62,058,*40\r\n"
"$GPGSV,3,2,10,14,37,266,,26,34,231,,27,24,143,33,29,43,215,35*70\r\n"
"$GPGSV,3,3,10,30,69,315,31,31,10,314,,,,,,,,,*74\r\n"
"$GPRMC,100217.578,A,4351.1263,N,01108.8712,E,0.00,187.49,131009,,,A*69\r\n"
"$GPVTG,187.49,T,,,0.00,N,0.00,K,A*73\r\n"
"$GPGGA,100218.578,4351.1263,N,01108.8712,E,1,03,17.2,-0.0,M,45.2,M,,*44\r\n"
"$GPRMC,100218.578,A,4351.1263,N,01108.8712,E,0.00,187.49,131009,,,A*66\r\n"
"$GPVTG,187.49,T,,,0.00,N,0.00,K,A*73\r\n"
"$GPGGA,100219.578,4351.1261,N,01108.8711,E,1,03,17.2,-0.0,M,45.2,M,,*44\r\n"
"$GPRMC,100219.578,A,4351.1261,N,01108.8711,E,0.00,187.49,131009,,,A*66\r\n"
"$GPVTG,187.49,T,,,0.00,N,0.00,K,A*73\r\n"
"$GPGGA,100220.578,4351.1264,N,01108.8712,E,1,03,17.4,-0.0,M,45.2,M,,*4E\r\n"
"$GPGSA,A,2,09,27,29,,,,,,,,,,17.4,17.4,0.0*34\r\n"
"$GPGSV,3,1,10,2,34,086,,4,20,052,,9,31,143,26,12,62,058,*43\r\n"
"$GPGSV,3,2,10,14,37,266,,26,34,231,,27,24,143,33,29,43,215,35*70\r\n"
"$GPGSV,3,3,10,30,69,315,31,31,10,314,,,,,,,,,*74\r\n"
"$GPRMC,100220.578,A,4351.1264,N,01108.8712,E,0.00,187.49,131009,,,A*6A\r\n"
"$GPVTG,187.49,T,,,0.00,N,0.00,K,A*73\r\n"
"$GPGGA,100221.577,4351.1265,N,01108.8713,E,1,03,17.4,-0.0,M,45.2,M,,*40\r\n"
"$GPRMC,100221.577,A,4351.1265,N,01108.8713,E,0.00,187.49,131009,,,A*64\r\n"
"$GPVTG,187.49,T,,,0.00,N,0.00,K,A*73\r\n"
"$GPGGA,100222.577,4351.1266,N,01108.8713,E,1,03,17.4,-0.0,M,45.2,M,,*40\r\n"
"$GPRMC,100222.577,A,4351.1266,N,01108.8713,E,0.00,187.49,131009,,,A*64\r\n"
"$GPVTG,187.49,T,,,0.00,N,0.00,K,A*73\r\n"
"$GPGGA,100223.577,4351.1267,N,01108.8714,E,1,03,17.4,-0.0,M,45.2,M,,*47\r\n"
"$GPGSA,A,2,09,27,29,,,,,,,,,,17.4,17.4,0.0*34\r\n"
"$GPGSV,3,1,10,2,34,086,,4,20,052,,9,31,143,26,12,62,058,*43\r\n"
"$GPGSV,3,2,10,14,37,266,,26,34,231,,27,24,143,32,29,43,215,36*72\r\n"
"$GPGSV,3,3,10,30,69,315,31,31,10,314,,,,,,,,,*74\r\n"
"$GPRMC,100223.577,A,4351.1267,N,01108.8714,E,0.00,187.49,131009,,,A*63\r\n"
"$GPVTG,187.49,T,,,0.00,N,0.00,K,A*73\r\n"
"$GPGGA,100224.577,4351.1271,N,01108.8713,E,1,03,17.4,-0.0,M,45.2,M,,*40\r\n"
"$GPRMC,100224.577,A,4351.1271,N,01108.8713,E,0.00,187.49,131009,,,A*64\r\n"
"$GPVTG,187.49,T,,,0.00,N,0.00,K,A*73\r\n"
"$GPGGA,100225.577,4351.1273,N,01108.8714,E,1,03,17.4,-0.0,M,45.2,M,,*44\r\n"
"$GPRMC,100225.577,A,4351.1273,N,01108.8714,E,0.00,187.49,131009,,,A*60\r\n"
"$GPVTG,187.49,T,,,0.00,N,0.00,K,A*73\r\n"
"$GPGGA,100226.576,4351.1274,N,01108.8714,E,1,03,17.4,-0.0,M,45.2,M,,*41\r\n"
"$GPGSA,A,2,09,27,29,,,,,,,,,,17.4,17.4,0.0*34\r\n"
"$GPGSV,3,1,10,2,34,086,,4,20,052,,9,31,143,25,12,62,058,*40\r\n"
"$GPGSV,3,2,10,14,37,266,,26,34,231,,27,24,143,32,29,43,215,35*71\r\n"
"$GPGSV,3,3,10,30,69,315,30,31,10,314,,,,,,,,,*75\r\n"
"$GPRMC,100226.576,A,4351.1274,N,01108.8714,E,0.00,187.49,131009,,,A*65\r\n"
"$GPVTG,187.49,T,,,0.00,N,0.00,K,A*73\r\n"
"$GPGGA,100227.576,4351.1274,N,01108.8714,E,1,03,17.4,-0.0,M,45.2,M,,*40\r\n"
"$GPRMC,100227.576,A,4351.1274,N,01108.8714,E,0.00,187.49,131009,,,A*64\r\n"
"$GPVTG,187.49,T,,,0.00,N,0.00,K,A*73\r\n"
"$GPGGA,100228.576,4351.1276,N,01108.8715,E,1,03,17.4,-0.0,M,45.2,M,,*4C\r\n"
"$GPRMC,100228.576,A,4351.1276,N,01108.8715,E,0.00,187.49,131009,,,A*68\r\n"
"$GPVTG,187.49,T,,,0.00,N,0.00,K,A*73\r\n"
"$GPGGA,100229.576,4351.1280,N,01108.8715,E,1,03,17.4,-0.0,M,45.2,M,,*44\r\n"
"$GPGSA,A,2,09,27,29,,,,,,,,,,17.4,17.4,0.0*34\r\n"
"$GPGSV,3,1,10,2,34,086,,4,20,052,,9,31,143,26,12,62,058,*43\r\n"
"$GPGSV,3,2,10,14,37,266,,26,34,231,,27,24,143,33,29,43,215,35*70\r\n"
"$GPGSV,3,3,10,30,69,315,31,31,10,314,,,,,,,,,*74\r\n"
"$GPRMC,100229.576,A,4351.1280,N,01108.8715,E,0.00,187.49,131009,,,A*60\r\n"
"$GPVTG,187.49,T,,,0.00,N,0.00,K,A*73\r\n"
"$GPGGA,100230.576,4351.1282,N,01108.8715,E,1,03,17.4,-0.0,M,45.2,M,,*4E\r\n"
"$GPRMC,100230.576,A,4351.1282,N,01108.8715,E,0.00,187.49,131009,,,A*6A\r\n"
"$GPVTG,187.49,T,,,0.00,N,0.00,K,A*73\r\n"
"$GPGGA,100231.575,4351.1294,N,01108.8718,E,1,03,17.4,-0.0,M,45.2,M,,*46\r\n"
"$GPRMC,100231.575,A,4351.1294,N,01108.8718,E,0.00,187.49,131009,,,A*62\r\n"
"$GPVTG,187.49,T,,,0.00,N,0.00,K,A*73\r\n"
"$GPGGA,100232.575,4351.1295,N,01108.8718,E,1,03,17.4,-0.0,M,45.2,M,,*44\r\n"
"$GPGSA,A,2,09,27,29,,,,,,,,,,17.4,17.4,0.0*34\r\n"
"$GPGSV,3,1,10,2,34,086,,4,20,052,,9,31,143,27,12,62,058,*42\r\n"
"$GPGSV,3,2,10,14,37,266,,26,34,231,,27,24,143,32,29,43,215,34*70\r\n"
"$GPGSV,3,3,10,30,69,315,30,31,10,314,,,,,,,,,*75\r\n"
"$GPRMC,100232.575,A,4351.1295,N,01108.8718,E,0.00,187.49,131009,,,A*60\r\n"
"$GPVTG,187.49,T,,,0.00,N,0.00,K,A*73\r\n"
"$GPGGA,100233.575,4351.1297,N,01108.8718,E,1,03,17.4,0.0,M,45.2,M,,*6A\r\n"
"$GPRMC,100233.575,A,4351.1297,N,01108.8718,E,0.00,187.49,131009,,,A*63\r\n"
"$GPVTG,187.49,T,,,0.00,N,0.00,K,A*73\r\n"
"$GPGGA,100234.575,4351.1301,N,01108.8719,E,1,03,17.4,-0.0,M,45.2,M,,*4F\r\n"
"$GPRMC,100234.575,A,4351.1301,N,01108.8719,E,0.00,187.49,131009,,,A*6B\r\n"
"$GPVTG,187.49,T,,,0.00,N,0.00,K,A*73\r\n"
"$GPGGA,100235.574,4351.1305,N,01108.8719,E,1,03,17.4,-0.0,M,45.2,M,,*4B\r\n"
"$GPGSA,A,2,09,27,29,,,,,,,,,,17.4,17.4,0.0*34\r\n"
"$GPGSV,3,1,10,2,34,086,,4,20,052,,9,31,143,27,12,62,058,*42\r\n"
"$GPGSV,3,2,10,14,37,266,,26,34,231,,27,24,143,32,29,43,215,34*70\r\n"
"$GPGSV,3,3,10,30,69,315,30,31,10,314,,,,,,,,,*75\r\n"
"$GPRMC,100235.574,A,4351.1305,N,01108.8719,E,0.00,187.49,131009,,,A*6F\r\n"
"$GPVTG,187.49,T,,,0.00,N,0.00,K,A*73\r\n"
"$GPGGA,100236.574,4351.1308,N,01108.8720,E,1,03,17.4,-0.0,M,45.2,M,,*4F\r\n"
"$GPRMC,100236.574,A,4351.1308,N,01108.8720,E,0.00,187.49,131009,,,A*6B\r\n"
"$GPVTG,187.49,T,,,0.00,N,0.00,K,A*73\r\n"
"$GPGGA,100237.574,4351.1311,N,01108.8720,E,1,03,17.4,-0.0,M,45.2,M,,*46\r\n"
"$GPRMC,100237.574,A,4351.1311,N,01108.8720,E,0.00,187.49,131009,,,A*62\r\n"
"$GPVTG,187.49,T,,,0.00,N,0.00,K,A*73\r\n"
"$GPGGA,100238.574,4351.1314,N,01108.8721,E,1,03,17.4,-0.0,M,45.2,M,,*4D\r\n"
"$GPGSA,A,2,09,27,29,,,,,,,,,,17.4,17.4,0.0*34\r\n"
"$GPGSV,3,1,10,2,34,086,,4,20,052,,9,31,143,26,12,62,058,*43\r\n"
"$GPGSV,3,2,10,14,37,266,,26,34,231,,27,24,143,32,29,43,215,34*70\r\n"
"$GPGSV,3,3,10,30,69,315,30,31,10,314,,,,,,,,,*75\r\n"
"$GP351.1314,N,01108.8721,E,0.00,187.49,131009,,,A*69\r"
"$GPVTG,187.49,T,,,0.00,N,0.00,K,A*73\r\n"
"$GPGGA,100239.574,4351.1316,N,01108.8722,E,1,03,17.4,-0.0,M,45.2,M,,*4D\r\n"
};

static NmeaGga gga_test1 =
{
	.latitude = 43851403,
	.longitude = 11147808,
	.altitude = 57,
	.time = 57928,
	.satellites = 5,
	.quality = 1,
	.hdop = 26,
	.geoid = 45,
};

static NmeaGga gga_test2 =
{
	.latitude = 43851403,
	.longitude = 11147808,
	.altitude = -57,
	.time = 57928,
	.satellites = 5,
	.quality = 1,
	.hdop = 26,
	.geoid = 45,
};

static NmeaGga gga_test3 =
{
	.latitude = -43851403,
	.longitude = -11147808,
	.altitude = -57,
	.time = 57928,
	.satellites = 5,
	.quality = 1,
	.hdop = 26,
	.geoid = -45,
};

static NmeaRmc rmc_test =
{
	.time = 1254758726,
	.warn = 'A',
	.latitude = 43851405,
	.longitude = 11147812,
	.speed = 0,
	.course = 237,
	.mag_var = 0
};


static NmeaVtg vtg_test =
{
	.track_good = 237,
	.knot_speed = 0,
	.km_speed = 0
};

static NmeaGsv gsv_test =
{
	.tot_message = 3,
	.message_num = 1,
	.tot_svv = 9,
	.info =
	{
		{  3, 78, 302, 37 },
		{  6, 87,  31,  0 },
		{  7,  5, 292, 37 },
		{ 14,  5, 135,  0 }

	}
};

typedef struct NmeaTest
{
	int test_num;
	void *val;
} NmeaTest;

NmeaTest test_vector[] =
{
	{1, &rmc_test},
	{2, &vtg_test},
	{3, &gsv_test},
	{4, &gga_test1},
	{5, &gga_test2},
	{6, &gga_test3},
};


static void *find_test(int n)
{
	for (unsigned i=0; i < countof(test_vector); i++)
		if (n == test_vector[i].test_num)
			return test_vector[i].val;
	
	return NULL;
}

#define TOT_GOOD_SENTENCE_NUM    665
#define TOT_SENTENCE_NUM         731

static int tot_sentence_parsed = 0;

/**
 * do something with the GGA data
 */
static void gpgga_callout_test(nmeap_context_t *context, void *data, void *user_data)
{
	(void)context;
	(void)user_data;
	NmeaGga *gga = (NmeaGga *)data;

	tot_sentence_parsed++;
	void *test = find_test(tot_sentence_parsed);
	if (test)
		ASSERT(memcmp(test, gga, sizeof(*gga)) == 0);

	LOG_INFO("[%d]found GPGGA message %ld %ld %ld %lu %d %d %d %d\n",tot_sentence_parsed,
            (long)gga->latitude,
            (long)gga->longitude,
            (long)gga->altitude,
            gga->time,
            gga->satellites,
            gga->quality,
            gga->hdop,
            gga->geoid);
}

/**
 * do something with the RMC data
 */
static void gprmc_callout_test(nmeap_context_t *context, void *data, void *user_data)
{
	(void)context;
	(void)user_data;
	NmeaRmc *rmc = (NmeaRmc *)data;

	tot_sentence_parsed++;
	void *test = find_test(tot_sentence_parsed);
	if (test)
		ASSERT(memcmp(test, rmc, sizeof(*rmc)) == 0);

	LOG_INFO("[%d]found GPRMC Message %lu %c %ld %ld %d %d %d\n",tot_sentence_parsed,
            rmc->time,
            rmc->warn,
            (long)rmc->latitude,
            (long)rmc->longitude,
            rmc->speed,
            rmc->course,
            rmc->mag_var);
}

/**
 * do something with the GSV data
 */
static void gpgsv_callout_test(nmeap_context_t *context, void *data, void *user_data)
{
	(void)context;
	(void)user_data;
	NmeaGsv *gsv = (NmeaGsv *)data;

	tot_sentence_parsed++;
	void *test = find_test(tot_sentence_parsed);
	if (test)
		ASSERT(memcmp(test, gsv, sizeof(*gsv)) == 0);

	LOG_INFO("[%d]Found GPGSV message %d %d %d\n",tot_sentence_parsed,
			gsv->tot_message,
			gsv->message_num,
			gsv->tot_svv);

	for (int i = 0; i < 4; i++)
	    LOG_INFO("\t[%d]%d %d %d %d\n", i, gsv->info[i].sv_prn, gsv->info[i].elevation, gsv->info[i].azimut, gsv->info[i].snr);
}

/**
 * do something with the VTG data
 */
static void gpvtg_callout_test(nmeap_context_t *context, void *data, void *user_data)
{
	(void)context;
	(void)user_data;
	NmeaVtg *vtg = (NmeaVtg *)data;

	tot_sentence_parsed++;
	void *test = find_test(tot_sentence_parsed);
	if (test)
		ASSERT(memcmp(test, vtg, sizeof(*vtg)) == 0);

	LOG_INFO("[%d]Found GPVTG message %d %d %d\n",tot_sentence_parsed,
			vtg->track_good,
			vtg->knot_speed,
			vtg->km_speed);
}

int nmea_testSetup(void)
{
	kdbg_init();

	kfilemem_init(&mem, nmea_test, sizeof(nmea_test));
	LOG_INFO("Init test buffer..done.\n");

	nmeap_init(&nmea, NULL);
	nmeap_addParser(&nmea, "GPGGA", nmea_gpgga, gpgga_callout_test, &gga);
	nmeap_addParser(&nmea, "GPRMC", nmea_gprmc, gprmc_callout_test, &rmc);
	nmeap_addParser(&nmea, "GPGSV", nmea_gpgsv, gpgsv_callout_test, &gsv);
	nmeap_addParser(&nmea, "GPVTG", nmea_gpvtg, gpvtg_callout_test, &vtg);

	return 0;
}

int nmea_testTearDown(void)
{
	return 0;
}

int nmea_testRun(void)
{
	for (int i = 0; i < TOT_SENTENCE_NUM; i++)
		nmea_poll(&nmea, &mem.fd);

	kprintf("tot sentence %d\n", tot_sentence_parsed);

	if (tot_sentence_parsed != TOT_GOOD_SENTENCE_NUM)
	{
		LOG_ERR("Incorrect number of parsed sentence.\n");
		return -1;
	}


	return  0;
}

TEST_MAIN(nmea);

