/**
 * \file
 * <!--
 * This file is part of BeRTOS.
 *
 * Bertos is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 * As a special exception, you may use this file as part of a free software
 * library without restriction.  Specifically, if other files instantiate
 * templates or use macros or inline functions from this file, or you compile
 * this file and link it with other files to produce an executable, this
 * file does not by itself cause the resulting executable to be covered by
 * the GNU General Public License.  This exception does not however
 * invalidate any other reasons why the executable file might be covered by
 * the GNU General Public License.
 *
 * Copyright 2010 Develer S.r.l. (http://www.develer.com/)
 *
 * -->
 *
 * \brief Atmel's SAM3 registers definitions.
 *
 * This file derives from the one included in Atmel softpack, and defines
 * registers not yet written in standard BeRTOS include file (io/sam3_*.h) with
 * some minor modifications for BeRTOS compatibility.
 * You should normally use standard BeRTOS include file for register definitions
 * (i.e. io/sam3.h, io/sam3_pio.h, io/sam3_uart.h, etc.) but in case you need
 * register definitions for SAM3 hardware not yet supported by BeRTOS you
 * can include this file.
 */

/* ---------------------------------------------------------------------------- */
/*                  Atmel Microcontroller Software Support                      */
/* ---------------------------------------------------------------------------- */
/* Copyright (c) 2010, Atmel Corporation                                        */
/*                                                                              */
/* All rights reserved.                                                         */
/*                                                                              */
/* Redistribution and use in source and binary forms, with or without           */
/* modification, are permitted provided that the following condition is met:    */
/*                                                                              */
/* - Redistributions of source code must retain the above copyright notice,     */
/* this list of conditions and the disclaimer below.                            */
/*                                                                              */
/* Atmel's name may not be used to endorse or promote products derived from     */
/* this software without specific prior written permission.                     */
/*                                                                              */
/* DISCLAIMER:  THIS SOFTWARE IS PROVIDED BY ATMEL "AS IS" AND ANY EXPRESS OR   */
/* IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF */
/* MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT ARE   */
/* DISCLAIMED. IN NO EVENT SHALL ATMEL BE LIABLE FOR ANY DIRECT, INDIRECT,      */
/* INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT */
/* LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA,  */
/* OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF    */
/* LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING         */
/* NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, */
/* EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.                           */
/* ---------------------------------------------------------------------------- */
/*                                                                              */
/* File Name    : SAM3N.h */
/* Object       : SAM3N definitions */
/* Generated by : AT91 SW Application Group */
/* Generated on : 2010-09-06 */

#ifndef SAM3N_H
#define SAM3N_H

/* SAM3N_definitions SAM3N definitions
  This file defines all structures and symbols for SAM3N:
    - registers and bitfields
    - peripheral base address
    - peripheral ID
    - PIO definitions
*/

#ifdef __cplusplus
 extern "C" {
#endif 

#ifndef __ASSEMBLY__
#include <stdint.h>
#ifndef __cplusplus
typedef volatile const uint32_t RoReg; /* Read only 32-bit register (volatile const unsigned int) */
#else
typedef volatile       uint32_t RoReg; /* Read only 32-bit register (volatile const unsigned int) */
#endif
typedef volatile       uint32_t WoReg; /* Write only 32-bit register (volatile unsigned int) */
typedef volatile       uint32_t RwReg; /* Read-Write 32-bit register (volatile unsigned int) */
#define CAST(type, value) ((type *) value)
#define REG_ACCESS(type, address) (*(type*)address) /* C code: Register value */
#else
#define CAST(type, value) (value) 
#define REG_ACCESS(type, address) (address) /* Assembly code: Register address */
#endif

/* ************************************************************************** */
/*   CMSIS DEFINITIONS FOR SAM3N */
/* ************************************************************************** */

/* Interrupt Number Definition */
typedef enum IRQn
{
/******  Cortex-M3 Processor Exceptions Numbers ******************************/
  NonMaskableInt_IRQn   = -14, /*  2 Non Maskable Interrupt                */
  MemoryManagement_IRQn = -12, /*  4 Cortex-M3 Memory Management Interrupt */
  BusFault_IRQn         = -11, /*  5 Cortex-M3 Bus Fault Interrupt         */
  UsageFault_IRQn       = -10, /*  6 Cortex-M3 Usage Fault Interrupt       */
  SVCall_IRQn           = -5,  /* 11 Cortex-M3 SV Call Interrupt           */
  DebugMonitor_IRQn     = -4,  /* 12 Cortex-M3 Debug Monitor Interrupt     */
  PendSV_IRQn           = -2,  /* 14 Cortex-M3 Pend SV Interrupt           */
  SysTick_IRQn          = -1,  /* 15 Cortex-M3 System Tick Interrupt       */
/******  SAM3N specific Interrupt Numbers *********************************/
  
  SUPC_IRQn            =  0, /*  0 SAM3N Supply Controller (SUPC) */
  RSTC_IRQn            =  1, /*  1 SAM3N Reset Controller (RSTC) */
  RTC_IRQn             =  2, /*  2 SAM3N Real Time Clock (RTC) */
  RTT_IRQn             =  3, /*  3 SAM3N Real Time Timer (RTT) */
  WDT_IRQn             =  4, /*  4 SAM3N Watchdog Timer (WDT) */
  PMC_IRQn             =  5, /*  5 SAM3N Power Management Controller (PMC) */
  EFC_IRQn             =  6, /*  6 SAM3N Enhanced Flash Controller (EFC) */
  UART0_IRQn           =  8, /*  8 SAM3N UART 0 (UART0) */
  UART1_IRQn           =  9, /*  9 SAM3N UART 1 (UART1) */
  PIOA_IRQn            = 11, /* 11 SAM3N Parallel I/O Controller A (PIOA) */
  PIOB_IRQn            = 12, /* 12 SAM3N Parallel I/O Controller B (PIOB) */
  PIOC_IRQn            = 13, /* 13 SAM3N Parallel I/O Controller C (PIOC) */
  USART0_IRQn          = 14, /* 14 SAM3N USART 0 (USART0) */
  USART1_IRQn          = 15, /* 15 SAM3N USART 1 (USART1) */
  TWI0_IRQn            = 19, /* 19 SAM3N Two Wire Interface 0 (TWI0) */
  TWI1_IRQn            = 20, /* 20 SAM3N Two Wire Interface 1 (TWI1) */
  SPI_IRQn             = 21, /* 21 SAM3N Serial Peripheral Interface (SPI) */
  TC0_IRQn             = 23, /* 23 SAM3N Timer/Counter 0 (TC0) */
  TC1_IRQn             = 24, /* 24 SAM3N Timer/Counter 1 (TC1) */
  TC2_IRQn             = 25, /* 25 SAM3N Timer/Counter 2 (TC2) */
  TC3_IRQn             = 26, /* 26 SAM3N Timer/Counter 3 (TC3) */
  TC4_IRQn             = 27, /* 27 SAM3N Timer/Counter 4 (TC4) */
  TC5_IRQn             = 28, /* 28 SAM3N Timer/Counter 5 (TC5) */
  ADC_IRQn             = 29, /* 29 SAM3N Analog To Digital Converter (ADC) */
  DACC_IRQn            = 30, /* 30 SAM3N Digital To Analog Converter (DACC) */
  PWM_IRQn             = 31  /* 31 SAM3N Pulse Width Modulation (PWM) */
} IRQn_Type;

/*
 *  Configuration of the Cortex-M3 Processor and Core Peripherals 
 */

#define __MPU_PRESENT          0 /* $product does not provide a MPU */
#define __NVIC_PRIO_BITS       4 /* $product uses 4 Bits for the Priority Levels */
#define __Vendor_SysTickConfig 0 /* Set to 1 if different SysTick Config is used */


/* ************************************************************************** */
/*  SOFTWARE PERIPHERAL API DEFINITION FOR SAM3N */
/* ************************************************************************** */
/* ============================================================================= */
/*  SOFTWARE API DEFINITION FOR Analog-to-digital Converter */
/* ============================================================================= */

#ifndef __ASSEMBLY__
/* Adc hardware registers */
typedef struct {
  WoReg ADC_CR;        /*  (Adc Offset: 0x00) Control Register */
  RwReg ADC_MR;        /*  (Adc Offset: 0x04) Mode Register */
  RwReg ADC_SEQR1;     /*  (Adc Offset: 0x08) Channel Sequence Register 1 */
  RwReg ADC_SEQR2;     /*  (Adc Offset: 0x0C) Channel Sequence Register 2 */
  WoReg ADC_CHER;      /*  (Adc Offset: 0x10) Channel Enable Register */
  WoReg ADC_CHDR;      /*  (Adc Offset: 0x14) Channel Disable Register */
  RoReg ADC_CHSR;      /*  (Adc Offset: 0x18) Channel Status Register */
  RwReg Reserved1[1]; 
  RoReg ADC_LCDR;      /*  (Adc Offset: 0x20) Last Converted Data Register */
  WoReg ADC_IER;       /*  (Adc Offset: 0x24) Interrupt Enable Register */
  WoReg ADC_IDR;       /*  (Adc Offset: 0x28) Interrupt Disable Register */
  RoReg ADC_IMR;       /*  (Adc Offset: 0x2C) Interrupt Mask Register */
  RoReg ADC_ISR;       /*  (Adc Offset: 0x30) Interrupt Status Register */
  RwReg Reserved2[2]; 
  RoReg ADC_OVER;      /*  (Adc Offset: 0x3C) Overrun Status Register */
  RwReg ADC_EMR;       /*  (Adc Offset: 0x40) Extended Mode Register */
  RwReg ADC_CWR;       /*  (Adc Offset: 0x44) Compare Window Register */
  RwReg Reserved3[2]; 
  RoReg ADC_CDR[16];   /*  (Adc Offset: 0x50) Channel Data Register */
  RwReg Reserved4[21];
  RwReg ADC_WPMR;      /*  (Adc Offset: 0xE4) Write Protect Mode Register */
  RoReg ADC_WPSR;      /*  (Adc Offset: 0xE8) Write Protect Status Register */
  RwReg Reserved5[5]; 
  RwReg ADC_RPR;       /*  (Adc Offset: 0x100) Receive Pointer Register */
  RwReg ADC_RCR;       /*  (Adc Offset: 0x104) Receive Counter Register */
  RwReg ADC_TPR;       /*  (Adc Offset: 0x108) Transmit Pointer Register */
  RwReg ADC_TCR;       /*  (Adc Offset: 0x10C) Transmit Counter Register */
  RwReg ADC_RNPR;      /*  (Adc Offset: 0x110) Receive Next Pointer Register */
  RwReg ADC_RNCR;      /*  (Adc Offset: 0x114) Receive Next Counter Register */
  RwReg ADC_TNPR;      /*  (Adc Offset: 0x118) Transmit Next Pointer Register */
  RwReg ADC_TNCR;      /*  (Adc Offset: 0x11C) Transmit Next Counter Register */
  WoReg ADC_PTCR;      /*  (Adc Offset: 0x120) Transfer Control Register */
  RoReg ADC_PTSR;      /*  (Adc Offset: 0x124) Transfer Status Register */
} Adc;
#endif /* __ASSEMBLY__ */
/* -------- ADC_CR : (ADC Offset: 0x00) Control Register -------- */
#define ADC_CR_SWRST (0x1u << 0) /*  (ADC_CR) Software Reset */
#define ADC_CR_START (0x1u << 1) /*  (ADC_CR) Start Conversion */
/* -------- ADC_MR : (ADC Offset: 0x04) Mode Register -------- */
#define ADC_MR_TRGEN (0x1u << 0) /*  (ADC_MR) Trigger Enable */
#define   ADC_MR_TRGEN_DIS (0x0u << 0) /*  (ADC_MR) Hardware triggers are disabled. Starting a conversion is only possible by software. */
#define   ADC_MR_TRGEN_EN (0x1u << 0) /*  (ADC_MR) Hardware trigger selected by TRGSEL field is enabled. */
#define ADC_MR_TRGSEL_Pos 1
#define ADC_MR_TRGSEL_Msk (0x7u << ADC_MR_TRGSEL_Pos) /*  (ADC_MR) Trigger Selection */
#define   ADC_MR_TRGSEL_ADC_TRIG0 (0x0u << 1) /*  (ADC_MR) External trigger */
#define   ADC_MR_TRGSEL_ADC_TRIG1 (0x1u << 1) /*  (ADC_MR) TIO Output of the Timer Counter Channel 0 */
#define   ADC_MR_TRGSEL_ADC_TRIG2 (0x2u << 1) /*  (ADC_MR) TIO Output of the Timer Counter Channel 1 */
#define   ADC_MR_TRGSEL_ADC_TRIG3 (0x3u << 1) /*  (ADC_MR) TIO Output of the Timer Counter Channel 2 */
#define ADC_MR_LOWRES (0x1u << 4) /*  (ADC_MR) Resolution */
#define   ADC_MR_LOWRES_BITS_10 (0x0u << 4) /*  (ADC_MR) 10-bit resolution */
#define   ADC_MR_LOWRES_BITS_8 (0x1u << 4) /*  (ADC_MR) 8-bit resolution */
#define ADC_MR_SLEEP (0x1u << 5) /*  (ADC_MR) Sleep Mode */
#define   ADC_MR_SLEEP_NORMAL (0x0u << 5) /*  (ADC_MR) Normal Mode: The ADC Core and reference voltage circuitry are kept ON between conversions */
#define   ADC_MR_SLEEP_SLEEP (0x1u << 5) /*  (ADC_MR) Sleep Mode: The ADC Core and reference voltage circuitry are OFF between conversions */
#define ADC_MR_FWUP (0x1u << 6) /*  (ADC_MR) Fast Wake Up */
#define   ADC_MR_FWUP_OFF (0x0u << 6) /*  (ADC_MR) Normal Sleep Mode: The sleep mode is defined by the SLEEP bit */
#define   ADC_MR_FWUP_ON (0x1u << 6) /*  (ADC_MR) Fast Wake Up Sleep Mode: The Voltage reference is ON between conversions and ADC Core is OFF */
#define ADC_MR_FREERUN (0x1u << 7) /*  (ADC_MR) Free Run Mode */
#define   ADC_MR_FREERUN_OFF (0x0u << 7) /*  (ADC_MR) Normal Mode */
#define   ADC_MR_FREERUN_ON (0x1u << 7) /*  (ADC_MR) Free Run Mode: Never wait for any trigger. */
#define ADC_MR_PRESCAL_Pos 8
#define ADC_MR_PRESCAL_Msk (0xffu << ADC_MR_PRESCAL_Pos) /*  (ADC_MR) Prescaler Rate Selection */
#define ADC_MR_PRESCAL(value) ((ADC_MR_PRESCAL_Msk & ((value) << ADC_MR_PRESCAL_Pos)))
#define ADC_MR_STARTUP_Pos 16
#define ADC_MR_STARTUP_Msk (0xfu << ADC_MR_STARTUP_Pos) /*  (ADC_MR) Start Up Time */
#define   ADC_MR_STARTUP_SUT0 (0x0u << 16) /*  (ADC_MR) 0 periods of ADCClock */
#define   ADC_MR_STARTUP_SUT8 (0x1u << 16) /*  (ADC_MR) 8 periods of ADCClock */
#define   ADC_MR_STARTUP_SUT16 (0x2u << 16) /*  (ADC_MR) 16 periods of ADCClock */
#define   ADC_MR_STARTUP_SUT24 (0x3u << 16) /*  (ADC_MR) 24 periods of ADCClock */
#define   ADC_MR_STARTUP_SUT64 (0x4u << 16) /*  (ADC_MR) 64 periods of ADCClock */
#define   ADC_MR_STARTUP_SUT80 (0x5u << 16) /*  (ADC_MR) 80 periods of ADCClock */
#define   ADC_MR_STARTUP_SUT96 (0x6u << 16) /*  (ADC_MR) 96 periods of ADCClock */
#define   ADC_MR_STARTUP_SUT112 (0x7u << 16) /*  (ADC_MR) 112 periods of ADCClock */
#define   ADC_MR_STARTUP_SUT512 (0x8u << 16) /*  (ADC_MR) 512 periods of ADCClock */
#define   ADC_MR_STARTUP_SUT576 (0x9u << 16) /*  (ADC_MR) 576 periods of ADCClock */
#define   ADC_MR_STARTUP_SUT640 (0xAu << 16) /*  (ADC_MR) 640 periods of ADCClock */
#define   ADC_MR_STARTUP_SUT704 (0xBu << 16) /*  (ADC_MR) 704 periods of ADCClock */
#define   ADC_MR_STARTUP_SUT768 (0xCu << 16) /*  (ADC_MR) 768 periods of ADCClock */
#define   ADC_MR_STARTUP_SUT832 (0xDu << 16) /*  (ADC_MR) 832 periods of ADCClock */
#define   ADC_MR_STARTUP_SUT896 (0xEu << 16) /*  (ADC_MR) 896 periods of ADCClock */
#define   ADC_MR_STARTUP_SUT960 (0xFu << 16) /*  (ADC_MR) 960 periods of ADCClock */
#define ADC_MR_TRACKTIM_Pos 24
#define ADC_MR_TRACKTIM_Msk (0xfu << ADC_MR_TRACKTIM_Pos) /*  (ADC_MR) Tracking Time */
#define ADC_MR_TRACKTIM(value) ((ADC_MR_TRACKTIM_Msk & ((value) << ADC_MR_TRACKTIM_Pos)))
#define ADC_MR_USEQ (0x1u << 31) /*  (ADC_MR) Use Sequence Enable */
#define   ADC_MR_USEQ_NUM_ORDER (0x0u << 31) /*  (ADC_MR) Normal Mode: The controller converts channels in a simple numeric order. */
#define   ADC_MR_USEQ_REG_ORDER (0x1u << 31) /*  (ADC_MR) User Sequence Mode: The sequence respects what is defined in ADC_SEQR1 and ADC_SEQR2 registers. */
/* -------- ADC_SEQR1 : (ADC Offset: 0x08) Channel Sequence Register 1 -------- */
#define ADC_SEQR1_USCH1_Pos 0
#define ADC_SEQR1_USCH1_Msk (0xfu << ADC_SEQR1_USCH1_Pos) /*  (ADC_SEQR1) User Sequence Number 1 */
#define ADC_SEQR1_USCH1(value) ((ADC_SEQR1_USCH1_Msk & ((value) << ADC_SEQR1_USCH1_Pos)))
#define ADC_SEQR1_USCH2_Pos 4
#define ADC_SEQR1_USCH2_Msk (0xfu << ADC_SEQR1_USCH2_Pos) /*  (ADC_SEQR1) User Sequence Number 2 */
#define ADC_SEQR1_USCH2(value) ((ADC_SEQR1_USCH2_Msk & ((value) << ADC_SEQR1_USCH2_Pos)))
#define ADC_SEQR1_USCH3_Pos 8
#define ADC_SEQR1_USCH3_Msk (0xfu << ADC_SEQR1_USCH3_Pos) /*  (ADC_SEQR1) User Sequence Number 3 */
#define ADC_SEQR1_USCH3(value) ((ADC_SEQR1_USCH3_Msk & ((value) << ADC_SEQR1_USCH3_Pos)))
#define ADC_SEQR1_USCH4_Pos 12
#define ADC_SEQR1_USCH4_Msk (0xfu << ADC_SEQR1_USCH4_Pos) /*  (ADC_SEQR1) User Sequence Number 4 */
#define ADC_SEQR1_USCH4(value) ((ADC_SEQR1_USCH4_Msk & ((value) << ADC_SEQR1_USCH4_Pos)))
#define ADC_SEQR1_USCH5_Pos 16
#define ADC_SEQR1_USCH5_Msk (0xfu << ADC_SEQR1_USCH5_Pos) /*  (ADC_SEQR1) User Sequence Number 5 */
#define ADC_SEQR1_USCH5(value) ((ADC_SEQR1_USCH5_Msk & ((value) << ADC_SEQR1_USCH5_Pos)))
#define ADC_SEQR1_USCH6_Pos 20
#define ADC_SEQR1_USCH6_Msk (0xfu << ADC_SEQR1_USCH6_Pos) /*  (ADC_SEQR1) User Sequence Number 6 */
#define ADC_SEQR1_USCH6(value) ((ADC_SEQR1_USCH6_Msk & ((value) << ADC_SEQR1_USCH6_Pos)))
#define ADC_SEQR1_USCH7_Pos 24
#define ADC_SEQR1_USCH7_Msk (0xfu << ADC_SEQR1_USCH7_Pos) /*  (ADC_SEQR1) User Sequence Number 7 */
#define ADC_SEQR1_USCH7(value) ((ADC_SEQR1_USCH7_Msk & ((value) << ADC_SEQR1_USCH7_Pos)))
#define ADC_SEQR1_USCH8_Pos 28
#define ADC_SEQR1_USCH8_Msk (0xfu << ADC_SEQR1_USCH8_Pos) /*  (ADC_SEQR1) User Sequence Number 8 */
#define ADC_SEQR1_USCH8(value) ((ADC_SEQR1_USCH8_Msk & ((value) << ADC_SEQR1_USCH8_Pos)))
/* -------- ADC_SEQR2 : (ADC Offset: 0x0C) Channel Sequence Register 2 -------- */
#define ADC_SEQR2_USCH9_Pos 0
#define ADC_SEQR2_USCH9_Msk (0xfu << ADC_SEQR2_USCH9_Pos) /*  (ADC_SEQR2) User Sequence Number 9 */
#define ADC_SEQR2_USCH9(value) ((ADC_SEQR2_USCH9_Msk & ((value) << ADC_SEQR2_USCH9_Pos)))
#define ADC_SEQR2_USCH10_Pos 4
#define ADC_SEQR2_USCH10_Msk (0xfu << ADC_SEQR2_USCH10_Pos) /*  (ADC_SEQR2) User Sequence Number 10 */
#define ADC_SEQR2_USCH10(value) ((ADC_SEQR2_USCH10_Msk & ((value) << ADC_SEQR2_USCH10_Pos)))
#define ADC_SEQR2_USCH11_Pos 8
#define ADC_SEQR2_USCH11_Msk (0xfu << ADC_SEQR2_USCH11_Pos) /*  (ADC_SEQR2) User Sequence Number 11 */
#define ADC_SEQR2_USCH11(value) ((ADC_SEQR2_USCH11_Msk & ((value) << ADC_SEQR2_USCH11_Pos)))
#define ADC_SEQR2_USCH12_Pos 12
#define ADC_SEQR2_USCH12_Msk (0xfu << ADC_SEQR2_USCH12_Pos) /*  (ADC_SEQR2) User Sequence Number 12 */
#define ADC_SEQR2_USCH12(value) ((ADC_SEQR2_USCH12_Msk & ((value) << ADC_SEQR2_USCH12_Pos)))
#define ADC_SEQR2_USCH13_Pos 16
#define ADC_SEQR2_USCH13_Msk (0xfu << ADC_SEQR2_USCH13_Pos) /*  (ADC_SEQR2) User Sequence Number 13 */
#define ADC_SEQR2_USCH13(value) ((ADC_SEQR2_USCH13_Msk & ((value) << ADC_SEQR2_USCH13_Pos)))
#define ADC_SEQR2_USCH14_Pos 20
#define ADC_SEQR2_USCH14_Msk (0xfu << ADC_SEQR2_USCH14_Pos) /*  (ADC_SEQR2) User Sequence Number 14 */
#define ADC_SEQR2_USCH14(value) ((ADC_SEQR2_USCH14_Msk & ((value) << ADC_SEQR2_USCH14_Pos)))
#define ADC_SEQR2_USCH15_Pos 24
#define ADC_SEQR2_USCH15_Msk (0xfu << ADC_SEQR2_USCH15_Pos) /*  (ADC_SEQR2) User Sequence Number 15 */
#define ADC_SEQR2_USCH15(value) ((ADC_SEQR2_USCH15_Msk & ((value) << ADC_SEQR2_USCH15_Pos)))
#define ADC_SEQR2_USCH16_Pos 28
#define ADC_SEQR2_USCH16_Msk (0xfu << ADC_SEQR2_USCH16_Pos) /*  (ADC_SEQR2) User Sequence Number 16 */
#define ADC_SEQR2_USCH16(value) ((ADC_SEQR2_USCH16_Msk & ((value) << ADC_SEQR2_USCH16_Pos)))
/* -------- ADC_CHER : (ADC Offset: 0x10) Channel Enable Register -------- */
#define ADC_CHER_CH0 (0x1u << 0) /*  (ADC_CHER) Channel 0 Enable */
#define ADC_CHER_CH1 (0x1u << 1) /*  (ADC_CHER) Channel 1 Enable */
#define ADC_CHER_CH2 (0x1u << 2) /*  (ADC_CHER) Channel 2 Enable */
#define ADC_CHER_CH3 (0x1u << 3) /*  (ADC_CHER) Channel 3 Enable */
#define ADC_CHER_CH4 (0x1u << 4) /*  (ADC_CHER) Channel 4 Enable */
#define ADC_CHER_CH5 (0x1u << 5) /*  (ADC_CHER) Channel 5 Enable */
#define ADC_CHER_CH6 (0x1u << 6) /*  (ADC_CHER) Channel 6 Enable */
#define ADC_CHER_CH7 (0x1u << 7) /*  (ADC_CHER) Channel 7 Enable */
#define ADC_CHER_CH8 (0x1u << 8) /*  (ADC_CHER) Channel 8 Enable */
#define ADC_CHER_CH9 (0x1u << 9) /*  (ADC_CHER) Channel 9 Enable */
#define ADC_CHER_CH10 (0x1u << 10) /*  (ADC_CHER) Channel 10 Enable */
#define ADC_CHER_CH11 (0x1u << 11) /*  (ADC_CHER) Channel 11 Enable */
#define ADC_CHER_CH12 (0x1u << 12) /*  (ADC_CHER) Channel 12 Enable */
#define ADC_CHER_CH13 (0x1u << 13) /*  (ADC_CHER) Channel 13 Enable */
#define ADC_CHER_CH14 (0x1u << 14) /*  (ADC_CHER) Channel 14 Enable */
#define ADC_CHER_CH15 (0x1u << 15) /*  (ADC_CHER) Channel 15 Enable */
/* -------- ADC_CHDR : (ADC Offset: 0x14) Channel Disable Register -------- */
#define ADC_CHDR_CH0 (0x1u << 0) /*  (ADC_CHDR) Channel 0 Disable */
#define ADC_CHDR_CH1 (0x1u << 1) /*  (ADC_CHDR) Channel 1 Disable */
#define ADC_CHDR_CH2 (0x1u << 2) /*  (ADC_CHDR) Channel 2 Disable */
#define ADC_CHDR_CH3 (0x1u << 3) /*  (ADC_CHDR) Channel 3 Disable */
#define ADC_CHDR_CH4 (0x1u << 4) /*  (ADC_CHDR) Channel 4 Disable */
#define ADC_CHDR_CH5 (0x1u << 5) /*  (ADC_CHDR) Channel 5 Disable */
#define ADC_CHDR_CH6 (0x1u << 6) /*  (ADC_CHDR) Channel 6 Disable */
#define ADC_CHDR_CH7 (0x1u << 7) /*  (ADC_CHDR) Channel 7 Disable */
#define ADC_CHDR_CH8 (0x1u << 8) /*  (ADC_CHDR) Channel 8 Disable */
#define ADC_CHDR_CH9 (0x1u << 9) /*  (ADC_CHDR) Channel 9 Disable */
#define ADC_CHDR_CH10 (0x1u << 10) /*  (ADC_CHDR) Channel 10 Disable */
#define ADC_CHDR_CH11 (0x1u << 11) /*  (ADC_CHDR) Channel 11 Disable */
#define ADC_CHDR_CH12 (0x1u << 12) /*  (ADC_CHDR) Channel 12 Disable */
#define ADC_CHDR_CH13 (0x1u << 13) /*  (ADC_CHDR) Channel 13 Disable */
#define ADC_CHDR_CH14 (0x1u << 14) /*  (ADC_CHDR) Channel 14 Disable */
#define ADC_CHDR_CH15 (0x1u << 15) /*  (ADC_CHDR) Channel 15 Disable */
/* -------- ADC_CHSR : (ADC Offset: 0x18) Channel Status Register -------- */
#define ADC_CHSR_CH0 (0x1u << 0) /*  (ADC_CHSR) Channel 0 Status */
#define ADC_CHSR_CH1 (0x1u << 1) /*  (ADC_CHSR) Channel 1 Status */
#define ADC_CHSR_CH2 (0x1u << 2) /*  (ADC_CHSR) Channel 2 Status */
#define ADC_CHSR_CH3 (0x1u << 3) /*  (ADC_CHSR) Channel 3 Status */
#define ADC_CHSR_CH4 (0x1u << 4) /*  (ADC_CHSR) Channel 4 Status */
#define ADC_CHSR_CH5 (0x1u << 5) /*  (ADC_CHSR) Channel 5 Status */
#define ADC_CHSR_CH6 (0x1u << 6) /*  (ADC_CHSR) Channel 6 Status */
#define ADC_CHSR_CH7 (0x1u << 7) /*  (ADC_CHSR) Channel 7 Status */
#define ADC_CHSR_CH8 (0x1u << 8) /*  (ADC_CHSR) Channel 8 Status */
#define ADC_CHSR_CH9 (0x1u << 9) /*  (ADC_CHSR) Channel 9 Status */
#define ADC_CHSR_CH10 (0x1u << 10) /*  (ADC_CHSR) Channel 10 Status */
#define ADC_CHSR_CH11 (0x1u << 11) /*  (ADC_CHSR) Channel 11 Status */
#define ADC_CHSR_CH12 (0x1u << 12) /*  (ADC_CHSR) Channel 12 Status */
#define ADC_CHSR_CH13 (0x1u << 13) /*  (ADC_CHSR) Channel 13 Status */
#define ADC_CHSR_CH14 (0x1u << 14) /*  (ADC_CHSR) Channel 14 Status */
#define ADC_CHSR_CH15 (0x1u << 15) /*  (ADC_CHSR) Channel 15 Status */
/* -------- ADC_LCDR : (ADC Offset: 0x20) Last Converted Data Register -------- */
#define ADC_LCDR_LDATA_Pos 0
#define ADC_LCDR_LDATA_Msk (0xfffu << ADC_LCDR_LDATA_Pos) /*  (ADC_LCDR) Last Data Converted */
#define ADC_LCDR_CHNB_Pos 12
#define ADC_LCDR_CHNB_Msk (0xfu << ADC_LCDR_CHNB_Pos) /*  (ADC_LCDR) Channel Number */
/* -------- ADC_IER : (ADC Offset: 0x24) Interrupt Enable Register -------- */
#define ADC_IER_EOC0 (0x1u << 0) /*  (ADC_IER) End of Conversion Interrupt Enable 0 */
#define ADC_IER_EOC1 (0x1u << 1) /*  (ADC_IER) End of Conversion Interrupt Enable 1 */
#define ADC_IER_EOC2 (0x1u << 2) /*  (ADC_IER) End of Conversion Interrupt Enable 2 */
#define ADC_IER_EOC3 (0x1u << 3) /*  (ADC_IER) End of Conversion Interrupt Enable 3 */
#define ADC_IER_EOC4 (0x1u << 4) /*  (ADC_IER) End of Conversion Interrupt Enable 4 */
#define ADC_IER_EOC5 (0x1u << 5) /*  (ADC_IER) End of Conversion Interrupt Enable 5 */
#define ADC_IER_EOC6 (0x1u << 6) /*  (ADC_IER) End of Conversion Interrupt Enable 6 */
#define ADC_IER_EOC7 (0x1u << 7) /*  (ADC_IER) End of Conversion Interrupt Enable 7 */
#define ADC_IER_EOC8 (0x1u << 8) /*  (ADC_IER) End of Conversion Interrupt Enable 8 */
#define ADC_IER_EOC9 (0x1u << 9) /*  (ADC_IER) End of Conversion Interrupt Enable 9 */
#define ADC_IER_EOC10 (0x1u << 10) /*  (ADC_IER) End of Conversion Interrupt Enable 10 */
#define ADC_IER_EOC11 (0x1u << 11) /*  (ADC_IER) End of Conversion Interrupt Enable 11 */
#define ADC_IER_EOC12 (0x1u << 12) /*  (ADC_IER) End of Conversion Interrupt Enable 12 */
#define ADC_IER_EOC13 (0x1u << 13) /*  (ADC_IER) End of Conversion Interrupt Enable 13 */
#define ADC_IER_EOC14 (0x1u << 14) /*  (ADC_IER) End of Conversion Interrupt Enable 14 */
#define ADC_IER_EOC15 (0x1u << 15) /*  (ADC_IER) End of Conversion Interrupt Enable 15 */
#define ADC_IER_DRDY (0x1u << 24) /*  (ADC_IER) Data Ready Interrupt Enable */
#define ADC_IER_GOVRE (0x1u << 25) /*  (ADC_IER) General Overrun Error Interrupt Enable */
#define ADC_IER_COMPE (0x1u << 26) /*  (ADC_IER) Comparison Event Interrupt Enable */
#define ADC_IER_ENDRX (0x1u << 27) /*  (ADC_IER) End of Receive Buffer Interrupt Enable */
#define ADC_IER_RXBUFF (0x1u << 28) /*  (ADC_IER) Receive Buffer Full Interrupt Enable */
/* -------- ADC_IDR : (ADC Offset: 0x28) Interrupt Disable Register -------- */
#define ADC_IDR_EOC0 (0x1u << 0) /*  (ADC_IDR) End of Conversion Interrupt Disable 0 */
#define ADC_IDR_EOC1 (0x1u << 1) /*  (ADC_IDR) End of Conversion Interrupt Disable 1 */
#define ADC_IDR_EOC2 (0x1u << 2) /*  (ADC_IDR) End of Conversion Interrupt Disable 2 */
#define ADC_IDR_EOC3 (0x1u << 3) /*  (ADC_IDR) End of Conversion Interrupt Disable 3 */
#define ADC_IDR_EOC4 (0x1u << 4) /*  (ADC_IDR) End of Conversion Interrupt Disable 4 */
#define ADC_IDR_EOC5 (0x1u << 5) /*  (ADC_IDR) End of Conversion Interrupt Disable 5 */
#define ADC_IDR_EOC6 (0x1u << 6) /*  (ADC_IDR) End of Conversion Interrupt Disable 6 */
#define ADC_IDR_EOC7 (0x1u << 7) /*  (ADC_IDR) End of Conversion Interrupt Disable 7 */
#define ADC_IDR_EOC8 (0x1u << 8) /*  (ADC_IDR) End of Conversion Interrupt Disable 8 */
#define ADC_IDR_EOC9 (0x1u << 9) /*  (ADC_IDR) End of Conversion Interrupt Disable 9 */
#define ADC_IDR_EOC10 (0x1u << 10) /*  (ADC_IDR) End of Conversion Interrupt Disable 10 */
#define ADC_IDR_EOC11 (0x1u << 11) /*  (ADC_IDR) End of Conversion Interrupt Disable 11 */
#define ADC_IDR_EOC12 (0x1u << 12) /*  (ADC_IDR) End of Conversion Interrupt Disable 12 */
#define ADC_IDR_EOC13 (0x1u << 13) /*  (ADC_IDR) End of Conversion Interrupt Disable 13 */
#define ADC_IDR_EOC14 (0x1u << 14) /*  (ADC_IDR) End of Conversion Interrupt Disable 14 */
#define ADC_IDR_EOC15 (0x1u << 15) /*  (ADC_IDR) End of Conversion Interrupt Disable 15 */
#define ADC_IDR_DRDY (0x1u << 24) /*  (ADC_IDR) Data Ready Interrupt Disable */
#define ADC_IDR_GOVRE (0x1u << 25) /*  (ADC_IDR) General Overrun Error Interrupt Disable */
#define ADC_IDR_COMPE (0x1u << 26) /*  (ADC_IDR) Comparison Event Interrupt Disable */
#define ADC_IDR_ENDRX (0x1u << 27) /*  (ADC_IDR) End of Receive Buffer Interrupt Disable */
#define ADC_IDR_RXBUFF (0x1u << 28) /*  (ADC_IDR) Receive Buffer Full Interrupt Disable */
/* -------- ADC_IMR : (ADC Offset: 0x2C) Interrupt Mask Register -------- */
#define ADC_IMR_EOC0 (0x1u << 0) /*  (ADC_IMR) End of Conversion Interrupt Mask 0 */
#define ADC_IMR_EOC1 (0x1u << 1) /*  (ADC_IMR) End of Conversion Interrupt Mask 1 */
#define ADC_IMR_EOC2 (0x1u << 2) /*  (ADC_IMR) End of Conversion Interrupt Mask 2 */
#define ADC_IMR_EOC3 (0x1u << 3) /*  (ADC_IMR) End of Conversion Interrupt Mask 3 */
#define ADC_IMR_EOC4 (0x1u << 4) /*  (ADC_IMR) End of Conversion Interrupt Mask 4 */
#define ADC_IMR_EOC5 (0x1u << 5) /*  (ADC_IMR) End of Conversion Interrupt Mask 5 */
#define ADC_IMR_EOC6 (0x1u << 6) /*  (ADC_IMR) End of Conversion Interrupt Mask 6 */
#define ADC_IMR_EOC7 (0x1u << 7) /*  (ADC_IMR) End of Conversion Interrupt Mask 7 */
#define ADC_IMR_EOC8 (0x1u << 8) /*  (ADC_IMR) End of Conversion Interrupt Mask 8 */
#define ADC_IMR_EOC9 (0x1u << 9) /*  (ADC_IMR) End of Conversion Interrupt Mask 9 */
#define ADC_IMR_EOC10 (0x1u << 10) /*  (ADC_IMR) End of Conversion Interrupt Mask 10 */
#define ADC_IMR_EOC11 (0x1u << 11) /*  (ADC_IMR) End of Conversion Interrupt Mask 11 */
#define ADC_IMR_EOC12 (0x1u << 12) /*  (ADC_IMR) End of Conversion Interrupt Mask 12 */
#define ADC_IMR_EOC13 (0x1u << 13) /*  (ADC_IMR) End of Conversion Interrupt Mask 13 */
#define ADC_IMR_EOC14 (0x1u << 14) /*  (ADC_IMR) End of Conversion Interrupt Mask 14 */
#define ADC_IMR_EOC15 (0x1u << 15) /*  (ADC_IMR) End of Conversion Interrupt Mask 15 */
#define ADC_IMR_DRDY (0x1u << 24) /*  (ADC_IMR) Data Ready Interrupt Mask */
#define ADC_IMR_GOVRE (0x1u << 25) /*  (ADC_IMR) General Overrun Error Interrupt Mask */
#define ADC_IMR_COMPE (0x1u << 26) /*  (ADC_IMR) Comparison Event Interrupt Mask */
#define ADC_IMR_ENDRX (0x1u << 27) /*  (ADC_IMR) End of Receive Buffer Interrupt Mask */
#define ADC_IMR_RXBUFF (0x1u << 28) /*  (ADC_IMR) Receive Buffer Full Interrupt Mask */
/* -------- ADC_ISR : (ADC Offset: 0x30) Interrupt Status Register -------- */
#define ADC_ISR_EOC0 (0x1u << 0) /*  (ADC_ISR) End of Conversion 0 */
#define ADC_ISR_EOC1 (0x1u << 1) /*  (ADC_ISR) End of Conversion 1 */
#define ADC_ISR_EOC2 (0x1u << 2) /*  (ADC_ISR) End of Conversion 2 */
#define ADC_ISR_EOC3 (0x1u << 3) /*  (ADC_ISR) End of Conversion 3 */
#define ADC_ISR_EOC4 (0x1u << 4) /*  (ADC_ISR) End of Conversion 4 */
#define ADC_ISR_EOC5 (0x1u << 5) /*  (ADC_ISR) End of Conversion 5 */
#define ADC_ISR_EOC6 (0x1u << 6) /*  (ADC_ISR) End of Conversion 6 */
#define ADC_ISR_EOC7 (0x1u << 7) /*  (ADC_ISR) End of Conversion 7 */
#define ADC_ISR_EOC8 (0x1u << 8) /*  (ADC_ISR) End of Conversion 8 */
#define ADC_ISR_EOC9 (0x1u << 9) /*  (ADC_ISR) End of Conversion 9 */
#define ADC_ISR_EOC10 (0x1u << 10) /*  (ADC_ISR) End of Conversion 10 */
#define ADC_ISR_EOC11 (0x1u << 11) /*  (ADC_ISR) End of Conversion 11 */
#define ADC_ISR_EOC12 (0x1u << 12) /*  (ADC_ISR) End of Conversion 12 */
#define ADC_ISR_EOC13 (0x1u << 13) /*  (ADC_ISR) End of Conversion 13 */
#define ADC_ISR_EOC14 (0x1u << 14) /*  (ADC_ISR) End of Conversion 14 */
#define ADC_ISR_EOC15 (0x1u << 15) /*  (ADC_ISR) End of Conversion 15 */
#define ADC_ISR_DRDY (0x1u << 24) /*  (ADC_ISR) Data Ready */
#define ADC_ISR_GOVRE (0x1u << 25) /*  (ADC_ISR) General Overrun Error */
#define ADC_ISR_COMPE (0x1u << 26) /*  (ADC_ISR) Comparison Error */
#define ADC_ISR_ENDRX (0x1u << 27) /*  (ADC_ISR) End of RX Buffer */
#define ADC_ISR_RXBUFF (0x1u << 28) /*  (ADC_ISR) RX Buffer Full */
/* -------- ADC_OVER : (ADC Offset: 0x3C) Overrun Status Register -------- */
#define ADC_OVER_OVRE0 (0x1u << 0) /*  (ADC_OVER) Overrun Error 0 */
#define ADC_OVER_OVRE1 (0x1u << 1) /*  (ADC_OVER) Overrun Error 1 */
#define ADC_OVER_OVRE2 (0x1u << 2) /*  (ADC_OVER) Overrun Error 2 */
#define ADC_OVER_OVRE3 (0x1u << 3) /*  (ADC_OVER) Overrun Error 3 */
#define ADC_OVER_OVRE4 (0x1u << 4) /*  (ADC_OVER) Overrun Error 4 */
#define ADC_OVER_OVRE5 (0x1u << 5) /*  (ADC_OVER) Overrun Error 5 */
#define ADC_OVER_OVRE6 (0x1u << 6) /*  (ADC_OVER) Overrun Error 6 */
#define ADC_OVER_OVRE7 (0x1u << 7) /*  (ADC_OVER) Overrun Error 7 */
#define ADC_OVER_OVRE8 (0x1u << 8) /*  (ADC_OVER) Overrun Error 8 */
#define ADC_OVER_OVRE9 (0x1u << 9) /*  (ADC_OVER) Overrun Error 9 */
#define ADC_OVER_OVRE10 (0x1u << 10) /*  (ADC_OVER) Overrun Error 10 */
#define ADC_OVER_OVRE11 (0x1u << 11) /*  (ADC_OVER) Overrun Error 11 */
#define ADC_OVER_OVRE12 (0x1u << 12) /*  (ADC_OVER) Overrun Error 12 */
#define ADC_OVER_OVRE13 (0x1u << 13) /*  (ADC_OVER) Overrun Error 13 */
#define ADC_OVER_OVRE14 (0x1u << 14) /*  (ADC_OVER) Overrun Error 14 */
#define ADC_OVER_OVRE15 (0x1u << 15) /*  (ADC_OVER) Overrun Error 15 */
/* -------- ADC_EMR : (ADC Offset: 0x40) Extended Mode Register -------- */
#define ADC_EMR_CMPMODE_Pos 0
#define ADC_EMR_CMPMODE_Msk (0x3u << ADC_EMR_CMPMODE_Pos) /*  (ADC_EMR) Comparison Mode */
#define   ADC_EMR_CMPMODE_LOW (0x0u << 0) /*  (ADC_EMR) Generates an event when the converted data is lower than the low threshold of the window. */
#define   ADC_EMR_CMPMODE_HIGH (0x1u << 0) /*  (ADC_EMR) Generates an event when the converted data is higher than the high threshold of the window. */
#define   ADC_EMR_CMPMODE_IN (0x2u << 0) /*  (ADC_EMR) Generates an event when the converted data is in the comparison window. */
#define   ADC_EMR_CMPMODE_OUT (0x3u << 0) /*  (ADC_EMR) Generates an event when the converted data is out of the comparison window. */
#define ADC_EMR_CMPSEL_Pos 4
#define ADC_EMR_CMPSEL_Msk (0xfu << ADC_EMR_CMPSEL_Pos) /*  (ADC_EMR) Comparison Selected Channel */
#define ADC_EMR_CMPSEL(value) ((ADC_EMR_CMPSEL_Msk & ((value) << ADC_EMR_CMPSEL_Pos)))
#define ADC_EMR_CMPALL (0x1u << 9) /*  (ADC_EMR) Compare All Channels */
#define ADC_EMR_TAG (0x1u << 24) /*  (ADC_EMR) TAG of ADC_LDCR register */
/* -------- ADC_CWR : (ADC Offset: 0x44) Compare Window Register -------- */
#define ADC_CWR_LOWTHRES_Pos 0
#define ADC_CWR_LOWTHRES_Msk (0xfffu << ADC_CWR_LOWTHRES_Pos) /*  (ADC_CWR) Low Threshold */
#define ADC_CWR_LOWTHRES(value) ((ADC_CWR_LOWTHRES_Msk & ((value) << ADC_CWR_LOWTHRES_Pos)))
#define ADC_CWR_HIGHTHRES_Pos 16
#define ADC_CWR_HIGHTHRES_Msk (0xfffu << ADC_CWR_HIGHTHRES_Pos) /*  (ADC_CWR) High Threshold */
#define ADC_CWR_HIGHTHRES(value) ((ADC_CWR_HIGHTHRES_Msk & ((value) << ADC_CWR_HIGHTHRES_Pos)))
/* -------- ADC_CDR[16] : (ADC Offset: 0x50) Channel Data Register -------- */
#define ADC_CDR_DATA_Pos 0
#define ADC_CDR_DATA_Msk (0x3ffu << ADC_CDR_DATA_Pos) /*  (ADC_CDR[16]) Converted Data */
/* -------- ADC_WPMR : (ADC Offset: 0xE4) Write Protect Mode Register -------- */
#define ADC_WPMR_WPEN (0x1u << 0) /*  (ADC_WPMR) Write Protect Enable */
#define ADC_WPMR_WPKEY_Pos 8
#define ADC_WPMR_WPKEY_Msk (0xffffffu << ADC_WPMR_WPKEY_Pos) /*  (ADC_WPMR) Write Protect KEY */
#define ADC_WPMR_WPKEY(value) ((ADC_WPMR_WPKEY_Msk & ((value) << ADC_WPMR_WPKEY_Pos)))
/* -------- ADC_WPSR : (ADC Offset: 0xE8) Write Protect Status Register -------- */
#define ADC_WPSR_WPVS (0x1u << 0) /*  (ADC_WPSR) Write Protect Violation Status */
#define ADC_WPSR_WPVSRC_Pos 8
#define ADC_WPSR_WPVSRC_Msk (0xffffu << ADC_WPSR_WPVSRC_Pos) /*  (ADC_WPSR) Write Protect Violation Source */
/* -------- ADC_RPR : (ADC Offset: 0x100) Receive Pointer Register -------- */
#define ADC_RPR_RXPTR_Pos 0
#define ADC_RPR_RXPTR_Msk (0xffffffffu << ADC_RPR_RXPTR_Pos) /*  (ADC_RPR) Receive Pointer Register */
#define ADC_RPR_RXPTR(value) ((ADC_RPR_RXPTR_Msk & ((value) << ADC_RPR_RXPTR_Pos)))
/* -------- ADC_RCR : (ADC Offset: 0x104) Receive Counter Register -------- */
#define ADC_RCR_RXCTR_Pos 0
#define ADC_RCR_RXCTR_Msk (0xffffu << ADC_RCR_RXCTR_Pos) /*  (ADC_RCR) Receive Counter Register */
#define ADC_RCR_RXCTR(value) ((ADC_RCR_RXCTR_Msk & ((value) << ADC_RCR_RXCTR_Pos)))
/* -------- ADC_TPR : (ADC Offset: 0x108) Transmit Pointer Register -------- */
#define ADC_TPR_TXPTR_Pos 0
#define ADC_TPR_TXPTR_Msk (0xffffffffu << ADC_TPR_TXPTR_Pos) /*  (ADC_TPR) Transmit Counter Register */
#define ADC_TPR_TXPTR(value) ((ADC_TPR_TXPTR_Msk & ((value) << ADC_TPR_TXPTR_Pos)))
/* -------- ADC_TCR : (ADC Offset: 0x10C) Transmit Counter Register -------- */
#define ADC_TCR_TXCTR_Pos 0
#define ADC_TCR_TXCTR_Msk (0xffffu << ADC_TCR_TXCTR_Pos) /*  (ADC_TCR) Transmit Counter Register */
#define ADC_TCR_TXCTR(value) ((ADC_TCR_TXCTR_Msk & ((value) << ADC_TCR_TXCTR_Pos)))
/* -------- ADC_RNPR : (ADC Offset: 0x110) Receive Next Pointer Register -------- */
#define ADC_RNPR_RXNPTR_Pos 0
#define ADC_RNPR_RXNPTR_Msk (0xffffffffu << ADC_RNPR_RXNPTR_Pos) /*  (ADC_RNPR) Receive Next Pointer */
#define ADC_RNPR_RXNPTR(value) ((ADC_RNPR_RXNPTR_Msk & ((value) << ADC_RNPR_RXNPTR_Pos)))
/* -------- ADC_RNCR : (ADC Offset: 0x114) Receive Next Counter Register -------- */
#define ADC_RNCR_RXNCTR_Pos 0
#define ADC_RNCR_RXNCTR_Msk (0xffffu << ADC_RNCR_RXNCTR_Pos) /*  (ADC_RNCR) Receive Next Counter */
#define ADC_RNCR_RXNCTR(value) ((ADC_RNCR_RXNCTR_Msk & ((value) << ADC_RNCR_RXNCTR_Pos)))
/* -------- ADC_TNPR : (ADC Offset: 0x118) Transmit Next Pointer Register -------- */
#define ADC_TNPR_TXNPTR_Pos 0
#define ADC_TNPR_TXNPTR_Msk (0xffffffffu << ADC_TNPR_TXNPTR_Pos) /*  (ADC_TNPR) Transmit Next Pointer */
#define ADC_TNPR_TXNPTR(value) ((ADC_TNPR_TXNPTR_Msk & ((value) << ADC_TNPR_TXNPTR_Pos)))
/* -------- ADC_TNCR : (ADC Offset: 0x11C) Transmit Next Counter Register -------- */
#define ADC_TNCR_TXNCTR_Pos 0
#define ADC_TNCR_TXNCTR_Msk (0xffffu << ADC_TNCR_TXNCTR_Pos) /*  (ADC_TNCR) Transmit Counter Next */
#define ADC_TNCR_TXNCTR(value) ((ADC_TNCR_TXNCTR_Msk & ((value) << ADC_TNCR_TXNCTR_Pos)))
/* -------- ADC_PTCR : (ADC Offset: 0x120) Transfer Control Register -------- */
#define ADC_PTCR_RXTEN (0x1u << 0) /*  (ADC_PTCR) Receiver Transfer Enable */
#define ADC_PTCR_RXTDIS (0x1u << 1) /*  (ADC_PTCR) Receiver Transfer Disable */
#define ADC_PTCR_TXTEN (0x1u << 8) /*  (ADC_PTCR) Transmitter Transfer Enable */
#define ADC_PTCR_TXTDIS (0x1u << 9) /*  (ADC_PTCR) Transmitter Transfer Disable */
/* -------- ADC_PTSR : (ADC Offset: 0x124) Transfer Status Register -------- */
#define ADC_PTSR_RXTEN (0x1u << 0) /*  (ADC_PTSR) Receiver Transfer Enable */
#define ADC_PTSR_TXTEN (0x1u << 8) /*  (ADC_PTSR) Transmitter Transfer Enable */


/* ============================================================================= */
/*  SOFTWARE API DEFINITION FOR Chip Identifier */
/* ============================================================================= */

#ifndef __ASSEMBLY__
/* Chipid hardware registers */
typedef struct {
  RoReg CHIPID_CIDR; /*  (Chipid Offset: 0x0) Chip ID Register */
  RoReg CHIPID_EXID; /*  (Chipid Offset: 0x4) Chip ID Extension Register */
} Chipid;
#endif /* __ASSEMBLY__ */
/* -------- CHIPID_CIDR : (CHIPID Offset: 0x0) Chip ID Register -------- */
#define CHIPID_CIDR_VERSION_Pos 0
#define CHIPID_CIDR_VERSION_Msk (0x1fu << CHIPID_CIDR_VERSION_Pos) /*  (CHIPID_CIDR) Version of the Device */
#define CHIPID_CIDR_EPROC_Pos 5
#define CHIPID_CIDR_EPROC_Msk (0x7u << CHIPID_CIDR_EPROC_Pos) /*  (CHIPID_CIDR) Embedded Processor */
#define   CHIPID_CIDR_EPROC_ARM946ES (0x1u << 5) /*  (CHIPID_CIDR) ARM946ES */
#define   CHIPID_CIDR_EPROC_ARM7TDMI (0x2u << 5) /*  (CHIPID_CIDR) ARM7TDMI */
#define   CHIPID_CIDR_EPROC_CM3 (0x3u << 5) /*  (CHIPID_CIDR) Cortex-M3 */
#define   CHIPID_CIDR_EPROC_ARM920T (0x4u << 5) /*  (CHIPID_CIDR) ARM920T */
#define   CHIPID_CIDR_EPROC_ARM926EJS (0x5u << 5) /*  (CHIPID_CIDR) ARM926EJS */
#define   CHIPID_CIDR_EPROC_CA5 (0x6u << 5) /*  (CHIPID_CIDR) Cortex-A5 */
#define CHIPID_CIDR_NVPSIZ_Pos 8
#define CHIPID_CIDR_NVPSIZ_Msk (0xfu << CHIPID_CIDR_NVPSIZ_Pos) /*  (CHIPID_CIDR) Nonvolatile Program Memory Size */
#define   CHIPID_CIDR_NVPSIZ_NONE (0x0u << 8) /*  (CHIPID_CIDR) None */
#define   CHIPID_CIDR_NVPSIZ_8K (0x1u << 8) /*  (CHIPID_CIDR) 8K bytes */
#define   CHIPID_CIDR_NVPSIZ_16K (0x2u << 8) /*  (CHIPID_CIDR) 16K bytes */
#define   CHIPID_CIDR_NVPSIZ_32K (0x3u << 8) /*  (CHIPID_CIDR) 32K bytes */
#define   CHIPID_CIDR_NVPSIZ_64K (0x5u << 8) /*  (CHIPID_CIDR) 64K bytes */
#define   CHIPID_CIDR_NVPSIZ_128K (0x7u << 8) /*  (CHIPID_CIDR) 128K bytes */
#define   CHIPID_CIDR_NVPSIZ_256K (0x9u << 8) /*  (CHIPID_CIDR) 256K bytes */
#define   CHIPID_CIDR_NVPSIZ_512K (0xAu << 8) /*  (CHIPID_CIDR) 512K bytes */
#define   CHIPID_CIDR_NVPSIZ_1024K (0xCu << 8) /*  (CHIPID_CIDR) 1024K bytes */
#define   CHIPID_CIDR_NVPSIZ_2048K (0xEu << 8) /*  (CHIPID_CIDR) 2048K bytes */
#define CHIPID_CIDR_NVPSIZ2_Pos 12
#define CHIPID_CIDR_NVPSIZ2_Msk (0xfu << CHIPID_CIDR_NVPSIZ2_Pos) /*  (CHIPID_CIDR)  */
#define   CHIPID_CIDR_NVPSIZ2_NONE (0x0u << 12) /*  (CHIPID_CIDR) None */
#define   CHIPID_CIDR_NVPSIZ2_8K (0x1u << 12) /*  (CHIPID_CIDR) 8K bytes */
#define   CHIPID_CIDR_NVPSIZ2_16K (0x2u << 12) /*  (CHIPID_CIDR) 16K bytes */
#define   CHIPID_CIDR_NVPSIZ2_32K (0x3u << 12) /*  (CHIPID_CIDR) 32K bytes */
#define   CHIPID_CIDR_NVPSIZ2_64K (0x5u << 12) /*  (CHIPID_CIDR) 64K bytes */
#define   CHIPID_CIDR_NVPSIZ2_128K (0x7u << 12) /*  (CHIPID_CIDR) 128K bytes */
#define   CHIPID_CIDR_NVPSIZ2_256K (0x9u << 12) /*  (CHIPID_CIDR) 256K bytes */
#define   CHIPID_CIDR_NVPSIZ2_512K (0xAu << 12) /*  (CHIPID_CIDR) 512K bytes */
#define   CHIPID_CIDR_NVPSIZ2_1024K (0xCu << 12) /*  (CHIPID_CIDR) 1024K bytes */
#define   CHIPID_CIDR_NVPSIZ2_2048K (0xEu << 12) /*  (CHIPID_CIDR) 2048K bytes */
#define CHIPID_CIDR_SRAMSIZ_Pos 16
#define CHIPID_CIDR_SRAMSIZ_Msk (0xfu << CHIPID_CIDR_SRAMSIZ_Pos) /*  (CHIPID_CIDR) Internal SRAM Size */
#define   CHIPID_CIDR_SRAMSIZ_48K (0x0u << 16) /*  (CHIPID_CIDR) 48K bytes */
#define   CHIPID_CIDR_SRAMSIZ_1K (0x1u << 16) /*  (CHIPID_CIDR) 1K bytes */
#define   CHIPID_CIDR_SRAMSIZ_2K (0x2u << 16) /*  (CHIPID_CIDR) 2K bytes */
#define   CHIPID_CIDR_SRAMSIZ_6K (0x3u << 16) /*  (CHIPID_CIDR) 6K bytes */
#define   CHIPID_CIDR_SRAMSIZ_112K (0x4u << 16) /*  (CHIPID_CIDR) 112K bytes */
#define   CHIPID_CIDR_SRAMSIZ_4K (0x5u << 16) /*  (CHIPID_CIDR) 4K bytes */
#define   CHIPID_CIDR_SRAMSIZ_80K (0x6u << 16) /*  (CHIPID_CIDR) 80K bytes */
#define   CHIPID_CIDR_SRAMSIZ_160K (0x7u << 16) /*  (CHIPID_CIDR) 160K bytes */
#define   CHIPID_CIDR_SRAMSIZ_8K (0x8u << 16) /*  (CHIPID_CIDR) 8K bytes */
#define   CHIPID_CIDR_SRAMSIZ_16K (0x9u << 16) /*  (CHIPID_CIDR) 16K bytes */
#define   CHIPID_CIDR_SRAMSIZ_32K (0xAu << 16) /*  (CHIPID_CIDR) 32K bytes */
#define   CHIPID_CIDR_SRAMSIZ_64K (0xBu << 16) /*  (CHIPID_CIDR) 64K bytes */
#define   CHIPID_CIDR_SRAMSIZ_128K (0xCu << 16) /*  (CHIPID_CIDR) 128K bytes */
#define   CHIPID_CIDR_SRAMSIZ_256K (0xDu << 16) /*  (CHIPID_CIDR) 256K bytes */
#define   CHIPID_CIDR_SRAMSIZ_96K (0xEu << 16) /*  (CHIPID_CIDR) 96K bytes */
#define   CHIPID_CIDR_SRAMSIZ_512K (0xFu << 16) /*  (CHIPID_CIDR) 512K bytes */
#define CHIPID_CIDR_ARCH_Pos 20
#define CHIPID_CIDR_ARCH_Msk (0xffu << CHIPID_CIDR_ARCH_Pos) /*  (CHIPID_CIDR) Architecture Identifier */
#define   CHIPID_CIDR_ARCH_AT91SAM9xx (0x19u << 20) /*  (CHIPID_CIDR) AT91SAM9xx Series */
#define   CHIPID_CIDR_ARCH_AT91SAM9XExx (0x29u << 20) /*  (CHIPID_CIDR) AT91SAM9XExx Series */
#define   CHIPID_CIDR_ARCH_AT91x34 (0x34u << 20) /*  (CHIPID_CIDR) AT91x34 Series */
#define   CHIPID_CIDR_ARCH_CAP7 (0x37u << 20) /*  (CHIPID_CIDR) CAP7 Series */
#define   CHIPID_CIDR_ARCH_CAP9 (0x39u << 20) /*  (CHIPID_CIDR) CAP9 Series */
#define   CHIPID_CIDR_ARCH_CAP11 (0x3Bu << 20) /*  (CHIPID_CIDR) CAP11 Series */
#define   CHIPID_CIDR_ARCH_AT91x40 (0x40u << 20) /*  (CHIPID_CIDR) AT91x40 Series */
#define   CHIPID_CIDR_ARCH_AT91x42 (0x42u << 20) /*  (CHIPID_CIDR) AT91x42 Series */
#define   CHIPID_CIDR_ARCH_AT91x55 (0x55u << 20) /*  (CHIPID_CIDR) AT91x55 Series */
#define   CHIPID_CIDR_ARCH_AT91SAM7Axx (0x60u << 20) /*  (CHIPID_CIDR) AT91SAM7Axx Series */
#define   CHIPID_CIDR_ARCH_AT91SAM7AQxx (0x61u << 20) /*  (CHIPID_CIDR) AT91SAM7AQxx Series */
#define   CHIPID_CIDR_ARCH_AT91x63 (0x63u << 20) /*  (CHIPID_CIDR) AT91x63 Series */
#define   CHIPID_CIDR_ARCH_AT91SAM7Sxx (0x70u << 20) /*  (CHIPID_CIDR) AT91SAM7Sxx Series */
#define   CHIPID_CIDR_ARCH_AT91SAM7XCxx (0x71u << 20) /*  (CHIPID_CIDR) AT91SAM7XCxx Series */
#define   CHIPID_CIDR_ARCH_AT91SAM7SExx (0x72u << 20) /*  (CHIPID_CIDR) AT91SAM7SExx Series */
#define   CHIPID_CIDR_ARCH_AT91SAM7Lxx (0x73u << 20) /*  (CHIPID_CIDR) AT91SAM7Lxx Series */
#define   CHIPID_CIDR_ARCH_AT91SAM7Xxx (0x75u << 20) /*  (CHIPID_CIDR) AT91SAM7Xxx Series */
#define   CHIPID_CIDR_ARCH_AT91SAM7SLxx (0x76u << 20) /*  (CHIPID_CIDR) AT91SAM7SLxx Series */
#define   CHIPID_CIDR_ARCH_SAM3UxC (0x80u << 20) /*  (CHIPID_CIDR) SAM3UxC Series (100-pin version) */
#define   CHIPID_CIDR_ARCH_SAM3UxE (0x81u << 20) /*  (CHIPID_CIDR) SAM3UxE Series (144-pin version) */
#define   CHIPID_CIDR_ARCH_SAM3AxC (0x83u << 20) /*  (CHIPID_CIDR) SAM3AxC Series (100-pin version) */
#define   CHIPID_CIDR_ARCH_SAM3XxC (0x84u << 20) /*  (CHIPID_CIDR) SAM3XxC Series (100-pin version) */
#define   CHIPID_CIDR_ARCH_SAM3XxE (0x85u << 20) /*  (CHIPID_CIDR) SAM3XxE Series (144-pin version) */
#define   CHIPID_CIDR_ARCH_SAM3XxG (0x86u << 20) /*  (CHIPID_CIDR) SAM3XxG Series (208/217-pin version) */
#define   CHIPID_CIDR_ARCH_SAM3SxA (0x88u << 20) /*  (CHIPID_CIDR) SAM3SxA Series (48-pin version) */
#define   CHIPID_CIDR_ARCH_SAM3SxB (0x89u << 20) /*  (CHIPID_CIDR) SAM3SxB Series (64-pin version) */
#define   CHIPID_CIDR_ARCH_SAM3SxC (0x8Au << 20) /*  (CHIPID_CIDR) SAM3SxC Series (100-pin version) */
#define   CHIPID_CIDR_ARCH_AT91x92 (0x92u << 20) /*  (CHIPID_CIDR) AT91x92 Series */
#define   CHIPID_CIDR_ARCH_SAM3NxA (0x93u << 20) /*  (CHIPID_CIDR) SAM3NxA Series (48-pin version) */
#define   CHIPID_CIDR_ARCH_SAM3NxB (0x94u << 20) /*  (CHIPID_CIDR) SAM3NxB Series (64-pin version) */
#define   CHIPID_CIDR_ARCH_SAM3NxC (0x95u << 20) /*  (CHIPID_CIDR) SAM3NxC Series (100-pin version) */
#define   CHIPID_CIDR_ARCH_SAM3SDxA (0x98u << 20) /*  (CHIPID_CIDR) SAM3SDxA Series (48-pin version) */
#define   CHIPID_CIDR_ARCH_SAM3SDxB (0x99u << 20) /*  (CHIPID_CIDR) SAM3SDxB Series (64-pin version) */
#define   CHIPID_CIDR_ARCH_SAM3SDxC (0x9Au << 20) /*  (CHIPID_CIDR) SAM3SDxC Series (100-pin version) */
#define   CHIPID_CIDR_ARCH_SAM5A (0xA5u << 20) /*  (CHIPID_CIDR) SAM5A */
#define   CHIPID_CIDR_ARCH_AT75Cxx (0xF0u << 20) /*  (CHIPID_CIDR) AT75Cxx Series */
#define CHIPID_CIDR_NVPTYP_Pos 28
#define CHIPID_CIDR_NVPTYP_Msk (0x7u << CHIPID_CIDR_NVPTYP_Pos) /*  (CHIPID_CIDR) Nonvolatile Program Memory Type */
#define   CHIPID_CIDR_NVPTYP_ROM (0x0u << 28) /*  (CHIPID_CIDR) ROM */
#define   CHIPID_CIDR_NVPTYP_ROMLESS (0x1u << 28) /*  (CHIPID_CIDR) ROMless or on-chip Flash */
#define   CHIPID_CIDR_NVPTYP_FLASH (0x2u << 28) /*  (CHIPID_CIDR) Embedded Flash Memory */
#define   CHIPID_CIDR_NVPTYP_ROM_FLASH (0x3u << 28) /*  (CHIPID_CIDR) ROM and Embedded Flash MemoryNVPSIZ is ROM size NVPSIZ2 is Flash size */
#define   CHIPID_CIDR_NVPTYP_SRAM (0x4u << 28) /*  (CHIPID_CIDR) SRAM emulating ROM */
#define CHIPID_CIDR_EXT (0x1u << 31) /*  (CHIPID_CIDR) Extension Flag */
/* -------- CHIPID_EXID : (CHIPID Offset: 0x4) Chip ID Extension Register -------- */
#define CHIPID_EXID_EXID_Pos 0
#define CHIPID_EXID_EXID_Msk (0xffffffffu << CHIPID_EXID_EXID_Pos) /*  (CHIPID_EXID) Chip ID Extension */


/* ============================================================================= */
/*  SOFTWARE API DEFINITION FOR Digital-to-Analog Converter Controller */
/* ============================================================================= */

#ifndef __ASSEMBLY__
/* Dacc hardware registers */
typedef struct {
  WoReg DACC_CR;       /*  (Dacc Offset: 0x00) Control Register */
  RwReg DACC_MR;       /*  (Dacc Offset: 0x04) Mode Register */
  WoReg DACC_CDR;      /*  (Dacc Offset: 0x08) Conversion Data Register */
  WoReg DACC_IER;      /*  (Dacc Offset: 0x0C) Interrupt Enable Register */
  WoReg DACC_IDR;      /*  (Dacc Offset: 0x10) Interrupt Disable Register */
  RoReg DACC_IMR;      /*  (Dacc Offset: 0x14) Interrupt Mask Register */
  RoReg DACC_ISR;      /*  (Dacc Offset: 0x18) Interrupt Status Register */
  RwReg Reserved1[50];
  RwReg DACC_WPMR;     /*  (Dacc Offset: 0xE4) Write Protect Mode Register */
  RoReg DACC_WPSR;     /*  (Dacc Offset: 0xE8) Write Protect Status Register */
  RwReg Reserved2[5]; 
  RwReg DACC_RPR;      /*  (Dacc Offset: 0x100) Receive Pointer Register */
  RwReg DACC_RCR;      /*  (Dacc Offset: 0x104) Receive Counter Register */
  RwReg DACC_TPR;      /*  (Dacc Offset: 0x108) Transmit Pointer Register */
  RwReg DACC_TCR;      /*  (Dacc Offset: 0x10C) Transmit Counter Register */
  RwReg DACC_RNPR;     /*  (Dacc Offset: 0x110) Receive Next Pointer Register */
  RwReg DACC_RNCR;     /*  (Dacc Offset: 0x114) Receive Next Counter Register */
  RwReg DACC_TNPR;     /*  (Dacc Offset: 0x118) Transmit Next Pointer Register */
  RwReg DACC_TNCR;     /*  (Dacc Offset: 0x11C) Transmit Next Counter Register */
  WoReg DACC_PTCR;     /*  (Dacc Offset: 0x120) Transfer Control Register */
  RoReg DACC_PTSR;     /*  (Dacc Offset: 0x124) Transfer Status Register */
} Dacc;
#endif /* __ASSEMBLY__ */
/* -------- DACC_CR : (DACC Offset: 0x00) Control Register -------- */
#define DACC_CR_SWRST (0x1u << 0) /*  (DACC_CR) Software Reset */
/* -------- DACC_MR : (DACC Offset: 0x04) Mode Register -------- */
#define DACC_MR_TRGEN (0x1u << 0) /*  (DACC_MR) Trigger Enable */
#define   DACC_MR_TRGEN_DIS (0x0u << 0) /*  (DACC_MR) External trigger mode disabled. DACC in free running mode. */
#define   DACC_MR_TRGEN_EN (0x1u << 0) /*  (DACC_MR) External trigger mode enabled. */
#define DACC_MR_TRGSEL_Pos 1
#define DACC_MR_TRGSEL_Msk (0x7u << DACC_MR_TRGSEL_Pos) /*  (DACC_MR) Trigger Selection */
#define   DACC_MR_TRGSEL_TRGSEL0 (0x0u << 1) /*  (DACC_MR) External trigger */
#define   DACC_MR_TRGSEL_TRGSEL1 (0x1u << 1) /*  (DACC_MR) TIO Output of the Timer Counter Channel 0 */
#define   DACC_MR_TRGSEL_TRGSEL2 (0x2u << 1) /*  (DACC_MR) TIO Output of the Timer Counter Channel 1 */
#define   DACC_MR_TRGSEL_TRGSEL3 (0x3u << 1) /*  (DACC_MR) TIO Output of the Timer Counter Channel 2 */
#define DACC_MR_DACEN (0x1u << 4) /*  (DACC_MR) DAC enable */
#define DACC_MR_WORD (0x1u << 5) /*  (DACC_MR) Word Transfer */
#define   DACC_MR_WORD_HALF (0x0u << 5) /*  (DACC_MR) Half-Word transfer */
#define   DACC_MR_WORD_WORD (0x1u << 5) /*  (DACC_MR) Word Transfer */
#define DACC_MR_STARTUP_Pos 8
#define DACC_MR_STARTUP_Msk (0xffu << DACC_MR_STARTUP_Pos) /*  (DACC_MR) Startup Time Selection */
#define DACC_MR_STARTUP(value) ((DACC_MR_STARTUP_Msk & ((value) << DACC_MR_STARTUP_Pos)))
#define DACC_MR_CLKDIV_Pos 16
#define DACC_MR_CLKDIV_Msk (0xffffu << DACC_MR_CLKDIV_Pos) /*  (DACC_MR) DAC Clock Divider for Internal Trigger */
#define DACC_MR_CLKDIV(value) ((DACC_MR_CLKDIV_Msk & ((value) << DACC_MR_CLKDIV_Pos)))
/* -------- DACC_CDR : (DACC Offset: 0x08) Conversion Data Register -------- */
#define DACC_CDR_DATA_Pos 0
#define DACC_CDR_DATA_Msk (0xffffffffu << DACC_CDR_DATA_Pos) /*  (DACC_CDR) Data to Convert */
#define DACC_CDR_DATA(value) ((DACC_CDR_DATA_Msk & ((value) << DACC_CDR_DATA_Pos)))
/* -------- DACC_IER : (DACC Offset: 0x0C) Interrupt Enable Register -------- */
#define DACC_IER_TXRDY (0x1u << 0) /*  (DACC_IER) Transmission Ready Interrupt Enable */
#define DACC_IER_ENDTX (0x1u << 1) /*  (DACC_IER) End of PDC Interrupt Enable */
#define DACC_IER_TXBUFE (0x1u << 2) /*  (DACC_IER) Buffer Empty Interrupt Enable */
/* -------- DACC_IDR : (DACC Offset: 0x10) Interrupt Disable Register -------- */
#define DACC_IDR_TXRDY (0x1u << 0) /*  (DACC_IDR) Transmission Ready Interrupt Disable */
#define DACC_IDR_ENDTX (0x1u << 1) /*  (DACC_IDR) End of PDC Interrupt Disable */
#define DACC_IDR_TXBUFE (0x1u << 2) /*  (DACC_IDR) Buffer Empty Interrupt Disable */
/* -------- DACC_IMR : (DACC Offset: 0x14) Interrupt Mask Register -------- */
#define DACC_IMR_TXRDY (0x1u << 0) /*  (DACC_IMR) Transmission Ready Interrupt Mask */
#define DACC_IMR_ENDTX (0x1u << 1) /*  (DACC_IMR) End of PDC Interrupt Mask */
#define DACC_IMR_TXBUFE (0x1u << 2) /*  (DACC_IMR) Buffer Empty Interrupt Mask */
/* -------- DACC_ISR : (DACC Offset: 0x18) Interrupt Status Register -------- */
#define DACC_ISR_TXRDY (0x1u << 0) /*  (DACC_ISR) Transmission Ready Interrupt Flag */
#define DACC_ISR_ENDTX (0x1u << 1) /*  (DACC_ISR) End of PDC Interrupt Flag */
#define DACC_ISR_TXBUFE (0x1u << 2) /*  (DACC_ISR) Buffer Empty Interrupt Flag */
/* -------- DACC_WPMR : (DACC Offset: 0xE4) Write Protect Mode Register -------- */
#define DACC_WPMR_WPEN (0x1u << 0) /*  (DACC_WPMR) Write Protect Enable */
#define DACC_WPMR_WPKEY_Pos 8
#define DACC_WPMR_WPKEY_Msk (0xffffffu << DACC_WPMR_WPKEY_Pos) /*  (DACC_WPMR) Write Protect KEY */
#define DACC_WPMR_WPKEY(value) ((DACC_WPMR_WPKEY_Msk & ((value) << DACC_WPMR_WPKEY_Pos)))
/* -------- DACC_WPSR : (DACC Offset: 0xE8) Write Protect Status Register -------- */
#define DACC_WPSR_WPROTERR (0x1u << 0) /*  (DACC_WPSR) Write protection error */
#define DACC_WPSR_WPROTADDR_Pos 8
#define DACC_WPSR_WPROTADDR_Msk (0xffu << DACC_WPSR_WPROTADDR_Pos) /*  (DACC_WPSR) Write protection error address */
/* -------- DACC_RPR : (DACC Offset: 0x100) Receive Pointer Register -------- */
#define DACC_RPR_RXPTR_Pos 0
#define DACC_RPR_RXPTR_Msk (0xffffffffu << DACC_RPR_RXPTR_Pos) /*  (DACC_RPR) Receive Pointer Register */
#define DACC_RPR_RXPTR(value) ((DACC_RPR_RXPTR_Msk & ((value) << DACC_RPR_RXPTR_Pos)))
/* -------- DACC_RCR : (DACC Offset: 0x104) Receive Counter Register -------- */
#define DACC_RCR_RXCTR_Pos 0
#define DACC_RCR_RXCTR_Msk (0xffffu << DACC_RCR_RXCTR_Pos) /*  (DACC_RCR) Receive Counter Register */
#define DACC_RCR_RXCTR(value) ((DACC_RCR_RXCTR_Msk & ((value) << DACC_RCR_RXCTR_Pos)))
/* -------- DACC_TPR : (DACC Offset: 0x108) Transmit Pointer Register -------- */
#define DACC_TPR_TXPTR_Pos 0
#define DACC_TPR_TXPTR_Msk (0xffffffffu << DACC_TPR_TXPTR_Pos) /*  (DACC_TPR) Transmit Counter Register */
#define DACC_TPR_TXPTR(value) ((DACC_TPR_TXPTR_Msk & ((value) << DACC_TPR_TXPTR_Pos)))
/* -------- DACC_TCR : (DACC Offset: 0x10C) Transmit Counter Register -------- */
#define DACC_TCR_TXCTR_Pos 0
#define DACC_TCR_TXCTR_Msk (0xffffu << DACC_TCR_TXCTR_Pos) /*  (DACC_TCR) Transmit Counter Register */
#define DACC_TCR_TXCTR(value) ((DACC_TCR_TXCTR_Msk & ((value) << DACC_TCR_TXCTR_Pos)))
/* -------- DACC_RNPR : (DACC Offset: 0x110) Receive Next Pointer Register -------- */
#define DACC_RNPR_RXNPTR_Pos 0
#define DACC_RNPR_RXNPTR_Msk (0xffffffffu << DACC_RNPR_RXNPTR_Pos) /*  (DACC_RNPR) Receive Next Pointer */
#define DACC_RNPR_RXNPTR(value) ((DACC_RNPR_RXNPTR_Msk & ((value) << DACC_RNPR_RXNPTR_Pos)))
/* -------- DACC_RNCR : (DACC Offset: 0x114) Receive Next Counter Register -------- */
#define DACC_RNCR_RXNCTR_Pos 0
#define DACC_RNCR_RXNCTR_Msk (0xffffu << DACC_RNCR_RXNCTR_Pos) /*  (DACC_RNCR) Receive Next Counter */
#define DACC_RNCR_RXNCTR(value) ((DACC_RNCR_RXNCTR_Msk & ((value) << DACC_RNCR_RXNCTR_Pos)))
/* -------- DACC_TNPR : (DACC Offset: 0x118) Transmit Next Pointer Register -------- */
#define DACC_TNPR_TXNPTR_Pos 0
#define DACC_TNPR_TXNPTR_Msk (0xffffffffu << DACC_TNPR_TXNPTR_Pos) /*  (DACC_TNPR) Transmit Next Pointer */
#define DACC_TNPR_TXNPTR(value) ((DACC_TNPR_TXNPTR_Msk & ((value) << DACC_TNPR_TXNPTR_Pos)))
/* -------- DACC_TNCR : (DACC Offset: 0x11C) Transmit Next Counter Register -------- */
#define DACC_TNCR_TXNCTR_Pos 0
#define DACC_TNCR_TXNCTR_Msk (0xffffu << DACC_TNCR_TXNCTR_Pos) /*  (DACC_TNCR) Transmit Counter Next */
#define DACC_TNCR_TXNCTR(value) ((DACC_TNCR_TXNCTR_Msk & ((value) << DACC_TNCR_TXNCTR_Pos)))
/* -------- DACC_PTCR : (DACC Offset: 0x120) Transfer Control Register -------- */
#define DACC_PTCR_RXTEN (0x1u << 0) /*  (DACC_PTCR) Receiver Transfer Enable */
#define DACC_PTCR_RXTDIS (0x1u << 1) /*  (DACC_PTCR) Receiver Transfer Disable */
#define DACC_PTCR_TXTEN (0x1u << 8) /*  (DACC_PTCR) Transmitter Transfer Enable */
#define DACC_PTCR_TXTDIS (0x1u << 9) /*  (DACC_PTCR) Transmitter Transfer Disable */
/* -------- DACC_PTSR : (DACC Offset: 0x124) Transfer Status Register -------- */
#define DACC_PTSR_RXTEN (0x1u << 0) /*  (DACC_PTSR) Receiver Transfer Enable */
#define DACC_PTSR_TXTEN (0x1u << 8) /*  (DACC_PTSR) Transmitter Transfer Enable */



/* ============================================================================= */
/*  SOFTWARE API DEFINITION FOR General Purpose Backup Register */
/* ============================================================================= */

#ifndef __ASSEMBLY__
/* Gpbr hardware registers */
typedef struct {
  RwReg SYS_GPBR0; /*  (Gpbr Offset: 0x0) General Purpose Backup Register 0 */
  RwReg SYS_GPBR1; /*  (Gpbr Offset: 0x4) General Purpose Backup Register 1 */
  RwReg SYS_GPBR2; /*  (Gpbr Offset: 0x8) General Purpose Backup Register 2 */
  RwReg SYS_GPBR3; /*  (Gpbr Offset: 0xC) General Purpose Backup Register 3 */
  RwReg SYS_GPBR4; /*  (Gpbr Offset: 0x10) General Purpose Backup Register 4 */
  RwReg SYS_GPBR5; /*  (Gpbr Offset: 0x14) General Purpose Backup Register 5 */
  RwReg SYS_GPBR6; /*  (Gpbr Offset: 0x18) General Purpose Backup Register 6 */
  RwReg SYS_GPBR7; /*  (Gpbr Offset: 0x1C) General Purpose Backup Register 7 */
} Gpbr;
#endif /* __ASSEMBLY__ */
/* -------- SYS_GPBR0 : (GPBR Offset: 0x0) General Purpose Backup Register 0 -------- */
#define SYS_GPBR0_GPBR_VALUE0_Pos 0
#define SYS_GPBR0_GPBR_VALUE0_Msk (0xffffffffu << SYS_GPBR0_GPBR_VALUE0_Pos) /*  (SYS_GPBR0) Value of GPBR x */
#define SYS_GPBR0_GPBR_VALUE0(value) ((SYS_GPBR0_GPBR_VALUE0_Msk & ((value) << SYS_GPBR0_GPBR_VALUE0_Pos)))
/* -------- SYS_GPBR1 : (GPBR Offset: 0x4) General Purpose Backup Register 1 -------- */
#define SYS_GPBR1_GPBR_VALUE1_Pos 0
#define SYS_GPBR1_GPBR_VALUE1_Msk (0xffffffffu << SYS_GPBR1_GPBR_VALUE1_Pos) /*  (SYS_GPBR1) Value of GPBR x */
#define SYS_GPBR1_GPBR_VALUE1(value) ((SYS_GPBR1_GPBR_VALUE1_Msk & ((value) << SYS_GPBR1_GPBR_VALUE1_Pos)))
/* -------- SYS_GPBR2 : (GPBR Offset: 0x8) General Purpose Backup Register 2 -------- */
#define SYS_GPBR2_GPBR_VALUE2_Pos 0
#define SYS_GPBR2_GPBR_VALUE2_Msk (0xffffffffu << SYS_GPBR2_GPBR_VALUE2_Pos) /*  (SYS_GPBR2) Value of GPBR x */
#define SYS_GPBR2_GPBR_VALUE2(value) ((SYS_GPBR2_GPBR_VALUE2_Msk & ((value) << SYS_GPBR2_GPBR_VALUE2_Pos)))
/* -------- SYS_GPBR3 : (GPBR Offset: 0xC) General Purpose Backup Register 3 -------- */
#define SYS_GPBR3_GPBR_VALUE3_Pos 0
#define SYS_GPBR3_GPBR_VALUE3_Msk (0xffffffffu << SYS_GPBR3_GPBR_VALUE3_Pos) /*  (SYS_GPBR3) Value of GPBR x */
#define SYS_GPBR3_GPBR_VALUE3(value) ((SYS_GPBR3_GPBR_VALUE3_Msk & ((value) << SYS_GPBR3_GPBR_VALUE3_Pos)))
/* -------- SYS_GPBR4 : (GPBR Offset: 0x10) General Purpose Backup Register 4 -------- */
#define SYS_GPBR4_GPBR_VALUE4_Pos 0
#define SYS_GPBR4_GPBR_VALUE4_Msk (0xffffffffu << SYS_GPBR4_GPBR_VALUE4_Pos) /*  (SYS_GPBR4) Value of GPBR x */
#define SYS_GPBR4_GPBR_VALUE4(value) ((SYS_GPBR4_GPBR_VALUE4_Msk & ((value) << SYS_GPBR4_GPBR_VALUE4_Pos)))
/* -------- SYS_GPBR5 : (GPBR Offset: 0x14) General Purpose Backup Register 5 -------- */
#define SYS_GPBR5_GPBR_VALUE5_Pos 0
#define SYS_GPBR5_GPBR_VALUE5_Msk (0xffffffffu << SYS_GPBR5_GPBR_VALUE5_Pos) /*  (SYS_GPBR5) Value of GPBR x */
#define SYS_GPBR5_GPBR_VALUE5(value) ((SYS_GPBR5_GPBR_VALUE5_Msk & ((value) << SYS_GPBR5_GPBR_VALUE5_Pos)))
/* -------- SYS_GPBR6 : (GPBR Offset: 0x18) General Purpose Backup Register 6 -------- */
#define SYS_GPBR6_GPBR_VALUE6_Pos 0
#define SYS_GPBR6_GPBR_VALUE6_Msk (0xffffffffu << SYS_GPBR6_GPBR_VALUE6_Pos) /*  (SYS_GPBR6) Value of GPBR x */
#define SYS_GPBR6_GPBR_VALUE6(value) ((SYS_GPBR6_GPBR_VALUE6_Msk & ((value) << SYS_GPBR6_GPBR_VALUE6_Pos)))
/* -------- SYS_GPBR7 : (GPBR Offset: 0x1C) General Purpose Backup Register 7 -------- */
#define SYS_GPBR7_GPBR_VALUE7_Pos 0
#define SYS_GPBR7_GPBR_VALUE7_Msk (0xffffffffu << SYS_GPBR7_GPBR_VALUE7_Pos) /*  (SYS_GPBR7) Value of GPBR x */
#define SYS_GPBR7_GPBR_VALUE7(value) ((SYS_GPBR7_GPBR_VALUE7_Msk & ((value) << SYS_GPBR7_GPBR_VALUE7_Pos)))


/* ============================================================================= */
/*  SOFTWARE API DEFINITION FOR AHB Bus Matrix */
/* ============================================================================= */

#ifndef __ASSEMBLY__
/* Matrix hardware registers */
typedef struct {
  RwReg MATRIX_MCFG[3]; /*  (Matrix Offset: 0x0000) Master Configuration Register */
  RwReg Reserved1[13]; 
  RwReg MATRIX_SCFG[4]; /*  (Matrix Offset: 0x0040) Slave Configuration Register */
  RwReg Reserved2[12]; 
  RwReg MATRIX_PRAS0;   /*  (Matrix Offset: 0x0080) Priority Register A for Slave 0 */
  RwReg Reserved3[1];  
  RwReg MATRIX_PRAS1;   /*  (Matrix Offset: 0x0088) Priority Register A for Slave 1 */
  RwReg Reserved4[1];  
  RwReg MATRIX_PRAS2;   /*  (Matrix Offset: 0x0090) Priority Register A for Slave 2 */
  RwReg Reserved5[1];  
  RwReg MATRIX_PRAS3;   /*  (Matrix Offset: 0x0098) Priority Register A for Slave 3 */
  RwReg Reserved6[1];  
  RwReg Reserved7[29]; 
  RwReg CCFG_SYSIO;     /*  (Matrix Offset: 0x0114) System I/O Configuration register */
  RwReg Reserved8[51]; 
  RwReg MATRIX_WPMR;    /*  (Matrix Offset: 0x1E4) Write Protect Mode Register */
  RoReg MATRIX_WPSR;    /*  (Matrix Offset: 0x1E8) Write Protect Status Register */
} Matrix;
#endif /* __ASSEMBLY__ */
/* -------- MATRIX_MCFG[3] : (MATRIX Offset: 0x0000) Master Configuration Register -------- */
#define MATRIX_MCFG_ULBT_Pos 0
#define MATRIX_MCFG_ULBT_Msk (0x7u << MATRIX_MCFG_ULBT_Pos) /*  (MATRIX_MCFG[3]) Undefined Length Burst Type */
#define MATRIX_MCFG_ULBT(value) ((MATRIX_MCFG_ULBT_Msk & ((value) << MATRIX_MCFG_ULBT_Pos)))
/* -------- MATRIX_SCFG[4] : (MATRIX Offset: 0x0040) Slave Configuration Register -------- */
#define MATRIX_SCFG_SLOT_CYCLE_Pos 0
#define MATRIX_SCFG_SLOT_CYCLE_Msk (0xffu << MATRIX_SCFG_SLOT_CYCLE_Pos) /*  (MATRIX_SCFG[4]) Maximum Number of Allowed Cycles for a Burst */
#define MATRIX_SCFG_SLOT_CYCLE(value) ((MATRIX_SCFG_SLOT_CYCLE_Msk & ((value) << MATRIX_SCFG_SLOT_CYCLE_Pos)))
#define MATRIX_SCFG_DEFMSTR_TYPE_Pos 16
#define MATRIX_SCFG_DEFMSTR_TYPE_Msk (0x3u << MATRIX_SCFG_DEFMSTR_TYPE_Pos) /*  (MATRIX_SCFG[4]) Default Master Type */
#define MATRIX_SCFG_DEFMSTR_TYPE(value) ((MATRIX_SCFG_DEFMSTR_TYPE_Msk & ((value) << MATRIX_SCFG_DEFMSTR_TYPE_Pos)))
#define MATRIX_SCFG_FIXED_DEFMSTR_Pos 18
#define MATRIX_SCFG_FIXED_DEFMSTR_Msk (0x7u << MATRIX_SCFG_FIXED_DEFMSTR_Pos) /*  (MATRIX_SCFG[4]) Fixed Default Master */
#define MATRIX_SCFG_FIXED_DEFMSTR(value) ((MATRIX_SCFG_FIXED_DEFMSTR_Msk & ((value) << MATRIX_SCFG_FIXED_DEFMSTR_Pos)))
#define MATRIX_SCFG_ARBT_Pos 24
#define MATRIX_SCFG_ARBT_Msk (0x3u << MATRIX_SCFG_ARBT_Pos) /*  (MATRIX_SCFG[4]) Arbitration Type */
#define MATRIX_SCFG_ARBT(value) ((MATRIX_SCFG_ARBT_Msk & ((value) << MATRIX_SCFG_ARBT_Pos)))
/* -------- MATRIX_PRAS0 : (MATRIX Offset: 0x0080) Priority Register A for Slave 0 -------- */
#define MATRIX_PRAS0_M0PR_Pos 0
#define MATRIX_PRAS0_M0PR_Msk (0x3u << MATRIX_PRAS0_M0PR_Pos) /*  (MATRIX_PRAS0) Master 0 Priority */
#define MATRIX_PRAS0_M0PR(value) ((MATRIX_PRAS0_M0PR_Msk & ((value) << MATRIX_PRAS0_M0PR_Pos)))
#define MATRIX_PRAS0_M1PR_Pos 4
#define MATRIX_PRAS0_M1PR_Msk (0x3u << MATRIX_PRAS0_M1PR_Pos) /*  (MATRIX_PRAS0) Master 1 Priority */
#define MATRIX_PRAS0_M1PR(value) ((MATRIX_PRAS0_M1PR_Msk & ((value) << MATRIX_PRAS0_M1PR_Pos)))
#define MATRIX_PRAS0_M2PR_Pos 8
#define MATRIX_PRAS0_M2PR_Msk (0x3u << MATRIX_PRAS0_M2PR_Pos) /*  (MATRIX_PRAS0) Master 2 Priority */
#define MATRIX_PRAS0_M2PR(value) ((MATRIX_PRAS0_M2PR_Msk & ((value) << MATRIX_PRAS0_M2PR_Pos)))
#define MATRIX_PRAS0_M3PR_Pos 12
#define MATRIX_PRAS0_M3PR_Msk (0x3u << MATRIX_PRAS0_M3PR_Pos) /*  (MATRIX_PRAS0) Master 3 Priority */
#define MATRIX_PRAS0_M3PR(value) ((MATRIX_PRAS0_M3PR_Msk & ((value) << MATRIX_PRAS0_M3PR_Pos)))
/* -------- MATRIX_PRAS1 : (MATRIX Offset: 0x0088) Priority Register A for Slave 1 -------- */
#define MATRIX_PRAS1_M0PR_Pos 0
#define MATRIX_PRAS1_M0PR_Msk (0x3u << MATRIX_PRAS1_M0PR_Pos) /*  (MATRIX_PRAS1) Master 0 Priority */
#define MATRIX_PRAS1_M0PR(value) ((MATRIX_PRAS1_M0PR_Msk & ((value) << MATRIX_PRAS1_M0PR_Pos)))
#define MATRIX_PRAS1_M1PR_Pos 4
#define MATRIX_PRAS1_M1PR_Msk (0x3u << MATRIX_PRAS1_M1PR_Pos) /*  (MATRIX_PRAS1) Master 1 Priority */
#define MATRIX_PRAS1_M1PR(value) ((MATRIX_PRAS1_M1PR_Msk & ((value) << MATRIX_PRAS1_M1PR_Pos)))
#define MATRIX_PRAS1_M2PR_Pos 8
#define MATRIX_PRAS1_M2PR_Msk (0x3u << MATRIX_PRAS1_M2PR_Pos) /*  (MATRIX_PRAS1) Master 2 Priority */
#define MATRIX_PRAS1_M2PR(value) ((MATRIX_PRAS1_M2PR_Msk & ((value) << MATRIX_PRAS1_M2PR_Pos)))
#define MATRIX_PRAS1_M3PR_Pos 12
#define MATRIX_PRAS1_M3PR_Msk (0x3u << MATRIX_PRAS1_M3PR_Pos) /*  (MATRIX_PRAS1) Master 3 Priority */
#define MATRIX_PRAS1_M3PR(value) ((MATRIX_PRAS1_M3PR_Msk & ((value) << MATRIX_PRAS1_M3PR_Pos)))
/* -------- MATRIX_PRAS2 : (MATRIX Offset: 0x0090) Priority Register A for Slave 2 -------- */
#define MATRIX_PRAS2_M0PR_Pos 0
#define MATRIX_PRAS2_M0PR_Msk (0x3u << MATRIX_PRAS2_M0PR_Pos) /*  (MATRIX_PRAS2) Master 0 Priority */
#define MATRIX_PRAS2_M0PR(value) ((MATRIX_PRAS2_M0PR_Msk & ((value) << MATRIX_PRAS2_M0PR_Pos)))
#define MATRIX_PRAS2_M1PR_Pos 4
#define MATRIX_PRAS2_M1PR_Msk (0x3u << MATRIX_PRAS2_M1PR_Pos) /*  (MATRIX_PRAS2) Master 1 Priority */
#define MATRIX_PRAS2_M1PR(value) ((MATRIX_PRAS2_M1PR_Msk & ((value) << MATRIX_PRAS2_M1PR_Pos)))
#define MATRIX_PRAS2_M2PR_Pos 8
#define MATRIX_PRAS2_M2PR_Msk (0x3u << MATRIX_PRAS2_M2PR_Pos) /*  (MATRIX_PRAS2) Master 2 Priority */
#define MATRIX_PRAS2_M2PR(value) ((MATRIX_PRAS2_M2PR_Msk & ((value) << MATRIX_PRAS2_M2PR_Pos)))
#define MATRIX_PRAS2_M3PR_Pos 12
#define MATRIX_PRAS2_M3PR_Msk (0x3u << MATRIX_PRAS2_M3PR_Pos) /*  (MATRIX_PRAS2) Master 3 Priority */
#define MATRIX_PRAS2_M3PR(value) ((MATRIX_PRAS2_M3PR_Msk & ((value) << MATRIX_PRAS2_M3PR_Pos)))
/* -------- MATRIX_PRAS3 : (MATRIX Offset: 0x0098) Priority Register A for Slave 3 -------- */
#define MATRIX_PRAS3_M0PR_Pos 0
#define MATRIX_PRAS3_M0PR_Msk (0x3u << MATRIX_PRAS3_M0PR_Pos) /*  (MATRIX_PRAS3) Master 0 Priority */
#define MATRIX_PRAS3_M0PR(value) ((MATRIX_PRAS3_M0PR_Msk & ((value) << MATRIX_PRAS3_M0PR_Pos)))
#define MATRIX_PRAS3_M1PR_Pos 4
#define MATRIX_PRAS3_M1PR_Msk (0x3u << MATRIX_PRAS3_M1PR_Pos) /*  (MATRIX_PRAS3) Master 1 Priority */
#define MATRIX_PRAS3_M1PR(value) ((MATRIX_PRAS3_M1PR_Msk & ((value) << MATRIX_PRAS3_M1PR_Pos)))
#define MATRIX_PRAS3_M2PR_Pos 8
#define MATRIX_PRAS3_M2PR_Msk (0x3u << MATRIX_PRAS3_M2PR_Pos) /*  (MATRIX_PRAS3) Master 2 Priority */
#define MATRIX_PRAS3_M2PR(value) ((MATRIX_PRAS3_M2PR_Msk & ((value) << MATRIX_PRAS3_M2PR_Pos)))
#define MATRIX_PRAS3_M3PR_Pos 12
#define MATRIX_PRAS3_M3PR_Msk (0x3u << MATRIX_PRAS3_M3PR_Pos) /*  (MATRIX_PRAS3) Master 3 Priority */
#define MATRIX_PRAS3_M3PR(value) ((MATRIX_PRAS3_M3PR_Msk & ((value) << MATRIX_PRAS3_M3PR_Pos)))
/* -------- CCFG_SYSIO : (MATRIX Offset: 0x0114) System I/O Configuration register -------- */
#define CCFG_SYSIO_SYSIO4 (0x1u << 4) /*  (CCFG_SYSIO) PB4 or TDI Assignment */
#define CCFG_SYSIO_SYSIO5 (0x1u << 5) /*  (CCFG_SYSIO) PB5 or TDO/TRACESWO Assignment */
#define CCFG_SYSIO_SYSIO6 (0x1u << 6) /*  (CCFG_SYSIO) PB6 or TMS/SWDIO Assignment */
#define CCFG_SYSIO_SYSIO7 (0x1u << 7) /*  (CCFG_SYSIO) PB7 or TCK/SWCLK Assignment */
#define CCFG_SYSIO_SYSIO12 (0x1u << 12) /*  (CCFG_SYSIO) PB12 or ERASE Assignment */
/* -------- MATRIX_WPMR : (MATRIX Offset: 0x1E4) Write Protect Mode Register -------- */
#define MATRIX_WPMR_WPEN (0x1u << 0) /*  (MATRIX_WPMR) Write Protect ENable */
#define MATRIX_WPMR_WPKEY_Pos 8
#define MATRIX_WPMR_WPKEY_Msk (0xffffffu << MATRIX_WPMR_WPKEY_Pos) /*  (MATRIX_WPMR) Write Protect KEY (Write-only) */
#define MATRIX_WPMR_WPKEY(value) ((MATRIX_WPMR_WPKEY_Msk & ((value) << MATRIX_WPMR_WPKEY_Pos)))
/* -------- MATRIX_WPSR : (MATRIX Offset: 0x1E8) Write Protect Status Register -------- */
#define MATRIX_WPSR_WPVS (0x1u << 0) /*  (MATRIX_WPSR) Write Protect Violation Status */
#define MATRIX_WPSR_WPVSRC_Pos 8
#define MATRIX_WPSR_WPVSRC_Msk (0xffffu << MATRIX_WPSR_WPVSRC_Pos) /*  (MATRIX_WPSR) Write Protect Violation Source */


/* ============================================================================= */
/*  SOFTWARE API DEFINITION FOR Peripheral DMA Controller */
/* ============================================================================= */

#ifndef __ASSEMBLY__
/* Pdc hardware registers */
typedef struct {
  RwReg Reserved1[64];
  RwReg PERIPH_RPR;    /*  (Pdc Offset: 0x100) Receive Pointer Register */
  RwReg PERIPH_RCR;    /*  (Pdc Offset: 0x104) Receive Counter Register */
  RwReg PERIPH_TPR;    /*  (Pdc Offset: 0x108) Transmit Pointer Register */
  RwReg PERIPH_TCR;    /*  (Pdc Offset: 0x10C) Transmit Counter Register */
  RwReg PERIPH_RNPR;   /*  (Pdc Offset: 0x110) Receive Next Pointer Register */
  RwReg PERIPH_RNCR;   /*  (Pdc Offset: 0x114) Receive Next Counter Register */
  RwReg PERIPH_TNPR;   /*  (Pdc Offset: 0x118) Transmit Next Pointer Register */
  RwReg PERIPH_TNCR;   /*  (Pdc Offset: 0x11C) Transmit Next Counter Register */
  WoReg PERIPH_PTCR;   /*  (Pdc Offset: 0x120) Transfer Control Register */
  RoReg PERIPH_PTSR;   /*  (Pdc Offset: 0x124) Transfer Status Register */
} Pdc;
#endif /* __ASSEMBLY__ */
/* -------- PERIPH_RPR : (PDC Offset: 0x100) Receive Pointer Register -------- */
#define PERIPH_RPR_RXPTR_Pos 0
#define PERIPH_RPR_RXPTR_Msk (0xffffffffu << PERIPH_RPR_RXPTR_Pos) /*  (PERIPH_RPR) Receive Pointer Register */
#define PERIPH_RPR_RXPTR(value) ((PERIPH_RPR_RXPTR_Msk & ((value) << PERIPH_RPR_RXPTR_Pos)))
/* -------- PERIPH_RCR : (PDC Offset: 0x104) Receive Counter Register -------- */
#define PERIPH_RCR_RXCTR_Pos 0
#define PERIPH_RCR_RXCTR_Msk (0xffffu << PERIPH_RCR_RXCTR_Pos) /*  (PERIPH_RCR) Receive Counter Register */
#define PERIPH_RCR_RXCTR(value) ((PERIPH_RCR_RXCTR_Msk & ((value) << PERIPH_RCR_RXCTR_Pos)))
/* -------- PERIPH_TPR : (PDC Offset: 0x108) Transmit Pointer Register -------- */
#define PERIPH_TPR_TXPTR_Pos 0
#define PERIPH_TPR_TXPTR_Msk (0xffffffffu << PERIPH_TPR_TXPTR_Pos) /*  (PERIPH_TPR) Transmit Counter Register */
#define PERIPH_TPR_TXPTR(value) ((PERIPH_TPR_TXPTR_Msk & ((value) << PERIPH_TPR_TXPTR_Pos)))
/* -------- PERIPH_TCR : (PDC Offset: 0x10C) Transmit Counter Register -------- */
#define PERIPH_TCR_TXCTR_Pos 0
#define PERIPH_TCR_TXCTR_Msk (0xffffu << PERIPH_TCR_TXCTR_Pos) /*  (PERIPH_TCR) Transmit Counter Register */
#define PERIPH_TCR_TXCTR(value) ((PERIPH_TCR_TXCTR_Msk & ((value) << PERIPH_TCR_TXCTR_Pos)))
/* -------- PERIPH_RNPR : (PDC Offset: 0x110) Receive Next Pointer Register -------- */
#define PERIPH_RNPR_RXNPTR_Pos 0
#define PERIPH_RNPR_RXNPTR_Msk (0xffffffffu << PERIPH_RNPR_RXNPTR_Pos) /*  (PERIPH_RNPR) Receive Next Pointer */
#define PERIPH_RNPR_RXNPTR(value) ((PERIPH_RNPR_RXNPTR_Msk & ((value) << PERIPH_RNPR_RXNPTR_Pos)))
/* -------- PERIPH_RNCR : (PDC Offset: 0x114) Receive Next Counter Register -------- */
#define PERIPH_RNCR_RXNCTR_Pos 0
#define PERIPH_RNCR_RXNCTR_Msk (0xffffu << PERIPH_RNCR_RXNCTR_Pos) /*  (PERIPH_RNCR) Receive Next Counter */
#define PERIPH_RNCR_RXNCTR(value) ((PERIPH_RNCR_RXNCTR_Msk & ((value) << PERIPH_RNCR_RXNCTR_Pos)))
/* -------- PERIPH_TNPR : (PDC Offset: 0x118) Transmit Next Pointer Register -------- */
#define PERIPH_TNPR_TXNPTR_Pos 0
#define PERIPH_TNPR_TXNPTR_Msk (0xffffffffu << PERIPH_TNPR_TXNPTR_Pos) /*  (PERIPH_TNPR) Transmit Next Pointer */
#define PERIPH_TNPR_TXNPTR(value) ((PERIPH_TNPR_TXNPTR_Msk & ((value) << PERIPH_TNPR_TXNPTR_Pos)))
/* -------- PERIPH_TNCR : (PDC Offset: 0x11C) Transmit Next Counter Register -------- */
#define PERIPH_TNCR_TXNCTR_Pos 0
#define PERIPH_TNCR_TXNCTR_Msk (0xffffu << PERIPH_TNCR_TXNCTR_Pos) /*  (PERIPH_TNCR) Transmit Counter Next */
#define PERIPH_TNCR_TXNCTR(value) ((PERIPH_TNCR_TXNCTR_Msk & ((value) << PERIPH_TNCR_TXNCTR_Pos)))
/* -------- PERIPH_PTCR : (PDC Offset: 0x120) Transfer Control Register -------- */
#define PERIPH_PTCR_RXTEN (0x1u << 0) /*  (PERIPH_PTCR) Receiver Transfer Enable */
#define PERIPH_PTCR_RXTDIS (0x1u << 1) /*  (PERIPH_PTCR) Receiver Transfer Disable */
#define PERIPH_PTCR_TXTEN (0x1u << 8) /*  (PERIPH_PTCR) Transmitter Transfer Enable */
#define PERIPH_PTCR_TXTDIS (0x1u << 9) /*  (PERIPH_PTCR) Transmitter Transfer Disable */
/* -------- PERIPH_PTSR : (PDC Offset: 0x124) Transfer Status Register -------- */
#define PERIPH_PTSR_RXTEN (0x1u << 0) /*  (PERIPH_PTSR) Receiver Transfer Enable */
#define PERIPH_PTSR_TXTEN (0x1u << 8) /*  (PERIPH_PTSR) Transmitter Transfer Enable */


/* ============================================================================= */
/*  SOFTWARE API DEFINITION FOR Parallel Input/Output */
/* ============================================================================= */

#ifndef __ASSEMBLY__
/* Pio hardware registers */
typedef struct {
  WoReg PIO_PER;       /*  (Pio Offset: 0x0000) PIO Enable Register */
  WoReg PIO_PDR;       /*  (Pio Offset: 0x0004) PIO Disable Register */
  RoReg PIO_PSR;       /*  (Pio Offset: 0x0008) PIO Status Register */
  RwReg Reserved1[1]; 
  WoReg PIO_OER;       /*  (Pio Offset: 0x0010) Output Enable Register */
  WoReg PIO_ODR;       /*  (Pio Offset: 0x0014) Output Disable Register */
  RoReg PIO_OSR;       /*  (Pio Offset: 0x0018) Output Status Register */
  RwReg Reserved2[1]; 
  WoReg PIO_IFER;      /*  (Pio Offset: 0x0020) Glitch Input Filter Enable Register */
  WoReg PIO_IFDR;      /*  (Pio Offset: 0x0024) Glitch Input Filter Disable Register */
  RoReg PIO_IFSR;      /*  (Pio Offset: 0x0028) Glitch Input Filter Status Register */
  RwReg Reserved3[1]; 
  WoReg PIO_SODR;      /*  (Pio Offset: 0x0030) Set Output Data Register */
  WoReg PIO_CODR;      /*  (Pio Offset: 0x0034) Clear Output Data Register */
  RwReg PIO_ODSR;      /*  (Pio Offset: 0x0038) Output Data Status Register */
  RoReg PIO_PDSR;      /*  (Pio Offset: 0x003C) Pin Data Status Register */
  WoReg PIO_IER;       /*  (Pio Offset: 0x0040) Interrupt Enable Register */
  WoReg PIO_IDR;       /*  (Pio Offset: 0x0044) Interrupt Disable Register */
  RoReg PIO_IMR;       /*  (Pio Offset: 0x0048) Interrupt Mask Register */
  RoReg PIO_ISR;       /*  (Pio Offset: 0x004C) Interrupt Status Register */
  WoReg PIO_MDER;      /*  (Pio Offset: 0x0050) Multi-driver Enable Register */
  WoReg PIO_MDDR;      /*  (Pio Offset: 0x0054) Multi-driver Disable Register */
  RoReg PIO_MDSR;      /*  (Pio Offset: 0x0058) Multi-driver Status Register */
  RwReg Reserved4[1]; 
  WoReg PIO_PUDR;      /*  (Pio Offset: 0x0060) Pull-up Disable Register */
  WoReg PIO_PUER;      /*  (Pio Offset: 0x0064) Pull-up Enable Register */
  RoReg PIO_PUSR;      /*  (Pio Offset: 0x0068) Pad Pull-up Status Register */
  RwReg Reserved5[1]; 
  RwReg PIO_ABCDSR[2]; /*  (Pio Offset: 0x0070) Peripheral Select Register */
  RwReg Reserved6[2]; 
  WoReg PIO_IFSCDR;    /*  (Pio Offset: 0x0080) Input Filter Slow Clock Disable Register */
  WoReg PIO_IFSCER;    /*  (Pio Offset: 0x0084) Input Filter Slow Clock Enable Register */
  RoReg PIO_IFSCSR;    /*  (Pio Offset: 0x0088) Input Filter Slow Clock Status Register */
  RwReg PIO_SCDR;      /*  (Pio Offset: 0x008C) Slow Clock Divider Debouncing Register */
  WoReg PIO_PPDDR;     /*  (Pio Offset: 0x0090) Pad Pull-down Disable Register */
  WoReg PIO_PPDER;     /*  (Pio Offset: 0x0094) Pad Pull-down Enable Register */
  RoReg PIO_PPDSR;     /*  (Pio Offset: 0x0098) Pad Pull-down Status Register */
  RwReg Reserved7[1]; 
  WoReg PIO_OWER;      /*  (Pio Offset: 0x00A0) Output Write Enable */
  WoReg PIO_OWDR;      /*  (Pio Offset: 0x00A4) Output Write Disable */
  RoReg PIO_OWSR;      /*  (Pio Offset: 0x00A8) Output Write Status Register */
  RwReg Reserved8[1]; 
  WoReg PIO_AIMER;     /*  (Pio Offset: 0x00B0) Additional Interrupt Modes Enable Register */
  WoReg PIO_AIMDR;     /*  (Pio Offset: 0x00B4) Additional Interrupt Modes Disables Register */
  RoReg PIO_AIMMR;     /*  (Pio Offset: 0x00B8) Additional Interrupt Modes Mask Register */
  RwReg Reserved9[1]; 
  WoReg PIO_ESR;       /*  (Pio Offset: 0x00C0) Edge Select Register */
  WoReg PIO_LSR;       /*  (Pio Offset: 0x00C4) Level Select Register */
  RoReg PIO_ELSR;      /*  (Pio Offset: 0x00C8) Edge/Level Status Register */
  RwReg Reserved10[1];
  WoReg PIO_FELLSR;    /*  (Pio Offset: 0x00D0) Falling Edge/Low Level Select Register */
  WoReg PIO_REHLSR;    /*  (Pio Offset: 0x00D4) Rising Edge/ High Level Select Register */
  RoReg PIO_FRLHSR;    /*  (Pio Offset: 0x00D8) Fall/Rise - Low/High Status Register */
  RwReg Reserved11[1];
  RoReg PIO_LOCKSR;    /*  (Pio Offset: 0x00E0) Lock Status */
  RwReg PIO_WPMR;      /*  (Pio Offset: 0x00E4) Write Protect Mode Register */
  RoReg PIO_WPSR;      /*  (Pio Offset: 0x00E8) Write Protect Status Register */
  RwReg Reserved12[5];
  RwReg PIO_SCHMITT;   /*  (Pio Offset: 0x0100) Schmitt Trigger Register */
} Pio;
#endif /* __ASSEMBLY__ */
/* -------- PIO_PER : (PIO Offset: 0x0000) PIO Enable Register -------- */
#define PIO_PER_P0 (0x1u << 0) /*  (PIO_PER) PIO Enable */
#define PIO_PER_P1 (0x1u << 1) /*  (PIO_PER) PIO Enable */
#define PIO_PER_P2 (0x1u << 2) /*  (PIO_PER) PIO Enable */
#define PIO_PER_P3 (0x1u << 3) /*  (PIO_PER) PIO Enable */
#define PIO_PER_P4 (0x1u << 4) /*  (PIO_PER) PIO Enable */
#define PIO_PER_P5 (0x1u << 5) /*  (PIO_PER) PIO Enable */
#define PIO_PER_P6 (0x1u << 6) /*  (PIO_PER) PIO Enable */
#define PIO_PER_P7 (0x1u << 7) /*  (PIO_PER) PIO Enable */
#define PIO_PER_P8 (0x1u << 8) /*  (PIO_PER) PIO Enable */
#define PIO_PER_P9 (0x1u << 9) /*  (PIO_PER) PIO Enable */
#define PIO_PER_P10 (0x1u << 10) /*  (PIO_PER) PIO Enable */
#define PIO_PER_P11 (0x1u << 11) /*  (PIO_PER) PIO Enable */
#define PIO_PER_P12 (0x1u << 12) /*  (PIO_PER) PIO Enable */
#define PIO_PER_P13 (0x1u << 13) /*  (PIO_PER) PIO Enable */
#define PIO_PER_P14 (0x1u << 14) /*  (PIO_PER) PIO Enable */
#define PIO_PER_P15 (0x1u << 15) /*  (PIO_PER) PIO Enable */
#define PIO_PER_P16 (0x1u << 16) /*  (PIO_PER) PIO Enable */
#define PIO_PER_P17 (0x1u << 17) /*  (PIO_PER) PIO Enable */
#define PIO_PER_P18 (0x1u << 18) /*  (PIO_PER) PIO Enable */
#define PIO_PER_P19 (0x1u << 19) /*  (PIO_PER) PIO Enable */
#define PIO_PER_P20 (0x1u << 20) /*  (PIO_PER) PIO Enable */
#define PIO_PER_P21 (0x1u << 21) /*  (PIO_PER) PIO Enable */
#define PIO_PER_P22 (0x1u << 22) /*  (PIO_PER) PIO Enable */
#define PIO_PER_P23 (0x1u << 23) /*  (PIO_PER) PIO Enable */
#define PIO_PER_P24 (0x1u << 24) /*  (PIO_PER) PIO Enable */
#define PIO_PER_P25 (0x1u << 25) /*  (PIO_PER) PIO Enable */
#define PIO_PER_P26 (0x1u << 26) /*  (PIO_PER) PIO Enable */
#define PIO_PER_P27 (0x1u << 27) /*  (PIO_PER) PIO Enable */
#define PIO_PER_P28 (0x1u << 28) /*  (PIO_PER) PIO Enable */
#define PIO_PER_P29 (0x1u << 29) /*  (PIO_PER) PIO Enable */
#define PIO_PER_P30 (0x1u << 30) /*  (PIO_PER) PIO Enable */
#define PIO_PER_P31 (0x1u << 31) /*  (PIO_PER) PIO Enable */
/* -------- PIO_PDR : (PIO Offset: 0x0004) PIO Disable Register -------- */
#define PIO_PDR_P0 (0x1u << 0) /*  (PIO_PDR) PIO Disable */
#define PIO_PDR_P1 (0x1u << 1) /*  (PIO_PDR) PIO Disable */
#define PIO_PDR_P2 (0x1u << 2) /*  (PIO_PDR) PIO Disable */
#define PIO_PDR_P3 (0x1u << 3) /*  (PIO_PDR) PIO Disable */
#define PIO_PDR_P4 (0x1u << 4) /*  (PIO_PDR) PIO Disable */
#define PIO_PDR_P5 (0x1u << 5) /*  (PIO_PDR) PIO Disable */
#define PIO_PDR_P6 (0x1u << 6) /*  (PIO_PDR) PIO Disable */
#define PIO_PDR_P7 (0x1u << 7) /*  (PIO_PDR) PIO Disable */
#define PIO_PDR_P8 (0x1u << 8) /*  (PIO_PDR) PIO Disable */
#define PIO_PDR_P9 (0x1u << 9) /*  (PIO_PDR) PIO Disable */
#define PIO_PDR_P10 (0x1u << 10) /*  (PIO_PDR) PIO Disable */
#define PIO_PDR_P11 (0x1u << 11) /*  (PIO_PDR) PIO Disable */
#define PIO_PDR_P12 (0x1u << 12) /*  (PIO_PDR) PIO Disable */
#define PIO_PDR_P13 (0x1u << 13) /*  (PIO_PDR) PIO Disable */
#define PIO_PDR_P14 (0x1u << 14) /*  (PIO_PDR) PIO Disable */
#define PIO_PDR_P15 (0x1u << 15) /*  (PIO_PDR) PIO Disable */
#define PIO_PDR_P16 (0x1u << 16) /*  (PIO_PDR) PIO Disable */
#define PIO_PDR_P17 (0x1u << 17) /*  (PIO_PDR) PIO Disable */
#define PIO_PDR_P18 (0x1u << 18) /*  (PIO_PDR) PIO Disable */
#define PIO_PDR_P19 (0x1u << 19) /*  (PIO_PDR) PIO Disable */
#define PIO_PDR_P20 (0x1u << 20) /*  (PIO_PDR) PIO Disable */
#define PIO_PDR_P21 (0x1u << 21) /*  (PIO_PDR) PIO Disable */
#define PIO_PDR_P22 (0x1u << 22) /*  (PIO_PDR) PIO Disable */
#define PIO_PDR_P23 (0x1u << 23) /*  (PIO_PDR) PIO Disable */
#define PIO_PDR_P24 (0x1u << 24) /*  (PIO_PDR) PIO Disable */
#define PIO_PDR_P25 (0x1u << 25) /*  (PIO_PDR) PIO Disable */
#define PIO_PDR_P26 (0x1u << 26) /*  (PIO_PDR) PIO Disable */
#define PIO_PDR_P27 (0x1u << 27) /*  (PIO_PDR) PIO Disable */
#define PIO_PDR_P28 (0x1u << 28) /*  (PIO_PDR) PIO Disable */
#define PIO_PDR_P29 (0x1u << 29) /*  (PIO_PDR) PIO Disable */
#define PIO_PDR_P30 (0x1u << 30) /*  (PIO_PDR) PIO Disable */
#define PIO_PDR_P31 (0x1u << 31) /*  (PIO_PDR) PIO Disable */
/* -------- PIO_PSR : (PIO Offset: 0x0008) PIO Status Register -------- */
#define PIO_PSR_P0 (0x1u << 0) /*  (PIO_PSR) PIO Status */
#define PIO_PSR_P1 (0x1u << 1) /*  (PIO_PSR) PIO Status */
#define PIO_PSR_P2 (0x1u << 2) /*  (PIO_PSR) PIO Status */
#define PIO_PSR_P3 (0x1u << 3) /*  (PIO_PSR) PIO Status */
#define PIO_PSR_P4 (0x1u << 4) /*  (PIO_PSR) PIO Status */
#define PIO_PSR_P5 (0x1u << 5) /*  (PIO_PSR) PIO Status */
#define PIO_PSR_P6 (0x1u << 6) /*  (PIO_PSR) PIO Status */
#define PIO_PSR_P7 (0x1u << 7) /*  (PIO_PSR) PIO Status */
#define PIO_PSR_P8 (0x1u << 8) /*  (PIO_PSR) PIO Status */
#define PIO_PSR_P9 (0x1u << 9) /*  (PIO_PSR) PIO Status */
#define PIO_PSR_P10 (0x1u << 10) /*  (PIO_PSR) PIO Status */
#define PIO_PSR_P11 (0x1u << 11) /*  (PIO_PSR) PIO Status */
#define PIO_PSR_P12 (0x1u << 12) /*  (PIO_PSR) PIO Status */
#define PIO_PSR_P13 (0x1u << 13) /*  (PIO_PSR) PIO Status */
#define PIO_PSR_P14 (0x1u << 14) /*  (PIO_PSR) PIO Status */
#define PIO_PSR_P15 (0x1u << 15) /*  (PIO_PSR) PIO Status */
#define PIO_PSR_P16 (0x1u << 16) /*  (PIO_PSR) PIO Status */
#define PIO_PSR_P17 (0x1u << 17) /*  (PIO_PSR) PIO Status */
#define PIO_PSR_P18 (0x1u << 18) /*  (PIO_PSR) PIO Status */
#define PIO_PSR_P19 (0x1u << 19) /*  (PIO_PSR) PIO Status */
#define PIO_PSR_P20 (0x1u << 20) /*  (PIO_PSR) PIO Status */
#define PIO_PSR_P21 (0x1u << 21) /*  (PIO_PSR) PIO Status */
#define PIO_PSR_P22 (0x1u << 22) /*  (PIO_PSR) PIO Status */
#define PIO_PSR_P23 (0x1u << 23) /*  (PIO_PSR) PIO Status */
#define PIO_PSR_P24 (0x1u << 24) /*  (PIO_PSR) PIO Status */
#define PIO_PSR_P25 (0x1u << 25) /*  (PIO_PSR) PIO Status */
#define PIO_PSR_P26 (0x1u << 26) /*  (PIO_PSR) PIO Status */
#define PIO_PSR_P27 (0x1u << 27) /*  (PIO_PSR) PIO Status */
#define PIO_PSR_P28 (0x1u << 28) /*  (PIO_PSR) PIO Status */
#define PIO_PSR_P29 (0x1u << 29) /*  (PIO_PSR) PIO Status */
#define PIO_PSR_P30 (0x1u << 30) /*  (PIO_PSR) PIO Status */
#define PIO_PSR_P31 (0x1u << 31) /*  (PIO_PSR) PIO Status */
/* -------- PIO_OER : (PIO Offset: 0x0010) Output Enable Register -------- */
#define PIO_OER_P0 (0x1u << 0) /*  (PIO_OER) Output Enable */
#define PIO_OER_P1 (0x1u << 1) /*  (PIO_OER) Output Enable */
#define PIO_OER_P2 (0x1u << 2) /*  (PIO_OER) Output Enable */
#define PIO_OER_P3 (0x1u << 3) /*  (PIO_OER) Output Enable */
#define PIO_OER_P4 (0x1u << 4) /*  (PIO_OER) Output Enable */
#define PIO_OER_P5 (0x1u << 5) /*  (PIO_OER) Output Enable */
#define PIO_OER_P6 (0x1u << 6) /*  (PIO_OER) Output Enable */
#define PIO_OER_P7 (0x1u << 7) /*  (PIO_OER) Output Enable */
#define PIO_OER_P8 (0x1u << 8) /*  (PIO_OER) Output Enable */
#define PIO_OER_P9 (0x1u << 9) /*  (PIO_OER) Output Enable */
#define PIO_OER_P10 (0x1u << 10) /*  (PIO_OER) Output Enable */
#define PIO_OER_P11 (0x1u << 11) /*  (PIO_OER) Output Enable */
#define PIO_OER_P12 (0x1u << 12) /*  (PIO_OER) Output Enable */
#define PIO_OER_P13 (0x1u << 13) /*  (PIO_OER) Output Enable */
#define PIO_OER_P14 (0x1u << 14) /*  (PIO_OER) Output Enable */
#define PIO_OER_P15 (0x1u << 15) /*  (PIO_OER) Output Enable */
#define PIO_OER_P16 (0x1u << 16) /*  (PIO_OER) Output Enable */
#define PIO_OER_P17 (0x1u << 17) /*  (PIO_OER) Output Enable */
#define PIO_OER_P18 (0x1u << 18) /*  (PIO_OER) Output Enable */
#define PIO_OER_P19 (0x1u << 19) /*  (PIO_OER) Output Enable */
#define PIO_OER_P20 (0x1u << 20) /*  (PIO_OER) Output Enable */
#define PIO_OER_P21 (0x1u << 21) /*  (PIO_OER) Output Enable */
#define PIO_OER_P22 (0x1u << 22) /*  (PIO_OER) Output Enable */
#define PIO_OER_P23 (0x1u << 23) /*  (PIO_OER) Output Enable */
#define PIO_OER_P24 (0x1u << 24) /*  (PIO_OER) Output Enable */
#define PIO_OER_P25 (0x1u << 25) /*  (PIO_OER) Output Enable */
#define PIO_OER_P26 (0x1u << 26) /*  (PIO_OER) Output Enable */
#define PIO_OER_P27 (0x1u << 27) /*  (PIO_OER) Output Enable */
#define PIO_OER_P28 (0x1u << 28) /*  (PIO_OER) Output Enable */
#define PIO_OER_P29 (0x1u << 29) /*  (PIO_OER) Output Enable */
#define PIO_OER_P30 (0x1u << 30) /*  (PIO_OER) Output Enable */
#define PIO_OER_P31 (0x1u << 31) /*  (PIO_OER) Output Enable */
/* -------- PIO_ODR : (PIO Offset: 0x0014) Output Disable Register -------- */
#define PIO_ODR_P0 (0x1u << 0) /*  (PIO_ODR) Output Disable */
#define PIO_ODR_P1 (0x1u << 1) /*  (PIO_ODR) Output Disable */
#define PIO_ODR_P2 (0x1u << 2) /*  (PIO_ODR) Output Disable */
#define PIO_ODR_P3 (0x1u << 3) /*  (PIO_ODR) Output Disable */
#define PIO_ODR_P4 (0x1u << 4) /*  (PIO_ODR) Output Disable */
#define PIO_ODR_P5 (0x1u << 5) /*  (PIO_ODR) Output Disable */
#define PIO_ODR_P6 (0x1u << 6) /*  (PIO_ODR) Output Disable */
#define PIO_ODR_P7 (0x1u << 7) /*  (PIO_ODR) Output Disable */
#define PIO_ODR_P8 (0x1u << 8) /*  (PIO_ODR) Output Disable */
#define PIO_ODR_P9 (0x1u << 9) /*  (PIO_ODR) Output Disable */
#define PIO_ODR_P10 (0x1u << 10) /*  (PIO_ODR) Output Disable */
#define PIO_ODR_P11 (0x1u << 11) /*  (PIO_ODR) Output Disable */
#define PIO_ODR_P12 (0x1u << 12) /*  (PIO_ODR) Output Disable */
#define PIO_ODR_P13 (0x1u << 13) /*  (PIO_ODR) Output Disable */
#define PIO_ODR_P14 (0x1u << 14) /*  (PIO_ODR) Output Disable */
#define PIO_ODR_P15 (0x1u << 15) /*  (PIO_ODR) Output Disable */
#define PIO_ODR_P16 (0x1u << 16) /*  (PIO_ODR) Output Disable */
#define PIO_ODR_P17 (0x1u << 17) /*  (PIO_ODR) Output Disable */
#define PIO_ODR_P18 (0x1u << 18) /*  (PIO_ODR) Output Disable */
#define PIO_ODR_P19 (0x1u << 19) /*  (PIO_ODR) Output Disable */
#define PIO_ODR_P20 (0x1u << 20) /*  (PIO_ODR) Output Disable */
#define PIO_ODR_P21 (0x1u << 21) /*  (PIO_ODR) Output Disable */
#define PIO_ODR_P22 (0x1u << 22) /*  (PIO_ODR) Output Disable */
#define PIO_ODR_P23 (0x1u << 23) /*  (PIO_ODR) Output Disable */
#define PIO_ODR_P24 (0x1u << 24) /*  (PIO_ODR) Output Disable */
#define PIO_ODR_P25 (0x1u << 25) /*  (PIO_ODR) Output Disable */
#define PIO_ODR_P26 (0x1u << 26) /*  (PIO_ODR) Output Disable */
#define PIO_ODR_P27 (0x1u << 27) /*  (PIO_ODR) Output Disable */
#define PIO_ODR_P28 (0x1u << 28) /*  (PIO_ODR) Output Disable */
#define PIO_ODR_P29 (0x1u << 29) /*  (PIO_ODR) Output Disable */
#define PIO_ODR_P30 (0x1u << 30) /*  (PIO_ODR) Output Disable */
#define PIO_ODR_P31 (0x1u << 31) /*  (PIO_ODR) Output Disable */
/* -------- PIO_OSR : (PIO Offset: 0x0018) Output Status Register -------- */
#define PIO_OSR_P0 (0x1u << 0) /*  (PIO_OSR) Output Status */
#define PIO_OSR_P1 (0x1u << 1) /*  (PIO_OSR) Output Status */
#define PIO_OSR_P2 (0x1u << 2) /*  (PIO_OSR) Output Status */
#define PIO_OSR_P3 (0x1u << 3) /*  (PIO_OSR) Output Status */
#define PIO_OSR_P4 (0x1u << 4) /*  (PIO_OSR) Output Status */
#define PIO_OSR_P5 (0x1u << 5) /*  (PIO_OSR) Output Status */
#define PIO_OSR_P6 (0x1u << 6) /*  (PIO_OSR) Output Status */
#define PIO_OSR_P7 (0x1u << 7) /*  (PIO_OSR) Output Status */
#define PIO_OSR_P8 (0x1u << 8) /*  (PIO_OSR) Output Status */
#define PIO_OSR_P9 (0x1u << 9) /*  (PIO_OSR) Output Status */
#define PIO_OSR_P10 (0x1u << 10) /*  (PIO_OSR) Output Status */
#define PIO_OSR_P11 (0x1u << 11) /*  (PIO_OSR) Output Status */
#define PIO_OSR_P12 (0x1u << 12) /*  (PIO_OSR) Output Status */
#define PIO_OSR_P13 (0x1u << 13) /*  (PIO_OSR) Output Status */
#define PIO_OSR_P14 (0x1u << 14) /*  (PIO_OSR) Output Status */
#define PIO_OSR_P15 (0x1u << 15) /*  (PIO_OSR) Output Status */
#define PIO_OSR_P16 (0x1u << 16) /*  (PIO_OSR) Output Status */
#define PIO_OSR_P17 (0x1u << 17) /*  (PIO_OSR) Output Status */
#define PIO_OSR_P18 (0x1u << 18) /*  (PIO_OSR) Output Status */
#define PIO_OSR_P19 (0x1u << 19) /*  (PIO_OSR) Output Status */
#define PIO_OSR_P20 (0x1u << 20) /*  (PIO_OSR) Output Status */
#define PIO_OSR_P21 (0x1u << 21) /*  (PIO_OSR) Output Status */
#define PIO_OSR_P22 (0x1u << 22) /*  (PIO_OSR) Output Status */
#define PIO_OSR_P23 (0x1u << 23) /*  (PIO_OSR) Output Status */
#define PIO_OSR_P24 (0x1u << 24) /*  (PIO_OSR) Output Status */
#define PIO_OSR_P25 (0x1u << 25) /*  (PIO_OSR) Output Status */
#define PIO_OSR_P26 (0x1u << 26) /*  (PIO_OSR) Output Status */
#define PIO_OSR_P27 (0x1u << 27) /*  (PIO_OSR) Output Status */
#define PIO_OSR_P28 (0x1u << 28) /*  (PIO_OSR) Output Status */
#define PIO_OSR_P29 (0x1u << 29) /*  (PIO_OSR) Output Status */
#define PIO_OSR_P30 (0x1u << 30) /*  (PIO_OSR) Output Status */
#define PIO_OSR_P31 (0x1u << 31) /*  (PIO_OSR) Output Status */
/* -------- PIO_IFER : (PIO Offset: 0x0020) Glitch Input Filter Enable Register -------- */
#define PIO_IFER_P0 (0x1u << 0) /*  (PIO_IFER) Input Filter Enable */
#define PIO_IFER_P1 (0x1u << 1) /*  (PIO_IFER) Input Filter Enable */
#define PIO_IFER_P2 (0x1u << 2) /*  (PIO_IFER) Input Filter Enable */
#define PIO_IFER_P3 (0x1u << 3) /*  (PIO_IFER) Input Filter Enable */
#define PIO_IFER_P4 (0x1u << 4) /*  (PIO_IFER) Input Filter Enable */
#define PIO_IFER_P5 (0x1u << 5) /*  (PIO_IFER) Input Filter Enable */
#define PIO_IFER_P6 (0x1u << 6) /*  (PIO_IFER) Input Filter Enable */
#define PIO_IFER_P7 (0x1u << 7) /*  (PIO_IFER) Input Filter Enable */
#define PIO_IFER_P8 (0x1u << 8) /*  (PIO_IFER) Input Filter Enable */
#define PIO_IFER_P9 (0x1u << 9) /*  (PIO_IFER) Input Filter Enable */
#define PIO_IFER_P10 (0x1u << 10) /*  (PIO_IFER) Input Filter Enable */
#define PIO_IFER_P11 (0x1u << 11) /*  (PIO_IFER) Input Filter Enable */
#define PIO_IFER_P12 (0x1u << 12) /*  (PIO_IFER) Input Filter Enable */
#define PIO_IFER_P13 (0x1u << 13) /*  (PIO_IFER) Input Filter Enable */
#define PIO_IFER_P14 (0x1u << 14) /*  (PIO_IFER) Input Filter Enable */
#define PIO_IFER_P15 (0x1u << 15) /*  (PIO_IFER) Input Filter Enable */
#define PIO_IFER_P16 (0x1u << 16) /*  (PIO_IFER) Input Filter Enable */
#define PIO_IFER_P17 (0x1u << 17) /*  (PIO_IFER) Input Filter Enable */
#define PIO_IFER_P18 (0x1u << 18) /*  (PIO_IFER) Input Filter Enable */
#define PIO_IFER_P19 (0x1u << 19) /*  (PIO_IFER) Input Filter Enable */
#define PIO_IFER_P20 (0x1u << 20) /*  (PIO_IFER) Input Filter Enable */
#define PIO_IFER_P21 (0x1u << 21) /*  (PIO_IFER) Input Filter Enable */
#define PIO_IFER_P22 (0x1u << 22) /*  (PIO_IFER) Input Filter Enable */
#define PIO_IFER_P23 (0x1u << 23) /*  (PIO_IFER) Input Filter Enable */
#define PIO_IFER_P24 (0x1u << 24) /*  (PIO_IFER) Input Filter Enable */
#define PIO_IFER_P25 (0x1u << 25) /*  (PIO_IFER) Input Filter Enable */
#define PIO_IFER_P26 (0x1u << 26) /*  (PIO_IFER) Input Filter Enable */
#define PIO_IFER_P27 (0x1u << 27) /*  (PIO_IFER) Input Filter Enable */
#define PIO_IFER_P28 (0x1u << 28) /*  (PIO_IFER) Input Filter Enable */
#define PIO_IFER_P29 (0x1u << 29) /*  (PIO_IFER) Input Filter Enable */
#define PIO_IFER_P30 (0x1u << 30) /*  (PIO_IFER) Input Filter Enable */
#define PIO_IFER_P31 (0x1u << 31) /*  (PIO_IFER) Input Filter Enable */
/* -------- PIO_IFDR : (PIO Offset: 0x0024) Glitch Input Filter Disable Register -------- */
#define PIO_IFDR_P0 (0x1u << 0) /*  (PIO_IFDR) Input Filter Disable */
#define PIO_IFDR_P1 (0x1u << 1) /*  (PIO_IFDR) Input Filter Disable */
#define PIO_IFDR_P2 (0x1u << 2) /*  (PIO_IFDR) Input Filter Disable */
#define PIO_IFDR_P3 (0x1u << 3) /*  (PIO_IFDR) Input Filter Disable */
#define PIO_IFDR_P4 (0x1u << 4) /*  (PIO_IFDR) Input Filter Disable */
#define PIO_IFDR_P5 (0x1u << 5) /*  (PIO_IFDR) Input Filter Disable */
#define PIO_IFDR_P6 (0x1u << 6) /*  (PIO_IFDR) Input Filter Disable */
#define PIO_IFDR_P7 (0x1u << 7) /*  (PIO_IFDR) Input Filter Disable */
#define PIO_IFDR_P8 (0x1u << 8) /*  (PIO_IFDR) Input Filter Disable */
#define PIO_IFDR_P9 (0x1u << 9) /*  (PIO_IFDR) Input Filter Disable */
#define PIO_IFDR_P10 (0x1u << 10) /*  (PIO_IFDR) Input Filter Disable */
#define PIO_IFDR_P11 (0x1u << 11) /*  (PIO_IFDR) Input Filter Disable */
#define PIO_IFDR_P12 (0x1u << 12) /*  (PIO_IFDR) Input Filter Disable */
#define PIO_IFDR_P13 (0x1u << 13) /*  (PIO_IFDR) Input Filter Disable */
#define PIO_IFDR_P14 (0x1u << 14) /*  (PIO_IFDR) Input Filter Disable */
#define PIO_IFDR_P15 (0x1u << 15) /*  (PIO_IFDR) Input Filter Disable */
#define PIO_IFDR_P16 (0x1u << 16) /*  (PIO_IFDR) Input Filter Disable */
#define PIO_IFDR_P17 (0x1u << 17) /*  (PIO_IFDR) Input Filter Disable */
#define PIO_IFDR_P18 (0x1u << 18) /*  (PIO_IFDR) Input Filter Disable */
#define PIO_IFDR_P19 (0x1u << 19) /*  (PIO_IFDR) Input Filter Disable */
#define PIO_IFDR_P20 (0x1u << 20) /*  (PIO_IFDR) Input Filter Disable */
#define PIO_IFDR_P21 (0x1u << 21) /*  (PIO_IFDR) Input Filter Disable */
#define PIO_IFDR_P22 (0x1u << 22) /*  (PIO_IFDR) Input Filter Disable */
#define PIO_IFDR_P23 (0x1u << 23) /*  (PIO_IFDR) Input Filter Disable */
#define PIO_IFDR_P24 (0x1u << 24) /*  (PIO_IFDR) Input Filter Disable */
#define PIO_IFDR_P25 (0x1u << 25) /*  (PIO_IFDR) Input Filter Disable */
#define PIO_IFDR_P26 (0x1u << 26) /*  (PIO_IFDR) Input Filter Disable */
#define PIO_IFDR_P27 (0x1u << 27) /*  (PIO_IFDR) Input Filter Disable */
#define PIO_IFDR_P28 (0x1u << 28) /*  (PIO_IFDR) Input Filter Disable */
#define PIO_IFDR_P29 (0x1u << 29) /*  (PIO_IFDR) Input Filter Disable */
#define PIO_IFDR_P30 (0x1u << 30) /*  (PIO_IFDR) Input Filter Disable */
#define PIO_IFDR_P31 (0x1u << 31) /*  (PIO_IFDR) Input Filter Disable */
/* -------- PIO_IFSR : (PIO Offset: 0x0028) Glitch Input Filter Status Register -------- */
#define PIO_IFSR_P0 (0x1u << 0) /*  (PIO_IFSR) Input Filer Status */
#define PIO_IFSR_P1 (0x1u << 1) /*  (PIO_IFSR) Input Filer Status */
#define PIO_IFSR_P2 (0x1u << 2) /*  (PIO_IFSR) Input Filer Status */
#define PIO_IFSR_P3 (0x1u << 3) /*  (PIO_IFSR) Input Filer Status */
#define PIO_IFSR_P4 (0x1u << 4) /*  (PIO_IFSR) Input Filer Status */
#define PIO_IFSR_P5 (0x1u << 5) /*  (PIO_IFSR) Input Filer Status */
#define PIO_IFSR_P6 (0x1u << 6) /*  (PIO_IFSR) Input Filer Status */
#define PIO_IFSR_P7 (0x1u << 7) /*  (PIO_IFSR) Input Filer Status */
#define PIO_IFSR_P8 (0x1u << 8) /*  (PIO_IFSR) Input Filer Status */
#define PIO_IFSR_P9 (0x1u << 9) /*  (PIO_IFSR) Input Filer Status */
#define PIO_IFSR_P10 (0x1u << 10) /*  (PIO_IFSR) Input Filer Status */
#define PIO_IFSR_P11 (0x1u << 11) /*  (PIO_IFSR) Input Filer Status */
#define PIO_IFSR_P12 (0x1u << 12) /*  (PIO_IFSR) Input Filer Status */
#define PIO_IFSR_P13 (0x1u << 13) /*  (PIO_IFSR) Input Filer Status */
#define PIO_IFSR_P14 (0x1u << 14) /*  (PIO_IFSR) Input Filer Status */
#define PIO_IFSR_P15 (0x1u << 15) /*  (PIO_IFSR) Input Filer Status */
#define PIO_IFSR_P16 (0x1u << 16) /*  (PIO_IFSR) Input Filer Status */
#define PIO_IFSR_P17 (0x1u << 17) /*  (PIO_IFSR) Input Filer Status */
#define PIO_IFSR_P18 (0x1u << 18) /*  (PIO_IFSR) Input Filer Status */
#define PIO_IFSR_P19 (0x1u << 19) /*  (PIO_IFSR) Input Filer Status */
#define PIO_IFSR_P20 (0x1u << 20) /*  (PIO_IFSR) Input Filer Status */
#define PIO_IFSR_P21 (0x1u << 21) /*  (PIO_IFSR) Input Filer Status */
#define PIO_IFSR_P22 (0x1u << 22) /*  (PIO_IFSR) Input Filer Status */
#define PIO_IFSR_P23 (0x1u << 23) /*  (PIO_IFSR) Input Filer Status */
#define PIO_IFSR_P24 (0x1u << 24) /*  (PIO_IFSR) Input Filer Status */
#define PIO_IFSR_P25 (0x1u << 25) /*  (PIO_IFSR) Input Filer Status */
#define PIO_IFSR_P26 (0x1u << 26) /*  (PIO_IFSR) Input Filer Status */
#define PIO_IFSR_P27 (0x1u << 27) /*  (PIO_IFSR) Input Filer Status */
#define PIO_IFSR_P28 (0x1u << 28) /*  (PIO_IFSR) Input Filer Status */
#define PIO_IFSR_P29 (0x1u << 29) /*  (PIO_IFSR) Input Filer Status */
#define PIO_IFSR_P30 (0x1u << 30) /*  (PIO_IFSR) Input Filer Status */
#define PIO_IFSR_P31 (0x1u << 31) /*  (PIO_IFSR) Input Filer Status */
/* -------- PIO_SODR : (PIO Offset: 0x0030) Set Output Data Register -------- */
#define PIO_SODR_P0 (0x1u << 0) /*  (PIO_SODR) Set Output Data */
#define PIO_SODR_P1 (0x1u << 1) /*  (PIO_SODR) Set Output Data */
#define PIO_SODR_P2 (0x1u << 2) /*  (PIO_SODR) Set Output Data */
#define PIO_SODR_P3 (0x1u << 3) /*  (PIO_SODR) Set Output Data */
#define PIO_SODR_P4 (0x1u << 4) /*  (PIO_SODR) Set Output Data */
#define PIO_SODR_P5 (0x1u << 5) /*  (PIO_SODR) Set Output Data */
#define PIO_SODR_P6 (0x1u << 6) /*  (PIO_SODR) Set Output Data */
#define PIO_SODR_P7 (0x1u << 7) /*  (PIO_SODR) Set Output Data */
#define PIO_SODR_P8 (0x1u << 8) /*  (PIO_SODR) Set Output Data */
#define PIO_SODR_P9 (0x1u << 9) /*  (PIO_SODR) Set Output Data */
#define PIO_SODR_P10 (0x1u << 10) /*  (PIO_SODR) Set Output Data */
#define PIO_SODR_P11 (0x1u << 11) /*  (PIO_SODR) Set Output Data */
#define PIO_SODR_P12 (0x1u << 12) /*  (PIO_SODR) Set Output Data */
#define PIO_SODR_P13 (0x1u << 13) /*  (PIO_SODR) Set Output Data */
#define PIO_SODR_P14 (0x1u << 14) /*  (PIO_SODR) Set Output Data */
#define PIO_SODR_P15 (0x1u << 15) /*  (PIO_SODR) Set Output Data */
#define PIO_SODR_P16 (0x1u << 16) /*  (PIO_SODR) Set Output Data */
#define PIO_SODR_P17 (0x1u << 17) /*  (PIO_SODR) Set Output Data */
#define PIO_SODR_P18 (0x1u << 18) /*  (PIO_SODR) Set Output Data */
#define PIO_SODR_P19 (0x1u << 19) /*  (PIO_SODR) Set Output Data */
#define PIO_SODR_P20 (0x1u << 20) /*  (PIO_SODR) Set Output Data */
#define PIO_SODR_P21 (0x1u << 21) /*  (PIO_SODR) Set Output Data */
#define PIO_SODR_P22 (0x1u << 22) /*  (PIO_SODR) Set Output Data */
#define PIO_SODR_P23 (0x1u << 23) /*  (PIO_SODR) Set Output Data */
#define PIO_SODR_P24 (0x1u << 24) /*  (PIO_SODR) Set Output Data */
#define PIO_SODR_P25 (0x1u << 25) /*  (PIO_SODR) Set Output Data */
#define PIO_SODR_P26 (0x1u << 26) /*  (PIO_SODR) Set Output Data */
#define PIO_SODR_P27 (0x1u << 27) /*  (PIO_SODR) Set Output Data */
#define PIO_SODR_P28 (0x1u << 28) /*  (PIO_SODR) Set Output Data */
#define PIO_SODR_P29 (0x1u << 29) /*  (PIO_SODR) Set Output Data */
#define PIO_SODR_P30 (0x1u << 30) /*  (PIO_SODR) Set Output Data */
#define PIO_SODR_P31 (0x1u << 31) /*  (PIO_SODR) Set Output Data */
/* -------- PIO_CODR : (PIO Offset: 0x0034) Clear Output Data Register -------- */
#define PIO_CODR_P0 (0x1u << 0) /*  (PIO_CODR) Clear Output Data */
#define PIO_CODR_P1 (0x1u << 1) /*  (PIO_CODR) Clear Output Data */
#define PIO_CODR_P2 (0x1u << 2) /*  (PIO_CODR) Clear Output Data */
#define PIO_CODR_P3 (0x1u << 3) /*  (PIO_CODR) Clear Output Data */
#define PIO_CODR_P4 (0x1u << 4) /*  (PIO_CODR) Clear Output Data */
#define PIO_CODR_P5 (0x1u << 5) /*  (PIO_CODR) Clear Output Data */
#define PIO_CODR_P6 (0x1u << 6) /*  (PIO_CODR) Clear Output Data */
#define PIO_CODR_P7 (0x1u << 7) /*  (PIO_CODR) Clear Output Data */
#define PIO_CODR_P8 (0x1u << 8) /*  (PIO_CODR) Clear Output Data */
#define PIO_CODR_P9 (0x1u << 9) /*  (PIO_CODR) Clear Output Data */
#define PIO_CODR_P10 (0x1u << 10) /*  (PIO_CODR) Clear Output Data */
#define PIO_CODR_P11 (0x1u << 11) /*  (PIO_CODR) Clear Output Data */
#define PIO_CODR_P12 (0x1u << 12) /*  (PIO_CODR) Clear Output Data */
#define PIO_CODR_P13 (0x1u << 13) /*  (PIO_CODR) Clear Output Data */
#define PIO_CODR_P14 (0x1u << 14) /*  (PIO_CODR) Clear Output Data */
#define PIO_CODR_P15 (0x1u << 15) /*  (PIO_CODR) Clear Output Data */
#define PIO_CODR_P16 (0x1u << 16) /*  (PIO_CODR) Clear Output Data */
#define PIO_CODR_P17 (0x1u << 17) /*  (PIO_CODR) Clear Output Data */
#define PIO_CODR_P18 (0x1u << 18) /*  (PIO_CODR) Clear Output Data */
#define PIO_CODR_P19 (0x1u << 19) /*  (PIO_CODR) Clear Output Data */
#define PIO_CODR_P20 (0x1u << 20) /*  (PIO_CODR) Clear Output Data */
#define PIO_CODR_P21 (0x1u << 21) /*  (PIO_CODR) Clear Output Data */
#define PIO_CODR_P22 (0x1u << 22) /*  (PIO_CODR) Clear Output Data */
#define PIO_CODR_P23 (0x1u << 23) /*  (PIO_CODR) Clear Output Data */
#define PIO_CODR_P24 (0x1u << 24) /*  (PIO_CODR) Clear Output Data */
#define PIO_CODR_P25 (0x1u << 25) /*  (PIO_CODR) Clear Output Data */
#define PIO_CODR_P26 (0x1u << 26) /*  (PIO_CODR) Clear Output Data */
#define PIO_CODR_P27 (0x1u << 27) /*  (PIO_CODR) Clear Output Data */
#define PIO_CODR_P28 (0x1u << 28) /*  (PIO_CODR) Clear Output Data */
#define PIO_CODR_P29 (0x1u << 29) /*  (PIO_CODR) Clear Output Data */
#define PIO_CODR_P30 (0x1u << 30) /*  (PIO_CODR) Clear Output Data */
#define PIO_CODR_P31 (0x1u << 31) /*  (PIO_CODR) Clear Output Data */
/* -------- PIO_ODSR : (PIO Offset: 0x0038) Output Data Status Register -------- */
#define PIO_ODSR_P0 (0x1u << 0) /*  (PIO_ODSR) Output Data Status */
#define PIO_ODSR_P1 (0x1u << 1) /*  (PIO_ODSR) Output Data Status */
#define PIO_ODSR_P2 (0x1u << 2) /*  (PIO_ODSR) Output Data Status */
#define PIO_ODSR_P3 (0x1u << 3) /*  (PIO_ODSR) Output Data Status */
#define PIO_ODSR_P4 (0x1u << 4) /*  (PIO_ODSR) Output Data Status */
#define PIO_ODSR_P5 (0x1u << 5) /*  (PIO_ODSR) Output Data Status */
#define PIO_ODSR_P6 (0x1u << 6) /*  (PIO_ODSR) Output Data Status */
#define PIO_ODSR_P7 (0x1u << 7) /*  (PIO_ODSR) Output Data Status */
#define PIO_ODSR_P8 (0x1u << 8) /*  (PIO_ODSR) Output Data Status */
#define PIO_ODSR_P9 (0x1u << 9) /*  (PIO_ODSR) Output Data Status */
#define PIO_ODSR_P10 (0x1u << 10) /*  (PIO_ODSR) Output Data Status */
#define PIO_ODSR_P11 (0x1u << 11) /*  (PIO_ODSR) Output Data Status */
#define PIO_ODSR_P12 (0x1u << 12) /*  (PIO_ODSR) Output Data Status */
#define PIO_ODSR_P13 (0x1u << 13) /*  (PIO_ODSR) Output Data Status */
#define PIO_ODSR_P14 (0x1u << 14) /*  (PIO_ODSR) Output Data Status */
#define PIO_ODSR_P15 (0x1u << 15) /*  (PIO_ODSR) Output Data Status */
#define PIO_ODSR_P16 (0x1u << 16) /*  (PIO_ODSR) Output Data Status */
#define PIO_ODSR_P17 (0x1u << 17) /*  (PIO_ODSR) Output Data Status */
#define PIO_ODSR_P18 (0x1u << 18) /*  (PIO_ODSR) Output Data Status */
#define PIO_ODSR_P19 (0x1u << 19) /*  (PIO_ODSR) Output Data Status */
#define PIO_ODSR_P20 (0x1u << 20) /*  (PIO_ODSR) Output Data Status */
#define PIO_ODSR_P21 (0x1u << 21) /*  (PIO_ODSR) Output Data Status */
#define PIO_ODSR_P22 (0x1u << 22) /*  (PIO_ODSR) Output Data Status */
#define PIO_ODSR_P23 (0x1u << 23) /*  (PIO_ODSR) Output Data Status */
#define PIO_ODSR_P24 (0x1u << 24) /*  (PIO_ODSR) Output Data Status */
#define PIO_ODSR_P25 (0x1u << 25) /*  (PIO_ODSR) Output Data Status */
#define PIO_ODSR_P26 (0x1u << 26) /*  (PIO_ODSR) Output Data Status */
#define PIO_ODSR_P27 (0x1u << 27) /*  (PIO_ODSR) Output Data Status */
#define PIO_ODSR_P28 (0x1u << 28) /*  (PIO_ODSR) Output Data Status */
#define PIO_ODSR_P29 (0x1u << 29) /*  (PIO_ODSR) Output Data Status */
#define PIO_ODSR_P30 (0x1u << 30) /*  (PIO_ODSR) Output Data Status */
#define PIO_ODSR_P31 (0x1u << 31) /*  (PIO_ODSR) Output Data Status */
/* -------- PIO_PDSR : (PIO Offset: 0x003C) Pin Data Status Register -------- */
#define PIO_PDSR_P0 (0x1u << 0) /*  (PIO_PDSR) Output Data Status */
#define PIO_PDSR_P1 (0x1u << 1) /*  (PIO_PDSR) Output Data Status */
#define PIO_PDSR_P2 (0x1u << 2) /*  (PIO_PDSR) Output Data Status */
#define PIO_PDSR_P3 (0x1u << 3) /*  (PIO_PDSR) Output Data Status */
#define PIO_PDSR_P4 (0x1u << 4) /*  (PIO_PDSR) Output Data Status */
#define PIO_PDSR_P5 (0x1u << 5) /*  (PIO_PDSR) Output Data Status */
#define PIO_PDSR_P6 (0x1u << 6) /*  (PIO_PDSR) Output Data Status */
#define PIO_PDSR_P7 (0x1u << 7) /*  (PIO_PDSR) Output Data Status */
#define PIO_PDSR_P8 (0x1u << 8) /*  (PIO_PDSR) Output Data Status */
#define PIO_PDSR_P9 (0x1u << 9) /*  (PIO_PDSR) Output Data Status */
#define PIO_PDSR_P10 (0x1u << 10) /*  (PIO_PDSR) Output Data Status */
#define PIO_PDSR_P11 (0x1u << 11) /*  (PIO_PDSR) Output Data Status */
#define PIO_PDSR_P12 (0x1u << 12) /*  (PIO_PDSR) Output Data Status */
#define PIO_PDSR_P13 (0x1u << 13) /*  (PIO_PDSR) Output Data Status */
#define PIO_PDSR_P14 (0x1u << 14) /*  (PIO_PDSR) Output Data Status */
#define PIO_PDSR_P15 (0x1u << 15) /*  (PIO_PDSR) Output Data Status */
#define PIO_PDSR_P16 (0x1u << 16) /*  (PIO_PDSR) Output Data Status */
#define PIO_PDSR_P17 (0x1u << 17) /*  (PIO_PDSR) Output Data Status */
#define PIO_PDSR_P18 (0x1u << 18) /*  (PIO_PDSR) Output Data Status */
#define PIO_PDSR_P19 (0x1u << 19) /*  (PIO_PDSR) Output Data Status */
#define PIO_PDSR_P20 (0x1u << 20) /*  (PIO_PDSR) Output Data Status */
#define PIO_PDSR_P21 (0x1u << 21) /*  (PIO_PDSR) Output Data Status */
#define PIO_PDSR_P22 (0x1u << 22) /*  (PIO_PDSR) Output Data Status */
#define PIO_PDSR_P23 (0x1u << 23) /*  (PIO_PDSR) Output Data Status */
#define PIO_PDSR_P24 (0x1u << 24) /*  (PIO_PDSR) Output Data Status */
#define PIO_PDSR_P25 (0x1u << 25) /*  (PIO_PDSR) Output Data Status */
#define PIO_PDSR_P26 (0x1u << 26) /*  (PIO_PDSR) Output Data Status */
#define PIO_PDSR_P27 (0x1u << 27) /*  (PIO_PDSR) Output Data Status */
#define PIO_PDSR_P28 (0x1u << 28) /*  (PIO_PDSR) Output Data Status */
#define PIO_PDSR_P29 (0x1u << 29) /*  (PIO_PDSR) Output Data Status */
#define PIO_PDSR_P30 (0x1u << 30) /*  (PIO_PDSR) Output Data Status */
#define PIO_PDSR_P31 (0x1u << 31) /*  (PIO_PDSR) Output Data Status */
/* -------- PIO_IER : (PIO Offset: 0x0040) Interrupt Enable Register -------- */
#define PIO_IER_P0 (0x1u << 0) /*  (PIO_IER) Input Change Interrupt Enable */
#define PIO_IER_P1 (0x1u << 1) /*  (PIO_IER) Input Change Interrupt Enable */
#define PIO_IER_P2 (0x1u << 2) /*  (PIO_IER) Input Change Interrupt Enable */
#define PIO_IER_P3 (0x1u << 3) /*  (PIO_IER) Input Change Interrupt Enable */
#define PIO_IER_P4 (0x1u << 4) /*  (PIO_IER) Input Change Interrupt Enable */
#define PIO_IER_P5 (0x1u << 5) /*  (PIO_IER) Input Change Interrupt Enable */
#define PIO_IER_P6 (0x1u << 6) /*  (PIO_IER) Input Change Interrupt Enable */
#define PIO_IER_P7 (0x1u << 7) /*  (PIO_IER) Input Change Interrupt Enable */
#define PIO_IER_P8 (0x1u << 8) /*  (PIO_IER) Input Change Interrupt Enable */
#define PIO_IER_P9 (0x1u << 9) /*  (PIO_IER) Input Change Interrupt Enable */
#define PIO_IER_P10 (0x1u << 10) /*  (PIO_IER) Input Change Interrupt Enable */
#define PIO_IER_P11 (0x1u << 11) /*  (PIO_IER) Input Change Interrupt Enable */
#define PIO_IER_P12 (0x1u << 12) /*  (PIO_IER) Input Change Interrupt Enable */
#define PIO_IER_P13 (0x1u << 13) /*  (PIO_IER) Input Change Interrupt Enable */
#define PIO_IER_P14 (0x1u << 14) /*  (PIO_IER) Input Change Interrupt Enable */
#define PIO_IER_P15 (0x1u << 15) /*  (PIO_IER) Input Change Interrupt Enable */
#define PIO_IER_P16 (0x1u << 16) /*  (PIO_IER) Input Change Interrupt Enable */
#define PIO_IER_P17 (0x1u << 17) /*  (PIO_IER) Input Change Interrupt Enable */
#define PIO_IER_P18 (0x1u << 18) /*  (PIO_IER) Input Change Interrupt Enable */
#define PIO_IER_P19 (0x1u << 19) /*  (PIO_IER) Input Change Interrupt Enable */
#define PIO_IER_P20 (0x1u << 20) /*  (PIO_IER) Input Change Interrupt Enable */
#define PIO_IER_P21 (0x1u << 21) /*  (PIO_IER) Input Change Interrupt Enable */
#define PIO_IER_P22 (0x1u << 22) /*  (PIO_IER) Input Change Interrupt Enable */
#define PIO_IER_P23 (0x1u << 23) /*  (PIO_IER) Input Change Interrupt Enable */
#define PIO_IER_P24 (0x1u << 24) /*  (PIO_IER) Input Change Interrupt Enable */
#define PIO_IER_P25 (0x1u << 25) /*  (PIO_IER) Input Change Interrupt Enable */
#define PIO_IER_P26 (0x1u << 26) /*  (PIO_IER) Input Change Interrupt Enable */
#define PIO_IER_P27 (0x1u << 27) /*  (PIO_IER) Input Change Interrupt Enable */
#define PIO_IER_P28 (0x1u << 28) /*  (PIO_IER) Input Change Interrupt Enable */
#define PIO_IER_P29 (0x1u << 29) /*  (PIO_IER) Input Change Interrupt Enable */
#define PIO_IER_P30 (0x1u << 30) /*  (PIO_IER) Input Change Interrupt Enable */
#define PIO_IER_P31 (0x1u << 31) /*  (PIO_IER) Input Change Interrupt Enable */
/* -------- PIO_IDR : (PIO Offset: 0x0044) Interrupt Disable Register -------- */
#define PIO_IDR_P0 (0x1u << 0) /*  (PIO_IDR) Input Change Interrupt Disable */
#define PIO_IDR_P1 (0x1u << 1) /*  (PIO_IDR) Input Change Interrupt Disable */
#define PIO_IDR_P2 (0x1u << 2) /*  (PIO_IDR) Input Change Interrupt Disable */
#define PIO_IDR_P3 (0x1u << 3) /*  (PIO_IDR) Input Change Interrupt Disable */
#define PIO_IDR_P4 (0x1u << 4) /*  (PIO_IDR) Input Change Interrupt Disable */
#define PIO_IDR_P5 (0x1u << 5) /*  (PIO_IDR) Input Change Interrupt Disable */
#define PIO_IDR_P6 (0x1u << 6) /*  (PIO_IDR) Input Change Interrupt Disable */
#define PIO_IDR_P7 (0x1u << 7) /*  (PIO_IDR) Input Change Interrupt Disable */
#define PIO_IDR_P8 (0x1u << 8) /*  (PIO_IDR) Input Change Interrupt Disable */
#define PIO_IDR_P9 (0x1u << 9) /*  (PIO_IDR) Input Change Interrupt Disable */
#define PIO_IDR_P10 (0x1u << 10) /*  (PIO_IDR) Input Change Interrupt Disable */
#define PIO_IDR_P11 (0x1u << 11) /*  (PIO_IDR) Input Change Interrupt Disable */
#define PIO_IDR_P12 (0x1u << 12) /*  (PIO_IDR) Input Change Interrupt Disable */
#define PIO_IDR_P13 (0x1u << 13) /*  (PIO_IDR) Input Change Interrupt Disable */
#define PIO_IDR_P14 (0x1u << 14) /*  (PIO_IDR) Input Change Interrupt Disable */
#define PIO_IDR_P15 (0x1u << 15) /*  (PIO_IDR) Input Change Interrupt Disable */
#define PIO_IDR_P16 (0x1u << 16) /*  (PIO_IDR) Input Change Interrupt Disable */
#define PIO_IDR_P17 (0x1u << 17) /*  (PIO_IDR) Input Change Interrupt Disable */
#define PIO_IDR_P18 (0x1u << 18) /*  (PIO_IDR) Input Change Interrupt Disable */
#define PIO_IDR_P19 (0x1u << 19) /*  (PIO_IDR) Input Change Interrupt Disable */
#define PIO_IDR_P20 (0x1u << 20) /*  (PIO_IDR) Input Change Interrupt Disable */
#define PIO_IDR_P21 (0x1u << 21) /*  (PIO_IDR) Input Change Interrupt Disable */
#define PIO_IDR_P22 (0x1u << 22) /*  (PIO_IDR) Input Change Interrupt Disable */
#define PIO_IDR_P23 (0x1u << 23) /*  (PIO_IDR) Input Change Interrupt Disable */
#define PIO_IDR_P24 (0x1u << 24) /*  (PIO_IDR) Input Change Interrupt Disable */
#define PIO_IDR_P25 (0x1u << 25) /*  (PIO_IDR) Input Change Interrupt Disable */
#define PIO_IDR_P26 (0x1u << 26) /*  (PIO_IDR) Input Change Interrupt Disable */
#define PIO_IDR_P27 (0x1u << 27) /*  (PIO_IDR) Input Change Interrupt Disable */
#define PIO_IDR_P28 (0x1u << 28) /*  (PIO_IDR) Input Change Interrupt Disable */
#define PIO_IDR_P29 (0x1u << 29) /*  (PIO_IDR) Input Change Interrupt Disable */
#define PIO_IDR_P30 (0x1u << 30) /*  (PIO_IDR) Input Change Interrupt Disable */
#define PIO_IDR_P31 (0x1u << 31) /*  (PIO_IDR) Input Change Interrupt Disable */
/* -------- PIO_IMR : (PIO Offset: 0x0048) Interrupt Mask Register -------- */
#define PIO_IMR_P0 (0x1u << 0) /*  (PIO_IMR) Input Change Interrupt Mask */
#define PIO_IMR_P1 (0x1u << 1) /*  (PIO_IMR) Input Change Interrupt Mask */
#define PIO_IMR_P2 (0x1u << 2) /*  (PIO_IMR) Input Change Interrupt Mask */
#define PIO_IMR_P3 (0x1u << 3) /*  (PIO_IMR) Input Change Interrupt Mask */
#define PIO_IMR_P4 (0x1u << 4) /*  (PIO_IMR) Input Change Interrupt Mask */
#define PIO_IMR_P5 (0x1u << 5) /*  (PIO_IMR) Input Change Interrupt Mask */
#define PIO_IMR_P6 (0x1u << 6) /*  (PIO_IMR) Input Change Interrupt Mask */
#define PIO_IMR_P7 (0x1u << 7) /*  (PIO_IMR) Input Change Interrupt Mask */
#define PIO_IMR_P8 (0x1u << 8) /*  (PIO_IMR) Input Change Interrupt Mask */
#define PIO_IMR_P9 (0x1u << 9) /*  (PIO_IMR) Input Change Interrupt Mask */
#define PIO_IMR_P10 (0x1u << 10) /*  (PIO_IMR) Input Change Interrupt Mask */
#define PIO_IMR_P11 (0x1u << 11) /*  (PIO_IMR) Input Change Interrupt Mask */
#define PIO_IMR_P12 (0x1u << 12) /*  (PIO_IMR) Input Change Interrupt Mask */
#define PIO_IMR_P13 (0x1u << 13) /*  (PIO_IMR) Input Change Interrupt Mask */
#define PIO_IMR_P14 (0x1u << 14) /*  (PIO_IMR) Input Change Interrupt Mask */
#define PIO_IMR_P15 (0x1u << 15) /*  (PIO_IMR) Input Change Interrupt Mask */
#define PIO_IMR_P16 (0x1u << 16) /*  (PIO_IMR) Input Change Interrupt Mask */
#define PIO_IMR_P17 (0x1u << 17) /*  (PIO_IMR) Input Change Interrupt Mask */
#define PIO_IMR_P18 (0x1u << 18) /*  (PIO_IMR) Input Change Interrupt Mask */
#define PIO_IMR_P19 (0x1u << 19) /*  (PIO_IMR) Input Change Interrupt Mask */
#define PIO_IMR_P20 (0x1u << 20) /*  (PIO_IMR) Input Change Interrupt Mask */
#define PIO_IMR_P21 (0x1u << 21) /*  (PIO_IMR) Input Change Interrupt Mask */
#define PIO_IMR_P22 (0x1u << 22) /*  (PIO_IMR) Input Change Interrupt Mask */
#define PIO_IMR_P23 (0x1u << 23) /*  (PIO_IMR) Input Change Interrupt Mask */
#define PIO_IMR_P24 (0x1u << 24) /*  (PIO_IMR) Input Change Interrupt Mask */
#define PIO_IMR_P25 (0x1u << 25) /*  (PIO_IMR) Input Change Interrupt Mask */
#define PIO_IMR_P26 (0x1u << 26) /*  (PIO_IMR) Input Change Interrupt Mask */
#define PIO_IMR_P27 (0x1u << 27) /*  (PIO_IMR) Input Change Interrupt Mask */
#define PIO_IMR_P28 (0x1u << 28) /*  (PIO_IMR) Input Change Interrupt Mask */
#define PIO_IMR_P29 (0x1u << 29) /*  (PIO_IMR) Input Change Interrupt Mask */
#define PIO_IMR_P30 (0x1u << 30) /*  (PIO_IMR) Input Change Interrupt Mask */
#define PIO_IMR_P31 (0x1u << 31) /*  (PIO_IMR) Input Change Interrupt Mask */
/* -------- PIO_ISR : (PIO Offset: 0x004C) Interrupt Status Register -------- */
#define PIO_ISR_P0 (0x1u << 0) /*  (PIO_ISR) Input Change Interrupt Status */
#define PIO_ISR_P1 (0x1u << 1) /*  (PIO_ISR) Input Change Interrupt Status */
#define PIO_ISR_P2 (0x1u << 2) /*  (PIO_ISR) Input Change Interrupt Status */
#define PIO_ISR_P3 (0x1u << 3) /*  (PIO_ISR) Input Change Interrupt Status */
#define PIO_ISR_P4 (0x1u << 4) /*  (PIO_ISR) Input Change Interrupt Status */
#define PIO_ISR_P5 (0x1u << 5) /*  (PIO_ISR) Input Change Interrupt Status */
#define PIO_ISR_P6 (0x1u << 6) /*  (PIO_ISR) Input Change Interrupt Status */
#define PIO_ISR_P7 (0x1u << 7) /*  (PIO_ISR) Input Change Interrupt Status */
#define PIO_ISR_P8 (0x1u << 8) /*  (PIO_ISR) Input Change Interrupt Status */
#define PIO_ISR_P9 (0x1u << 9) /*  (PIO_ISR) Input Change Interrupt Status */
#define PIO_ISR_P10 (0x1u << 10) /*  (PIO_ISR) Input Change Interrupt Status */
#define PIO_ISR_P11 (0x1u << 11) /*  (PIO_ISR) Input Change Interrupt Status */
#define PIO_ISR_P12 (0x1u << 12) /*  (PIO_ISR) Input Change Interrupt Status */
#define PIO_ISR_P13 (0x1u << 13) /*  (PIO_ISR) Input Change Interrupt Status */
#define PIO_ISR_P14 (0x1u << 14) /*  (PIO_ISR) Input Change Interrupt Status */
#define PIO_ISR_P15 (0x1u << 15) /*  (PIO_ISR) Input Change Interrupt Status */
#define PIO_ISR_P16 (0x1u << 16) /*  (PIO_ISR) Input Change Interrupt Status */
#define PIO_ISR_P17 (0x1u << 17) /*  (PIO_ISR) Input Change Interrupt Status */
#define PIO_ISR_P18 (0x1u << 18) /*  (PIO_ISR) Input Change Interrupt Status */
#define PIO_ISR_P19 (0x1u << 19) /*  (PIO_ISR) Input Change Interrupt Status */
#define PIO_ISR_P20 (0x1u << 20) /*  (PIO_ISR) Input Change Interrupt Status */
#define PIO_ISR_P21 (0x1u << 21) /*  (PIO_ISR) Input Change Interrupt Status */
#define PIO_ISR_P22 (0x1u << 22) /*  (PIO_ISR) Input Change Interrupt Status */
#define PIO_ISR_P23 (0x1u << 23) /*  (PIO_ISR) Input Change Interrupt Status */
#define PIO_ISR_P24 (0x1u << 24) /*  (PIO_ISR) Input Change Interrupt Status */
#define PIO_ISR_P25 (0x1u << 25) /*  (PIO_ISR) Input Change Interrupt Status */
#define PIO_ISR_P26 (0x1u << 26) /*  (PIO_ISR) Input Change Interrupt Status */
#define PIO_ISR_P27 (0x1u << 27) /*  (PIO_ISR) Input Change Interrupt Status */
#define PIO_ISR_P28 (0x1u << 28) /*  (PIO_ISR) Input Change Interrupt Status */
#define PIO_ISR_P29 (0x1u << 29) /*  (PIO_ISR) Input Change Interrupt Status */
#define PIO_ISR_P30 (0x1u << 30) /*  (PIO_ISR) Input Change Interrupt Status */
#define PIO_ISR_P31 (0x1u << 31) /*  (PIO_ISR) Input Change Interrupt Status */
/* -------- PIO_MDER : (PIO Offset: 0x0050) Multi-driver Enable Register -------- */
#define PIO_MDER_P0 (0x1u << 0) /*  (PIO_MDER) Multi Drive Enable. */
#define PIO_MDER_P1 (0x1u << 1) /*  (PIO_MDER) Multi Drive Enable. */
#define PIO_MDER_P2 (0x1u << 2) /*  (PIO_MDER) Multi Drive Enable. */
#define PIO_MDER_P3 (0x1u << 3) /*  (PIO_MDER) Multi Drive Enable. */
#define PIO_MDER_P4 (0x1u << 4) /*  (PIO_MDER) Multi Drive Enable. */
#define PIO_MDER_P5 (0x1u << 5) /*  (PIO_MDER) Multi Drive Enable. */
#define PIO_MDER_P6 (0x1u << 6) /*  (PIO_MDER) Multi Drive Enable. */
#define PIO_MDER_P7 (0x1u << 7) /*  (PIO_MDER) Multi Drive Enable. */
#define PIO_MDER_P8 (0x1u << 8) /*  (PIO_MDER) Multi Drive Enable. */
#define PIO_MDER_P9 (0x1u << 9) /*  (PIO_MDER) Multi Drive Enable. */
#define PIO_MDER_P10 (0x1u << 10) /*  (PIO_MDER) Multi Drive Enable. */
#define PIO_MDER_P11 (0x1u << 11) /*  (PIO_MDER) Multi Drive Enable. */
#define PIO_MDER_P12 (0x1u << 12) /*  (PIO_MDER) Multi Drive Enable. */
#define PIO_MDER_P13 (0x1u << 13) /*  (PIO_MDER) Multi Drive Enable. */
#define PIO_MDER_P14 (0x1u << 14) /*  (PIO_MDER) Multi Drive Enable. */
#define PIO_MDER_P15 (0x1u << 15) /*  (PIO_MDER) Multi Drive Enable. */
#define PIO_MDER_P16 (0x1u << 16) /*  (PIO_MDER) Multi Drive Enable. */
#define PIO_MDER_P17 (0x1u << 17) /*  (PIO_MDER) Multi Drive Enable. */
#define PIO_MDER_P18 (0x1u << 18) /*  (PIO_MDER) Multi Drive Enable. */
#define PIO_MDER_P19 (0x1u << 19) /*  (PIO_MDER) Multi Drive Enable. */
#define PIO_MDER_P20 (0x1u << 20) /*  (PIO_MDER) Multi Drive Enable. */
#define PIO_MDER_P21 (0x1u << 21) /*  (PIO_MDER) Multi Drive Enable. */
#define PIO_MDER_P22 (0x1u << 22) /*  (PIO_MDER) Multi Drive Enable. */
#define PIO_MDER_P23 (0x1u << 23) /*  (PIO_MDER) Multi Drive Enable. */
#define PIO_MDER_P24 (0x1u << 24) /*  (PIO_MDER) Multi Drive Enable. */
#define PIO_MDER_P25 (0x1u << 25) /*  (PIO_MDER) Multi Drive Enable. */
#define PIO_MDER_P26 (0x1u << 26) /*  (PIO_MDER) Multi Drive Enable. */
#define PIO_MDER_P27 (0x1u << 27) /*  (PIO_MDER) Multi Drive Enable. */
#define PIO_MDER_P28 (0x1u << 28) /*  (PIO_MDER) Multi Drive Enable. */
#define PIO_MDER_P29 (0x1u << 29) /*  (PIO_MDER) Multi Drive Enable. */
#define PIO_MDER_P30 (0x1u << 30) /*  (PIO_MDER) Multi Drive Enable. */
#define PIO_MDER_P31 (0x1u << 31) /*  (PIO_MDER) Multi Drive Enable. */
/* -------- PIO_MDDR : (PIO Offset: 0x0054) Multi-driver Disable Register -------- */
#define PIO_MDDR_P0 (0x1u << 0) /*  (PIO_MDDR) Multi Drive Disable. */
#define PIO_MDDR_P1 (0x1u << 1) /*  (PIO_MDDR) Multi Drive Disable. */
#define PIO_MDDR_P2 (0x1u << 2) /*  (PIO_MDDR) Multi Drive Disable. */
#define PIO_MDDR_P3 (0x1u << 3) /*  (PIO_MDDR) Multi Drive Disable. */
#define PIO_MDDR_P4 (0x1u << 4) /*  (PIO_MDDR) Multi Drive Disable. */
#define PIO_MDDR_P5 (0x1u << 5) /*  (PIO_MDDR) Multi Drive Disable. */
#define PIO_MDDR_P6 (0x1u << 6) /*  (PIO_MDDR) Multi Drive Disable. */
#define PIO_MDDR_P7 (0x1u << 7) /*  (PIO_MDDR) Multi Drive Disable. */
#define PIO_MDDR_P8 (0x1u << 8) /*  (PIO_MDDR) Multi Drive Disable. */
#define PIO_MDDR_P9 (0x1u << 9) /*  (PIO_MDDR) Multi Drive Disable. */
#define PIO_MDDR_P10 (0x1u << 10) /*  (PIO_MDDR) Multi Drive Disable. */
#define PIO_MDDR_P11 (0x1u << 11) /*  (PIO_MDDR) Multi Drive Disable. */
#define PIO_MDDR_P12 (0x1u << 12) /*  (PIO_MDDR) Multi Drive Disable. */
#define PIO_MDDR_P13 (0x1u << 13) /*  (PIO_MDDR) Multi Drive Disable. */
#define PIO_MDDR_P14 (0x1u << 14) /*  (PIO_MDDR) Multi Drive Disable. */
#define PIO_MDDR_P15 (0x1u << 15) /*  (PIO_MDDR) Multi Drive Disable. */
#define PIO_MDDR_P16 (0x1u << 16) /*  (PIO_MDDR) Multi Drive Disable. */
#define PIO_MDDR_P17 (0x1u << 17) /*  (PIO_MDDR) Multi Drive Disable. */
#define PIO_MDDR_P18 (0x1u << 18) /*  (PIO_MDDR) Multi Drive Disable. */
#define PIO_MDDR_P19 (0x1u << 19) /*  (PIO_MDDR) Multi Drive Disable. */
#define PIO_MDDR_P20 (0x1u << 20) /*  (PIO_MDDR) Multi Drive Disable. */
#define PIO_MDDR_P21 (0x1u << 21) /*  (PIO_MDDR) Multi Drive Disable. */
#define PIO_MDDR_P22 (0x1u << 22) /*  (PIO_MDDR) Multi Drive Disable. */
#define PIO_MDDR_P23 (0x1u << 23) /*  (PIO_MDDR) Multi Drive Disable. */
#define PIO_MDDR_P24 (0x1u << 24) /*  (PIO_MDDR) Multi Drive Disable. */
#define PIO_MDDR_P25 (0x1u << 25) /*  (PIO_MDDR) Multi Drive Disable. */
#define PIO_MDDR_P26 (0x1u << 26) /*  (PIO_MDDR) Multi Drive Disable. */
#define PIO_MDDR_P27 (0x1u << 27) /*  (PIO_MDDR) Multi Drive Disable. */
#define PIO_MDDR_P28 (0x1u << 28) /*  (PIO_MDDR) Multi Drive Disable. */
#define PIO_MDDR_P29 (0x1u << 29) /*  (PIO_MDDR) Multi Drive Disable. */
#define PIO_MDDR_P30 (0x1u << 30) /*  (PIO_MDDR) Multi Drive Disable. */
#define PIO_MDDR_P31 (0x1u << 31) /*  (PIO_MDDR) Multi Drive Disable. */
/* -------- PIO_MDSR : (PIO Offset: 0x0058) Multi-driver Status Register -------- */
#define PIO_MDSR_P0 (0x1u << 0) /*  (PIO_MDSR) Multi Drive Status. */
#define PIO_MDSR_P1 (0x1u << 1) /*  (PIO_MDSR) Multi Drive Status. */
#define PIO_MDSR_P2 (0x1u << 2) /*  (PIO_MDSR) Multi Drive Status. */
#define PIO_MDSR_P3 (0x1u << 3) /*  (PIO_MDSR) Multi Drive Status. */
#define PIO_MDSR_P4 (0x1u << 4) /*  (PIO_MDSR) Multi Drive Status. */
#define PIO_MDSR_P5 (0x1u << 5) /*  (PIO_MDSR) Multi Drive Status. */
#define PIO_MDSR_P6 (0x1u << 6) /*  (PIO_MDSR) Multi Drive Status. */
#define PIO_MDSR_P7 (0x1u << 7) /*  (PIO_MDSR) Multi Drive Status. */
#define PIO_MDSR_P8 (0x1u << 8) /*  (PIO_MDSR) Multi Drive Status. */
#define PIO_MDSR_P9 (0x1u << 9) /*  (PIO_MDSR) Multi Drive Status. */
#define PIO_MDSR_P10 (0x1u << 10) /*  (PIO_MDSR) Multi Drive Status. */
#define PIO_MDSR_P11 (0x1u << 11) /*  (PIO_MDSR) Multi Drive Status. */
#define PIO_MDSR_P12 (0x1u << 12) /*  (PIO_MDSR) Multi Drive Status. */
#define PIO_MDSR_P13 (0x1u << 13) /*  (PIO_MDSR) Multi Drive Status. */
#define PIO_MDSR_P14 (0x1u << 14) /*  (PIO_MDSR) Multi Drive Status. */
#define PIO_MDSR_P15 (0x1u << 15) /*  (PIO_MDSR) Multi Drive Status. */
#define PIO_MDSR_P16 (0x1u << 16) /*  (PIO_MDSR) Multi Drive Status. */
#define PIO_MDSR_P17 (0x1u << 17) /*  (PIO_MDSR) Multi Drive Status. */
#define PIO_MDSR_P18 (0x1u << 18) /*  (PIO_MDSR) Multi Drive Status. */
#define PIO_MDSR_P19 (0x1u << 19) /*  (PIO_MDSR) Multi Drive Status. */
#define PIO_MDSR_P20 (0x1u << 20) /*  (PIO_MDSR) Multi Drive Status. */
#define PIO_MDSR_P21 (0x1u << 21) /*  (PIO_MDSR) Multi Drive Status. */
#define PIO_MDSR_P22 (0x1u << 22) /*  (PIO_MDSR) Multi Drive Status. */
#define PIO_MDSR_P23 (0x1u << 23) /*  (PIO_MDSR) Multi Drive Status. */
#define PIO_MDSR_P24 (0x1u << 24) /*  (PIO_MDSR) Multi Drive Status. */
#define PIO_MDSR_P25 (0x1u << 25) /*  (PIO_MDSR) Multi Drive Status. */
#define PIO_MDSR_P26 (0x1u << 26) /*  (PIO_MDSR) Multi Drive Status. */
#define PIO_MDSR_P27 (0x1u << 27) /*  (PIO_MDSR) Multi Drive Status. */
#define PIO_MDSR_P28 (0x1u << 28) /*  (PIO_MDSR) Multi Drive Status. */
#define PIO_MDSR_P29 (0x1u << 29) /*  (PIO_MDSR) Multi Drive Status. */
#define PIO_MDSR_P30 (0x1u << 30) /*  (PIO_MDSR) Multi Drive Status. */
#define PIO_MDSR_P31 (0x1u << 31) /*  (PIO_MDSR) Multi Drive Status. */
/* -------- PIO_PUDR : (PIO Offset: 0x0060) Pull-up Disable Register -------- */
#define PIO_PUDR_P0 (0x1u << 0) /*  (PIO_PUDR) Pull Up Disable. */
#define PIO_PUDR_P1 (0x1u << 1) /*  (PIO_PUDR) Pull Up Disable. */
#define PIO_PUDR_P2 (0x1u << 2) /*  (PIO_PUDR) Pull Up Disable. */
#define PIO_PUDR_P3 (0x1u << 3) /*  (PIO_PUDR) Pull Up Disable. */
#define PIO_PUDR_P4 (0x1u << 4) /*  (PIO_PUDR) Pull Up Disable. */
#define PIO_PUDR_P5 (0x1u << 5) /*  (PIO_PUDR) Pull Up Disable. */
#define PIO_PUDR_P6 (0x1u << 6) /*  (PIO_PUDR) Pull Up Disable. */
#define PIO_PUDR_P7 (0x1u << 7) /*  (PIO_PUDR) Pull Up Disable. */
#define PIO_PUDR_P8 (0x1u << 8) /*  (PIO_PUDR) Pull Up Disable. */
#define PIO_PUDR_P9 (0x1u << 9) /*  (PIO_PUDR) Pull Up Disable. */
#define PIO_PUDR_P10 (0x1u << 10) /*  (PIO_PUDR) Pull Up Disable. */
#define PIO_PUDR_P11 (0x1u << 11) /*  (PIO_PUDR) Pull Up Disable. */
#define PIO_PUDR_P12 (0x1u << 12) /*  (PIO_PUDR) Pull Up Disable. */
#define PIO_PUDR_P13 (0x1u << 13) /*  (PIO_PUDR) Pull Up Disable. */
#define PIO_PUDR_P14 (0x1u << 14) /*  (PIO_PUDR) Pull Up Disable. */
#define PIO_PUDR_P15 (0x1u << 15) /*  (PIO_PUDR) Pull Up Disable. */
#define PIO_PUDR_P16 (0x1u << 16) /*  (PIO_PUDR) Pull Up Disable. */
#define PIO_PUDR_P17 (0x1u << 17) /*  (PIO_PUDR) Pull Up Disable. */
#define PIO_PUDR_P18 (0x1u << 18) /*  (PIO_PUDR) Pull Up Disable. */
#define PIO_PUDR_P19 (0x1u << 19) /*  (PIO_PUDR) Pull Up Disable. */
#define PIO_PUDR_P20 (0x1u << 20) /*  (PIO_PUDR) Pull Up Disable. */
#define PIO_PUDR_P21 (0x1u << 21) /*  (PIO_PUDR) Pull Up Disable. */
#define PIO_PUDR_P22 (0x1u << 22) /*  (PIO_PUDR) Pull Up Disable. */
#define PIO_PUDR_P23 (0x1u << 23) /*  (PIO_PUDR) Pull Up Disable. */
#define PIO_PUDR_P24 (0x1u << 24) /*  (PIO_PUDR) Pull Up Disable. */
#define PIO_PUDR_P25 (0x1u << 25) /*  (PIO_PUDR) Pull Up Disable. */
#define PIO_PUDR_P26 (0x1u << 26) /*  (PIO_PUDR) Pull Up Disable. */
#define PIO_PUDR_P27 (0x1u << 27) /*  (PIO_PUDR) Pull Up Disable. */
#define PIO_PUDR_P28 (0x1u << 28) /*  (PIO_PUDR) Pull Up Disable. */
#define PIO_PUDR_P29 (0x1u << 29) /*  (PIO_PUDR) Pull Up Disable. */
#define PIO_PUDR_P30 (0x1u << 30) /*  (PIO_PUDR) Pull Up Disable. */
#define PIO_PUDR_P31 (0x1u << 31) /*  (PIO_PUDR) Pull Up Disable. */
/* -------- PIO_PUER : (PIO Offset: 0x0064) Pull-up Enable Register -------- */
#define PIO_PUER_P0 (0x1u << 0) /*  (PIO_PUER) Pull Up Enable. */
#define PIO_PUER_P1 (0x1u << 1) /*  (PIO_PUER) Pull Up Enable. */
#define PIO_PUER_P2 (0x1u << 2) /*  (PIO_PUER) Pull Up Enable. */
#define PIO_PUER_P3 (0x1u << 3) /*  (PIO_PUER) Pull Up Enable. */
#define PIO_PUER_P4 (0x1u << 4) /*  (PIO_PUER) Pull Up Enable. */
#define PIO_PUER_P5 (0x1u << 5) /*  (PIO_PUER) Pull Up Enable. */
#define PIO_PUER_P6 (0x1u << 6) /*  (PIO_PUER) Pull Up Enable. */
#define PIO_PUER_P7 (0x1u << 7) /*  (PIO_PUER) Pull Up Enable. */
#define PIO_PUER_P8 (0x1u << 8) /*  (PIO_PUER) Pull Up Enable. */
#define PIO_PUER_P9 (0x1u << 9) /*  (PIO_PUER) Pull Up Enable. */
#define PIO_PUER_P10 (0x1u << 10) /*  (PIO_PUER) Pull Up Enable. */
#define PIO_PUER_P11 (0x1u << 11) /*  (PIO_PUER) Pull Up Enable. */
#define PIO_PUER_P12 (0x1u << 12) /*  (PIO_PUER) Pull Up Enable. */
#define PIO_PUER_P13 (0x1u << 13) /*  (PIO_PUER) Pull Up Enable. */
#define PIO_PUER_P14 (0x1u << 14) /*  (PIO_PUER) Pull Up Enable. */
#define PIO_PUER_P15 (0x1u << 15) /*  (PIO_PUER) Pull Up Enable. */
#define PIO_PUER_P16 (0x1u << 16) /*  (PIO_PUER) Pull Up Enable. */
#define PIO_PUER_P17 (0x1u << 17) /*  (PIO_PUER) Pull Up Enable. */
#define PIO_PUER_P18 (0x1u << 18) /*  (PIO_PUER) Pull Up Enable. */
#define PIO_PUER_P19 (0x1u << 19) /*  (PIO_PUER) Pull Up Enable. */
#define PIO_PUER_P20 (0x1u << 20) /*  (PIO_PUER) Pull Up Enable. */
#define PIO_PUER_P21 (0x1u << 21) /*  (PIO_PUER) Pull Up Enable. */
#define PIO_PUER_P22 (0x1u << 22) /*  (PIO_PUER) Pull Up Enable. */
#define PIO_PUER_P23 (0x1u << 23) /*  (PIO_PUER) Pull Up Enable. */
#define PIO_PUER_P24 (0x1u << 24) /*  (PIO_PUER) Pull Up Enable. */
#define PIO_PUER_P25 (0x1u << 25) /*  (PIO_PUER) Pull Up Enable. */
#define PIO_PUER_P26 (0x1u << 26) /*  (PIO_PUER) Pull Up Enable. */
#define PIO_PUER_P27 (0x1u << 27) /*  (PIO_PUER) Pull Up Enable. */
#define PIO_PUER_P28 (0x1u << 28) /*  (PIO_PUER) Pull Up Enable. */
#define PIO_PUER_P29 (0x1u << 29) /*  (PIO_PUER) Pull Up Enable. */
#define PIO_PUER_P30 (0x1u << 30) /*  (PIO_PUER) Pull Up Enable. */
#define PIO_PUER_P31 (0x1u << 31) /*  (PIO_PUER) Pull Up Enable. */
/* -------- PIO_PUSR : (PIO Offset: 0x0068) Pad Pull-up Status Register -------- */
#define PIO_PUSR_P0 (0x1u << 0) /*  (PIO_PUSR) Pull Up Status. */
#define PIO_PUSR_P1 (0x1u << 1) /*  (PIO_PUSR) Pull Up Status. */
#define PIO_PUSR_P2 (0x1u << 2) /*  (PIO_PUSR) Pull Up Status. */
#define PIO_PUSR_P3 (0x1u << 3) /*  (PIO_PUSR) Pull Up Status. */
#define PIO_PUSR_P4 (0x1u << 4) /*  (PIO_PUSR) Pull Up Status. */
#define PIO_PUSR_P5 (0x1u << 5) /*  (PIO_PUSR) Pull Up Status. */
#define PIO_PUSR_P6 (0x1u << 6) /*  (PIO_PUSR) Pull Up Status. */
#define PIO_PUSR_P7 (0x1u << 7) /*  (PIO_PUSR) Pull Up Status. */
#define PIO_PUSR_P8 (0x1u << 8) /*  (PIO_PUSR) Pull Up Status. */
#define PIO_PUSR_P9 (0x1u << 9) /*  (PIO_PUSR) Pull Up Status. */
#define PIO_PUSR_P10 (0x1u << 10) /*  (PIO_PUSR) Pull Up Status. */
#define PIO_PUSR_P11 (0x1u << 11) /*  (PIO_PUSR) Pull Up Status. */
#define PIO_PUSR_P12 (0x1u << 12) /*  (PIO_PUSR) Pull Up Status. */
#define PIO_PUSR_P13 (0x1u << 13) /*  (PIO_PUSR) Pull Up Status. */
#define PIO_PUSR_P14 (0x1u << 14) /*  (PIO_PUSR) Pull Up Status. */
#define PIO_PUSR_P15 (0x1u << 15) /*  (PIO_PUSR) Pull Up Status. */
#define PIO_PUSR_P16 (0x1u << 16) /*  (PIO_PUSR) Pull Up Status. */
#define PIO_PUSR_P17 (0x1u << 17) /*  (PIO_PUSR) Pull Up Status. */
#define PIO_PUSR_P18 (0x1u << 18) /*  (PIO_PUSR) Pull Up Status. */
#define PIO_PUSR_P19 (0x1u << 19) /*  (PIO_PUSR) Pull Up Status. */
#define PIO_PUSR_P20 (0x1u << 20) /*  (PIO_PUSR) Pull Up Status. */
#define PIO_PUSR_P21 (0x1u << 21) /*  (PIO_PUSR) Pull Up Status. */
#define PIO_PUSR_P22 (0x1u << 22) /*  (PIO_PUSR) Pull Up Status. */
#define PIO_PUSR_P23 (0x1u << 23) /*  (PIO_PUSR) Pull Up Status. */
#define PIO_PUSR_P24 (0x1u << 24) /*  (PIO_PUSR) Pull Up Status. */
#define PIO_PUSR_P25 (0x1u << 25) /*  (PIO_PUSR) Pull Up Status. */
#define PIO_PUSR_P26 (0x1u << 26) /*  (PIO_PUSR) Pull Up Status. */
#define PIO_PUSR_P27 (0x1u << 27) /*  (PIO_PUSR) Pull Up Status. */
#define PIO_PUSR_P28 (0x1u << 28) /*  (PIO_PUSR) Pull Up Status. */
#define PIO_PUSR_P29 (0x1u << 29) /*  (PIO_PUSR) Pull Up Status. */
#define PIO_PUSR_P30 (0x1u << 30) /*  (PIO_PUSR) Pull Up Status. */
#define PIO_PUSR_P31 (0x1u << 31) /*  (PIO_PUSR) Pull Up Status. */
/* -------- PIO_ABCDSR[2] : (PIO Offset: 0x0070) Peripheral Select Register -------- */
#define PIO_ABCDSR_P0 (0x1u << 0) /*  (PIO_ABCDSR[2]) Peripheral Select. */
#define PIO_ABCDSR_P1 (0x1u << 1) /*  (PIO_ABCDSR[2]) Peripheral Select. */
#define PIO_ABCDSR_P2 (0x1u << 2) /*  (PIO_ABCDSR[2]) Peripheral Select. */
#define PIO_ABCDSR_P3 (0x1u << 3) /*  (PIO_ABCDSR[2]) Peripheral Select. */
#define PIO_ABCDSR_P4 (0x1u << 4) /*  (PIO_ABCDSR[2]) Peripheral Select. */
#define PIO_ABCDSR_P5 (0x1u << 5) /*  (PIO_ABCDSR[2]) Peripheral Select. */
#define PIO_ABCDSR_P6 (0x1u << 6) /*  (PIO_ABCDSR[2]) Peripheral Select. */
#define PIO_ABCDSR_P7 (0x1u << 7) /*  (PIO_ABCDSR[2]) Peripheral Select. */
#define PIO_ABCDSR_P8 (0x1u << 8) /*  (PIO_ABCDSR[2]) Peripheral Select. */
#define PIO_ABCDSR_P9 (0x1u << 9) /*  (PIO_ABCDSR[2]) Peripheral Select. */
#define PIO_ABCDSR_P10 (0x1u << 10) /*  (PIO_ABCDSR[2]) Peripheral Select. */
#define PIO_ABCDSR_P11 (0x1u << 11) /*  (PIO_ABCDSR[2]) Peripheral Select. */
#define PIO_ABCDSR_P12 (0x1u << 12) /*  (PIO_ABCDSR[2]) Peripheral Select. */
#define PIO_ABCDSR_P13 (0x1u << 13) /*  (PIO_ABCDSR[2]) Peripheral Select. */
#define PIO_ABCDSR_P14 (0x1u << 14) /*  (PIO_ABCDSR[2]) Peripheral Select. */
#define PIO_ABCDSR_P15 (0x1u << 15) /*  (PIO_ABCDSR[2]) Peripheral Select. */
#define PIO_ABCDSR_P16 (0x1u << 16) /*  (PIO_ABCDSR[2]) Peripheral Select. */
#define PIO_ABCDSR_P17 (0x1u << 17) /*  (PIO_ABCDSR[2]) Peripheral Select. */
#define PIO_ABCDSR_P18 (0x1u << 18) /*  (PIO_ABCDSR[2]) Peripheral Select. */
#define PIO_ABCDSR_P19 (0x1u << 19) /*  (PIO_ABCDSR[2]) Peripheral Select. */
#define PIO_ABCDSR_P20 (0x1u << 20) /*  (PIO_ABCDSR[2]) Peripheral Select. */
#define PIO_ABCDSR_P21 (0x1u << 21) /*  (PIO_ABCDSR[2]) Peripheral Select. */
#define PIO_ABCDSR_P22 (0x1u << 22) /*  (PIO_ABCDSR[2]) Peripheral Select. */
#define PIO_ABCDSR_P23 (0x1u << 23) /*  (PIO_ABCDSR[2]) Peripheral Select. */
#define PIO_ABCDSR_P24 (0x1u << 24) /*  (PIO_ABCDSR[2]) Peripheral Select. */
#define PIO_ABCDSR_P25 (0x1u << 25) /*  (PIO_ABCDSR[2]) Peripheral Select. */
#define PIO_ABCDSR_P26 (0x1u << 26) /*  (PIO_ABCDSR[2]) Peripheral Select. */
#define PIO_ABCDSR_P27 (0x1u << 27) /*  (PIO_ABCDSR[2]) Peripheral Select. */
#define PIO_ABCDSR_P28 (0x1u << 28) /*  (PIO_ABCDSR[2]) Peripheral Select. */
#define PIO_ABCDSR_P29 (0x1u << 29) /*  (PIO_ABCDSR[2]) Peripheral Select. */
#define PIO_ABCDSR_P30 (0x1u << 30) /*  (PIO_ABCDSR[2]) Peripheral Select. */
#define PIO_ABCDSR_P31 (0x1u << 31) /*  (PIO_ABCDSR[2]) Peripheral Select. */
/* -------- PIO_IFSCDR : (PIO Offset: 0x0080) Input Filter Slow Clock Disable Register -------- */
#define PIO_IFSCDR_P0 (0x1u << 0) /*  (PIO_IFSCDR) PIO Clock Glitch Filtering Select. */
#define PIO_IFSCDR_P1 (0x1u << 1) /*  (PIO_IFSCDR) PIO Clock Glitch Filtering Select. */
#define PIO_IFSCDR_P2 (0x1u << 2) /*  (PIO_IFSCDR) PIO Clock Glitch Filtering Select. */
#define PIO_IFSCDR_P3 (0x1u << 3) /*  (PIO_IFSCDR) PIO Clock Glitch Filtering Select. */
#define PIO_IFSCDR_P4 (0x1u << 4) /*  (PIO_IFSCDR) PIO Clock Glitch Filtering Select. */
#define PIO_IFSCDR_P5 (0x1u << 5) /*  (PIO_IFSCDR) PIO Clock Glitch Filtering Select. */
#define PIO_IFSCDR_P6 (0x1u << 6) /*  (PIO_IFSCDR) PIO Clock Glitch Filtering Select. */
#define PIO_IFSCDR_P7 (0x1u << 7) /*  (PIO_IFSCDR) PIO Clock Glitch Filtering Select. */
#define PIO_IFSCDR_P8 (0x1u << 8) /*  (PIO_IFSCDR) PIO Clock Glitch Filtering Select. */
#define PIO_IFSCDR_P9 (0x1u << 9) /*  (PIO_IFSCDR) PIO Clock Glitch Filtering Select. */
#define PIO_IFSCDR_P10 (0x1u << 10) /*  (PIO_IFSCDR) PIO Clock Glitch Filtering Select. */
#define PIO_IFSCDR_P11 (0x1u << 11) /*  (PIO_IFSCDR) PIO Clock Glitch Filtering Select. */
#define PIO_IFSCDR_P12 (0x1u << 12) /*  (PIO_IFSCDR) PIO Clock Glitch Filtering Select. */
#define PIO_IFSCDR_P13 (0x1u << 13) /*  (PIO_IFSCDR) PIO Clock Glitch Filtering Select. */
#define PIO_IFSCDR_P14 (0x1u << 14) /*  (PIO_IFSCDR) PIO Clock Glitch Filtering Select. */
#define PIO_IFSCDR_P15 (0x1u << 15) /*  (PIO_IFSCDR) PIO Clock Glitch Filtering Select. */
#define PIO_IFSCDR_P16 (0x1u << 16) /*  (PIO_IFSCDR) PIO Clock Glitch Filtering Select. */
#define PIO_IFSCDR_P17 (0x1u << 17) /*  (PIO_IFSCDR) PIO Clock Glitch Filtering Select. */
#define PIO_IFSCDR_P18 (0x1u << 18) /*  (PIO_IFSCDR) PIO Clock Glitch Filtering Select. */
#define PIO_IFSCDR_P19 (0x1u << 19) /*  (PIO_IFSCDR) PIO Clock Glitch Filtering Select. */
#define PIO_IFSCDR_P20 (0x1u << 20) /*  (PIO_IFSCDR) PIO Clock Glitch Filtering Select. */
#define PIO_IFSCDR_P21 (0x1u << 21) /*  (PIO_IFSCDR) PIO Clock Glitch Filtering Select. */
#define PIO_IFSCDR_P22 (0x1u << 22) /*  (PIO_IFSCDR) PIO Clock Glitch Filtering Select. */
#define PIO_IFSCDR_P23 (0x1u << 23) /*  (PIO_IFSCDR) PIO Clock Glitch Filtering Select. */
#define PIO_IFSCDR_P24 (0x1u << 24) /*  (PIO_IFSCDR) PIO Clock Glitch Filtering Select. */
#define PIO_IFSCDR_P25 (0x1u << 25) /*  (PIO_IFSCDR) PIO Clock Glitch Filtering Select. */
#define PIO_IFSCDR_P26 (0x1u << 26) /*  (PIO_IFSCDR) PIO Clock Glitch Filtering Select. */
#define PIO_IFSCDR_P27 (0x1u << 27) /*  (PIO_IFSCDR) PIO Clock Glitch Filtering Select. */
#define PIO_IFSCDR_P28 (0x1u << 28) /*  (PIO_IFSCDR) PIO Clock Glitch Filtering Select. */
#define PIO_IFSCDR_P29 (0x1u << 29) /*  (PIO_IFSCDR) PIO Clock Glitch Filtering Select. */
#define PIO_IFSCDR_P30 (0x1u << 30) /*  (PIO_IFSCDR) PIO Clock Glitch Filtering Select. */
#define PIO_IFSCDR_P31 (0x1u << 31) /*  (PIO_IFSCDR) PIO Clock Glitch Filtering Select. */
/* -------- PIO_IFSCER : (PIO Offset: 0x0084) Input Filter Slow Clock Enable Register -------- */
#define PIO_IFSCER_P0 (0x1u << 0) /*  (PIO_IFSCER) Debouncing Filtering Select. */
#define PIO_IFSCER_P1 (0x1u << 1) /*  (PIO_IFSCER) Debouncing Filtering Select. */
#define PIO_IFSCER_P2 (0x1u << 2) /*  (PIO_IFSCER) Debouncing Filtering Select. */
#define PIO_IFSCER_P3 (0x1u << 3) /*  (PIO_IFSCER) Debouncing Filtering Select. */
#define PIO_IFSCER_P4 (0x1u << 4) /*  (PIO_IFSCER) Debouncing Filtering Select. */
#define PIO_IFSCER_P5 (0x1u << 5) /*  (PIO_IFSCER) Debouncing Filtering Select. */
#define PIO_IFSCER_P6 (0x1u << 6) /*  (PIO_IFSCER) Debouncing Filtering Select. */
#define PIO_IFSCER_P7 (0x1u << 7) /*  (PIO_IFSCER) Debouncing Filtering Select. */
#define PIO_IFSCER_P8 (0x1u << 8) /*  (PIO_IFSCER) Debouncing Filtering Select. */
#define PIO_IFSCER_P9 (0x1u << 9) /*  (PIO_IFSCER) Debouncing Filtering Select. */
#define PIO_IFSCER_P10 (0x1u << 10) /*  (PIO_IFSCER) Debouncing Filtering Select. */
#define PIO_IFSCER_P11 (0x1u << 11) /*  (PIO_IFSCER) Debouncing Filtering Select. */
#define PIO_IFSCER_P12 (0x1u << 12) /*  (PIO_IFSCER) Debouncing Filtering Select. */
#define PIO_IFSCER_P13 (0x1u << 13) /*  (PIO_IFSCER) Debouncing Filtering Select. */
#define PIO_IFSCER_P14 (0x1u << 14) /*  (PIO_IFSCER) Debouncing Filtering Select. */
#define PIO_IFSCER_P15 (0x1u << 15) /*  (PIO_IFSCER) Debouncing Filtering Select. */
#define PIO_IFSCER_P16 (0x1u << 16) /*  (PIO_IFSCER) Debouncing Filtering Select. */
#define PIO_IFSCER_P17 (0x1u << 17) /*  (PIO_IFSCER) Debouncing Filtering Select. */
#define PIO_IFSCER_P18 (0x1u << 18) /*  (PIO_IFSCER) Debouncing Filtering Select. */
#define PIO_IFSCER_P19 (0x1u << 19) /*  (PIO_IFSCER) Debouncing Filtering Select. */
#define PIO_IFSCER_P20 (0x1u << 20) /*  (PIO_IFSCER) Debouncing Filtering Select. */
#define PIO_IFSCER_P21 (0x1u << 21) /*  (PIO_IFSCER) Debouncing Filtering Select. */
#define PIO_IFSCER_P22 (0x1u << 22) /*  (PIO_IFSCER) Debouncing Filtering Select. */
#define PIO_IFSCER_P23 (0x1u << 23) /*  (PIO_IFSCER) Debouncing Filtering Select. */
#define PIO_IFSCER_P24 (0x1u << 24) /*  (PIO_IFSCER) Debouncing Filtering Select. */
#define PIO_IFSCER_P25 (0x1u << 25) /*  (PIO_IFSCER) Debouncing Filtering Select. */
#define PIO_IFSCER_P26 (0x1u << 26) /*  (PIO_IFSCER) Debouncing Filtering Select. */
#define PIO_IFSCER_P27 (0x1u << 27) /*  (PIO_IFSCER) Debouncing Filtering Select. */
#define PIO_IFSCER_P28 (0x1u << 28) /*  (PIO_IFSCER) Debouncing Filtering Select. */
#define PIO_IFSCER_P29 (0x1u << 29) /*  (PIO_IFSCER) Debouncing Filtering Select. */
#define PIO_IFSCER_P30 (0x1u << 30) /*  (PIO_IFSCER) Debouncing Filtering Select. */
#define PIO_IFSCER_P31 (0x1u << 31) /*  (PIO_IFSCER) Debouncing Filtering Select. */
/* -------- PIO_IFSCSR : (PIO Offset: 0x0088) Input Filter Slow Clock Status Register -------- */
#define PIO_IFSCSR_P0 (0x1u << 0) /*  (PIO_IFSCSR) Glitch or Debouncing Filter Selection Status */
#define PIO_IFSCSR_P1 (0x1u << 1) /*  (PIO_IFSCSR) Glitch or Debouncing Filter Selection Status */
#define PIO_IFSCSR_P2 (0x1u << 2) /*  (PIO_IFSCSR) Glitch or Debouncing Filter Selection Status */
#define PIO_IFSCSR_P3 (0x1u << 3) /*  (PIO_IFSCSR) Glitch or Debouncing Filter Selection Status */
#define PIO_IFSCSR_P4 (0x1u << 4) /*  (PIO_IFSCSR) Glitch or Debouncing Filter Selection Status */
#define PIO_IFSCSR_P5 (0x1u << 5) /*  (PIO_IFSCSR) Glitch or Debouncing Filter Selection Status */
#define PIO_IFSCSR_P6 (0x1u << 6) /*  (PIO_IFSCSR) Glitch or Debouncing Filter Selection Status */
#define PIO_IFSCSR_P7 (0x1u << 7) /*  (PIO_IFSCSR) Glitch or Debouncing Filter Selection Status */
#define PIO_IFSCSR_P8 (0x1u << 8) /*  (PIO_IFSCSR) Glitch or Debouncing Filter Selection Status */
#define PIO_IFSCSR_P9 (0x1u << 9) /*  (PIO_IFSCSR) Glitch or Debouncing Filter Selection Status */
#define PIO_IFSCSR_P10 (0x1u << 10) /*  (PIO_IFSCSR) Glitch or Debouncing Filter Selection Status */
#define PIO_IFSCSR_P11 (0x1u << 11) /*  (PIO_IFSCSR) Glitch or Debouncing Filter Selection Status */
#define PIO_IFSCSR_P12 (0x1u << 12) /*  (PIO_IFSCSR) Glitch or Debouncing Filter Selection Status */
#define PIO_IFSCSR_P13 (0x1u << 13) /*  (PIO_IFSCSR) Glitch or Debouncing Filter Selection Status */
#define PIO_IFSCSR_P14 (0x1u << 14) /*  (PIO_IFSCSR) Glitch or Debouncing Filter Selection Status */
#define PIO_IFSCSR_P15 (0x1u << 15) /*  (PIO_IFSCSR) Glitch or Debouncing Filter Selection Status */
#define PIO_IFSCSR_P16 (0x1u << 16) /*  (PIO_IFSCSR) Glitch or Debouncing Filter Selection Status */
#define PIO_IFSCSR_P17 (0x1u << 17) /*  (PIO_IFSCSR) Glitch or Debouncing Filter Selection Status */
#define PIO_IFSCSR_P18 (0x1u << 18) /*  (PIO_IFSCSR) Glitch or Debouncing Filter Selection Status */
#define PIO_IFSCSR_P19 (0x1u << 19) /*  (PIO_IFSCSR) Glitch or Debouncing Filter Selection Status */
#define PIO_IFSCSR_P20 (0x1u << 20) /*  (PIO_IFSCSR) Glitch or Debouncing Filter Selection Status */
#define PIO_IFSCSR_P21 (0x1u << 21) /*  (PIO_IFSCSR) Glitch or Debouncing Filter Selection Status */
#define PIO_IFSCSR_P22 (0x1u << 22) /*  (PIO_IFSCSR) Glitch or Debouncing Filter Selection Status */
#define PIO_IFSCSR_P23 (0x1u << 23) /*  (PIO_IFSCSR) Glitch or Debouncing Filter Selection Status */
#define PIO_IFSCSR_P24 (0x1u << 24) /*  (PIO_IFSCSR) Glitch or Debouncing Filter Selection Status */
#define PIO_IFSCSR_P25 (0x1u << 25) /*  (PIO_IFSCSR) Glitch or Debouncing Filter Selection Status */
#define PIO_IFSCSR_P26 (0x1u << 26) /*  (PIO_IFSCSR) Glitch or Debouncing Filter Selection Status */
#define PIO_IFSCSR_P27 (0x1u << 27) /*  (PIO_IFSCSR) Glitch or Debouncing Filter Selection Status */
#define PIO_IFSCSR_P28 (0x1u << 28) /*  (PIO_IFSCSR) Glitch or Debouncing Filter Selection Status */
#define PIO_IFSCSR_P29 (0x1u << 29) /*  (PIO_IFSCSR) Glitch or Debouncing Filter Selection Status */
#define PIO_IFSCSR_P30 (0x1u << 30) /*  (PIO_IFSCSR) Glitch or Debouncing Filter Selection Status */
#define PIO_IFSCSR_P31 (0x1u << 31) /*  (PIO_IFSCSR) Glitch or Debouncing Filter Selection Status */
/* -------- PIO_SCDR : (PIO Offset: 0x008C) Slow Clock Divider Debouncing Register -------- */
#define PIO_SCDR_DIV0 (0x1u << 0) /*  (PIO_SCDR) Slow Clock Divider Selection for Debouncing */
#define PIO_SCDR_DIV1 (0x1u << 1) /*  (PIO_SCDR) Slow Clock Divider Selection for Debouncing */
#define PIO_SCDR_DIV2 (0x1u << 2) /*  (PIO_SCDR) Slow Clock Divider Selection for Debouncing */
#define PIO_SCDR_DIV3 (0x1u << 3) /*  (PIO_SCDR) Slow Clock Divider Selection for Debouncing */
#define PIO_SCDR_DIV4 (0x1u << 4) /*  (PIO_SCDR) Slow Clock Divider Selection for Debouncing */
#define PIO_SCDR_DIV5 (0x1u << 5) /*  (PIO_SCDR) Slow Clock Divider Selection for Debouncing */
#define PIO_SCDR_DIV6 (0x1u << 6) /*  (PIO_SCDR) Slow Clock Divider Selection for Debouncing */
#define PIO_SCDR_DIV7 (0x1u << 7) /*  (PIO_SCDR) Slow Clock Divider Selection for Debouncing */
#define PIO_SCDR_DIV8 (0x1u << 8) /*  (PIO_SCDR) Slow Clock Divider Selection for Debouncing */
#define PIO_SCDR_DIV9 (0x1u << 9) /*  (PIO_SCDR) Slow Clock Divider Selection for Debouncing */
#define PIO_SCDR_DIV10 (0x1u << 10) /*  (PIO_SCDR) Slow Clock Divider Selection for Debouncing */
#define PIO_SCDR_DIV11 (0x1u << 11) /*  (PIO_SCDR) Slow Clock Divider Selection for Debouncing */
#define PIO_SCDR_DIV12 (0x1u << 12) /*  (PIO_SCDR) Slow Clock Divider Selection for Debouncing */
#define PIO_SCDR_DIV13 (0x1u << 13) /*  (PIO_SCDR) Slow Clock Divider Selection for Debouncing */
/* -------- PIO_PPDDR : (PIO Offset: 0x0090) Pad Pull-down Disable Register -------- */
#define PIO_PPDDR_P0 (0x1u << 0) /*  (PIO_PPDDR) Pull Down Disable. */
#define PIO_PPDDR_P1 (0x1u << 1) /*  (PIO_PPDDR) Pull Down Disable. */
#define PIO_PPDDR_P2 (0x1u << 2) /*  (PIO_PPDDR) Pull Down Disable. */
#define PIO_PPDDR_P3 (0x1u << 3) /*  (PIO_PPDDR) Pull Down Disable. */
#define PIO_PPDDR_P4 (0x1u << 4) /*  (PIO_PPDDR) Pull Down Disable. */
#define PIO_PPDDR_P5 (0x1u << 5) /*  (PIO_PPDDR) Pull Down Disable. */
#define PIO_PPDDR_P6 (0x1u << 6) /*  (PIO_PPDDR) Pull Down Disable. */
#define PIO_PPDDR_P7 (0x1u << 7) /*  (PIO_PPDDR) Pull Down Disable. */
#define PIO_PPDDR_P8 (0x1u << 8) /*  (PIO_PPDDR) Pull Down Disable. */
#define PIO_PPDDR_P9 (0x1u << 9) /*  (PIO_PPDDR) Pull Down Disable. */
#define PIO_PPDDR_P10 (0x1u << 10) /*  (PIO_PPDDR) Pull Down Disable. */
#define PIO_PPDDR_P11 (0x1u << 11) /*  (PIO_PPDDR) Pull Down Disable. */
#define PIO_PPDDR_P12 (0x1u << 12) /*  (PIO_PPDDR) Pull Down Disable. */
#define PIO_PPDDR_P13 (0x1u << 13) /*  (PIO_PPDDR) Pull Down Disable. */
#define PIO_PPDDR_P14 (0x1u << 14) /*  (PIO_PPDDR) Pull Down Disable. */
#define PIO_PPDDR_P15 (0x1u << 15) /*  (PIO_PPDDR) Pull Down Disable. */
#define PIO_PPDDR_P16 (0x1u << 16) /*  (PIO_PPDDR) Pull Down Disable. */
#define PIO_PPDDR_P17 (0x1u << 17) /*  (PIO_PPDDR) Pull Down Disable. */
#define PIO_PPDDR_P18 (0x1u << 18) /*  (PIO_PPDDR) Pull Down Disable. */
#define PIO_PPDDR_P19 (0x1u << 19) /*  (PIO_PPDDR) Pull Down Disable. */
#define PIO_PPDDR_P20 (0x1u << 20) /*  (PIO_PPDDR) Pull Down Disable. */
#define PIO_PPDDR_P21 (0x1u << 21) /*  (PIO_PPDDR) Pull Down Disable. */
#define PIO_PPDDR_P22 (0x1u << 22) /*  (PIO_PPDDR) Pull Down Disable. */
#define PIO_PPDDR_P23 (0x1u << 23) /*  (PIO_PPDDR) Pull Down Disable. */
#define PIO_PPDDR_P24 (0x1u << 24) /*  (PIO_PPDDR) Pull Down Disable. */
#define PIO_PPDDR_P25 (0x1u << 25) /*  (PIO_PPDDR) Pull Down Disable. */
#define PIO_PPDDR_P26 (0x1u << 26) /*  (PIO_PPDDR) Pull Down Disable. */
#define PIO_PPDDR_P27 (0x1u << 27) /*  (PIO_PPDDR) Pull Down Disable. */
#define PIO_PPDDR_P28 (0x1u << 28) /*  (PIO_PPDDR) Pull Down Disable. */
#define PIO_PPDDR_P29 (0x1u << 29) /*  (PIO_PPDDR) Pull Down Disable. */
#define PIO_PPDDR_P30 (0x1u << 30) /*  (PIO_PPDDR) Pull Down Disable. */
#define PIO_PPDDR_P31 (0x1u << 31) /*  (PIO_PPDDR) Pull Down Disable. */
/* -------- PIO_PPDER : (PIO Offset: 0x0094) Pad Pull-down Enable Register -------- */
#define PIO_PPDER_P0 (0x1u << 0) /*  (PIO_PPDER) Pull Down Enable. */
#define PIO_PPDER_P1 (0x1u << 1) /*  (PIO_PPDER) Pull Down Enable. */
#define PIO_PPDER_P2 (0x1u << 2) /*  (PIO_PPDER) Pull Down Enable. */
#define PIO_PPDER_P3 (0x1u << 3) /*  (PIO_PPDER) Pull Down Enable. */
#define PIO_PPDER_P4 (0x1u << 4) /*  (PIO_PPDER) Pull Down Enable. */
#define PIO_PPDER_P5 (0x1u << 5) /*  (PIO_PPDER) Pull Down Enable. */
#define PIO_PPDER_P6 (0x1u << 6) /*  (PIO_PPDER) Pull Down Enable. */
#define PIO_PPDER_P7 (0x1u << 7) /*  (PIO_PPDER) Pull Down Enable. */
#define PIO_PPDER_P8 (0x1u << 8) /*  (PIO_PPDER) Pull Down Enable. */
#define PIO_PPDER_P9 (0x1u << 9) /*  (PIO_PPDER) Pull Down Enable. */
#define PIO_PPDER_P10 (0x1u << 10) /*  (PIO_PPDER) Pull Down Enable. */
#define PIO_PPDER_P11 (0x1u << 11) /*  (PIO_PPDER) Pull Down Enable. */
#define PIO_PPDER_P12 (0x1u << 12) /*  (PIO_PPDER) Pull Down Enable. */
#define PIO_PPDER_P13 (0x1u << 13) /*  (PIO_PPDER) Pull Down Enable. */
#define PIO_PPDER_P14 (0x1u << 14) /*  (PIO_PPDER) Pull Down Enable. */
#define PIO_PPDER_P15 (0x1u << 15) /*  (PIO_PPDER) Pull Down Enable. */
#define PIO_PPDER_P16 (0x1u << 16) /*  (PIO_PPDER) Pull Down Enable. */
#define PIO_PPDER_P17 (0x1u << 17) /*  (PIO_PPDER) Pull Down Enable. */
#define PIO_PPDER_P18 (0x1u << 18) /*  (PIO_PPDER) Pull Down Enable. */
#define PIO_PPDER_P19 (0x1u << 19) /*  (PIO_PPDER) Pull Down Enable. */
#define PIO_PPDER_P20 (0x1u << 20) /*  (PIO_PPDER) Pull Down Enable. */
#define PIO_PPDER_P21 (0x1u << 21) /*  (PIO_PPDER) Pull Down Enable. */
#define PIO_PPDER_P22 (0x1u << 22) /*  (PIO_PPDER) Pull Down Enable. */
#define PIO_PPDER_P23 (0x1u << 23) /*  (PIO_PPDER) Pull Down Enable. */
#define PIO_PPDER_P24 (0x1u << 24) /*  (PIO_PPDER) Pull Down Enable. */
#define PIO_PPDER_P25 (0x1u << 25) /*  (PIO_PPDER) Pull Down Enable. */
#define PIO_PPDER_P26 (0x1u << 26) /*  (PIO_PPDER) Pull Down Enable. */
#define PIO_PPDER_P27 (0x1u << 27) /*  (PIO_PPDER) Pull Down Enable. */
#define PIO_PPDER_P28 (0x1u << 28) /*  (PIO_PPDER) Pull Down Enable. */
#define PIO_PPDER_P29 (0x1u << 29) /*  (PIO_PPDER) Pull Down Enable. */
#define PIO_PPDER_P30 (0x1u << 30) /*  (PIO_PPDER) Pull Down Enable. */
#define PIO_PPDER_P31 (0x1u << 31) /*  (PIO_PPDER) Pull Down Enable. */
/* -------- PIO_PPDSR : (PIO Offset: 0x0098) Pad Pull-down Status Register -------- */
#define PIO_PPDSR_P0 (0x1u << 0) /*  (PIO_PPDSR) Pull Down Status. */
#define PIO_PPDSR_P1 (0x1u << 1) /*  (PIO_PPDSR) Pull Down Status. */
#define PIO_PPDSR_P2 (0x1u << 2) /*  (PIO_PPDSR) Pull Down Status. */
#define PIO_PPDSR_P3 (0x1u << 3) /*  (PIO_PPDSR) Pull Down Status. */
#define PIO_PPDSR_P4 (0x1u << 4) /*  (PIO_PPDSR) Pull Down Status. */
#define PIO_PPDSR_P5 (0x1u << 5) /*  (PIO_PPDSR) Pull Down Status. */
#define PIO_PPDSR_P6 (0x1u << 6) /*  (PIO_PPDSR) Pull Down Status. */
#define PIO_PPDSR_P7 (0x1u << 7) /*  (PIO_PPDSR) Pull Down Status. */
#define PIO_PPDSR_P8 (0x1u << 8) /*  (PIO_PPDSR) Pull Down Status. */
#define PIO_PPDSR_P9 (0x1u << 9) /*  (PIO_PPDSR) Pull Down Status. */
#define PIO_PPDSR_P10 (0x1u << 10) /*  (PIO_PPDSR) Pull Down Status. */
#define PIO_PPDSR_P11 (0x1u << 11) /*  (PIO_PPDSR) Pull Down Status. */
#define PIO_PPDSR_P12 (0x1u << 12) /*  (PIO_PPDSR) Pull Down Status. */
#define PIO_PPDSR_P13 (0x1u << 13) /*  (PIO_PPDSR) Pull Down Status. */
#define PIO_PPDSR_P14 (0x1u << 14) /*  (PIO_PPDSR) Pull Down Status. */
#define PIO_PPDSR_P15 (0x1u << 15) /*  (PIO_PPDSR) Pull Down Status. */
#define PIO_PPDSR_P16 (0x1u << 16) /*  (PIO_PPDSR) Pull Down Status. */
#define PIO_PPDSR_P17 (0x1u << 17) /*  (PIO_PPDSR) Pull Down Status. */
#define PIO_PPDSR_P18 (0x1u << 18) /*  (PIO_PPDSR) Pull Down Status. */
#define PIO_PPDSR_P19 (0x1u << 19) /*  (PIO_PPDSR) Pull Down Status. */
#define PIO_PPDSR_P20 (0x1u << 20) /*  (PIO_PPDSR) Pull Down Status. */
#define PIO_PPDSR_P21 (0x1u << 21) /*  (PIO_PPDSR) Pull Down Status. */
#define PIO_PPDSR_P22 (0x1u << 22) /*  (PIO_PPDSR) Pull Down Status. */
#define PIO_PPDSR_P23 (0x1u << 23) /*  (PIO_PPDSR) Pull Down Status. */
#define PIO_PPDSR_P24 (0x1u << 24) /*  (PIO_PPDSR) Pull Down Status. */
#define PIO_PPDSR_P25 (0x1u << 25) /*  (PIO_PPDSR) Pull Down Status. */
#define PIO_PPDSR_P26 (0x1u << 26) /*  (PIO_PPDSR) Pull Down Status. */
#define PIO_PPDSR_P27 (0x1u << 27) /*  (PIO_PPDSR) Pull Down Status. */
#define PIO_PPDSR_P28 (0x1u << 28) /*  (PIO_PPDSR) Pull Down Status. */
#define PIO_PPDSR_P29 (0x1u << 29) /*  (PIO_PPDSR) Pull Down Status. */
#define PIO_PPDSR_P30 (0x1u << 30) /*  (PIO_PPDSR) Pull Down Status. */
#define PIO_PPDSR_P31 (0x1u << 31) /*  (PIO_PPDSR) Pull Down Status. */
/* -------- PIO_OWER : (PIO Offset: 0x00A0) Output Write Enable -------- */
#define PIO_OWER_P0 (0x1u << 0) /*  (PIO_OWER) Output Write Enable. */
#define PIO_OWER_P1 (0x1u << 1) /*  (PIO_OWER) Output Write Enable. */
#define PIO_OWER_P2 (0x1u << 2) /*  (PIO_OWER) Output Write Enable. */
#define PIO_OWER_P3 (0x1u << 3) /*  (PIO_OWER) Output Write Enable. */
#define PIO_OWER_P4 (0x1u << 4) /*  (PIO_OWER) Output Write Enable. */
#define PIO_OWER_P5 (0x1u << 5) /*  (PIO_OWER) Output Write Enable. */
#define PIO_OWER_P6 (0x1u << 6) /*  (PIO_OWER) Output Write Enable. */
#define PIO_OWER_P7 (0x1u << 7) /*  (PIO_OWER) Output Write Enable. */
#define PIO_OWER_P8 (0x1u << 8) /*  (PIO_OWER) Output Write Enable. */
#define PIO_OWER_P9 (0x1u << 9) /*  (PIO_OWER) Output Write Enable. */
#define PIO_OWER_P10 (0x1u << 10) /*  (PIO_OWER) Output Write Enable. */
#define PIO_OWER_P11 (0x1u << 11) /*  (PIO_OWER) Output Write Enable. */
#define PIO_OWER_P12 (0x1u << 12) /*  (PIO_OWER) Output Write Enable. */
#define PIO_OWER_P13 (0x1u << 13) /*  (PIO_OWER) Output Write Enable. */
#define PIO_OWER_P14 (0x1u << 14) /*  (PIO_OWER) Output Write Enable. */
#define PIO_OWER_P15 (0x1u << 15) /*  (PIO_OWER) Output Write Enable. */
#define PIO_OWER_P16 (0x1u << 16) /*  (PIO_OWER) Output Write Enable. */
#define PIO_OWER_P17 (0x1u << 17) /*  (PIO_OWER) Output Write Enable. */
#define PIO_OWER_P18 (0x1u << 18) /*  (PIO_OWER) Output Write Enable. */
#define PIO_OWER_P19 (0x1u << 19) /*  (PIO_OWER) Output Write Enable. */
#define PIO_OWER_P20 (0x1u << 20) /*  (PIO_OWER) Output Write Enable. */
#define PIO_OWER_P21 (0x1u << 21) /*  (PIO_OWER) Output Write Enable. */
#define PIO_OWER_P22 (0x1u << 22) /*  (PIO_OWER) Output Write Enable. */
#define PIO_OWER_P23 (0x1u << 23) /*  (PIO_OWER) Output Write Enable. */
#define PIO_OWER_P24 (0x1u << 24) /*  (PIO_OWER) Output Write Enable. */
#define PIO_OWER_P25 (0x1u << 25) /*  (PIO_OWER) Output Write Enable. */
#define PIO_OWER_P26 (0x1u << 26) /*  (PIO_OWER) Output Write Enable. */
#define PIO_OWER_P27 (0x1u << 27) /*  (PIO_OWER) Output Write Enable. */
#define PIO_OWER_P28 (0x1u << 28) /*  (PIO_OWER) Output Write Enable. */
#define PIO_OWER_P29 (0x1u << 29) /*  (PIO_OWER) Output Write Enable. */
#define PIO_OWER_P30 (0x1u << 30) /*  (PIO_OWER) Output Write Enable. */
#define PIO_OWER_P31 (0x1u << 31) /*  (PIO_OWER) Output Write Enable. */
/* -------- PIO_OWDR : (PIO Offset: 0x00A4) Output Write Disable -------- */
#define PIO_OWDR_P0 (0x1u << 0) /*  (PIO_OWDR) Output Write Disable. */
#define PIO_OWDR_P1 (0x1u << 1) /*  (PIO_OWDR) Output Write Disable. */
#define PIO_OWDR_P2 (0x1u << 2) /*  (PIO_OWDR) Output Write Disable. */
#define PIO_OWDR_P3 (0x1u << 3) /*  (PIO_OWDR) Output Write Disable. */
#define PIO_OWDR_P4 (0x1u << 4) /*  (PIO_OWDR) Output Write Disable. */
#define PIO_OWDR_P5 (0x1u << 5) /*  (PIO_OWDR) Output Write Disable. */
#define PIO_OWDR_P6 (0x1u << 6) /*  (PIO_OWDR) Output Write Disable. */
#define PIO_OWDR_P7 (0x1u << 7) /*  (PIO_OWDR) Output Write Disable. */
#define PIO_OWDR_P8 (0x1u << 8) /*  (PIO_OWDR) Output Write Disable. */
#define PIO_OWDR_P9 (0x1u << 9) /*  (PIO_OWDR) Output Write Disable. */
#define PIO_OWDR_P10 (0x1u << 10) /*  (PIO_OWDR) Output Write Disable. */
#define PIO_OWDR_P11 (0x1u << 11) /*  (PIO_OWDR) Output Write Disable. */
#define PIO_OWDR_P12 (0x1u << 12) /*  (PIO_OWDR) Output Write Disable. */
#define PIO_OWDR_P13 (0x1u << 13) /*  (PIO_OWDR) Output Write Disable. */
#define PIO_OWDR_P14 (0x1u << 14) /*  (PIO_OWDR) Output Write Disable. */
#define PIO_OWDR_P15 (0x1u << 15) /*  (PIO_OWDR) Output Write Disable. */
#define PIO_OWDR_P16 (0x1u << 16) /*  (PIO_OWDR) Output Write Disable. */
#define PIO_OWDR_P17 (0x1u << 17) /*  (PIO_OWDR) Output Write Disable. */
#define PIO_OWDR_P18 (0x1u << 18) /*  (PIO_OWDR) Output Write Disable. */
#define PIO_OWDR_P19 (0x1u << 19) /*  (PIO_OWDR) Output Write Disable. */
#define PIO_OWDR_P20 (0x1u << 20) /*  (PIO_OWDR) Output Write Disable. */
#define PIO_OWDR_P21 (0x1u << 21) /*  (PIO_OWDR) Output Write Disable. */
#define PIO_OWDR_P22 (0x1u << 22) /*  (PIO_OWDR) Output Write Disable. */
#define PIO_OWDR_P23 (0x1u << 23) /*  (PIO_OWDR) Output Write Disable. */
#define PIO_OWDR_P24 (0x1u << 24) /*  (PIO_OWDR) Output Write Disable. */
#define PIO_OWDR_P25 (0x1u << 25) /*  (PIO_OWDR) Output Write Disable. */
#define PIO_OWDR_P26 (0x1u << 26) /*  (PIO_OWDR) Output Write Disable. */
#define PIO_OWDR_P27 (0x1u << 27) /*  (PIO_OWDR) Output Write Disable. */
#define PIO_OWDR_P28 (0x1u << 28) /*  (PIO_OWDR) Output Write Disable. */
#define PIO_OWDR_P29 (0x1u << 29) /*  (PIO_OWDR) Output Write Disable. */
#define PIO_OWDR_P30 (0x1u << 30) /*  (PIO_OWDR) Output Write Disable. */
#define PIO_OWDR_P31 (0x1u << 31) /*  (PIO_OWDR) Output Write Disable. */
/* -------- PIO_OWSR : (PIO Offset: 0x00A8) Output Write Status Register -------- */
#define PIO_OWSR_P0 (0x1u << 0) /*  (PIO_OWSR) Output Write Status. */
#define PIO_OWSR_P1 (0x1u << 1) /*  (PIO_OWSR) Output Write Status. */
#define PIO_OWSR_P2 (0x1u << 2) /*  (PIO_OWSR) Output Write Status. */
#define PIO_OWSR_P3 (0x1u << 3) /*  (PIO_OWSR) Output Write Status. */
#define PIO_OWSR_P4 (0x1u << 4) /*  (PIO_OWSR) Output Write Status. */
#define PIO_OWSR_P5 (0x1u << 5) /*  (PIO_OWSR) Output Write Status. */
#define PIO_OWSR_P6 (0x1u << 6) /*  (PIO_OWSR) Output Write Status. */
#define PIO_OWSR_P7 (0x1u << 7) /*  (PIO_OWSR) Output Write Status. */
#define PIO_OWSR_P8 (0x1u << 8) /*  (PIO_OWSR) Output Write Status. */
#define PIO_OWSR_P9 (0x1u << 9) /*  (PIO_OWSR) Output Write Status. */
#define PIO_OWSR_P10 (0x1u << 10) /*  (PIO_OWSR) Output Write Status. */
#define PIO_OWSR_P11 (0x1u << 11) /*  (PIO_OWSR) Output Write Status. */
#define PIO_OWSR_P12 (0x1u << 12) /*  (PIO_OWSR) Output Write Status. */
#define PIO_OWSR_P13 (0x1u << 13) /*  (PIO_OWSR) Output Write Status. */
#define PIO_OWSR_P14 (0x1u << 14) /*  (PIO_OWSR) Output Write Status. */
#define PIO_OWSR_P15 (0x1u << 15) /*  (PIO_OWSR) Output Write Status. */
#define PIO_OWSR_P16 (0x1u << 16) /*  (PIO_OWSR) Output Write Status. */
#define PIO_OWSR_P17 (0x1u << 17) /*  (PIO_OWSR) Output Write Status. */
#define PIO_OWSR_P18 (0x1u << 18) /*  (PIO_OWSR) Output Write Status. */
#define PIO_OWSR_P19 (0x1u << 19) /*  (PIO_OWSR) Output Write Status. */
#define PIO_OWSR_P20 (0x1u << 20) /*  (PIO_OWSR) Output Write Status. */
#define PIO_OWSR_P21 (0x1u << 21) /*  (PIO_OWSR) Output Write Status. */
#define PIO_OWSR_P22 (0x1u << 22) /*  (PIO_OWSR) Output Write Status. */
#define PIO_OWSR_P23 (0x1u << 23) /*  (PIO_OWSR) Output Write Status. */
#define PIO_OWSR_P24 (0x1u << 24) /*  (PIO_OWSR) Output Write Status. */
#define PIO_OWSR_P25 (0x1u << 25) /*  (PIO_OWSR) Output Write Status. */
#define PIO_OWSR_P26 (0x1u << 26) /*  (PIO_OWSR) Output Write Status. */
#define PIO_OWSR_P27 (0x1u << 27) /*  (PIO_OWSR) Output Write Status. */
#define PIO_OWSR_P28 (0x1u << 28) /*  (PIO_OWSR) Output Write Status. */
#define PIO_OWSR_P29 (0x1u << 29) /*  (PIO_OWSR) Output Write Status. */
#define PIO_OWSR_P30 (0x1u << 30) /*  (PIO_OWSR) Output Write Status. */
#define PIO_OWSR_P31 (0x1u << 31) /*  (PIO_OWSR) Output Write Status. */
/* -------- PIO_AIMER : (PIO Offset: 0x00B0) Additional Interrupt Modes Enable Register -------- */
#define PIO_AIMER_P0 (0x1u << 0) /*  (PIO_AIMER) Additional Interrupt Modes Enable. */
#define PIO_AIMER_P1 (0x1u << 1) /*  (PIO_AIMER) Additional Interrupt Modes Enable. */
#define PIO_AIMER_P2 (0x1u << 2) /*  (PIO_AIMER) Additional Interrupt Modes Enable. */
#define PIO_AIMER_P3 (0x1u << 3) /*  (PIO_AIMER) Additional Interrupt Modes Enable. */
#define PIO_AIMER_P4 (0x1u << 4) /*  (PIO_AIMER) Additional Interrupt Modes Enable. */
#define PIO_AIMER_P5 (0x1u << 5) /*  (PIO_AIMER) Additional Interrupt Modes Enable. */
#define PIO_AIMER_P6 (0x1u << 6) /*  (PIO_AIMER) Additional Interrupt Modes Enable. */
#define PIO_AIMER_P7 (0x1u << 7) /*  (PIO_AIMER) Additional Interrupt Modes Enable. */
#define PIO_AIMER_P8 (0x1u << 8) /*  (PIO_AIMER) Additional Interrupt Modes Enable. */
#define PIO_AIMER_P9 (0x1u << 9) /*  (PIO_AIMER) Additional Interrupt Modes Enable. */
#define PIO_AIMER_P10 (0x1u << 10) /*  (PIO_AIMER) Additional Interrupt Modes Enable. */
#define PIO_AIMER_P11 (0x1u << 11) /*  (PIO_AIMER) Additional Interrupt Modes Enable. */
#define PIO_AIMER_P12 (0x1u << 12) /*  (PIO_AIMER) Additional Interrupt Modes Enable. */
#define PIO_AIMER_P13 (0x1u << 13) /*  (PIO_AIMER) Additional Interrupt Modes Enable. */
#define PIO_AIMER_P14 (0x1u << 14) /*  (PIO_AIMER) Additional Interrupt Modes Enable. */
#define PIO_AIMER_P15 (0x1u << 15) /*  (PIO_AIMER) Additional Interrupt Modes Enable. */
#define PIO_AIMER_P16 (0x1u << 16) /*  (PIO_AIMER) Additional Interrupt Modes Enable. */
#define PIO_AIMER_P17 (0x1u << 17) /*  (PIO_AIMER) Additional Interrupt Modes Enable. */
#define PIO_AIMER_P18 (0x1u << 18) /*  (PIO_AIMER) Additional Interrupt Modes Enable. */
#define PIO_AIMER_P19 (0x1u << 19) /*  (PIO_AIMER) Additional Interrupt Modes Enable. */
#define PIO_AIMER_P20 (0x1u << 20) /*  (PIO_AIMER) Additional Interrupt Modes Enable. */
#define PIO_AIMER_P21 (0x1u << 21) /*  (PIO_AIMER) Additional Interrupt Modes Enable. */
#define PIO_AIMER_P22 (0x1u << 22) /*  (PIO_AIMER) Additional Interrupt Modes Enable. */
#define PIO_AIMER_P23 (0x1u << 23) /*  (PIO_AIMER) Additional Interrupt Modes Enable. */
#define PIO_AIMER_P24 (0x1u << 24) /*  (PIO_AIMER) Additional Interrupt Modes Enable. */
#define PIO_AIMER_P25 (0x1u << 25) /*  (PIO_AIMER) Additional Interrupt Modes Enable. */
#define PIO_AIMER_P26 (0x1u << 26) /*  (PIO_AIMER) Additional Interrupt Modes Enable. */
#define PIO_AIMER_P27 (0x1u << 27) /*  (PIO_AIMER) Additional Interrupt Modes Enable. */
#define PIO_AIMER_P28 (0x1u << 28) /*  (PIO_AIMER) Additional Interrupt Modes Enable. */
#define PIO_AIMER_P29 (0x1u << 29) /*  (PIO_AIMER) Additional Interrupt Modes Enable. */
#define PIO_AIMER_P30 (0x1u << 30) /*  (PIO_AIMER) Additional Interrupt Modes Enable. */
#define PIO_AIMER_P31 (0x1u << 31) /*  (PIO_AIMER) Additional Interrupt Modes Enable. */
/* -------- PIO_AIMDR : (PIO Offset: 0x00B4) Additional Interrupt Modes Disables Register -------- */
#define PIO_AIMDR_P0 (0x1u << 0) /*  (PIO_AIMDR) Additional Interrupt Modes Disable. */
#define PIO_AIMDR_P1 (0x1u << 1) /*  (PIO_AIMDR) Additional Interrupt Modes Disable. */
#define PIO_AIMDR_P2 (0x1u << 2) /*  (PIO_AIMDR) Additional Interrupt Modes Disable. */
#define PIO_AIMDR_P3 (0x1u << 3) /*  (PIO_AIMDR) Additional Interrupt Modes Disable. */
#define PIO_AIMDR_P4 (0x1u << 4) /*  (PIO_AIMDR) Additional Interrupt Modes Disable. */
#define PIO_AIMDR_P5 (0x1u << 5) /*  (PIO_AIMDR) Additional Interrupt Modes Disable. */
#define PIO_AIMDR_P6 (0x1u << 6) /*  (PIO_AIMDR) Additional Interrupt Modes Disable. */
#define PIO_AIMDR_P7 (0x1u << 7) /*  (PIO_AIMDR) Additional Interrupt Modes Disable. */
#define PIO_AIMDR_P8 (0x1u << 8) /*  (PIO_AIMDR) Additional Interrupt Modes Disable. */
#define PIO_AIMDR_P9 (0x1u << 9) /*  (PIO_AIMDR) Additional Interrupt Modes Disable. */
#define PIO_AIMDR_P10 (0x1u << 10) /*  (PIO_AIMDR) Additional Interrupt Modes Disable. */
#define PIO_AIMDR_P11 (0x1u << 11) /*  (PIO_AIMDR) Additional Interrupt Modes Disable. */
#define PIO_AIMDR_P12 (0x1u << 12) /*  (PIO_AIMDR) Additional Interrupt Modes Disable. */
#define PIO_AIMDR_P13 (0x1u << 13) /*  (PIO_AIMDR) Additional Interrupt Modes Disable. */
#define PIO_AIMDR_P14 (0x1u << 14) /*  (PIO_AIMDR) Additional Interrupt Modes Disable. */
#define PIO_AIMDR_P15 (0x1u << 15) /*  (PIO_AIMDR) Additional Interrupt Modes Disable. */
#define PIO_AIMDR_P16 (0x1u << 16) /*  (PIO_AIMDR) Additional Interrupt Modes Disable. */
#define PIO_AIMDR_P17 (0x1u << 17) /*  (PIO_AIMDR) Additional Interrupt Modes Disable. */
#define PIO_AIMDR_P18 (0x1u << 18) /*  (PIO_AIMDR) Additional Interrupt Modes Disable. */
#define PIO_AIMDR_P19 (0x1u << 19) /*  (PIO_AIMDR) Additional Interrupt Modes Disable. */
#define PIO_AIMDR_P20 (0x1u << 20) /*  (PIO_AIMDR) Additional Interrupt Modes Disable. */
#define PIO_AIMDR_P21 (0x1u << 21) /*  (PIO_AIMDR) Additional Interrupt Modes Disable. */
#define PIO_AIMDR_P22 (0x1u << 22) /*  (PIO_AIMDR) Additional Interrupt Modes Disable. */
#define PIO_AIMDR_P23 (0x1u << 23) /*  (PIO_AIMDR) Additional Interrupt Modes Disable. */
#define PIO_AIMDR_P24 (0x1u << 24) /*  (PIO_AIMDR) Additional Interrupt Modes Disable. */
#define PIO_AIMDR_P25 (0x1u << 25) /*  (PIO_AIMDR) Additional Interrupt Modes Disable. */
#define PIO_AIMDR_P26 (0x1u << 26) /*  (PIO_AIMDR) Additional Interrupt Modes Disable. */
#define PIO_AIMDR_P27 (0x1u << 27) /*  (PIO_AIMDR) Additional Interrupt Modes Disable. */
#define PIO_AIMDR_P28 (0x1u << 28) /*  (PIO_AIMDR) Additional Interrupt Modes Disable. */
#define PIO_AIMDR_P29 (0x1u << 29) /*  (PIO_AIMDR) Additional Interrupt Modes Disable. */
#define PIO_AIMDR_P30 (0x1u << 30) /*  (PIO_AIMDR) Additional Interrupt Modes Disable. */
#define PIO_AIMDR_P31 (0x1u << 31) /*  (PIO_AIMDR) Additional Interrupt Modes Disable. */
/* -------- PIO_AIMMR : (PIO Offset: 0x00B8) Additional Interrupt Modes Mask Register -------- */
#define PIO_AIMMR_P0 (0x1u << 0) /*  (PIO_AIMMR) Peripheral CD Status. */
#define PIO_AIMMR_P1 (0x1u << 1) /*  (PIO_AIMMR) Peripheral CD Status. */
#define PIO_AIMMR_P2 (0x1u << 2) /*  (PIO_AIMMR) Peripheral CD Status. */
#define PIO_AIMMR_P3 (0x1u << 3) /*  (PIO_AIMMR) Peripheral CD Status. */
#define PIO_AIMMR_P4 (0x1u << 4) /*  (PIO_AIMMR) Peripheral CD Status. */
#define PIO_AIMMR_P5 (0x1u << 5) /*  (PIO_AIMMR) Peripheral CD Status. */
#define PIO_AIMMR_P6 (0x1u << 6) /*  (PIO_AIMMR) Peripheral CD Status. */
#define PIO_AIMMR_P7 (0x1u << 7) /*  (PIO_AIMMR) Peripheral CD Status. */
#define PIO_AIMMR_P8 (0x1u << 8) /*  (PIO_AIMMR) Peripheral CD Status. */
#define PIO_AIMMR_P9 (0x1u << 9) /*  (PIO_AIMMR) Peripheral CD Status. */
#define PIO_AIMMR_P10 (0x1u << 10) /*  (PIO_AIMMR) Peripheral CD Status. */
#define PIO_AIMMR_P11 (0x1u << 11) /*  (PIO_AIMMR) Peripheral CD Status. */
#define PIO_AIMMR_P12 (0x1u << 12) /*  (PIO_AIMMR) Peripheral CD Status. */
#define PIO_AIMMR_P13 (0x1u << 13) /*  (PIO_AIMMR) Peripheral CD Status. */
#define PIO_AIMMR_P14 (0x1u << 14) /*  (PIO_AIMMR) Peripheral CD Status. */
#define PIO_AIMMR_P15 (0x1u << 15) /*  (PIO_AIMMR) Peripheral CD Status. */
#define PIO_AIMMR_P16 (0x1u << 16) /*  (PIO_AIMMR) Peripheral CD Status. */
#define PIO_AIMMR_P17 (0x1u << 17) /*  (PIO_AIMMR) Peripheral CD Status. */
#define PIO_AIMMR_P18 (0x1u << 18) /*  (PIO_AIMMR) Peripheral CD Status. */
#define PIO_AIMMR_P19 (0x1u << 19) /*  (PIO_AIMMR) Peripheral CD Status. */
#define PIO_AIMMR_P20 (0x1u << 20) /*  (PIO_AIMMR) Peripheral CD Status. */
#define PIO_AIMMR_P21 (0x1u << 21) /*  (PIO_AIMMR) Peripheral CD Status. */
#define PIO_AIMMR_P22 (0x1u << 22) /*  (PIO_AIMMR) Peripheral CD Status. */
#define PIO_AIMMR_P23 (0x1u << 23) /*  (PIO_AIMMR) Peripheral CD Status. */
#define PIO_AIMMR_P24 (0x1u << 24) /*  (PIO_AIMMR) Peripheral CD Status. */
#define PIO_AIMMR_P25 (0x1u << 25) /*  (PIO_AIMMR) Peripheral CD Status. */
#define PIO_AIMMR_P26 (0x1u << 26) /*  (PIO_AIMMR) Peripheral CD Status. */
#define PIO_AIMMR_P27 (0x1u << 27) /*  (PIO_AIMMR) Peripheral CD Status. */
#define PIO_AIMMR_P28 (0x1u << 28) /*  (PIO_AIMMR) Peripheral CD Status. */
#define PIO_AIMMR_P29 (0x1u << 29) /*  (PIO_AIMMR) Peripheral CD Status. */
#define PIO_AIMMR_P30 (0x1u << 30) /*  (PIO_AIMMR) Peripheral CD Status. */
#define PIO_AIMMR_P31 (0x1u << 31) /*  (PIO_AIMMR) Peripheral CD Status. */
/* -------- PIO_ESR : (PIO Offset: 0x00C0) Edge Select Register -------- */
#define PIO_ESR_P0 (0x1u << 0) /*  (PIO_ESR) Edge Interrupt Selection. */
#define PIO_ESR_P1 (0x1u << 1) /*  (PIO_ESR) Edge Interrupt Selection. */
#define PIO_ESR_P2 (0x1u << 2) /*  (PIO_ESR) Edge Interrupt Selection. */
#define PIO_ESR_P3 (0x1u << 3) /*  (PIO_ESR) Edge Interrupt Selection. */
#define PIO_ESR_P4 (0x1u << 4) /*  (PIO_ESR) Edge Interrupt Selection. */
#define PIO_ESR_P5 (0x1u << 5) /*  (PIO_ESR) Edge Interrupt Selection. */
#define PIO_ESR_P6 (0x1u << 6) /*  (PIO_ESR) Edge Interrupt Selection. */
#define PIO_ESR_P7 (0x1u << 7) /*  (PIO_ESR) Edge Interrupt Selection. */
#define PIO_ESR_P8 (0x1u << 8) /*  (PIO_ESR) Edge Interrupt Selection. */
#define PIO_ESR_P9 (0x1u << 9) /*  (PIO_ESR) Edge Interrupt Selection. */
#define PIO_ESR_P10 (0x1u << 10) /*  (PIO_ESR) Edge Interrupt Selection. */
#define PIO_ESR_P11 (0x1u << 11) /*  (PIO_ESR) Edge Interrupt Selection. */
#define PIO_ESR_P12 (0x1u << 12) /*  (PIO_ESR) Edge Interrupt Selection. */
#define PIO_ESR_P13 (0x1u << 13) /*  (PIO_ESR) Edge Interrupt Selection. */
#define PIO_ESR_P14 (0x1u << 14) /*  (PIO_ESR) Edge Interrupt Selection. */
#define PIO_ESR_P15 (0x1u << 15) /*  (PIO_ESR) Edge Interrupt Selection. */
#define PIO_ESR_P16 (0x1u << 16) /*  (PIO_ESR) Edge Interrupt Selection. */
#define PIO_ESR_P17 (0x1u << 17) /*  (PIO_ESR) Edge Interrupt Selection. */
#define PIO_ESR_P18 (0x1u << 18) /*  (PIO_ESR) Edge Interrupt Selection. */
#define PIO_ESR_P19 (0x1u << 19) /*  (PIO_ESR) Edge Interrupt Selection. */
#define PIO_ESR_P20 (0x1u << 20) /*  (PIO_ESR) Edge Interrupt Selection. */
#define PIO_ESR_P21 (0x1u << 21) /*  (PIO_ESR) Edge Interrupt Selection. */
#define PIO_ESR_P22 (0x1u << 22) /*  (PIO_ESR) Edge Interrupt Selection. */
#define PIO_ESR_P23 (0x1u << 23) /*  (PIO_ESR) Edge Interrupt Selection. */
#define PIO_ESR_P24 (0x1u << 24) /*  (PIO_ESR) Edge Interrupt Selection. */
#define PIO_ESR_P25 (0x1u << 25) /*  (PIO_ESR) Edge Interrupt Selection. */
#define PIO_ESR_P26 (0x1u << 26) /*  (PIO_ESR) Edge Interrupt Selection. */
#define PIO_ESR_P27 (0x1u << 27) /*  (PIO_ESR) Edge Interrupt Selection. */
#define PIO_ESR_P28 (0x1u << 28) /*  (PIO_ESR) Edge Interrupt Selection. */
#define PIO_ESR_P29 (0x1u << 29) /*  (PIO_ESR) Edge Interrupt Selection. */
#define PIO_ESR_P30 (0x1u << 30) /*  (PIO_ESR) Edge Interrupt Selection. */
#define PIO_ESR_P31 (0x1u << 31) /*  (PIO_ESR) Edge Interrupt Selection. */
/* -------- PIO_LSR : (PIO Offset: 0x00C4) Level Select Register -------- */
#define PIO_LSR_P0 (0x1u << 0) /*  (PIO_LSR) Level Interrupt Selection. */
#define PIO_LSR_P1 (0x1u << 1) /*  (PIO_LSR) Level Interrupt Selection. */
#define PIO_LSR_P2 (0x1u << 2) /*  (PIO_LSR) Level Interrupt Selection. */
#define PIO_LSR_P3 (0x1u << 3) /*  (PIO_LSR) Level Interrupt Selection. */
#define PIO_LSR_P4 (0x1u << 4) /*  (PIO_LSR) Level Interrupt Selection. */
#define PIO_LSR_P5 (0x1u << 5) /*  (PIO_LSR) Level Interrupt Selection. */
#define PIO_LSR_P6 (0x1u << 6) /*  (PIO_LSR) Level Interrupt Selection. */
#define PIO_LSR_P7 (0x1u << 7) /*  (PIO_LSR) Level Interrupt Selection. */
#define PIO_LSR_P8 (0x1u << 8) /*  (PIO_LSR) Level Interrupt Selection. */
#define PIO_LSR_P9 (0x1u << 9) /*  (PIO_LSR) Level Interrupt Selection. */
#define PIO_LSR_P10 (0x1u << 10) /*  (PIO_LSR) Level Interrupt Selection. */
#define PIO_LSR_P11 (0x1u << 11) /*  (PIO_LSR) Level Interrupt Selection. */
#define PIO_LSR_P12 (0x1u << 12) /*  (PIO_LSR) Level Interrupt Selection. */
#define PIO_LSR_P13 (0x1u << 13) /*  (PIO_LSR) Level Interrupt Selection. */
#define PIO_LSR_P14 (0x1u << 14) /*  (PIO_LSR) Level Interrupt Selection. */
#define PIO_LSR_P15 (0x1u << 15) /*  (PIO_LSR) Level Interrupt Selection. */
#define PIO_LSR_P16 (0x1u << 16) /*  (PIO_LSR) Level Interrupt Selection. */
#define PIO_LSR_P17 (0x1u << 17) /*  (PIO_LSR) Level Interrupt Selection. */
#define PIO_LSR_P18 (0x1u << 18) /*  (PIO_LSR) Level Interrupt Selection. */
#define PIO_LSR_P19 (0x1u << 19) /*  (PIO_LSR) Level Interrupt Selection. */
#define PIO_LSR_P20 (0x1u << 20) /*  (PIO_LSR) Level Interrupt Selection. */
#define PIO_LSR_P21 (0x1u << 21) /*  (PIO_LSR) Level Interrupt Selection. */
#define PIO_LSR_P22 (0x1u << 22) /*  (PIO_LSR) Level Interrupt Selection. */
#define PIO_LSR_P23 (0x1u << 23) /*  (PIO_LSR) Level Interrupt Selection. */
#define PIO_LSR_P24 (0x1u << 24) /*  (PIO_LSR) Level Interrupt Selection. */
#define PIO_LSR_P25 (0x1u << 25) /*  (PIO_LSR) Level Interrupt Selection. */
#define PIO_LSR_P26 (0x1u << 26) /*  (PIO_LSR) Level Interrupt Selection. */
#define PIO_LSR_P27 (0x1u << 27) /*  (PIO_LSR) Level Interrupt Selection. */
#define PIO_LSR_P28 (0x1u << 28) /*  (PIO_LSR) Level Interrupt Selection. */
#define PIO_LSR_P29 (0x1u << 29) /*  (PIO_LSR) Level Interrupt Selection. */
#define PIO_LSR_P30 (0x1u << 30) /*  (PIO_LSR) Level Interrupt Selection. */
#define PIO_LSR_P31 (0x1u << 31) /*  (PIO_LSR) Level Interrupt Selection. */
/* -------- PIO_ELSR : (PIO Offset: 0x00C8) Edge/Level Status Register -------- */
#define PIO_ELSR_P0 (0x1u << 0) /*  (PIO_ELSR) Edge/Level Interrupt source selection. */
#define PIO_ELSR_P1 (0x1u << 1) /*  (PIO_ELSR) Edge/Level Interrupt source selection. */
#define PIO_ELSR_P2 (0x1u << 2) /*  (PIO_ELSR) Edge/Level Interrupt source selection. */
#define PIO_ELSR_P3 (0x1u << 3) /*  (PIO_ELSR) Edge/Level Interrupt source selection. */
#define PIO_ELSR_P4 (0x1u << 4) /*  (PIO_ELSR) Edge/Level Interrupt source selection. */
#define PIO_ELSR_P5 (0x1u << 5) /*  (PIO_ELSR) Edge/Level Interrupt source selection. */
#define PIO_ELSR_P6 (0x1u << 6) /*  (PIO_ELSR) Edge/Level Interrupt source selection. */
#define PIO_ELSR_P7 (0x1u << 7) /*  (PIO_ELSR) Edge/Level Interrupt source selection. */
#define PIO_ELSR_P8 (0x1u << 8) /*  (PIO_ELSR) Edge/Level Interrupt source selection. */
#define PIO_ELSR_P9 (0x1u << 9) /*  (PIO_ELSR) Edge/Level Interrupt source selection. */
#define PIO_ELSR_P10 (0x1u << 10) /*  (PIO_ELSR) Edge/Level Interrupt source selection. */
#define PIO_ELSR_P11 (0x1u << 11) /*  (PIO_ELSR) Edge/Level Interrupt source selection. */
#define PIO_ELSR_P12 (0x1u << 12) /*  (PIO_ELSR) Edge/Level Interrupt source selection. */
#define PIO_ELSR_P13 (0x1u << 13) /*  (PIO_ELSR) Edge/Level Interrupt source selection. */
#define PIO_ELSR_P14 (0x1u << 14) /*  (PIO_ELSR) Edge/Level Interrupt source selection. */
#define PIO_ELSR_P15 (0x1u << 15) /*  (PIO_ELSR) Edge/Level Interrupt source selection. */
#define PIO_ELSR_P16 (0x1u << 16) /*  (PIO_ELSR) Edge/Level Interrupt source selection. */
#define PIO_ELSR_P17 (0x1u << 17) /*  (PIO_ELSR) Edge/Level Interrupt source selection. */
#define PIO_ELSR_P18 (0x1u << 18) /*  (PIO_ELSR) Edge/Level Interrupt source selection. */
#define PIO_ELSR_P19 (0x1u << 19) /*  (PIO_ELSR) Edge/Level Interrupt source selection. */
#define PIO_ELSR_P20 (0x1u << 20) /*  (PIO_ELSR) Edge/Level Interrupt source selection. */
#define PIO_ELSR_P21 (0x1u << 21) /*  (PIO_ELSR) Edge/Level Interrupt source selection. */
#define PIO_ELSR_P22 (0x1u << 22) /*  (PIO_ELSR) Edge/Level Interrupt source selection. */
#define PIO_ELSR_P23 (0x1u << 23) /*  (PIO_ELSR) Edge/Level Interrupt source selection. */
#define PIO_ELSR_P24 (0x1u << 24) /*  (PIO_ELSR) Edge/Level Interrupt source selection. */
#define PIO_ELSR_P25 (0x1u << 25) /*  (PIO_ELSR) Edge/Level Interrupt source selection. */
#define PIO_ELSR_P26 (0x1u << 26) /*  (PIO_ELSR) Edge/Level Interrupt source selection. */
#define PIO_ELSR_P27 (0x1u << 27) /*  (PIO_ELSR) Edge/Level Interrupt source selection. */
#define PIO_ELSR_P28 (0x1u << 28) /*  (PIO_ELSR) Edge/Level Interrupt source selection. */
#define PIO_ELSR_P29 (0x1u << 29) /*  (PIO_ELSR) Edge/Level Interrupt source selection. */
#define PIO_ELSR_P30 (0x1u << 30) /*  (PIO_ELSR) Edge/Level Interrupt source selection. */
#define PIO_ELSR_P31 (0x1u << 31) /*  (PIO_ELSR) Edge/Level Interrupt source selection. */
/* -------- PIO_FELLSR : (PIO Offset: 0x00D0) Falling Edge/Low Level Select Register -------- */
#define PIO_FELLSR_P0 (0x1u << 0) /*  (PIO_FELLSR) Falling Edge/Low Level Interrupt Selection. */
#define PIO_FELLSR_P1 (0x1u << 1) /*  (PIO_FELLSR) Falling Edge/Low Level Interrupt Selection. */
#define PIO_FELLSR_P2 (0x1u << 2) /*  (PIO_FELLSR) Falling Edge/Low Level Interrupt Selection. */
#define PIO_FELLSR_P3 (0x1u << 3) /*  (PIO_FELLSR) Falling Edge/Low Level Interrupt Selection. */
#define PIO_FELLSR_P4 (0x1u << 4) /*  (PIO_FELLSR) Falling Edge/Low Level Interrupt Selection. */
#define PIO_FELLSR_P5 (0x1u << 5) /*  (PIO_FELLSR) Falling Edge/Low Level Interrupt Selection. */
#define PIO_FELLSR_P6 (0x1u << 6) /*  (PIO_FELLSR) Falling Edge/Low Level Interrupt Selection. */
#define PIO_FELLSR_P7 (0x1u << 7) /*  (PIO_FELLSR) Falling Edge/Low Level Interrupt Selection. */
#define PIO_FELLSR_P8 (0x1u << 8) /*  (PIO_FELLSR) Falling Edge/Low Level Interrupt Selection. */
#define PIO_FELLSR_P9 (0x1u << 9) /*  (PIO_FELLSR) Falling Edge/Low Level Interrupt Selection. */
#define PIO_FELLSR_P10 (0x1u << 10) /*  (PIO_FELLSR) Falling Edge/Low Level Interrupt Selection. */
#define PIO_FELLSR_P11 (0x1u << 11) /*  (PIO_FELLSR) Falling Edge/Low Level Interrupt Selection. */
#define PIO_FELLSR_P12 (0x1u << 12) /*  (PIO_FELLSR) Falling Edge/Low Level Interrupt Selection. */
#define PIO_FELLSR_P13 (0x1u << 13) /*  (PIO_FELLSR) Falling Edge/Low Level Interrupt Selection. */
#define PIO_FELLSR_P14 (0x1u << 14) /*  (PIO_FELLSR) Falling Edge/Low Level Interrupt Selection. */
#define PIO_FELLSR_P15 (0x1u << 15) /*  (PIO_FELLSR) Falling Edge/Low Level Interrupt Selection. */
#define PIO_FELLSR_P16 (0x1u << 16) /*  (PIO_FELLSR) Falling Edge/Low Level Interrupt Selection. */
#define PIO_FELLSR_P17 (0x1u << 17) /*  (PIO_FELLSR) Falling Edge/Low Level Interrupt Selection. */
#define PIO_FELLSR_P18 (0x1u << 18) /*  (PIO_FELLSR) Falling Edge/Low Level Interrupt Selection. */
#define PIO_FELLSR_P19 (0x1u << 19) /*  (PIO_FELLSR) Falling Edge/Low Level Interrupt Selection. */
#define PIO_FELLSR_P20 (0x1u << 20) /*  (PIO_FELLSR) Falling Edge/Low Level Interrupt Selection. */
#define PIO_FELLSR_P21 (0x1u << 21) /*  (PIO_FELLSR) Falling Edge/Low Level Interrupt Selection. */
#define PIO_FELLSR_P22 (0x1u << 22) /*  (PIO_FELLSR) Falling Edge/Low Level Interrupt Selection. */
#define PIO_FELLSR_P23 (0x1u << 23) /*  (PIO_FELLSR) Falling Edge/Low Level Interrupt Selection. */
#define PIO_FELLSR_P24 (0x1u << 24) /*  (PIO_FELLSR) Falling Edge/Low Level Interrupt Selection. */
#define PIO_FELLSR_P25 (0x1u << 25) /*  (PIO_FELLSR) Falling Edge/Low Level Interrupt Selection. */
#define PIO_FELLSR_P26 (0x1u << 26) /*  (PIO_FELLSR) Falling Edge/Low Level Interrupt Selection. */
#define PIO_FELLSR_P27 (0x1u << 27) /*  (PIO_FELLSR) Falling Edge/Low Level Interrupt Selection. */
#define PIO_FELLSR_P28 (0x1u << 28) /*  (PIO_FELLSR) Falling Edge/Low Level Interrupt Selection. */
#define PIO_FELLSR_P29 (0x1u << 29) /*  (PIO_FELLSR) Falling Edge/Low Level Interrupt Selection. */
#define PIO_FELLSR_P30 (0x1u << 30) /*  (PIO_FELLSR) Falling Edge/Low Level Interrupt Selection. */
#define PIO_FELLSR_P31 (0x1u << 31) /*  (PIO_FELLSR) Falling Edge/Low Level Interrupt Selection. */
/* -------- PIO_REHLSR : (PIO Offset: 0x00D4) Rising Edge/ High Level Select Register -------- */
#define PIO_REHLSR_P0 (0x1u << 0) /*  (PIO_REHLSR) Rising Edge /High Level Interrupt Selection. */
#define PIO_REHLSR_P1 (0x1u << 1) /*  (PIO_REHLSR) Rising Edge /High Level Interrupt Selection. */
#define PIO_REHLSR_P2 (0x1u << 2) /*  (PIO_REHLSR) Rising Edge /High Level Interrupt Selection. */
#define PIO_REHLSR_P3 (0x1u << 3) /*  (PIO_REHLSR) Rising Edge /High Level Interrupt Selection. */
#define PIO_REHLSR_P4 (0x1u << 4) /*  (PIO_REHLSR) Rising Edge /High Level Interrupt Selection. */
#define PIO_REHLSR_P5 (0x1u << 5) /*  (PIO_REHLSR) Rising Edge /High Level Interrupt Selection. */
#define PIO_REHLSR_P6 (0x1u << 6) /*  (PIO_REHLSR) Rising Edge /High Level Interrupt Selection. */
#define PIO_REHLSR_P7 (0x1u << 7) /*  (PIO_REHLSR) Rising Edge /High Level Interrupt Selection. */
#define PIO_REHLSR_P8 (0x1u << 8) /*  (PIO_REHLSR) Rising Edge /High Level Interrupt Selection. */
#define PIO_REHLSR_P9 (0x1u << 9) /*  (PIO_REHLSR) Rising Edge /High Level Interrupt Selection. */
#define PIO_REHLSR_P10 (0x1u << 10) /*  (PIO_REHLSR) Rising Edge /High Level Interrupt Selection. */
#define PIO_REHLSR_P11 (0x1u << 11) /*  (PIO_REHLSR) Rising Edge /High Level Interrupt Selection. */
#define PIO_REHLSR_P12 (0x1u << 12) /*  (PIO_REHLSR) Rising Edge /High Level Interrupt Selection. */
#define PIO_REHLSR_P13 (0x1u << 13) /*  (PIO_REHLSR) Rising Edge /High Level Interrupt Selection. */
#define PIO_REHLSR_P14 (0x1u << 14) /*  (PIO_REHLSR) Rising Edge /High Level Interrupt Selection. */
#define PIO_REHLSR_P15 (0x1u << 15) /*  (PIO_REHLSR) Rising Edge /High Level Interrupt Selection. */
#define PIO_REHLSR_P16 (0x1u << 16) /*  (PIO_REHLSR) Rising Edge /High Level Interrupt Selection. */
#define PIO_REHLSR_P17 (0x1u << 17) /*  (PIO_REHLSR) Rising Edge /High Level Interrupt Selection. */
#define PIO_REHLSR_P18 (0x1u << 18) /*  (PIO_REHLSR) Rising Edge /High Level Interrupt Selection. */
#define PIO_REHLSR_P19 (0x1u << 19) /*  (PIO_REHLSR) Rising Edge /High Level Interrupt Selection. */
#define PIO_REHLSR_P20 (0x1u << 20) /*  (PIO_REHLSR) Rising Edge /High Level Interrupt Selection. */
#define PIO_REHLSR_P21 (0x1u << 21) /*  (PIO_REHLSR) Rising Edge /High Level Interrupt Selection. */
#define PIO_REHLSR_P22 (0x1u << 22) /*  (PIO_REHLSR) Rising Edge /High Level Interrupt Selection. */
#define PIO_REHLSR_P23 (0x1u << 23) /*  (PIO_REHLSR) Rising Edge /High Level Interrupt Selection. */
#define PIO_REHLSR_P24 (0x1u << 24) /*  (PIO_REHLSR) Rising Edge /High Level Interrupt Selection. */
#define PIO_REHLSR_P25 (0x1u << 25) /*  (PIO_REHLSR) Rising Edge /High Level Interrupt Selection. */
#define PIO_REHLSR_P26 (0x1u << 26) /*  (PIO_REHLSR) Rising Edge /High Level Interrupt Selection. */
#define PIO_REHLSR_P27 (0x1u << 27) /*  (PIO_REHLSR) Rising Edge /High Level Interrupt Selection. */
#define PIO_REHLSR_P28 (0x1u << 28) /*  (PIO_REHLSR) Rising Edge /High Level Interrupt Selection. */
#define PIO_REHLSR_P29 (0x1u << 29) /*  (PIO_REHLSR) Rising Edge /High Level Interrupt Selection. */
#define PIO_REHLSR_P30 (0x1u << 30) /*  (PIO_REHLSR) Rising Edge /High Level Interrupt Selection. */
#define PIO_REHLSR_P31 (0x1u << 31) /*  (PIO_REHLSR) Rising Edge /High Level Interrupt Selection. */
/* -------- PIO_FRLHSR : (PIO Offset: 0x00D8) Fall/Rise - Low/High Status Register -------- */
#define PIO_FRLHSR_P0 (0x1u << 0) /*  (PIO_FRLHSR) Edge /Level Interrupt Source Selection. */
#define PIO_FRLHSR_P1 (0x1u << 1) /*  (PIO_FRLHSR) Edge /Level Interrupt Source Selection. */
#define PIO_FRLHSR_P2 (0x1u << 2) /*  (PIO_FRLHSR) Edge /Level Interrupt Source Selection. */
#define PIO_FRLHSR_P3 (0x1u << 3) /*  (PIO_FRLHSR) Edge /Level Interrupt Source Selection. */
#define PIO_FRLHSR_P4 (0x1u << 4) /*  (PIO_FRLHSR) Edge /Level Interrupt Source Selection. */
#define PIO_FRLHSR_P5 (0x1u << 5) /*  (PIO_FRLHSR) Edge /Level Interrupt Source Selection. */
#define PIO_FRLHSR_P6 (0x1u << 6) /*  (PIO_FRLHSR) Edge /Level Interrupt Source Selection. */
#define PIO_FRLHSR_P7 (0x1u << 7) /*  (PIO_FRLHSR) Edge /Level Interrupt Source Selection. */
#define PIO_FRLHSR_P8 (0x1u << 8) /*  (PIO_FRLHSR) Edge /Level Interrupt Source Selection. */
#define PIO_FRLHSR_P9 (0x1u << 9) /*  (PIO_FRLHSR) Edge /Level Interrupt Source Selection. */
#define PIO_FRLHSR_P10 (0x1u << 10) /*  (PIO_FRLHSR) Edge /Level Interrupt Source Selection. */
#define PIO_FRLHSR_P11 (0x1u << 11) /*  (PIO_FRLHSR) Edge /Level Interrupt Source Selection. */
#define PIO_FRLHSR_P12 (0x1u << 12) /*  (PIO_FRLHSR) Edge /Level Interrupt Source Selection. */
#define PIO_FRLHSR_P13 (0x1u << 13) /*  (PIO_FRLHSR) Edge /Level Interrupt Source Selection. */
#define PIO_FRLHSR_P14 (0x1u << 14) /*  (PIO_FRLHSR) Edge /Level Interrupt Source Selection. */
#define PIO_FRLHSR_P15 (0x1u << 15) /*  (PIO_FRLHSR) Edge /Level Interrupt Source Selection. */
#define PIO_FRLHSR_P16 (0x1u << 16) /*  (PIO_FRLHSR) Edge /Level Interrupt Source Selection. */
#define PIO_FRLHSR_P17 (0x1u << 17) /*  (PIO_FRLHSR) Edge /Level Interrupt Source Selection. */
#define PIO_FRLHSR_P18 (0x1u << 18) /*  (PIO_FRLHSR) Edge /Level Interrupt Source Selection. */
#define PIO_FRLHSR_P19 (0x1u << 19) /*  (PIO_FRLHSR) Edge /Level Interrupt Source Selection. */
#define PIO_FRLHSR_P20 (0x1u << 20) /*  (PIO_FRLHSR) Edge /Level Interrupt Source Selection. */
#define PIO_FRLHSR_P21 (0x1u << 21) /*  (PIO_FRLHSR) Edge /Level Interrupt Source Selection. */
#define PIO_FRLHSR_P22 (0x1u << 22) /*  (PIO_FRLHSR) Edge /Level Interrupt Source Selection. */
#define PIO_FRLHSR_P23 (0x1u << 23) /*  (PIO_FRLHSR) Edge /Level Interrupt Source Selection. */
#define PIO_FRLHSR_P24 (0x1u << 24) /*  (PIO_FRLHSR) Edge /Level Interrupt Source Selection. */
#define PIO_FRLHSR_P25 (0x1u << 25) /*  (PIO_FRLHSR) Edge /Level Interrupt Source Selection. */
#define PIO_FRLHSR_P26 (0x1u << 26) /*  (PIO_FRLHSR) Edge /Level Interrupt Source Selection. */
#define PIO_FRLHSR_P27 (0x1u << 27) /*  (PIO_FRLHSR) Edge /Level Interrupt Source Selection. */
#define PIO_FRLHSR_P28 (0x1u << 28) /*  (PIO_FRLHSR) Edge /Level Interrupt Source Selection. */
#define PIO_FRLHSR_P29 (0x1u << 29) /*  (PIO_FRLHSR) Edge /Level Interrupt Source Selection. */
#define PIO_FRLHSR_P30 (0x1u << 30) /*  (PIO_FRLHSR) Edge /Level Interrupt Source Selection. */
#define PIO_FRLHSR_P31 (0x1u << 31) /*  (PIO_FRLHSR) Edge /Level Interrupt Source Selection. */
/* -------- PIO_LOCKSR : (PIO Offset: 0x00E0) Lock Status -------- */
#define PIO_LOCKSR_P0 (0x1u << 0) /*  (PIO_LOCKSR) Lock Status. */
#define PIO_LOCKSR_P1 (0x1u << 1) /*  (PIO_LOCKSR) Lock Status. */
#define PIO_LOCKSR_P2 (0x1u << 2) /*  (PIO_LOCKSR) Lock Status. */
#define PIO_LOCKSR_P3 (0x1u << 3) /*  (PIO_LOCKSR) Lock Status. */
#define PIO_LOCKSR_P4 (0x1u << 4) /*  (PIO_LOCKSR) Lock Status. */
#define PIO_LOCKSR_P5 (0x1u << 5) /*  (PIO_LOCKSR) Lock Status. */
#define PIO_LOCKSR_P6 (0x1u << 6) /*  (PIO_LOCKSR) Lock Status. */
#define PIO_LOCKSR_P7 (0x1u << 7) /*  (PIO_LOCKSR) Lock Status. */
#define PIO_LOCKSR_P8 (0x1u << 8) /*  (PIO_LOCKSR) Lock Status. */
#define PIO_LOCKSR_P9 (0x1u << 9) /*  (PIO_LOCKSR) Lock Status. */
#define PIO_LOCKSR_P10 (0x1u << 10) /*  (PIO_LOCKSR) Lock Status. */
#define PIO_LOCKSR_P11 (0x1u << 11) /*  (PIO_LOCKSR) Lock Status. */
#define PIO_LOCKSR_P12 (0x1u << 12) /*  (PIO_LOCKSR) Lock Status. */
#define PIO_LOCKSR_P13 (0x1u << 13) /*  (PIO_LOCKSR) Lock Status. */
#define PIO_LOCKSR_P14 (0x1u << 14) /*  (PIO_LOCKSR) Lock Status. */
#define PIO_LOCKSR_P15 (0x1u << 15) /*  (PIO_LOCKSR) Lock Status. */
#define PIO_LOCKSR_P16 (0x1u << 16) /*  (PIO_LOCKSR) Lock Status. */
#define PIO_LOCKSR_P17 (0x1u << 17) /*  (PIO_LOCKSR) Lock Status. */
#define PIO_LOCKSR_P18 (0x1u << 18) /*  (PIO_LOCKSR) Lock Status. */
#define PIO_LOCKSR_P19 (0x1u << 19) /*  (PIO_LOCKSR) Lock Status. */
#define PIO_LOCKSR_P20 (0x1u << 20) /*  (PIO_LOCKSR) Lock Status. */
#define PIO_LOCKSR_P21 (0x1u << 21) /*  (PIO_LOCKSR) Lock Status. */
#define PIO_LOCKSR_P22 (0x1u << 22) /*  (PIO_LOCKSR) Lock Status. */
#define PIO_LOCKSR_P23 (0x1u << 23) /*  (PIO_LOCKSR) Lock Status. */
#define PIO_LOCKSR_P24 (0x1u << 24) /*  (PIO_LOCKSR) Lock Status. */
#define PIO_LOCKSR_P25 (0x1u << 25) /*  (PIO_LOCKSR) Lock Status. */
#define PIO_LOCKSR_P26 (0x1u << 26) /*  (PIO_LOCKSR) Lock Status. */
#define PIO_LOCKSR_P27 (0x1u << 27) /*  (PIO_LOCKSR) Lock Status. */
#define PIO_LOCKSR_P28 (0x1u << 28) /*  (PIO_LOCKSR) Lock Status. */
#define PIO_LOCKSR_P29 (0x1u << 29) /*  (PIO_LOCKSR) Lock Status. */
#define PIO_LOCKSR_P30 (0x1u << 30) /*  (PIO_LOCKSR) Lock Status. */
#define PIO_LOCKSR_P31 (0x1u << 31) /*  (PIO_LOCKSR) Lock Status. */
/* -------- PIO_WPMR : (PIO Offset: 0x00E4) Write Protect Mode Register -------- */
#define PIO_WPMR_WPEN (0x1u << 0) /*  (PIO_WPMR) Write Protect Enable */
#define PIO_WPMR_WPKEY_Pos 8
#define PIO_WPMR_WPKEY_Msk (0xffffffu << PIO_WPMR_WPKEY_Pos) /*  (PIO_WPMR) Write Protect KEY */
#define PIO_WPMR_WPKEY(value) ((PIO_WPMR_WPKEY_Msk & ((value) << PIO_WPMR_WPKEY_Pos)))
/* -------- PIO_WPSR : (PIO Offset: 0x00E8) Write Protect Status Register -------- */
#define PIO_WPSR_WPVS (0x1u << 0) /*  (PIO_WPSR) Write Protect Violation Status */
#define PIO_WPSR_WPVSRC_Pos 8
#define PIO_WPSR_WPVSRC_Msk (0xffffu << PIO_WPSR_WPVSRC_Pos) /*  (PIO_WPSR) Write Protect Violation Source */
/* -------- PIO_SCHMITT : (PIO Offset: 0x0100) Schmitt Trigger Register -------- */
#define PIO_SCHMITT_SCHMITT0 (0x1u << 0) /*  (PIO_SCHMITT)  */
#define PIO_SCHMITT_SCHMITT1 (0x1u << 1) /*  (PIO_SCHMITT)  */
#define PIO_SCHMITT_SCHMITT2 (0x1u << 2) /*  (PIO_SCHMITT)  */
#define PIO_SCHMITT_SCHMITT3 (0x1u << 3) /*  (PIO_SCHMITT)  */
#define PIO_SCHMITT_SCHMITT4 (0x1u << 4) /*  (PIO_SCHMITT)  */
#define PIO_SCHMITT_SCHMITT5 (0x1u << 5) /*  (PIO_SCHMITT)  */
#define PIO_SCHMITT_SCHMITT6 (0x1u << 6) /*  (PIO_SCHMITT)  */
#define PIO_SCHMITT_SCHMITT7 (0x1u << 7) /*  (PIO_SCHMITT)  */
#define PIO_SCHMITT_SCHMITT8 (0x1u << 8) /*  (PIO_SCHMITT)  */
#define PIO_SCHMITT_SCHMITT9 (0x1u << 9) /*  (PIO_SCHMITT)  */
#define PIO_SCHMITT_SCHMITT10 (0x1u << 10) /*  (PIO_SCHMITT)  */
#define PIO_SCHMITT_SCHMITT11 (0x1u << 11) /*  (PIO_SCHMITT)  */
#define PIO_SCHMITT_SCHMITT12 (0x1u << 12) /*  (PIO_SCHMITT)  */
#define PIO_SCHMITT_SCHMITT13 (0x1u << 13) /*  (PIO_SCHMITT)  */
#define PIO_SCHMITT_SCHMITT14 (0x1u << 14) /*  (PIO_SCHMITT)  */
#define PIO_SCHMITT_SCHMITT15 (0x1u << 15) /*  (PIO_SCHMITT)  */
#define PIO_SCHMITT_SCHMITT16 (0x1u << 16) /*  (PIO_SCHMITT)  */
#define PIO_SCHMITT_SCHMITT17 (0x1u << 17) /*  (PIO_SCHMITT)  */
#define PIO_SCHMITT_SCHMITT18 (0x1u << 18) /*  (PIO_SCHMITT)  */
#define PIO_SCHMITT_SCHMITT19 (0x1u << 19) /*  (PIO_SCHMITT)  */
#define PIO_SCHMITT_SCHMITT20 (0x1u << 20) /*  (PIO_SCHMITT)  */
#define PIO_SCHMITT_SCHMITT21 (0x1u << 21) /*  (PIO_SCHMITT)  */
#define PIO_SCHMITT_SCHMITT22 (0x1u << 22) /*  (PIO_SCHMITT)  */
#define PIO_SCHMITT_SCHMITT23 (0x1u << 23) /*  (PIO_SCHMITT)  */
#define PIO_SCHMITT_SCHMITT24 (0x1u << 24) /*  (PIO_SCHMITT)  */
#define PIO_SCHMITT_SCHMITT25 (0x1u << 25) /*  (PIO_SCHMITT)  */
#define PIO_SCHMITT_SCHMITT26 (0x1u << 26) /*  (PIO_SCHMITT)  */
#define PIO_SCHMITT_SCHMITT27 (0x1u << 27) /*  (PIO_SCHMITT)  */
#define PIO_SCHMITT_SCHMITT28 (0x1u << 28) /*  (PIO_SCHMITT)  */
#define PIO_SCHMITT_SCHMITT29 (0x1u << 29) /*  (PIO_SCHMITT)  */
#define PIO_SCHMITT_SCHMITT30 (0x1u << 30) /*  (PIO_SCHMITT)  */
#define PIO_SCHMITT_SCHMITT31 (0x1u << 31) /*  (PIO_SCHMITT)  */



/* ============================================================================= */
/*  SOFTWARE API DEFINITION FOR Pulse Width Modulation Controller */
/* ============================================================================= */

#ifndef __ASSEMBLY__
/* PwmCh_num hardware registers */
typedef struct {
  RwReg      PWM_CMR;        /*  (PwmCh_num Offset: 0x0) PWM Channel Mode Register */
  RwReg      PWM_CDTY;       /*  (PwmCh_num Offset: 0x4) PWM Channel Duty Cycle Register */
  RwReg      PWM_CPRD;       /*  (PwmCh_num Offset: 0x8) PWM Channel Period Register */
  RwReg      PWM_CCNT;       /*  (PwmCh_num Offset: 0xC) PWM Channel Counter Register */
  RwReg      PWM_CUPD;       /*  (PwmCh_num Offset: 0x10) PWM Channel Update Register */
  RwReg      Reserved1[3];  
} PwmCh_num;
/* Pwm hardware registers */
typedef struct {
  RwReg      PWM_MR;         /*  (Pwm Offset: 0x00) PWM Mode Register */
  WoReg      PWM_ENA;        /*  (Pwm Offset: 0x04) PWM Enable Register */
  WoReg      PWM_DIS;        /*  (Pwm Offset: 0x08) PWM Disable Register */
  RoReg      PWM_SR;         /*  (Pwm Offset: 0x0C) PWM Status Register */
  WoReg      PWM_IER;        /*  (Pwm Offset: 0x10) PWM Interrupt Enable Register */
  WoReg      PWM_IDR;        /*  (Pwm Offset: 0x14) PWM Interrupt Disable Register */
  RoReg      PWM_IMR;        /*  (Pwm Offset: 0x18) PWM Interrupt Mask Register */
  RoReg      PWM_ISR;        /*  (Pwm Offset: 0x1C) PWM Interrupt Status Register */
  RwReg      Reserved1[120];
  PwmCh_num  PWM_CH_NUM[4];  /*  (Pwm Offset: 0x200) ch_num = 0 .. 3 */
} Pwm;
#endif /* __ASSEMBLY__ */
/* -------- PWM_MR : (PWM Offset: 0x00) PWM Mode Register -------- */
#define PWM_MR_DIVA_Pos 0
#define PWM_MR_DIVA_Msk (0xffu << PWM_MR_DIVA_Pos) /*  (PWM_MR) CLKA, CLKB Divide Factor */
#define   PWM_MR_DIVA_CLK_OFF (0x0u << 0) /*  (PWM_MR) CLKA, CLKB clock is turned off */
#define   PWM_MR_DIVA_CLK_DIV1 (0x1u << 0) /*  (PWM_MR) CLKA, CLKB clock is clock selected by PREA, PREB */
#define PWM_MR_PREA_Pos 8
#define PWM_MR_PREA_Msk (0xfu << PWM_MR_PREA_Pos) /*  (PWM_MR)  */
#define   PWM_MR_PREA_MCK (0x0u << 8) /*  (PWM_MR) Master Clock */
#define   PWM_MR_PREA_MCKDIV2 (0x1u << 8) /*  (PWM_MR) Master Clock divided by 2 */
#define   PWM_MR_PREA_MCKDIV4 (0x2u << 8) /*  (PWM_MR) Master Clock divided by 4 */
#define   PWM_MR_PREA_MCKDIV8 (0x3u << 8) /*  (PWM_MR) Master Clock divided by 8 */
#define   PWM_MR_PREA_MCKDIV16 (0x4u << 8) /*  (PWM_MR) Master Clock divided by 16 */
#define   PWM_MR_PREA_MCKDIV32 (0x5u << 8) /*  (PWM_MR) Master Clock divided by 32 */
#define   PWM_MR_PREA_MCKDIV64 (0x6u << 8) /*  (PWM_MR) Master Clock divided by 64 */
#define   PWM_MR_PREA_MCKDIV128 (0x7u << 8) /*  (PWM_MR) Master Clock divided by 128 */
#define   PWM_MR_PREA_MCKDIV256 (0x8u << 8) /*  (PWM_MR) Master Clock divided by 256 */
#define   PWM_MR_PREA_MCKDIV512 (0x9u << 8) /*  (PWM_MR) Master Clock divided by 512 */
#define   PWM_MR_PREA_MCKDIV1024 (0xAu << 8) /*  (PWM_MR) Master Clock divided by 1024 */
#define PWM_MR_DIVB_Pos 16
#define PWM_MR_DIVB_Msk (0xffu << PWM_MR_DIVB_Pos) /*  (PWM_MR) CLKA, CLKB Divide Factor */
#define   PWM_MR_DIVB_CLK_OFF (0x0u << 16) /*  (PWM_MR) CLKA, CLKB clock is turned off */
#define   PWM_MR_DIVB_CLK_DIV1 (0x1u << 16) /*  (PWM_MR) CLKA, CLKB clock is clock selected by PREA, PREB */
#define PWM_MR_PREB_Pos 24
#define PWM_MR_PREB_Msk (0xfu << PWM_MR_PREB_Pos) /*  (PWM_MR)  */
#define   PWM_MR_PREB_MCK (0x0u << 24) /*  (PWM_MR) Master Clock */
#define   PWM_MR_PREB_MCKDIV2 (0x1u << 24) /*  (PWM_MR) Master Clock divided by 2 */
#define   PWM_MR_PREB_MCKDIV4 (0x2u << 24) /*  (PWM_MR) Master Clock divided by 4 */
#define   PWM_MR_PREB_MCKDIV8 (0x3u << 24) /*  (PWM_MR) Master Clock divided by 8 */
#define   PWM_MR_PREB_MCKDIV16 (0x4u << 24) /*  (PWM_MR) Master Clock divided by 16 */
#define   PWM_MR_PREB_MCKDIV32 (0x5u << 24) /*  (PWM_MR) Master Clock divided by 32 */
#define   PWM_MR_PREB_MCKDIV64 (0x6u << 24) /*  (PWM_MR) Master Clock divided by 64 */
#define   PWM_MR_PREB_MCKDIV128 (0x7u << 24) /*  (PWM_MR) Master Clock divided by 128 */
#define   PWM_MR_PREB_MCKDIV256 (0x8u << 24) /*  (PWM_MR) Master Clock divided by 256 */
#define   PWM_MR_PREB_MCKDIV512 (0x9u << 24) /*  (PWM_MR) Master Clock divided by 512 */
#define   PWM_MR_PREB_MCKDIV1024 (0xAu << 24) /*  (PWM_MR) Master Clock divided by 1024 */
/* -------- PWM_ENA : (PWM Offset: 0x04) PWM Enable Register -------- */
#define PWM_ENA_CHID0 (0x1u << 0) /*  (PWM_ENA) Channel ID */
#define PWM_ENA_CHID1 (0x1u << 1) /*  (PWM_ENA) Channel ID */
#define PWM_ENA_CHID2 (0x1u << 2) /*  (PWM_ENA) Channel ID */
#define PWM_ENA_CHID3 (0x1u << 3) /*  (PWM_ENA) Channel ID */
/* -------- PWM_DIS : (PWM Offset: 0x08) PWM Disable Register -------- */
#define PWM_DIS_CHID0 (0x1u << 0) /*  (PWM_DIS) Channel ID */
#define PWM_DIS_CHID1 (0x1u << 1) /*  (PWM_DIS) Channel ID */
#define PWM_DIS_CHID2 (0x1u << 2) /*  (PWM_DIS) Channel ID */
#define PWM_DIS_CHID3 (0x1u << 3) /*  (PWM_DIS) Channel ID */
/* -------- PWM_SR : (PWM Offset: 0x0C) PWM Status Register -------- */
#define PWM_SR_CHID0 (0x1u << 0) /*  (PWM_SR) Channel ID */
#define PWM_SR_CHID1 (0x1u << 1) /*  (PWM_SR) Channel ID */
#define PWM_SR_CHID2 (0x1u << 2) /*  (PWM_SR) Channel ID */
#define PWM_SR_CHID3 (0x1u << 3) /*  (PWM_SR) Channel ID */
/* -------- PWM_IER : (PWM Offset: 0x10) PWM Interrupt Enable Register -------- */
#define PWM_IER_CHID0 (0x1u << 0) /*  (PWM_IER) Channel ID. */
#define PWM_IER_CHID1 (0x1u << 1) /*  (PWM_IER) Channel ID. */
#define PWM_IER_CHID2 (0x1u << 2) /*  (PWM_IER) Channel ID. */
#define PWM_IER_CHID3 (0x1u << 3) /*  (PWM_IER) Channel ID. */
/* -------- PWM_IDR : (PWM Offset: 0x14) PWM Interrupt Disable Register -------- */
#define PWM_IDR_CHID0 (0x1u << 0) /*  (PWM_IDR) Channel ID. */
#define PWM_IDR_CHID1 (0x1u << 1) /*  (PWM_IDR) Channel ID. */
#define PWM_IDR_CHID2 (0x1u << 2) /*  (PWM_IDR) Channel ID. */
#define PWM_IDR_CHID3 (0x1u << 3) /*  (PWM_IDR) Channel ID. */
/* -------- PWM_IMR : (PWM Offset: 0x18) PWM Interrupt Mask Register -------- */
#define PWM_IMR_CHID0 (0x1u << 0) /*  (PWM_IMR) Channel ID. */
#define PWM_IMR_CHID1 (0x1u << 1) /*  (PWM_IMR) Channel ID. */
#define PWM_IMR_CHID2 (0x1u << 2) /*  (PWM_IMR) Channel ID. */
#define PWM_IMR_CHID3 (0x1u << 3) /*  (PWM_IMR) Channel ID. */
/* -------- PWM_ISR : (PWM Offset: 0x1C) PWM Interrupt Status Register -------- */
#define PWM_ISR_CHID0 (0x1u << 0) /*  (PWM_ISR) Channel ID */
#define PWM_ISR_CHID1 (0x1u << 1) /*  (PWM_ISR) Channel ID */
#define PWM_ISR_CHID2 (0x1u << 2) /*  (PWM_ISR) Channel ID */
#define PWM_ISR_CHID3 (0x1u << 3) /*  (PWM_ISR) Channel ID */
/* -------- PWM_CMR : (PWM Offset: N/A) PWM Channel Mode Register -------- */
#define PWM_CMR_CPRE_Pos 0
#define PWM_CMR_CPRE_Msk (0xfu << PWM_CMR_CPRE_Pos) /*  (PWM_CMR) Channel Pre-scaler */
#define   PWM_CMR_CPRE_MCK (0x0u << 0) /*  (PWM_CMR) Master Clock */
#define   PWM_CMR_CPRE_MCKDIV2 (0x1u << 0) /*  (PWM_CMR) Master Clock divided by 2 */
#define   PWM_CMR_CPRE_MCKDIV4 (0x2u << 0) /*  (PWM_CMR) Master Clock divided by 4 */
#define   PWM_CMR_CPRE_MCKDIV8 (0x3u << 0) /*  (PWM_CMR) Master Clock divided by 8 */
#define   PWM_CMR_CPRE_MCKDIV16 (0x4u << 0) /*  (PWM_CMR) Master Clock divided by 16 */
#define   PWM_CMR_CPRE_MCKDIV32 (0x5u << 0) /*  (PWM_CMR) Master Clock divided by 32 */
#define   PWM_CMR_CPRE_MCKDIV64 (0x6u << 0) /*  (PWM_CMR) Master Clock divided by 64 */
#define   PWM_CMR_CPRE_MCKDIV128 (0x7u << 0) /*  (PWM_CMR) Master Clock divided by 128 */
#define   PWM_CMR_CPRE_MCKDIV256 (0x8u << 0) /*  (PWM_CMR) Master Clock divided by 256 */
#define   PWM_CMR_CPRE_MCKDIV512 (0x9u << 0) /*  (PWM_CMR) Master Clock divided by 512 */
#define   PWM_CMR_CPRE_MCKDIV1024 (0xAu << 0) /*  (PWM_CMR) Master Clock divided by 1024 */
#define   PWM_CMR_CPRE_CLKA (0xBu << 0) /*  (PWM_CMR) Clock A */
#define   PWM_CMR_CPRE_CLKB (0xCu << 0) /*  (PWM_CMR) Clock B */
#define PWM_CMR_CALG (0x1u << 8) /*  (PWM_CMR) Channel Alignment */
#define PWM_CMR_CPOL (0x1u << 9) /*  (PWM_CMR) Channel Polarity */
#define PWM_CMR_CPD (0x1u << 10) /*  (PWM_CMR) Channel Update Period */
/* -------- PWM_CDTY : (PWM Offset: N/A) PWM Channel Duty Cycle Register -------- */
#define PWM_CDTY_CDTY_Pos 0
#define PWM_CDTY_CDTY_Msk (0xffffffffu << PWM_CDTY_CDTY_Pos) /*  (PWM_CDTY) Channel Duty Cycle */
#define PWM_CDTY_CDTY(value) ((PWM_CDTY_CDTY_Msk & ((value) << PWM_CDTY_CDTY_Pos)))
/* -------- PWM_CPRD : (PWM Offset: N/A) PWM Channel Period Register -------- */
#define PWM_CPRD_CPRD_Pos 0
#define PWM_CPRD_CPRD_Msk (0xffffffffu << PWM_CPRD_CPRD_Pos) /*  (PWM_CPRD) Channel Period */
#define PWM_CPRD_CPRD(value) ((PWM_CPRD_CPRD_Msk & ((value) << PWM_CPRD_CPRD_Pos)))
/* -------- PWM_CCNT : (PWM Offset: N/A) PWM Channel Counter Register -------- */
#define PWM_CCNT_CNT_Pos 0
#define PWM_CCNT_CNT_Msk (0xffffffffu << PWM_CCNT_CNT_Pos) /*  (PWM_CCNT) Channel Counter Register */
/* -------- PWM_CUPD : (PWM Offset: N/A) PWM Channel Update Register -------- */
#define PWM_CUPD_CUPD_Pos 0
#define PWM_CUPD_CUPD_Msk (0xffffffffu << PWM_CUPD_CUPD_Pos) /*  (PWM_CUPD)  */
#define PWM_CUPD_CUPD(value) ((PWM_CUPD_CUPD_Msk & ((value) << PWM_CUPD_CUPD_Pos)))


/* ============================================================================= */
/*  SOFTWARE API DEFINITION FOR Reset Controller */
/* ============================================================================= */

#ifndef __ASSEMBLY__
/* Rstc hardware registers */
typedef struct {
  WoReg RSTC_CR; /*  (Rstc Offset: 0x00) Control Register */
  RoReg RSTC_SR; /*  (Rstc Offset: 0x04) Status Register */
  RwReg RSTC_MR; /*  (Rstc Offset: 0x08) Mode Register */
} Rstc;
#endif /* __ASSEMBLY__ */
/* -------- RSTC_CR : (RSTC Offset: 0x00) Control Register -------- */
#define RSTC_CR_PROCRST (0x1u << 0) /*  (RSTC_CR) Processor Reset */
#define RSTC_CR_PERRST (0x1u << 2) /*  (RSTC_CR) Peripheral Reset */
#define RSTC_CR_EXTRST (0x1u << 3) /*  (RSTC_CR) External Reset */
#define RSTC_CR_KEY_Pos 24
#define RSTC_CR_KEY_Msk (0xffu << RSTC_CR_KEY_Pos) /*  (RSTC_CR) Password */
#define RSTC_CR_KEY(value) ((RSTC_CR_KEY_Msk & ((value) << RSTC_CR_KEY_Pos)))
/* -------- RSTC_SR : (RSTC Offset: 0x04) Status Register -------- */
#define RSTC_SR_URSTS (0x1u << 0) /*  (RSTC_SR) User Reset Status */
#define RSTC_SR_RSTTYP_Pos 8
#define RSTC_SR_RSTTYP_Msk (0x7u << RSTC_SR_RSTTYP_Pos) /*  (RSTC_SR) Reset Type */
#define RSTC_SR_NRSTL (0x1u << 16) /*  (RSTC_SR) NRST Pin Level */
#define RSTC_SR_SRCMP (0x1u << 17) /*  (RSTC_SR) Software Reset Command in Progress */
/* -------- RSTC_MR : (RSTC Offset: 0x08) Mode Register -------- */
#define RSTC_MR_URSTEN (0x1u << 0) /*  (RSTC_MR) User Reset Enable */
#define RSTC_MR_URSTIEN (0x1u << 4) /*  (RSTC_MR) User Reset Interrupt Enable */
#define RSTC_MR_ERSTL_Pos 8
#define RSTC_MR_ERSTL_Msk (0xfu << RSTC_MR_ERSTL_Pos) /*  (RSTC_MR) External Reset Length */
#define RSTC_MR_ERSTL(value) ((RSTC_MR_ERSTL_Msk & ((value) << RSTC_MR_ERSTL_Pos)))
#define RSTC_MR_KEY_Pos 24
#define RSTC_MR_KEY_Msk (0xffu << RSTC_MR_KEY_Pos) /*  (RSTC_MR) Password */
#define RSTC_MR_KEY(value) ((RSTC_MR_KEY_Msk & ((value) << RSTC_MR_KEY_Pos)))


/* ============================================================================= */
/*  SOFTWARE API DEFINITION FOR Real-time Clock */
/* ============================================================================= */

#ifndef __ASSEMBLY__
/* Rtc hardware registers */
typedef struct {
  RwReg RTC_CR;        /*  (Rtc Offset: 0x00) Control Register */
  RwReg RTC_MR;        /*  (Rtc Offset: 0x04) Mode Register */
  RwReg RTC_TIMR;      /*  (Rtc Offset: 0x08) Time Register */
  RwReg RTC_CALR;      /*  (Rtc Offset: 0x0C) Calendar Register */
  RwReg RTC_TIMALR;    /*  (Rtc Offset: 0x10) Time Alarm Register */
  RwReg RTC_CALALR;    /*  (Rtc Offset: 0x14) Calendar Alarm Register */
  RoReg RTC_SR;        /*  (Rtc Offset: 0x18) Status Register */
  WoReg RTC_SCCR;      /*  (Rtc Offset: 0x1C) Status Clear Command Register */
  WoReg RTC_IER;       /*  (Rtc Offset: 0x20) Interrupt Enable Register */
  WoReg RTC_IDR;       /*  (Rtc Offset: 0x24) Interrupt Disable Register */
  RoReg RTC_IMR;       /*  (Rtc Offset: 0x28) Interrupt Mask Register */
  RoReg RTC_VER;       /*  (Rtc Offset: 0x2C) Valid Entry Register */
  RwReg Reserved1[45];
  RwReg RTC_WPMR;      /*  (Rtc Offset: 0xE4) Write Protect Mode Register */
} Rtc;
#endif /* __ASSEMBLY__ */
/* -------- RTC_CR : (RTC Offset: 0x00) Control Register -------- */
#define RTC_CR_UPDTIM (0x1u << 0) /*  (RTC_CR) Update Request Time Register */
#define RTC_CR_UPDCAL (0x1u << 1) /*  (RTC_CR) Update Request Calendar Register */
#define RTC_CR_TIMEVSEL_Pos 8
#define RTC_CR_TIMEVSEL_Msk (0x3u << RTC_CR_TIMEVSEL_Pos) /*  (RTC_CR) Time Event Selection */
#define   RTC_CR_TIMEVSEL_MINUTE (0x0u << 8) /*  (RTC_CR) Minute change */
#define   RTC_CR_TIMEVSEL_HOUR (0x1u << 8) /*  (RTC_CR) Hour change */
#define   RTC_CR_TIMEVSEL_MIDNIGHT (0x2u << 8) /*  (RTC_CR) Every day at midnight */
#define   RTC_CR_TIMEVSEL_NOON (0x3u << 8) /*  (RTC_CR) Every day at noon */
#define RTC_CR_CALEVSEL_Pos 16
#define RTC_CR_CALEVSEL_Msk (0x3u << RTC_CR_CALEVSEL_Pos) /*  (RTC_CR) Calendar Event Selection */
#define   RTC_CR_CALEVSEL_WEEK (0x0u << 16) /*  (RTC_CR) Week change (every Monday at time 00:00:00) */
#define   RTC_CR_CALEVSEL_MONTH (0x1u << 16) /*  (RTC_CR) Month change (every 01 of each month at time 00:00:00) */
#define   RTC_CR_CALEVSEL_YEAR (0x2u << 16) /*  (RTC_CR) Year change (every January 1 at time 00:00:00) */
/* -------- RTC_MR : (RTC Offset: 0x04) Mode Register -------- */
#define RTC_MR_HRMOD (0x1u << 0) /*  (RTC_MR) 12-/24-hour Mode */
/* -------- RTC_TIMR : (RTC Offset: 0x08) Time Register -------- */
#define RTC_TIMR_SEC_Pos 0
#define RTC_TIMR_SEC_Msk (0x7fu << RTC_TIMR_SEC_Pos) /*  (RTC_TIMR) Current Second */
#define RTC_TIMR_SEC(value) ((RTC_TIMR_SEC_Msk & ((value) << RTC_TIMR_SEC_Pos)))
#define RTC_TIMR_MIN_Pos 8
#define RTC_TIMR_MIN_Msk (0x7fu << RTC_TIMR_MIN_Pos) /*  (RTC_TIMR) Current Minute */
#define RTC_TIMR_MIN(value) ((RTC_TIMR_MIN_Msk & ((value) << RTC_TIMR_MIN_Pos)))
#define RTC_TIMR_HOUR_Pos 16
#define RTC_TIMR_HOUR_Msk (0x3fu << RTC_TIMR_HOUR_Pos) /*  (RTC_TIMR) Current Hour */
#define RTC_TIMR_HOUR(value) ((RTC_TIMR_HOUR_Msk & ((value) << RTC_TIMR_HOUR_Pos)))
#define RTC_TIMR_AMPM (0x1u << 22) /*  (RTC_TIMR) Ante Meridiem Post Meridiem Indicator */
/* -------- RTC_CALR : (RTC Offset: 0x0C) Calendar Register -------- */
#define RTC_CALR_CENT_Pos 0
#define RTC_CALR_CENT_Msk (0x7fu << RTC_CALR_CENT_Pos) /*  (RTC_CALR) Current Century */
#define RTC_CALR_CENT(value) ((RTC_CALR_CENT_Msk & ((value) << RTC_CALR_CENT_Pos)))
#define RTC_CALR_YEAR_Pos 8
#define RTC_CALR_YEAR_Msk (0xffu << RTC_CALR_YEAR_Pos) /*  (RTC_CALR) Current Year */
#define RTC_CALR_YEAR(value) ((RTC_CALR_YEAR_Msk & ((value) << RTC_CALR_YEAR_Pos)))
#define RTC_CALR_MONTH_Pos 16
#define RTC_CALR_MONTH_Msk (0x1fu << RTC_CALR_MONTH_Pos) /*  (RTC_CALR) Current Month */
#define RTC_CALR_MONTH(value) ((RTC_CALR_MONTH_Msk & ((value) << RTC_CALR_MONTH_Pos)))
#define RTC_CALR_DAY_Pos 21
#define RTC_CALR_DAY_Msk (0x7u << RTC_CALR_DAY_Pos) /*  (RTC_CALR) Current Day in Current Week */
#define RTC_CALR_DAY(value) ((RTC_CALR_DAY_Msk & ((value) << RTC_CALR_DAY_Pos)))
#define RTC_CALR_DATE_Pos 24
#define RTC_CALR_DATE_Msk (0x3fu << RTC_CALR_DATE_Pos) /*  (RTC_CALR) Current Day in Current Month */
#define RTC_CALR_DATE(value) ((RTC_CALR_DATE_Msk & ((value) << RTC_CALR_DATE_Pos)))
/* -------- RTC_TIMALR : (RTC Offset: 0x10) Time Alarm Register -------- */
#define RTC_TIMALR_SEC_Pos 0
#define RTC_TIMALR_SEC_Msk (0x7fu << RTC_TIMALR_SEC_Pos) /*  (RTC_TIMALR) Second Alarm */
#define RTC_TIMALR_SEC(value) ((RTC_TIMALR_SEC_Msk & ((value) << RTC_TIMALR_SEC_Pos)))
#define RTC_TIMALR_SECEN (0x1u << 7) /*  (RTC_TIMALR) Second Alarm Enable */
#define RTC_TIMALR_MIN_Pos 8
#define RTC_TIMALR_MIN_Msk (0x7fu << RTC_TIMALR_MIN_Pos) /*  (RTC_TIMALR) Minute Alarm */
#define RTC_TIMALR_MIN(value) ((RTC_TIMALR_MIN_Msk & ((value) << RTC_TIMALR_MIN_Pos)))
#define RTC_TIMALR_MINEN (0x1u << 15) /*  (RTC_TIMALR) Minute Alarm Enable */
#define RTC_TIMALR_HOUR_Pos 16
#define RTC_TIMALR_HOUR_Msk (0x3fu << RTC_TIMALR_HOUR_Pos) /*  (RTC_TIMALR) Hour Alarm */
#define RTC_TIMALR_HOUR(value) ((RTC_TIMALR_HOUR_Msk & ((value) << RTC_TIMALR_HOUR_Pos)))
#define RTC_TIMALR_AMPM (0x1u << 22) /*  (RTC_TIMALR) AM/PM Indicator */
#define RTC_TIMALR_HOUREN (0x1u << 23) /*  (RTC_TIMALR) Hour Alarm Enable */
/* -------- RTC_CALALR : (RTC Offset: 0x14) Calendar Alarm Register -------- */
#define RTC_CALALR_MONTH_Pos 16
#define RTC_CALALR_MONTH_Msk (0x1fu << RTC_CALALR_MONTH_Pos) /*  (RTC_CALALR) Month Alarm */
#define RTC_CALALR_MONTH(value) ((RTC_CALALR_MONTH_Msk & ((value) << RTC_CALALR_MONTH_Pos)))
#define RTC_CALALR_MTHEN (0x1u << 23) /*  (RTC_CALALR) Month Alarm Enable */
#define RTC_CALALR_DATE_Pos 24
#define RTC_CALALR_DATE_Msk (0x3fu << RTC_CALALR_DATE_Pos) /*  (RTC_CALALR) Date Alarm */
#define RTC_CALALR_DATE(value) ((RTC_CALALR_DATE_Msk & ((value) << RTC_CALALR_DATE_Pos)))
#define RTC_CALALR_DATEEN (0x1u << 31) /*  (RTC_CALALR) Date Alarm Enable */
/* -------- RTC_SR : (RTC Offset: 0x18) Status Register -------- */
#define RTC_SR_ACKUPD (0x1u << 0) /*  (RTC_SR) Acknowledge for Update */
#define RTC_SR_ALARM (0x1u << 1) /*  (RTC_SR) Alarm Flag */
#define RTC_SR_SEC (0x1u << 2) /*  (RTC_SR) Second Event */
#define RTC_SR_TIMEV (0x1u << 3) /*  (RTC_SR) Time Event */
#define RTC_SR_CALEV (0x1u << 4) /*  (RTC_SR) Calendar Event */
/* -------- RTC_SCCR : (RTC Offset: 0x1C) Status Clear Command Register -------- */
#define RTC_SCCR_ACKCLR (0x1u << 0) /*  (RTC_SCCR) Acknowledge Clear */
#define RTC_SCCR_ALRCLR (0x1u << 1) /*  (RTC_SCCR) Alarm Clear */
#define RTC_SCCR_SECCLR (0x1u << 2) /*  (RTC_SCCR) Second Clear */
#define RTC_SCCR_TIMCLR (0x1u << 3) /*  (RTC_SCCR) Time Clear */
#define RTC_SCCR_CALCLR (0x1u << 4) /*  (RTC_SCCR) Calendar Clear */
/* -------- RTC_IER : (RTC Offset: 0x20) Interrupt Enable Register -------- */
#define RTC_IER_ACKEN (0x1u << 0) /*  (RTC_IER) Acknowledge Update Interrupt Enable */
#define RTC_IER_ALREN (0x1u << 1) /*  (RTC_IER) Alarm Interrupt Enable */
#define RTC_IER_SECEN (0x1u << 2) /*  (RTC_IER) Second Event Interrupt Enable */
#define RTC_IER_TIMEN (0x1u << 3) /*  (RTC_IER) Time Event Interrupt Enable */
#define RTC_IER_CALEN (0x1u << 4) /*  (RTC_IER) Calendar Event Interrupt Enable */
/* -------- RTC_IDR : (RTC Offset: 0x24) Interrupt Disable Register -------- */
#define RTC_IDR_ACKDIS (0x1u << 0) /*  (RTC_IDR) Acknowledge Update Interrupt Disable */
#define RTC_IDR_ALRDIS (0x1u << 1) /*  (RTC_IDR) Alarm Interrupt Disable */
#define RTC_IDR_SECDIS (0x1u << 2) /*  (RTC_IDR) Second Event Interrupt Disable */
#define RTC_IDR_TIMDIS (0x1u << 3) /*  (RTC_IDR) Time Event Interrupt Disable */
#define RTC_IDR_CALDIS (0x1u << 4) /*  (RTC_IDR) Calendar Event Interrupt Disable */
/* -------- RTC_IMR : (RTC Offset: 0x28) Interrupt Mask Register -------- */
#define RTC_IMR_ACK (0x1u << 0) /*  (RTC_IMR) Acknowledge Update Interrupt Mask */
#define RTC_IMR_ALR (0x1u << 1) /*  (RTC_IMR) Alarm Interrupt Mask */
#define RTC_IMR_SEC (0x1u << 2) /*  (RTC_IMR) Second Event Interrupt Mask */
#define RTC_IMR_TIM (0x1u << 3) /*  (RTC_IMR) Time Event Interrupt Mask */
#define RTC_IMR_CAL (0x1u << 4) /*  (RTC_IMR) Calendar Event Interrupt Mask */
/* -------- RTC_VER : (RTC Offset: 0x2C) Valid Entry Register -------- */
#define RTC_VER_NVTIM (0x1u << 0) /*  (RTC_VER) Non-valid Time */
#define RTC_VER_NVCAL (0x1u << 1) /*  (RTC_VER) Non-valid Calendar */
#define RTC_VER_NVTIMALR (0x1u << 2) /*  (RTC_VER) Non-valid Time Alarm */
#define RTC_VER_NVCALALR (0x1u << 3) /*  (RTC_VER) Non-valid Calendar Alarm */
/* -------- RTC_WPMR : (RTC Offset: 0xE4) Write Protect Mode Register -------- */
#define RTC_WPMR_WPEN (0x1u << 0) /*  (RTC_WPMR) Write Protect Enable */
#define RTC_WPMR_WPKEY_Pos 8
#define RTC_WPMR_WPKEY_Msk (0xffffffu << RTC_WPMR_WPKEY_Pos) /*  (RTC_WPMR)  */
#define RTC_WPMR_WPKEY(value) ((RTC_WPMR_WPKEY_Msk & ((value) << RTC_WPMR_WPKEY_Pos)))


/* ============================================================================= */
/*  SOFTWARE API DEFINITION FOR Real-time Timer */
/* ============================================================================= */

#ifndef __ASSEMBLY__
/* Rtt hardware registers */
typedef struct {
  RwReg RTT_MR; /*  (Rtt Offset: 0x00) Mode Register */
  RwReg RTT_AR; /*  (Rtt Offset: 0x04) Alarm Register */
  RoReg RTT_VR; /*  (Rtt Offset: 0x08) Value Register */
  RoReg RTT_SR; /*  (Rtt Offset: 0x0C) Status Register */
} Rtt;
#endif /* __ASSEMBLY__ */
/* -------- RTT_MR : (RTT Offset: 0x00) Mode Register -------- */
#define RTT_MR_RTPRES_Pos 0
#define RTT_MR_RTPRES_Msk (0xffffu << RTT_MR_RTPRES_Pos) /*  (RTT_MR) Real-time Timer Prescaler Value */
#define RTT_MR_RTPRES(value) ((RTT_MR_RTPRES_Msk & ((value) << RTT_MR_RTPRES_Pos)))
#define RTT_MR_ALMIEN (0x1u << 16) /*  (RTT_MR) Alarm Interrupt Enable */
#define RTT_MR_RTTINCIEN (0x1u << 17) /*  (RTT_MR) Real-time Timer Increment Interrupt Enable */
#define RTT_MR_RTTRST (0x1u << 18) /*  (RTT_MR) Real-time Timer Restart */
/* -------- RTT_AR : (RTT Offset: 0x04) Alarm Register -------- */
#define RTT_AR_ALMV_Pos 0
#define RTT_AR_ALMV_Msk (0xffffffffu << RTT_AR_ALMV_Pos) /*  (RTT_AR) Alarm Value */
#define RTT_AR_ALMV(value) ((RTT_AR_ALMV_Msk & ((value) << RTT_AR_ALMV_Pos)))
/* -------- RTT_VR : (RTT Offset: 0x08) Value Register -------- */
#define RTT_VR_CRTV_Pos 0
#define RTT_VR_CRTV_Msk (0xffffffffu << RTT_VR_CRTV_Pos) /*  (RTT_VR) Current Real-time Value */
/* -------- RTT_SR : (RTT Offset: 0x0C) Status Register -------- */
#define RTT_SR_ALMS (0x1u << 0) /*  (RTT_SR) Real-time Alarm Status */
#define RTT_SR_RTTINC (0x1u << 1) /*  (RTT_SR) Real-time Timer Increment */


/* ============================================================================= */
/*  SOFTWARE API DEFINITION FOR Serial Peripheral Interface */
/* ============================================================================= */

#ifndef __ASSEMBLY__
/* Spi hardware registers */
typedef struct {
  WoReg SPI_CR;        /*  (Spi Offset: 0x00) Control Register */
  RwReg SPI_MR;        /*  (Spi Offset: 0x04) Mode Register */
  RoReg SPI_RDR;       /*  (Spi Offset: 0x08) Receive Data Register */
  WoReg SPI_TDR;       /*  (Spi Offset: 0x0C) Transmit Data Register */
  RoReg SPI_SR;        /*  (Spi Offset: 0x10) Status Register */
  WoReg SPI_IER;       /*  (Spi Offset: 0x14) Interrupt Enable Register */
  WoReg SPI_IDR;       /*  (Spi Offset: 0x18) Interrupt Disable Register */
  RoReg SPI_IMR;       /*  (Spi Offset: 0x1C) Interrupt Mask Register */
  RwReg Reserved1[4]; 
  RwReg SPI_CSR[4];    /*  (Spi Offset: 0x30) Chip Select Register */
  RwReg Reserved2[41];
  RwReg SPI_WPMR;      /*  (Spi Offset: 0xE4) Write Protection Control Register */
  RoReg SPI_WPSR;      /*  (Spi Offset: 0xE8) Write Protection Status Register */
  RwReg Reserved3[5]; 
  RwReg SPI_RPR;       /*  (Spi Offset: 0x100) Receive Pointer Register */
  RwReg SPI_RCR;       /*  (Spi Offset: 0x104) Receive Counter Register */
  RwReg SPI_TPR;       /*  (Spi Offset: 0x108) Transmit Pointer Register */
  RwReg SPI_TCR;       /*  (Spi Offset: 0x10C) Transmit Counter Register */
  RwReg SPI_RNPR;      /*  (Spi Offset: 0x110) Receive Next Pointer Register */
  RwReg SPI_RNCR;      /*  (Spi Offset: 0x114) Receive Next Counter Register */
  RwReg SPI_TNPR;      /*  (Spi Offset: 0x118) Transmit Next Pointer Register */
  RwReg SPI_TNCR;      /*  (Spi Offset: 0x11C) Transmit Next Counter Register */
  WoReg SPI_PTCR;      /*  (Spi Offset: 0x120) Transfer Control Register */
  RoReg SPI_PTSR;      /*  (Spi Offset: 0x124) Transfer Status Register */
} Spi;
#endif /* __ASSEMBLY__ */
/* -------- SPI_CR : (SPI Offset: 0x00) Control Register -------- */
#define SPI_CR_SPIEN (0x1u << 0) /*  (SPI_CR) SPI Enable */
#define SPI_CR_SPIDIS (0x1u << 1) /*  (SPI_CR) SPI Disable */
#define SPI_CR_SWRST (0x1u << 7) /*  (SPI_CR) SPI Software Reset */
#define SPI_CR_LASTXFER (0x1u << 24) /*  (SPI_CR) Last Transfer */
/* -------- SPI_MR : (SPI Offset: 0x04) Mode Register -------- */
#define SPI_MR_MSTR (0x1u << 0) /*  (SPI_MR) Master/Slave Mode */
#define SPI_MR_PS (0x1u << 1) /*  (SPI_MR) Peripheral Select */
#define SPI_MR_PCSDEC (0x1u << 2) /*  (SPI_MR) Chip Select Decode */
#define SPI_MR_MODFDIS (0x1u << 4) /*  (SPI_MR) Mode Fault Detection */
#define SPI_MR_WDRBT (0x1u << 5) /*  (SPI_MR) Wait Data Read Before Transfer */
#define SPI_MR_LLB (0x1u << 7) /*  (SPI_MR) Local Loopback Enable */
#define SPI_MR_PCS_Pos 16
#define SPI_MR_PCS_Msk (0xfu << SPI_MR_PCS_Pos) /*  (SPI_MR) Peripheral Chip Select */
#define SPI_MR_PCS(value) ((SPI_MR_PCS_Msk & ((value) << SPI_MR_PCS_Pos)))
#define SPI_MR_DLYBCS_Pos 24
#define SPI_MR_DLYBCS_Msk (0xffu << SPI_MR_DLYBCS_Pos) /*  (SPI_MR) Delay Between Chip Selects */
#define SPI_MR_DLYBCS(value) ((SPI_MR_DLYBCS_Msk & ((value) << SPI_MR_DLYBCS_Pos)))
/* -------- SPI_RDR : (SPI Offset: 0x08) Receive Data Register -------- */
#define SPI_RDR_RD_Pos 0
#define SPI_RDR_RD_Msk (0xffffu << SPI_RDR_RD_Pos) /*  (SPI_RDR) Receive Data */
#define SPI_RDR_PCS_Pos 16
#define SPI_RDR_PCS_Msk (0xfu << SPI_RDR_PCS_Pos) /*  (SPI_RDR) Peripheral Chip Select */
/* -------- SPI_TDR : (SPI Offset: 0x0C) Transmit Data Register -------- */
#define SPI_TDR_TD_Pos 0
#define SPI_TDR_TD_Msk (0xffffu << SPI_TDR_TD_Pos) /*  (SPI_TDR) Transmit Data */
#define SPI_TDR_TD(value) ((SPI_TDR_TD_Msk & ((value) << SPI_TDR_TD_Pos)))
#define SPI_TDR_PCS_Pos 16
#define SPI_TDR_PCS_Msk (0xfu << SPI_TDR_PCS_Pos) /*  (SPI_TDR) Peripheral Chip Select */
#define SPI_TDR_PCS(value) ((SPI_TDR_PCS_Msk & ((value) << SPI_TDR_PCS_Pos)))
#define SPI_TDR_LASTXFER (0x1u << 24) /*  (SPI_TDR) Last Transfer */
/* -------- SPI_SR : (SPI Offset: 0x10) Status Register -------- */
#define SPI_SR_RDRF (0x1u << 0) /*  (SPI_SR) Receive Data Register Full */
#define SPI_SR_TDRE (0x1u << 1) /*  (SPI_SR) Transmit Data Register Empty */
#define SPI_SR_MODF (0x1u << 2) /*  (SPI_SR) Mode Fault Error */
#define SPI_SR_OVRES (0x1u << 3) /*  (SPI_SR) Overrun Error Status */
#define SPI_SR_ENDRX (0x1u << 4) /*  (SPI_SR) End of RX buffer */
#define SPI_SR_ENDTX (0x1u << 5) /*  (SPI_SR) End of TX buffer */
#define SPI_SR_RXBUFF (0x1u << 6) /*  (SPI_SR) RX Buffer Full */
#define SPI_SR_TXBUFE (0x1u << 7) /*  (SPI_SR) TX Buffer Empty */
#define SPI_SR_NSSR (0x1u << 8) /*  (SPI_SR) NSS Rising */
#define SPI_SR_TXEMPTY (0x1u << 9) /*  (SPI_SR) Transmission Registers Empty */
#define SPI_SR_UNDES (0x1u << 10) /*  (SPI_SR) Underrun Error Status (Slave Mode Only) */
#define SPI_SR_SPIENS (0x1u << 16) /*  (SPI_SR) SPI Enable Status */
/* -------- SPI_IER : (SPI Offset: 0x14) Interrupt Enable Register -------- */
#define SPI_IER_RDRF (0x1u << 0) /*  (SPI_IER) Receive Data Register Full Interrupt Enable */
#define SPI_IER_TDRE (0x1u << 1) /*  (SPI_IER) SPI Transmit Data Register Empty Interrupt Enable */
#define SPI_IER_MODF (0x1u << 2) /*  (SPI_IER) Mode Fault Error Interrupt Enable */
#define SPI_IER_OVRES (0x1u << 3) /*  (SPI_IER) Overrun Error Interrupt Enable */
#define SPI_IER_ENDRX (0x1u << 4) /*  (SPI_IER) End of Receive Buffer Interrupt Enable */
#define SPI_IER_ENDTX (0x1u << 5) /*  (SPI_IER) End of Transmit Buffer Interrupt Enable */
#define SPI_IER_RXBUFF (0x1u << 6) /*  (SPI_IER) Receive Buffer Full Interrupt Enable */
#define SPI_IER_TXBUFE (0x1u << 7) /*  (SPI_IER) Transmit Buffer Empty Interrupt Enable */
#define SPI_IER_NSSR (0x1u << 8) /*  (SPI_IER) NSS Rising Interrupt Enable */
#define SPI_IER_TXEMPTY (0x1u << 9) /*  (SPI_IER) Transmission Registers Empty Enable */
#define SPI_IER_UNDES (0x1u << 10) /*  (SPI_IER) Underrun Error Interrupt Enable */
/* -------- SPI_IDR : (SPI Offset: 0x18) Interrupt Disable Register -------- */
#define SPI_IDR_RDRF (0x1u << 0) /*  (SPI_IDR) Receive Data Register Full Interrupt Disable */
#define SPI_IDR_TDRE (0x1u << 1) /*  (SPI_IDR) SPI Transmit Data Register Empty Interrupt Disable */
#define SPI_IDR_MODF (0x1u << 2) /*  (SPI_IDR) Mode Fault Error Interrupt Disable */
#define SPI_IDR_OVRES (0x1u << 3) /*  (SPI_IDR) Overrun Error Interrupt Disable */
#define SPI_IDR_ENDRX (0x1u << 4) /*  (SPI_IDR) End of Receive Buffer Interrupt Disable */
#define SPI_IDR_ENDTX (0x1u << 5) /*  (SPI_IDR) End of Transmit Buffer Interrupt Disable */
#define SPI_IDR_RXBUFF (0x1u << 6) /*  (SPI_IDR) Receive Buffer Full Interrupt Disable */
#define SPI_IDR_TXBUFE (0x1u << 7) /*  (SPI_IDR) Transmit Buffer Empty Interrupt Disable */
#define SPI_IDR_NSSR (0x1u << 8) /*  (SPI_IDR) NSS Rising Interrupt Disable */
#define SPI_IDR_TXEMPTY (0x1u << 9) /*  (SPI_IDR) Transmission Registers Empty Disable */
#define SPI_IDR_UNDES (0x1u << 10) /*  (SPI_IDR) Underrun Error Interrupt Disable */
/* -------- SPI_IMR : (SPI Offset: 0x1C) Interrupt Mask Register -------- */
#define SPI_IMR_RDRF (0x1u << 0) /*  (SPI_IMR) Receive Data Register Full Interrupt Mask */
#define SPI_IMR_TDRE (0x1u << 1) /*  (SPI_IMR) SPI Transmit Data Register Empty Interrupt Mask */
#define SPI_IMR_MODF (0x1u << 2) /*  (SPI_IMR) Mode Fault Error Interrupt Mask */
#define SPI_IMR_OVRES (0x1u << 3) /*  (SPI_IMR) Overrun Error Interrupt Mask */
#define SPI_IMR_ENDRX (0x1u << 4) /*  (SPI_IMR) End of Receive Buffer Interrupt Mask */
#define SPI_IMR_ENDTX (0x1u << 5) /*  (SPI_IMR) End of Transmit Buffer Interrupt Mask */
#define SPI_IMR_RXBUFF (0x1u << 6) /*  (SPI_IMR) Receive Buffer Full Interrupt Mask */
#define SPI_IMR_TXBUFE (0x1u << 7) /*  (SPI_IMR) Transmit Buffer Empty Interrupt Mask */
#define SPI_IMR_NSSR (0x1u << 8) /*  (SPI_IMR) NSS Rising Interrupt Mask */
#define SPI_IMR_TXEMPTY (0x1u << 9) /*  (SPI_IMR) Transmission Registers Empty Mask */
#define SPI_IMR_UNDES (0x1u << 10) /*  (SPI_IMR) Underrun Error Interrupt Mask */
/* -------- SPI_CSR[4] : (SPI Offset: 0x30) Chip Select Register -------- */
#define SPI_CSR_CPOL (0x1u << 0) /*  (SPI_CSR[4]) Clock Polarity */
#define SPI_CSR_NCPHA (0x1u << 1) /*  (SPI_CSR[4]) Clock Phase */
#define SPI_CSR_CSNAAT (0x1u << 2) /*  (SPI_CSR[4]) Chip Select Not Active After Transfer (Ignored if CSAAT = 1) */
#define SPI_CSR_CSAAT (0x1u << 3) /*  (SPI_CSR[4]) Chip Select Not Active After Transfer (Ignored if CSAAT = 1) */
#define SPI_CSR_BITS_Pos 4
#define SPI_CSR_BITS_Msk (0xfu << SPI_CSR_BITS_Pos) /*  (SPI_CSR[4]) Bits Per Transfer */
#define   SPI_CSR_BITS_8_BIT (0x0u << 4) /*  (SPI_CSR[4]) 8_bits for transfer */
#define   SPI_CSR_BITS_9_BIT (0x1u << 4) /*  (SPI_CSR[4]) 9_bits for transfer */
#define   SPI_CSR_BITS_10_BIT (0x2u << 4) /*  (SPI_CSR[4]) 8_bits for transfer */
#define   SPI_CSR_BITS_11_BIT (0x3u << 4) /*  (SPI_CSR[4]) 8_bits for transfer */
#define   SPI_CSR_BITS_12_BIT (0x4u << 4) /*  (SPI_CSR[4]) 8_bits for transfer */
#define   SPI_CSR_BITS_13_BIT (0x5u << 4) /*  (SPI_CSR[4]) 8_bits for transfer */
#define   SPI_CSR_BITS_14_BIT (0x6u << 4) /*  (SPI_CSR[4]) 8_bits for transfer */
#define   SPI_CSR_BITS_15_BIT (0x7u << 4) /*  (SPI_CSR[4]) 8_bits for transfer */
#define   SPI_CSR_BITS_16_BIT (0x8u << 4) /*  (SPI_CSR[4]) 8_bits for transfer */
#define SPI_CSR_SCBR_Pos 8
#define SPI_CSR_SCBR_Msk (0xffu << SPI_CSR_SCBR_Pos) /*  (SPI_CSR[4]) Serial Clock Baud Rate */
#define SPI_CSR_SCBR(value) ((SPI_CSR_SCBR_Msk & ((value) << SPI_CSR_SCBR_Pos)))
#define SPI_CSR_DLYBS_Pos 16
#define SPI_CSR_DLYBS_Msk (0xffu << SPI_CSR_DLYBS_Pos) /*  (SPI_CSR[4]) Delay Before SPCK */
#define SPI_CSR_DLYBS(value) ((SPI_CSR_DLYBS_Msk & ((value) << SPI_CSR_DLYBS_Pos)))
#define SPI_CSR_DLYBCT_Pos 24
#define SPI_CSR_DLYBCT_Msk (0xffu << SPI_CSR_DLYBCT_Pos) /*  (SPI_CSR[4]) Delay Between Consecutive Transfers */
#define SPI_CSR_DLYBCT(value) ((SPI_CSR_DLYBCT_Msk & ((value) << SPI_CSR_DLYBCT_Pos)))
/* -------- SPI_WPMR : (SPI Offset: 0xE4) Write Protection Control Register -------- */
#define SPI_WPMR_SPIWPEN (0x1u << 0) /*  (SPI_WPMR) SPI Write Protection Enable */
#define SPI_WPMR_SPIWPKEY_Pos 8
#define SPI_WPMR_SPIWPKEY_Msk (0xffffffu << SPI_WPMR_SPIWPKEY_Pos) /*  (SPI_WPMR) SPI Write Protection Key Password */
#define SPI_WPMR_SPIWPKEY(value) ((SPI_WPMR_SPIWPKEY_Msk & ((value) << SPI_WPMR_SPIWPKEY_Pos)))
/* -------- SPI_WPSR : (SPI Offset: 0xE8) Write Protection Status Register -------- */
#define SPI_WPSR_SPIWPVS_Pos 0
#define SPI_WPSR_SPIWPVS_Msk (0x7u << SPI_WPSR_SPIWPVS_Pos) /*  (SPI_WPSR) SPI Write Protection Violation Status */
#define SPI_WPSR_SPIWPVSRC_Pos 8
#define SPI_WPSR_SPIWPVSRC_Msk (0xffu << SPI_WPSR_SPIWPVSRC_Pos) /*  (SPI_WPSR) SPI Write Protection Violation Source */
/* -------- SPI_RPR : (SPI Offset: 0x100) Receive Pointer Register -------- */
#define SPI_RPR_RXPTR_Pos 0
#define SPI_RPR_RXPTR_Msk (0xffffffffu << SPI_RPR_RXPTR_Pos) /*  (SPI_RPR) Receive Pointer Register */
#define SPI_RPR_RXPTR(value) ((SPI_RPR_RXPTR_Msk & ((value) << SPI_RPR_RXPTR_Pos)))
/* -------- SPI_RCR : (SPI Offset: 0x104) Receive Counter Register -------- */
#define SPI_RCR_RXCTR_Pos 0
#define SPI_RCR_RXCTR_Msk (0xffffu << SPI_RCR_RXCTR_Pos) /*  (SPI_RCR) Receive Counter Register */
#define SPI_RCR_RXCTR(value) ((SPI_RCR_RXCTR_Msk & ((value) << SPI_RCR_RXCTR_Pos)))
/* -------- SPI_TPR : (SPI Offset: 0x108) Transmit Pointer Register -------- */
#define SPI_TPR_TXPTR_Pos 0
#define SPI_TPR_TXPTR_Msk (0xffffffffu << SPI_TPR_TXPTR_Pos) /*  (SPI_TPR) Transmit Counter Register */
#define SPI_TPR_TXPTR(value) ((SPI_TPR_TXPTR_Msk & ((value) << SPI_TPR_TXPTR_Pos)))
/* -------- SPI_TCR : (SPI Offset: 0x10C) Transmit Counter Register -------- */
#define SPI_TCR_TXCTR_Pos 0
#define SPI_TCR_TXCTR_Msk (0xffffu << SPI_TCR_TXCTR_Pos) /*  (SPI_TCR) Transmit Counter Register */
#define SPI_TCR_TXCTR(value) ((SPI_TCR_TXCTR_Msk & ((value) << SPI_TCR_TXCTR_Pos)))
/* -------- SPI_RNPR : (SPI Offset: 0x110) Receive Next Pointer Register -------- */
#define SPI_RNPR_RXNPTR_Pos 0
#define SPI_RNPR_RXNPTR_Msk (0xffffffffu << SPI_RNPR_RXNPTR_Pos) /*  (SPI_RNPR) Receive Next Pointer */
#define SPI_RNPR_RXNPTR(value) ((SPI_RNPR_RXNPTR_Msk & ((value) << SPI_RNPR_RXNPTR_Pos)))
/* -------- SPI_RNCR : (SPI Offset: 0x114) Receive Next Counter Register -------- */
#define SPI_RNCR_RXNCTR_Pos 0
#define SPI_RNCR_RXNCTR_Msk (0xffffu << SPI_RNCR_RXNCTR_Pos) /*  (SPI_RNCR) Receive Next Counter */
#define SPI_RNCR_RXNCTR(value) ((SPI_RNCR_RXNCTR_Msk & ((value) << SPI_RNCR_RXNCTR_Pos)))
/* -------- SPI_TNPR : (SPI Offset: 0x118) Transmit Next Pointer Register -------- */
#define SPI_TNPR_TXNPTR_Pos 0
#define SPI_TNPR_TXNPTR_Msk (0xffffffffu << SPI_TNPR_TXNPTR_Pos) /*  (SPI_TNPR) Transmit Next Pointer */
#define SPI_TNPR_TXNPTR(value) ((SPI_TNPR_TXNPTR_Msk & ((value) << SPI_TNPR_TXNPTR_Pos)))
/* -------- SPI_TNCR : (SPI Offset: 0x11C) Transmit Next Counter Register -------- */
#define SPI_TNCR_TXNCTR_Pos 0
#define SPI_TNCR_TXNCTR_Msk (0xffffu << SPI_TNCR_TXNCTR_Pos) /*  (SPI_TNCR) Transmit Counter Next */
#define SPI_TNCR_TXNCTR(value) ((SPI_TNCR_TXNCTR_Msk & ((value) << SPI_TNCR_TXNCTR_Pos)))
/* -------- SPI_PTCR : (SPI Offset: 0x120) Transfer Control Register -------- */
#define SPI_PTCR_RXTEN (0x1u << 0) /*  (SPI_PTCR) Receiver Transfer Enable */
#define SPI_PTCR_RXTDIS (0x1u << 1) /*  (SPI_PTCR) Receiver Transfer Disable */
#define SPI_PTCR_TXTEN (0x1u << 8) /*  (SPI_PTCR) Transmitter Transfer Enable */
#define SPI_PTCR_TXTDIS (0x1u << 9) /*  (SPI_PTCR) Transmitter Transfer Disable */
/* -------- SPI_PTSR : (SPI Offset: 0x124) Transfer Status Register -------- */
#define SPI_PTSR_RXTEN (0x1u << 0) /*  (SPI_PTSR) Receiver Transfer Enable */
#define SPI_PTSR_TXTEN (0x1u << 8) /*  (SPI_PTSR) Transmitter Transfer Enable */



/* ============================================================================= */
/*  SOFTWARE API DEFINITION FOR Timer Counter */
/* ============================================================================= */

#ifndef __ASSEMBLY__
/* TcChannel hardware registers */
typedef struct {
  RwReg      TC_CCR;        /*  (TcChannel Offset: 0x0) Channel Control Register */
  RwReg      TC_CMR;        /*  (TcChannel Offset: 0x4) Channel Mode Register */
  RwReg      TC_SMMR;       /*  (TcChannel Offset: 0x8) Stepper Motor Mode Register */
  RwReg      Reserved1[1]; 
  RwReg      TC_CV;         /*  (TcChannel Offset: 0x10) Counter Value */
  RwReg      TC_RA;         /*  (TcChannel Offset: 0x14) Register A */
  RwReg      TC_RB;         /*  (TcChannel Offset: 0x18) Register B */
  RwReg      TC_RC;         /*  (TcChannel Offset: 0x1C) Register C */
  RwReg      TC_SR;         /*  (TcChannel Offset: 0x20) Status Register */
  RwReg      TC_IER;        /*  (TcChannel Offset: 0x24) Interrupt Enable Register */
  RwReg      TC_IDR;        /*  (TcChannel Offset: 0x28) Interrupt Disable Register */
  RwReg      TC_IMR;        /*  (TcChannel Offset: 0x2C) Interrupt Mask Register */
  RwReg      Reserved2[4]; 
} TcChannel;
/* Tc hardware registers */
typedef struct {
  TcChannel  TC_CHANNEL[3]; /*  (Tc Offset: 0x0) channel = 0 .. 2 */
  WoReg      TC_BCR;        /*  (Tc Offset: 0xC0) Block Control Register */
  RwReg      TC_BMR;        /*  (Tc Offset: 0xC4) Block Mode Register */
  WoReg      TC_QIER;       /*  (Tc Offset: 0xC8) QDEC Interrupt Enable Register */
  WoReg      TC_QIDR;       /*  (Tc Offset: 0xCC) QDEC Interrupt Disable Register */
  RoReg      TC_QIMR;       /*  (Tc Offset: 0xD0) QDEC Interrupt Mask Register */
  RoReg      TC_QISR;       /*  (Tc Offset: 0xD4) QDEC Interrupt Status Register */
  RwReg      Reserved1[3]; 
  RwReg      TC_WPMR;       /*  (Tc Offset: 0xE4) Write Protect Mode Register */
} Tc;
#endif /* __ASSEMBLY__ */
/* -------- TC_CCR : (TC Offset: N/A) Channel Control Register -------- */
#define TC_CCR_CLKEN (0x1u << 0) /*  (TC_CCR) Counter Clock Enable Command */
#define TC_CCR_CLKDIS (0x1u << 1) /*  (TC_CCR) Counter Clock Disable Command */
#define TC_CCR_SWTRG (0x1u << 2) /*  (TC_CCR) Software Trigger Command */
/* -------- TC_CMR : (TC Offset: N/A) Channel Mode Register -------- */
#define TC_CMR_TCCLKS_Pos 0
#define TC_CMR_TCCLKS_Msk (0x7u << TC_CMR_TCCLKS_Pos) /*  (TC_CMR) Clock Selection */
#define   TC_CMR_TCCLKS_TIMER_CLOCK1 (0x0u << 0) /*  (TC_CMR) Clock selected: TCLK1 */
#define   TC_CMR_TCCLKS_TIMER_CLOCK2 (0x1u << 0) /*  (TC_CMR) Clock selected: TCLK2 */
#define   TC_CMR_TCCLKS_TIMER_CLOCK3 (0x2u << 0) /*  (TC_CMR) Clock selected: TCLK3 */
#define   TC_CMR_TCCLKS_TIMER_CLOCK4 (0x3u << 0) /*  (TC_CMR) Clock selected: TCLK4 */
#define   TC_CMR_TCCLKS_TIMER_CLOCK5 (0x4u << 0) /*  (TC_CMR) Clock selected: TCLK5 */
#define   TC_CMR_TCCLKS_XC0 (0x5u << 0) /*  (TC_CMR) Clock selected: XC0 */
#define   TC_CMR_TCCLKS_XC1 (0x6u << 0) /*  (TC_CMR) Clock selected: XC1 */
#define   TC_CMR_TCCLKS_XC2 (0x7u << 0) /*  (TC_CMR) Clock selected: XC2 */
#define TC_CMR_CLKI (0x1u << 3) /*  (TC_CMR) Clock Invert */
#define TC_CMR_BURST_Pos 4
#define TC_CMR_BURST_Msk (0x3u << TC_CMR_BURST_Pos) /*  (TC_CMR) Burst Signal Selection */
#define   TC_CMR_BURST_NONE (0x0u << 4) /*  (TC_CMR) The clock is not gated by an external signal. */
#define   TC_CMR_BURST_XC0 (0x1u << 4) /*  (TC_CMR) XC0 is ANDed with the selected clock. */
#define   TC_CMR_BURST_XC1 (0x2u << 4) /*  (TC_CMR) XC1 is ANDed with the selected clock. */
#define   TC_CMR_BURST_XC2 (0x3u << 4) /*  (TC_CMR) XC2 is ANDed with the selected clock. */
#define TC_CMR_LDBSTOP (0x1u << 6) /*  (TC_CMR) Counter Clock Stopped with RB Loading */
#define TC_CMR_LDBDIS (0x1u << 7) /*  (TC_CMR) Counter Clock Disable with RB Loading */
#define TC_CMR_ETRGEDG_Pos 8
#define TC_CMR_ETRGEDG_Msk (0x3u << TC_CMR_ETRGEDG_Pos) /*  (TC_CMR) External Trigger Edge Selection */
#define   TC_CMR_ETRGEDG_NONE (0x0u << 8) /*  (TC_CMR) The clock is not gated by an external signal. */
#define   TC_CMR_ETRGEDG_RISING (0x1u << 8) /*  (TC_CMR) Rising edge */
#define   TC_CMR_ETRGEDG_FALLING (0x2u << 8) /*  (TC_CMR) Falling edge */
#define   TC_CMR_ETRGEDG_EDGE (0x3u << 8) /*  (TC_CMR) Each edge */
#define TC_CMR_ABETRG (0x1u << 10) /*  (TC_CMR) TIOA or TIOB External Trigger Selection */
#define TC_CMR_CPCTRG (0x1u << 14) /*  (TC_CMR) RC Compare Trigger Enable */
#define TC_CMR_WAVE (0x1u << 15) /*  (TC_CMR)  */
#define TC_CMR_LDRA_Pos 16
#define TC_CMR_LDRA_Msk (0x3u << TC_CMR_LDRA_Pos) /*  (TC_CMR) RA Loading Selection */
#define   TC_CMR_LDRA_NONE (0x0u << 16) /*  (TC_CMR) None */
#define   TC_CMR_LDRA_RISING (0x1u << 16) /*  (TC_CMR) Rising edge of TIOA */
#define   TC_CMR_LDRA_FALLING (0x2u << 16) /*  (TC_CMR) Falling edge of TIOA */
#define   TC_CMR_LDRA_EDGE (0x3u << 16) /*  (TC_CMR) Each edge of TIOA */
#define TC_CMR_LDRB_Pos 18
#define TC_CMR_LDRB_Msk (0x3u << TC_CMR_LDRB_Pos) /*  (TC_CMR) RB Loading Selection */
#define   TC_CMR_LDRB_NONE (0x0u << 18) /*  (TC_CMR) None */
#define   TC_CMR_LDRB_RISING (0x1u << 18) /*  (TC_CMR) Rising edge of TIOA */
#define   TC_CMR_LDRB_FALLING (0x2u << 18) /*  (TC_CMR) Falling edge of TIOA */
#define   TC_CMR_LDRB_EDGE (0x3u << 18) /*  (TC_CMR) Each edge of TIOA */
#define TC_CMR_CPCSTOP (0x1u << 6) /*  (TC_CMR) Counter Clock Stopped with RC Compare */
#define TC_CMR_CPCDIS (0x1u << 7) /*  (TC_CMR) Counter Clock Disable with RC Compare */
#define TC_CMR_EEVTEDG_Pos 8
#define TC_CMR_EEVTEDG_Msk (0x3u << TC_CMR_EEVTEDG_Pos) /*  (TC_CMR) External Event Edge Selection */
#define   TC_CMR_EEVTEDG_NONE (0x0u << 8) /*  (TC_CMR) None */
#define   TC_CMR_EEVTEDG_RISING (0x1u << 8) /*  (TC_CMR) Rising edge */
#define   TC_CMR_EEVTEDG_FALLING (0x2u << 8) /*  (TC_CMR) Falling edge */
#define   TC_CMR_EEVTEDG_EDGE (0x3u << 8) /*  (TC_CMR) Each edge */
#define TC_CMR_EEVT_Pos 10
#define TC_CMR_EEVT_Msk (0x3u << TC_CMR_EEVT_Pos) /*  (TC_CMR) External Event Selection */
#define   TC_CMR_EEVT_TIOB (0x0u << 10) /*  (TC_CMR) TIOB */
#define   TC_CMR_EEVT_XC0 (0x1u << 10) /*  (TC_CMR) XC0 */
#define   TC_CMR_EEVT_XC1 (0x2u << 10) /*  (TC_CMR) XC1 */
#define   TC_CMR_EEVT_XC2 (0x3u << 10) /*  (TC_CMR) XC2 */
#define TC_CMR_ENETRG (0x1u << 12) /*  (TC_CMR) External Event Trigger Enable */
#define TC_CMR_WAVSEL_Pos 13
#define TC_CMR_WAVSEL_Msk (0x3u << TC_CMR_WAVSEL_Pos) /*  (TC_CMR) Waveform Selection */
#define   TC_CMR_WAVSEL_UP (0x0u << 13) /*  (TC_CMR) UP mode without automatic trigger on RC Compare */
#define   TC_CMR_WAVSEL_UPDOWN (0x1u << 13) /*  (TC_CMR) UPDOWN mode without automatic trigger on RC Compare */
#define   TC_CMR_WAVSEL_UP_RC (0x2u << 13) /*  (TC_CMR) UP mode with automatic trigger on RC Compare */
#define   TC_CMR_WAVSEL_UPDOWN_RC (0x3u << 13) /*  (TC_CMR) UPDOWN mode with automatic trigger on RC Compare */
#define TC_CMR_ACPA_Pos 16
#define TC_CMR_ACPA_Msk (0x3u << TC_CMR_ACPA_Pos) /*  (TC_CMR) RA Compare Effect on TIOA */
#define   TC_CMR_ACPA_NONE (0x0u << 16) /*  (TC_CMR) None */
#define   TC_CMR_ACPA_SET (0x1u << 16) /*  (TC_CMR) Set */
#define   TC_CMR_ACPA_CLEAR (0x2u << 16) /*  (TC_CMR) Clear */
#define   TC_CMR_ACPA_TOGGLE (0x3u << 16) /*  (TC_CMR) Toggle */
#define TC_CMR_ACPC_Pos 18
#define TC_CMR_ACPC_Msk (0x3u << TC_CMR_ACPC_Pos) /*  (TC_CMR) RC Compare Effect on TIOA */
#define   TC_CMR_ACPC_NONE (0x0u << 18) /*  (TC_CMR) None */
#define   TC_CMR_ACPC_SET (0x1u << 18) /*  (TC_CMR) Set */
#define   TC_CMR_ACPC_CLEAR (0x2u << 18) /*  (TC_CMR) Clear */
#define   TC_CMR_ACPC_TOGGLE (0x3u << 18) /*  (TC_CMR) Toggle */
#define TC_CMR_AEEVT_Pos 20
#define TC_CMR_AEEVT_Msk (0x3u << TC_CMR_AEEVT_Pos) /*  (TC_CMR) External Event Effect on TIOA */
#define   TC_CMR_AEEVT_NONE (0x0u << 20) /*  (TC_CMR) None */
#define   TC_CMR_AEEVT_SET (0x1u << 20) /*  (TC_CMR) Set */
#define   TC_CMR_AEEVT_CLEAR (0x2u << 20) /*  (TC_CMR) Clear */
#define   TC_CMR_AEEVT_TOGGLE (0x3u << 20) /*  (TC_CMR) Toggle */
#define TC_CMR_ASWTRG_Pos 22
#define TC_CMR_ASWTRG_Msk (0x3u << TC_CMR_ASWTRG_Pos) /*  (TC_CMR) Software Trigger Effect on TIOA */
#define   TC_CMR_ASWTRG_NONE (0x0u << 22) /*  (TC_CMR) None */
#define   TC_CMR_ASWTRG_SET (0x1u << 22) /*  (TC_CMR) Set */
#define   TC_CMR_ASWTRG_CLEAR (0x2u << 22) /*  (TC_CMR) Clear */
#define   TC_CMR_ASWTRG_TOGGLE (0x3u << 22) /*  (TC_CMR) Toggle */
#define TC_CMR_BCPB_Pos 24
#define TC_CMR_BCPB_Msk (0x3u << TC_CMR_BCPB_Pos) /*  (TC_CMR) RB Compare Effect on TIOB */
#define   TC_CMR_BCPB_NONE (0x0u << 24) /*  (TC_CMR) None */
#define   TC_CMR_BCPB_SET (0x1u << 24) /*  (TC_CMR) Set */
#define   TC_CMR_BCPB_CLEAR (0x2u << 24) /*  (TC_CMR) Clear */
#define   TC_CMR_BCPB_TOGGLE (0x3u << 24) /*  (TC_CMR) Toggle */
#define TC_CMR_BCPC_Pos 26
#define TC_CMR_BCPC_Msk (0x3u << TC_CMR_BCPC_Pos) /*  (TC_CMR) RC Compare Effect on TIOB */
#define   TC_CMR_BCPC_NONE (0x0u << 26) /*  (TC_CMR) None */
#define   TC_CMR_BCPC_SET (0x1u << 26) /*  (TC_CMR) Set */
#define   TC_CMR_BCPC_CLEAR (0x2u << 26) /*  (TC_CMR) Clear */
#define   TC_CMR_BCPC_TOGGLE (0x3u << 26) /*  (TC_CMR) Toggle */
#define TC_CMR_BEEVT_Pos 28
#define TC_CMR_BEEVT_Msk (0x3u << TC_CMR_BEEVT_Pos) /*  (TC_CMR) External Event Effect on TIOB */
#define   TC_CMR_BEEVT_NONE (0x0u << 28) /*  (TC_CMR) None */
#define   TC_CMR_BEEVT_SET (0x1u << 28) /*  (TC_CMR) Set */
#define   TC_CMR_BEEVT_CLEAR (0x2u << 28) /*  (TC_CMR) Clear */
#define   TC_CMR_BEEVT_TOGGLE (0x3u << 28) /*  (TC_CMR) Toggle */
#define TC_CMR_BSWTRG_Pos 30
#define TC_CMR_BSWTRG_Msk (0x3u << TC_CMR_BSWTRG_Pos) /*  (TC_CMR) Software Trigger Effect on TIOB */
#define   TC_CMR_BSWTRG_NONE (0x0u << 30) /*  (TC_CMR) None */
#define   TC_CMR_BSWTRG_SET (0x1u << 30) /*  (TC_CMR) Set */
#define   TC_CMR_BSWTRG_CLEAR (0x2u << 30) /*  (TC_CMR) Clear */
#define   TC_CMR_BSWTRG_TOGGLE (0x3u << 30) /*  (TC_CMR) Toggle */
/* -------- TC_SMMR : (TC Offset: N/A) Stepper Motor Mode Register -------- */
#define TC_SMMR_GCEN (0x1u << 0) /*  (TC_SMMR) Gray Count Enable */
#define TC_SMMR_DOWN (0x1u << 1) /*  (TC_SMMR) DOWN Count */
/* -------- TC_CV : (TC Offset: N/A) Counter Value -------- */
#define TC_CV_CV_Pos 0
#define TC_CV_CV_Msk (0xffffffffu << TC_CV_CV_Pos) /*  (TC_CV) Counter Value */
/* -------- TC_RA : (TC Offset: N/A) Register A -------- */
#define TC_RA_RA_Pos 0
#define TC_RA_RA_Msk (0xffffffffu << TC_RA_RA_Pos) /*  (TC_RA) Register A */
#define TC_RA_RA(value) ((TC_RA_RA_Msk & ((value) << TC_RA_RA_Pos)))
/* -------- TC_RB : (TC Offset: N/A) Register B -------- */
#define TC_RB_RB_Pos 0
#define TC_RB_RB_Msk (0xffffffffu << TC_RB_RB_Pos) /*  (TC_RB) Register B */
#define TC_RB_RB(value) ((TC_RB_RB_Msk & ((value) << TC_RB_RB_Pos)))
/* -------- TC_RC : (TC Offset: N/A) Register C -------- */
#define TC_RC_RC_Pos 0
#define TC_RC_RC_Msk (0xffffffffu << TC_RC_RC_Pos) /*  (TC_RC) Register C */
#define TC_RC_RC(value) ((TC_RC_RC_Msk & ((value) << TC_RC_RC_Pos)))
/* -------- TC_SR : (TC Offset: N/A) Status Register -------- */
#define TC_SR_COVFS (0x1u << 0) /*  (TC_SR) Counter Overflow Status */
#define TC_SR_LOVRS (0x1u << 1) /*  (TC_SR) Load Overrun Status */
#define TC_SR_CPAS (0x1u << 2) /*  (TC_SR) RA Compare Status */
#define TC_SR_CPBS (0x1u << 3) /*  (TC_SR) RB Compare Status */
#define TC_SR_CPCS (0x1u << 4) /*  (TC_SR) RC Compare Status */
#define TC_SR_LDRAS (0x1u << 5) /*  (TC_SR) RA Loading Status */
#define TC_SR_LDRBS (0x1u << 6) /*  (TC_SR) RB Loading Status */
#define TC_SR_ETRGS (0x1u << 7) /*  (TC_SR) External Trigger Status */
#define TC_SR_CLKSTA (0x1u << 16) /*  (TC_SR) Clock Enabling Status */
#define TC_SR_MTIOA (0x1u << 17) /*  (TC_SR) TIOA Mirror */
#define TC_SR_MTIOB (0x1u << 18) /*  (TC_SR) TIOB Mirror */
/* -------- TC_IER : (TC Offset: N/A) Interrupt Enable Register -------- */
#define TC_IER_COVFS (0x1u << 0) /*  (TC_IER) Counter Overflow */
#define TC_IER_LOVRS (0x1u << 1) /*  (TC_IER) Load Overrun */
#define TC_IER_CPAS (0x1u << 2) /*  (TC_IER) RA Compare */
#define TC_IER_CPBS (0x1u << 3) /*  (TC_IER) RB Compare */
#define TC_IER_CPCS (0x1u << 4) /*  (TC_IER) RC Compare */
#define TC_IER_LDRAS (0x1u << 5) /*  (TC_IER) RA Loading */
#define TC_IER_LDRBS (0x1u << 6) /*  (TC_IER) RB Loading */
#define TC_IER_ETRGS (0x1u << 7) /*  (TC_IER) External Trigger */
/* -------- TC_IDR : (TC Offset: N/A) Interrupt Disable Register -------- */
#define TC_IDR_COVFS (0x1u << 0) /*  (TC_IDR) Counter Overflow */
#define TC_IDR_LOVRS (0x1u << 1) /*  (TC_IDR) Load Overrun */
#define TC_IDR_CPAS (0x1u << 2) /*  (TC_IDR) RA Compare */
#define TC_IDR_CPBS (0x1u << 3) /*  (TC_IDR) RB Compare */
#define TC_IDR_CPCS (0x1u << 4) /*  (TC_IDR) RC Compare */
#define TC_IDR_LDRAS (0x1u << 5) /*  (TC_IDR) RA Loading */
#define TC_IDR_LDRBS (0x1u << 6) /*  (TC_IDR) RB Loading */
#define TC_IDR_ETRGS (0x1u << 7) /*  (TC_IDR) External Trigger */
/* -------- TC_IMR : (TC Offset: N/A) Interrupt Mask Register -------- */
#define TC_IMR_COVFS (0x1u << 0) /*  (TC_IMR) Counter Overflow */
#define TC_IMR_LOVRS (0x1u << 1) /*  (TC_IMR) Load Overrun */
#define TC_IMR_CPAS (0x1u << 2) /*  (TC_IMR) RA Compare */
#define TC_IMR_CPBS (0x1u << 3) /*  (TC_IMR) RB Compare */
#define TC_IMR_CPCS (0x1u << 4) /*  (TC_IMR) RC Compare */
#define TC_IMR_LDRAS (0x1u << 5) /*  (TC_IMR) RA Loading */
#define TC_IMR_LDRBS (0x1u << 6) /*  (TC_IMR) RB Loading */
#define TC_IMR_ETRGS (0x1u << 7) /*  (TC_IMR) External Trigger */
/* -------- TC_BCR : (TC Offset: 0xC0) Block Control Register -------- */
#define TC_BCR_SYNC (0x1u << 0) /*  (TC_BCR) Synchro Command */
/* -------- TC_BMR : (TC Offset: 0xC4) Block Mode Register -------- */
#define TC_BMR_TC0XC0S_Pos 0
#define TC_BMR_TC0XC0S_Msk (0x3u << TC_BMR_TC0XC0S_Pos) /*  (TC_BMR) External Clock Signal 0 Selection */
#define   TC_BMR_TC0XC0S_TCLK0 (0x0u << 0) /*  (TC_BMR) Signal connected to XC0: TCLK0 */
#define   TC_BMR_TC0XC0S_TIOA1 (0x2u << 0) /*  (TC_BMR) Signal connected to XC0: TIOA1 */
#define   TC_BMR_TC0XC0S_TIOA2 (0x3u << 0) /*  (TC_BMR) Signal connected to XC0: TIOA2 */
#define TC_BMR_TC1XC1S_Pos 2
#define TC_BMR_TC1XC1S_Msk (0x3u << TC_BMR_TC1XC1S_Pos) /*  (TC_BMR) External Clock Signal 1 Selection */
#define   TC_BMR_TC1XC1S_TCLK1 (0x0u << 2) /*  (TC_BMR) Signal connected to XC1: TCLK1 */
#define   TC_BMR_TC1XC1S_TIOA0 (0x2u << 2) /*  (TC_BMR) Signal connected to XC1: TIOA0 */
#define   TC_BMR_TC1XC1S_TIOA2 (0x3u << 2) /*  (TC_BMR) Signal connected to XC1: TIOA2 */
#define TC_BMR_TC2XC2S_Pos 4
#define TC_BMR_TC2XC2S_Msk (0x3u << TC_BMR_TC2XC2S_Pos) /*  (TC_BMR) External Clock Signal 2 Selection */
#define   TC_BMR_TC2XC2S_TCLK2 (0x0u << 4) /*  (TC_BMR) Signal connected to XC2: TCLK2 */
#define   TC_BMR_TC2XC2S_TIOA1 (0x2u << 4) /*  (TC_BMR) Signal connected to XC2: TIOA1 */
#define   TC_BMR_TC2XC2S_TIOA2 (0x3u << 4) /*  (TC_BMR) Signal connected to XC2: TIOA2 */
#define TC_BMR_QDEN (0x1u << 8) /*  (TC_BMR) Quadrature Decoder ENabled */
#define TC_BMR_POSEN (0x1u << 9) /*  (TC_BMR) POSition ENabled */
#define TC_BMR_SPEEDEN (0x1u << 10) /*  (TC_BMR) SPEED ENabled */
#define TC_BMR_QDTRANS (0x1u << 11) /*  (TC_BMR) Quadrature Decoding TRANSparent */
#define TC_BMR_EDGPHA (0x1u << 12) /*  (TC_BMR) EDGe on PHA count mode */
#define TC_BMR_INVA (0x1u << 13) /*  (TC_BMR) INVerted phA */
#define TC_BMR_INVB (0x1u << 14) /*  (TC_BMR) INVerted phB */
#define TC_BMR_INVIDX (0x1u << 15) /*  (TC_BMR) INVerted InDeX */
#define TC_BMR_SWAP (0x1u << 16) /*  (TC_BMR) SWAP PHA and PHB */
#define TC_BMR_IDXPHB (0x1u << 17) /*  (TC_BMR) InDeX pin is PHB pin */
#define TC_BMR_FILTER (0x1u << 19) /*  (TC_BMR)  */
#define TC_BMR_MAXFILT_Pos 20
#define TC_BMR_MAXFILT_Msk (0x3fu << TC_BMR_MAXFILT_Pos) /*  (TC_BMR) MAXimum FILTer */
#define TC_BMR_MAXFILT(value) ((TC_BMR_MAXFILT_Msk & ((value) << TC_BMR_MAXFILT_Pos)))
/* -------- TC_QIER : (TC Offset: 0xC8) QDEC Interrupt Enable Register -------- */
#define TC_QIER_IDX (0x1u << 0) /*  (TC_QIER) InDeX */
#define TC_QIER_DIRCHG (0x1u << 1) /*  (TC_QIER) DIRection CHanGe */
#define TC_QIER_QERR (0x1u << 2) /*  (TC_QIER) Quadrature ERRor */
/* -------- TC_QIDR : (TC Offset: 0xCC) QDEC Interrupt Disable Register -------- */
#define TC_QIDR_IDX (0x1u << 0) /*  (TC_QIDR) InDeX */
#define TC_QIDR_DIRCHG (0x1u << 1) /*  (TC_QIDR) DIRection CHanGe */
#define TC_QIDR_QERR (0x1u << 2) /*  (TC_QIDR) Quadrature ERRor */
/* -------- TC_QIMR : (TC Offset: 0xD0) QDEC Interrupt Mask Register -------- */
#define TC_QIMR_IDX (0x1u << 0) /*  (TC_QIMR) InDeX */
#define TC_QIMR_DIRCHG (0x1u << 1) /*  (TC_QIMR) DIRection CHanGe */
#define TC_QIMR_QERR (0x1u << 2) /*  (TC_QIMR) Quadrature ERRor */
/* -------- TC_QISR : (TC Offset: 0xD4) QDEC Interrupt Status Register -------- */
#define TC_QISR_IDX (0x1u << 0) /*  (TC_QISR) InDeX */
#define TC_QISR_DIRCHG (0x1u << 1) /*  (TC_QISR) DIRection CHanGe */
#define TC_QISR_QERR (0x1u << 2) /*  (TC_QISR) Quadrature ERRor */
#define TC_QISR_DIR (0x1u << 8) /*  (TC_QISR) Direction */
/* -------- TC_WPMR : (TC Offset: 0xE4) Write Protect Mode Register -------- */
#define TC_WPMR_WPEN (0x1u << 0) /*  (TC_WPMR) Write Protect Enable */
#define TC_WPMR_WPKEY_Pos 8
#define TC_WPMR_WPKEY_Msk (0xffffffu << TC_WPMR_WPKEY_Pos) /*  (TC_WPMR) Write Protect KEY */
#define TC_WPMR_WPKEY(value) ((TC_WPMR_WPKEY_Msk & ((value) << TC_WPMR_WPKEY_Pos)))


/* ============================================================================= */
/*  SOFTWARE API DEFINITION FOR Two-wire Interface */
/* ============================================================================= */

#ifndef __ASSEMBLY__
/* Twi hardware registers */
typedef struct {
  WoReg TWI_CR;        /*  (Twi Offset: 0x00) Control Register */
  RwReg TWI_MMR;       /*  (Twi Offset: 0x04) Master Mode Register */
  RwReg TWI_SMR;       /*  (Twi Offset: 0x08) Slave Mode Register */
  RwReg TWI_IADR;      /*  (Twi Offset: 0x0C) Internal Address Register */
  RwReg TWI_CWGR;      /*  (Twi Offset: 0x10) Clock Waveform Generator Register */
  RwReg Reserved1[3]; 
  RoReg TWI_SR;        /*  (Twi Offset: 0x20) Status Register */
  WoReg TWI_IER;       /*  (Twi Offset: 0x24) Interrupt Enable Register */
  WoReg TWI_IDR;       /*  (Twi Offset: 0x28) Interrupt Disable Register */
  RoReg TWI_IMR;       /*  (Twi Offset: 0x2C) Interrupt Mask Register */
  RoReg TWI_RHR;       /*  (Twi Offset: 0x30) Receive Holding Register */
  WoReg TWI_THR;       /*  (Twi Offset: 0x34) Transmit Holding Register */
  RwReg Reserved2[50];
  RwReg TWI_RPR;       /*  (Twi Offset: 0x100) Receive Pointer Register */
  RwReg TWI_RCR;       /*  (Twi Offset: 0x104) Receive Counter Register */
  RwReg TWI_TPR;       /*  (Twi Offset: 0x108) Transmit Pointer Register */
  RwReg TWI_TCR;       /*  (Twi Offset: 0x10C) Transmit Counter Register */
  RwReg TWI_RNPR;      /*  (Twi Offset: 0x110) Receive Next Pointer Register */
  RwReg TWI_RNCR;      /*  (Twi Offset: 0x114) Receive Next Counter Register */
  RwReg TWI_TNPR;      /*  (Twi Offset: 0x118) Transmit Next Pointer Register */
  RwReg TWI_TNCR;      /*  (Twi Offset: 0x11C) Transmit Next Counter Register */
  WoReg TWI_PTCR;      /*  (Twi Offset: 0x120) Transfer Control Register */
  RoReg TWI_PTSR;      /*  (Twi Offset: 0x124) Transfer Status Register */
} Twi;
#endif /* __ASSEMBLY__ */
/* -------- TWI_CR : (TWI Offset: 0x00) Control Register -------- */
#define TWI_CR_START (0x1u << 0) /*  (TWI_CR) Send a START Condition */
#define TWI_CR_STOP (0x1u << 1) /*  (TWI_CR) Send a STOP Condition */
#define TWI_CR_MSEN (0x1u << 2) /*  (TWI_CR) TWI Master Mode Enabled */
#define TWI_CR_MSDIS (0x1u << 3) /*  (TWI_CR) TWI Master Mode Disabled */
#define TWI_CR_SVEN (0x1u << 4) /*  (TWI_CR) TWI Slave Mode Enabled */
#define TWI_CR_SVDIS (0x1u << 5) /*  (TWI_CR) TWI Slave Mode Disabled */
#define TWI_CR_QUICK (0x1u << 6) /*  (TWI_CR) SMBUS Quick Command */
#define TWI_CR_SWRST (0x1u << 7) /*  (TWI_CR) Software Reset */
/* -------- TWI_MMR : (TWI Offset: 0x04) Master Mode Register -------- */
#define TWI_MMR_IADRSZ_Pos 8
#define TWI_MMR_IADRSZ_Msk (0x3u << TWI_MMR_IADRSZ_Pos) /*  (TWI_MMR) Internal Device Address Size */
#define   TWI_MMR_IADRSZ_NONE (0x0u << 8) /*  (TWI_MMR) No internal device address */
#define   TWI_MMR_IADRSZ_1_BYTE (0x1u << 8) /*  (TWI_MMR) One-byte internal device address */
#define   TWI_MMR_IADRSZ_2_BYTE (0x2u << 8) /*  (TWI_MMR) Two-byte internal device address */
#define   TWI_MMR_IADRSZ_3_BYTE (0x3u << 8) /*  (TWI_MMR) Three-byte internal device address */
#define TWI_MMR_MREAD (0x1u << 12) /*  (TWI_MMR) Master Read Direction */
#define TWI_MMR_DADR_Pos 16
#define TWI_MMR_DADR_Msk (0x7fu << TWI_MMR_DADR_Pos) /*  (TWI_MMR) Device Address */
#define TWI_MMR_DADR(value) ((TWI_MMR_DADR_Msk & ((value) << TWI_MMR_DADR_Pos)))
/* -------- TWI_SMR : (TWI Offset: 0x08) Slave Mode Register -------- */
#define TWI_SMR_SADR_Pos 16
#define TWI_SMR_SADR_Msk (0x7fu << TWI_SMR_SADR_Pos) /*  (TWI_SMR) Slave Address */
#define TWI_SMR_SADR(value) ((TWI_SMR_SADR_Msk & ((value) << TWI_SMR_SADR_Pos)))
/* -------- TWI_IADR : (TWI Offset: 0x0C) Internal Address Register -------- */
#define TWI_IADR_IADR_Pos 0
#define TWI_IADR_IADR_Msk (0xffffffu << TWI_IADR_IADR_Pos) /*  (TWI_IADR) Internal Address */
#define TWI_IADR_IADR(value) ((TWI_IADR_IADR_Msk & ((value) << TWI_IADR_IADR_Pos)))
/* -------- TWI_CWGR : (TWI Offset: 0x10) Clock Waveform Generator Register -------- */
#define TWI_CWGR_CLDIV_Pos 0
#define TWI_CWGR_CLDIV_Msk (0xffu << TWI_CWGR_CLDIV_Pos) /*  (TWI_CWGR) Clock Low Divider */
#define TWI_CWGR_CLDIV(value) ((TWI_CWGR_CLDIV_Msk & ((value) << TWI_CWGR_CLDIV_Pos)))
#define TWI_CWGR_CHDIV_Pos 8
#define TWI_CWGR_CHDIV_Msk (0xffu << TWI_CWGR_CHDIV_Pos) /*  (TWI_CWGR) Clock High Divider */
#define TWI_CWGR_CHDIV(value) ((TWI_CWGR_CHDIV_Msk & ((value) << TWI_CWGR_CHDIV_Pos)))
#define TWI_CWGR_CKDIV_Pos 16
#define TWI_CWGR_CKDIV_Msk (0x7u << TWI_CWGR_CKDIV_Pos) /*  (TWI_CWGR) Clock Divider */
#define TWI_CWGR_CKDIV(value) ((TWI_CWGR_CKDIV_Msk & ((value) << TWI_CWGR_CKDIV_Pos)))
/* -------- TWI_SR : (TWI Offset: 0x20) Status Register -------- */
#define TWI_SR_TXCOMP (0x1u << 0) /*  (TWI_SR) Transmission Completed (automatically set / reset) */
#define TWI_SR_RXRDY (0x1u << 1) /*  (TWI_SR) Receive Holding Register Ready (automatically set / reset) */
#define TWI_SR_TXRDY (0x1u << 2) /*  (TWI_SR) Transmit Holding Register Ready (automatically set / reset) */
#define TWI_SR_SVREAD (0x1u << 3) /*  (TWI_SR) Slave Read (automatically set / reset) */
#define TWI_SR_SVACC (0x1u << 4) /*  (TWI_SR) Slave Access (automatically set / reset) */
#define TWI_SR_GACC (0x1u << 5) /*  (TWI_SR) General Call Access (clear on read) */
#define TWI_SR_OVRE (0x1u << 6) /*  (TWI_SR) Overrun Error (clear on read) */
#define TWI_SR_NACK (0x1u << 8) /*  (TWI_SR) Not Acknowledged (clear on read) */
#define TWI_SR_ARBLST (0x1u << 9) /*  (TWI_SR) Arbitration Lost (clear on read) */
#define TWI_SR_SCLWS (0x1u << 10) /*  (TWI_SR) Clock Wait State (automatically set / reset) */
#define TWI_SR_EOSACC (0x1u << 11) /*  (TWI_SR) End Of Slave Access (clear on read) */
#define TWI_SR_ENDRX (0x1u << 12) /*  (TWI_SR) End of RX buffer */
#define TWI_SR_ENDTX (0x1u << 13) /*  (TWI_SR) End of TX buffer */
#define TWI_SR_RXBUFF (0x1u << 14) /*  (TWI_SR) RX Buffer Full */
#define TWI_SR_TXBUFE (0x1u << 15) /*  (TWI_SR) TX Buffer Empty */
/* -------- TWI_IER : (TWI Offset: 0x24) Interrupt Enable Register -------- */
#define TWI_IER_TXCOMP (0x1u << 0) /*  (TWI_IER) Transmission Completed Interrupt Enable */
#define TWI_IER_RXRDY (0x1u << 1) /*  (TWI_IER) Receive Holding Register Ready Interrupt Enable */
#define TWI_IER_TXRDY (0x1u << 2) /*  (TWI_IER) Transmit Holding Register Ready Interrupt Enable */
#define TWI_IER_SVACC (0x1u << 4) /*  (TWI_IER) Slave Access Interrupt Enable */
#define TWI_IER_GACC (0x1u << 5) /*  (TWI_IER) General Call Access Interrupt Enable */
#define TWI_IER_OVRE (0x1u << 6) /*  (TWI_IER) Overrun Error Interrupt Enable */
#define TWI_IER_NACK (0x1u << 8) /*  (TWI_IER) Not Acknowledge Interrupt Enable */
#define TWI_IER_ARBLST (0x1u << 9) /*  (TWI_IER) Arbitration Lost Interrupt Enable */
#define TWI_IER_SCL_WS (0x1u << 10) /*  (TWI_IER) Clock Wait State Interrupt Enable */
#define TWI_IER_EOSACC (0x1u << 11) /*  (TWI_IER) End Of Slave Access Interrupt Enable */
#define TWI_IER_ENDRX (0x1u << 12) /*  (TWI_IER) End of Receive Buffer Interrupt Enable */
#define TWI_IER_ENDTX (0x1u << 13) /*  (TWI_IER) End of Transmit Buffer Interrupt Enable */
#define TWI_IER_RXBUFF (0x1u << 14) /*  (TWI_IER) Receive Buffer Full Interrupt Enable */
#define TWI_IER_TXBUFE (0x1u << 15) /*  (TWI_IER) Transmit Buffer Empty Interrupt Enable */
/* -------- TWI_IDR : (TWI Offset: 0x28) Interrupt Disable Register -------- */
#define TWI_IDR_TXCOMP (0x1u << 0) /*  (TWI_IDR) Transmission Completed Interrupt Disable */
#define TWI_IDR_RXRDY (0x1u << 1) /*  (TWI_IDR) Receive Holding Register Ready Interrupt Disable */
#define TWI_IDR_TXRDY (0x1u << 2) /*  (TWI_IDR) Transmit Holding Register Ready Interrupt Disable */
#define TWI_IDR_SVACC (0x1u << 4) /*  (TWI_IDR) Slave Access Interrupt Disable */
#define TWI_IDR_GACC (0x1u << 5) /*  (TWI_IDR) General Call Access Interrupt Disable */
#define TWI_IDR_OVRE (0x1u << 6) /*  (TWI_IDR) Overrun Error Interrupt Disable */
#define TWI_IDR_NACK (0x1u << 8) /*  (TWI_IDR) Not Acknowledge Interrupt Disable */
#define TWI_IDR_ARBLST (0x1u << 9) /*  (TWI_IDR) Arbitration Lost Interrupt Disable */
#define TWI_IDR_SCL_WS (0x1u << 10) /*  (TWI_IDR) Clock Wait State Interrupt Disable */
#define TWI_IDR_EOSACC (0x1u << 11) /*  (TWI_IDR) End Of Slave Access Interrupt Disable */
#define TWI_IDR_ENDRX (0x1u << 12) /*  (TWI_IDR) End of Receive Buffer Interrupt Disable */
#define TWI_IDR_ENDTX (0x1u << 13) /*  (TWI_IDR) End of Transmit Buffer Interrupt Disable */
#define TWI_IDR_RXBUFF (0x1u << 14) /*  (TWI_IDR) Receive Buffer Full Interrupt Disable */
#define TWI_IDR_TXBUFE (0x1u << 15) /*  (TWI_IDR) Transmit Buffer Empty Interrupt Disable */
/* -------- TWI_IMR : (TWI Offset: 0x2C) Interrupt Mask Register -------- */
#define TWI_IMR_TXCOMP (0x1u << 0) /*  (TWI_IMR) Transmission Completed Interrupt Mask */
#define TWI_IMR_RXRDY (0x1u << 1) /*  (TWI_IMR) Receive Holding Register Ready Interrupt Mask */
#define TWI_IMR_TXRDY (0x1u << 2) /*  (TWI_IMR) Transmit Holding Register Ready Interrupt Mask */
#define TWI_IMR_SVACC (0x1u << 4) /*  (TWI_IMR) Slave Access Interrupt Mask */
#define TWI_IMR_GACC (0x1u << 5) /*  (TWI_IMR) General Call Access Interrupt Mask */
#define TWI_IMR_OVRE (0x1u << 6) /*  (TWI_IMR) Overrun Error Interrupt Mask */
#define TWI_IMR_NACK (0x1u << 8) /*  (TWI_IMR) Not Acknowledge Interrupt Mask */
#define TWI_IMR_ARBLST (0x1u << 9) /*  (TWI_IMR) Arbitration Lost Interrupt Mask */
#define TWI_IMR_SCL_WS (0x1u << 10) /*  (TWI_IMR) Clock Wait State Interrupt Mask */
#define TWI_IMR_EOSACC (0x1u << 11) /*  (TWI_IMR) End Of Slave Access Interrupt Mask */
#define TWI_IMR_ENDRX (0x1u << 12) /*  (TWI_IMR) End of Receive Buffer Interrupt Mask */
#define TWI_IMR_ENDTX (0x1u << 13) /*  (TWI_IMR) End of Transmit Buffer Interrupt Mask */
#define TWI_IMR_RXBUFF (0x1u << 14) /*  (TWI_IMR) Receive Buffer Full Interrupt Mask */
#define TWI_IMR_TXBUFE (0x1u << 15) /*  (TWI_IMR) Transmit Buffer Empty Interrupt Mask */
/* -------- TWI_RHR : (TWI Offset: 0x30) Receive Holding Register -------- */
#define TWI_RHR_RXDATA_Pos 0
#define TWI_RHR_RXDATA_Msk (0xffu << TWI_RHR_RXDATA_Pos) /*  (TWI_RHR) Master or Slave Receive Holding Data */
/* -------- TWI_THR : (TWI Offset: 0x34) Transmit Holding Register -------- */
#define TWI_THR_TXDATA_Pos 0
#define TWI_THR_TXDATA_Msk (0xffu << TWI_THR_TXDATA_Pos) /*  (TWI_THR) Master or Slave Transmit Holding Data */
#define TWI_THR_TXDATA(value) ((TWI_THR_TXDATA_Msk & ((value) << TWI_THR_TXDATA_Pos)))
/* -------- TWI_RPR : (TWI Offset: 0x100) Receive Pointer Register -------- */
#define TWI_RPR_RXPTR_Pos 0
#define TWI_RPR_RXPTR_Msk (0xffffffffu << TWI_RPR_RXPTR_Pos) /*  (TWI_RPR) Receive Pointer Register */
#define TWI_RPR_RXPTR(value) ((TWI_RPR_RXPTR_Msk & ((value) << TWI_RPR_RXPTR_Pos)))
/* -------- TWI_RCR : (TWI Offset: 0x104) Receive Counter Register -------- */
#define TWI_RCR_RXCTR_Pos 0
#define TWI_RCR_RXCTR_Msk (0xffffu << TWI_RCR_RXCTR_Pos) /*  (TWI_RCR) Receive Counter Register */
#define TWI_RCR_RXCTR(value) ((TWI_RCR_RXCTR_Msk & ((value) << TWI_RCR_RXCTR_Pos)))
/* -------- TWI_TPR : (TWI Offset: 0x108) Transmit Pointer Register -------- */
#define TWI_TPR_TXPTR_Pos 0
#define TWI_TPR_TXPTR_Msk (0xffffffffu << TWI_TPR_TXPTR_Pos) /*  (TWI_TPR) Transmit Counter Register */
#define TWI_TPR_TXPTR(value) ((TWI_TPR_TXPTR_Msk & ((value) << TWI_TPR_TXPTR_Pos)))
/* -------- TWI_TCR : (TWI Offset: 0x10C) Transmit Counter Register -------- */
#define TWI_TCR_TXCTR_Pos 0
#define TWI_TCR_TXCTR_Msk (0xffffu << TWI_TCR_TXCTR_Pos) /*  (TWI_TCR) Transmit Counter Register */
#define TWI_TCR_TXCTR(value) ((TWI_TCR_TXCTR_Msk & ((value) << TWI_TCR_TXCTR_Pos)))
/* -------- TWI_RNPR : (TWI Offset: 0x110) Receive Next Pointer Register -------- */
#define TWI_RNPR_RXNPTR_Pos 0
#define TWI_RNPR_RXNPTR_Msk (0xffffffffu << TWI_RNPR_RXNPTR_Pos) /*  (TWI_RNPR) Receive Next Pointer */
#define TWI_RNPR_RXNPTR(value) ((TWI_RNPR_RXNPTR_Msk & ((value) << TWI_RNPR_RXNPTR_Pos)))
/* -------- TWI_RNCR : (TWI Offset: 0x114) Receive Next Counter Register -------- */
#define TWI_RNCR_RXNCTR_Pos 0
#define TWI_RNCR_RXNCTR_Msk (0xffffu << TWI_RNCR_RXNCTR_Pos) /*  (TWI_RNCR) Receive Next Counter */
#define TWI_RNCR_RXNCTR(value) ((TWI_RNCR_RXNCTR_Msk & ((value) << TWI_RNCR_RXNCTR_Pos)))
/* -------- TWI_TNPR : (TWI Offset: 0x118) Transmit Next Pointer Register -------- */
#define TWI_TNPR_TXNPTR_Pos 0
#define TWI_TNPR_TXNPTR_Msk (0xffffffffu << TWI_TNPR_TXNPTR_Pos) /*  (TWI_TNPR) Transmit Next Pointer */
#define TWI_TNPR_TXNPTR(value) ((TWI_TNPR_TXNPTR_Msk & ((value) << TWI_TNPR_TXNPTR_Pos)))
/* -------- TWI_TNCR : (TWI Offset: 0x11C) Transmit Next Counter Register -------- */
#define TWI_TNCR_TXNCTR_Pos 0
#define TWI_TNCR_TXNCTR_Msk (0xffffu << TWI_TNCR_TXNCTR_Pos) /*  (TWI_TNCR) Transmit Counter Next */
#define TWI_TNCR_TXNCTR(value) ((TWI_TNCR_TXNCTR_Msk & ((value) << TWI_TNCR_TXNCTR_Pos)))
/* -------- TWI_PTCR : (TWI Offset: 0x120) Transfer Control Register -------- */
#define TWI_PTCR_RXTEN (0x1u << 0) /*  (TWI_PTCR) Receiver Transfer Enable */
#define TWI_PTCR_RXTDIS (0x1u << 1) /*  (TWI_PTCR) Receiver Transfer Disable */
#define TWI_PTCR_TXTEN (0x1u << 8) /*  (TWI_PTCR) Transmitter Transfer Enable */
#define TWI_PTCR_TXTDIS (0x1u << 9) /*  (TWI_PTCR) Transmitter Transfer Disable */
/* -------- TWI_PTSR : (TWI Offset: 0x124) Transfer Status Register -------- */
#define TWI_PTSR_RXTEN (0x1u << 0) /*  (TWI_PTSR) Receiver Transfer Enable */
#define TWI_PTSR_TXTEN (0x1u << 8) /*  (TWI_PTSR) Transmitter Transfer Enable */




/* ************************************************************************** */
/*   REGISTER ACCESS DEFINITIONS FOR SAM3N */
/* ************************************************************************** */

/* ========== Register definition for SPI peripheral ========== */
#define REG_SPI_CR         REG_ACCESS(WoReg, 0x40008000U) /*  (SPI) Control Register */
#define REG_SPI_MR         REG_ACCESS(RwReg, 0x40008004U) /*  (SPI) Mode Register */
#define REG_SPI_RDR        REG_ACCESS(RoReg, 0x40008008U) /*  (SPI) Receive Data Register */
#define REG_SPI_TDR        REG_ACCESS(WoReg, 0x4000800CU) /*  (SPI) Transmit Data Register */
#define REG_SPI_SR         REG_ACCESS(RoReg, 0x40008010U) /*  (SPI) Status Register */
#define REG_SPI_IER        REG_ACCESS(WoReg, 0x40008014U) /*  (SPI) Interrupt Enable Register */
#define REG_SPI_IDR        REG_ACCESS(WoReg, 0x40008018U) /*  (SPI) Interrupt Disable Register */
#define REG_SPI_IMR        REG_ACCESS(RoReg, 0x4000801CU) /*  (SPI) Interrupt Mask Register */
#define REG_SPI_CSR        REG_ACCESS(RwReg, 0x40008030U) /*  (SPI) Chip Select Register */
#define REG_SPI_WPMR       REG_ACCESS(RwReg, 0x400080E4U) /*  (SPI) Write Protection Control Register */
#define REG_SPI_WPSR       REG_ACCESS(RoReg, 0x400080E8U) /*  (SPI) Write Protection Status Register */
#define REG_SPI_RPR        REG_ACCESS(RwReg, 0x40008100U) /*  (SPI) Receive Pointer Register */
#define REG_SPI_RCR        REG_ACCESS(RwReg, 0x40008104U) /*  (SPI) Receive Counter Register */
#define REG_SPI_TPR        REG_ACCESS(RwReg, 0x40008108U) /*  (SPI) Transmit Pointer Register */
#define REG_SPI_TCR        REG_ACCESS(RwReg, 0x4000810CU) /*  (SPI) Transmit Counter Register */
#define REG_SPI_RNPR       REG_ACCESS(RwReg, 0x40008110U) /*  (SPI) Receive Next Pointer Register */
#define REG_SPI_RNCR       REG_ACCESS(RwReg, 0x40008114U) /*  (SPI) Receive Next Counter Register */
#define REG_SPI_TNPR       REG_ACCESS(RwReg, 0x40008118U) /*  (SPI) Transmit Next Pointer Register */
#define REG_SPI_TNCR       REG_ACCESS(RwReg, 0x4000811CU) /*  (SPI) Transmit Next Counter Register */
#define REG_SPI_PTCR       REG_ACCESS(WoReg, 0x40008120U) /*  (SPI) Transfer Control Register */
#define REG_SPI_PTSR       REG_ACCESS(RoReg, 0x40008124U) /*  (SPI) Transfer Status Register */
/* ========== Register definition for TC0 peripheral ========== */
#define REG_TC0_CCR0       REG_ACCESS(WoReg, 0x40010000U) /*  (TC0) Channel Control Register (channel = 0) */
#define REG_TC0_CMR0       REG_ACCESS(RwReg, 0x40010004U) /*  (TC0) Channel Mode Register (channel = 0) */
#define REG_TC0_SMMR0      REG_ACCESS(RwReg, 0x40010008U) /*  (TC0) Stepper Motor Mode Register (channel = 0) */
#define REG_TC0_CV0        REG_ACCESS(RoReg, 0x40010010U) /*  (TC0) Counter Value (channel = 0) */
#define REG_TC0_RA0        REG_ACCESS(RwReg, 0x40010014U) /*  (TC0) Register A (channel = 0) */
#define REG_TC0_RB0        REG_ACCESS(RwReg, 0x40010018U) /*  (TC0) Register B (channel = 0) */
#define REG_TC0_RC0        REG_ACCESS(RwReg, 0x4001001CU) /*  (TC0) Register C (channel = 0) */
#define REG_TC0_SR0        REG_ACCESS(RoReg, 0x40010020U) /*  (TC0) Status Register (channel = 0) */
#define REG_TC0_IER0       REG_ACCESS(WoReg, 0x40010024U) /*  (TC0) Interrupt Enable Register (channel = 0) */
#define REG_TC0_IDR0       REG_ACCESS(WoReg, 0x40010028U) /*  (TC0) Interrupt Disable Register (channel = 0) */
#define REG_TC0_IMR0       REG_ACCESS(RoReg, 0x4001002CU) /*  (TC0) Interrupt Mask Register (channel = 0) */
#define REG_TC0_CCR1       REG_ACCESS(WoReg, 0x40010040U) /*  (TC0) Channel Control Register (channel = 1) */
#define REG_TC0_CMR1       REG_ACCESS(RwReg, 0x40010044U) /*  (TC0) Channel Mode Register (channel = 1) */
#define REG_TC0_SMMR1      REG_ACCESS(RwReg, 0x40010048U) /*  (TC0) Stepper Motor Mode Register (channel = 1) */
#define REG_TC0_CV1        REG_ACCESS(RoReg, 0x40010050U) /*  (TC0) Counter Value (channel = 1) */
#define REG_TC0_RA1        REG_ACCESS(RwReg, 0x40010054U) /*  (TC0) Register A (channel = 1) */
#define REG_TC0_RB1        REG_ACCESS(RwReg, 0x40010058U) /*  (TC0) Register B (channel = 1) */
#define REG_TC0_RC1        REG_ACCESS(RwReg, 0x4001005CU) /*  (TC0) Register C (channel = 1) */
#define REG_TC0_SR1        REG_ACCESS(RoReg, 0x40010060U) /*  (TC0) Status Register (channel = 1) */
#define REG_TC0_IER1       REG_ACCESS(WoReg, 0x40010064U) /*  (TC0) Interrupt Enable Register (channel = 1) */
#define REG_TC0_IDR1       REG_ACCESS(WoReg, 0x40010068U) /*  (TC0) Interrupt Disable Register (channel = 1) */
#define REG_TC0_IMR1       REG_ACCESS(RoReg, 0x4001006CU) /*  (TC0) Interrupt Mask Register (channel = 1) */
#define REG_TC0_CCR2       REG_ACCESS(WoReg, 0x40010080U) /*  (TC0) Channel Control Register (channel = 2) */
#define REG_TC0_CMR2       REG_ACCESS(RwReg, 0x40010084U) /*  (TC0) Channel Mode Register (channel = 2) */
#define REG_TC0_SMMR2      REG_ACCESS(RwReg, 0x40010088U) /*  (TC0) Stepper Motor Mode Register (channel = 2) */
#define REG_TC0_CV2        REG_ACCESS(RoReg, 0x40010090U) /*  (TC0) Counter Value (channel = 2) */
#define REG_TC0_RA2        REG_ACCESS(RwReg, 0x40010094U) /*  (TC0) Register A (channel = 2) */
#define REG_TC0_RB2        REG_ACCESS(RwReg, 0x40010098U) /*  (TC0) Register B (channel = 2) */
#define REG_TC0_RC2        REG_ACCESS(RwReg, 0x4001009CU) /*  (TC0) Register C (channel = 2) */
#define REG_TC0_SR2        REG_ACCESS(RoReg, 0x400100A0U) /*  (TC0) Status Register (channel = 2) */
#define REG_TC0_IER2       REG_ACCESS(WoReg, 0x400100A4U) /*  (TC0) Interrupt Enable Register (channel = 2) */
#define REG_TC0_IDR2       REG_ACCESS(WoReg, 0x400100A8U) /*  (TC0) Interrupt Disable Register (channel = 2) */
#define REG_TC0_IMR2       REG_ACCESS(RoReg, 0x400100ACU) /*  (TC0) Interrupt Mask Register (channel = 2) */
#define REG_TC0_BCR        REG_ACCESS(WoReg, 0x400100C0U) /*  (TC0) Block Control Register */
#define REG_TC0_BMR        REG_ACCESS(RwReg, 0x400100C4U) /*  (TC0) Block Mode Register */
#define REG_TC0_QIER       REG_ACCESS(WoReg, 0x400100C8U) /*  (TC0) QDEC Interrupt Enable Register */
#define REG_TC0_QIDR       REG_ACCESS(WoReg, 0x400100CCU) /*  (TC0) QDEC Interrupt Disable Register */
#define REG_TC0_QIMR       REG_ACCESS(RoReg, 0x400100D0U) /*  (TC0) QDEC Interrupt Mask Register */
#define REG_TC0_QISR       REG_ACCESS(RoReg, 0x400100D4U) /*  (TC0) QDEC Interrupt Status Register */
#define REG_TC0_WPMR       REG_ACCESS(RwReg, 0x400100E4U) /*  (TC0) Write Protect Mode Register */
/* ========== Register definition for TC1 peripheral ========== */
#define REG_TC1_CCR0       REG_ACCESS(WoReg, 0x40014000U) /*  (TC1) Channel Control Register (channel = 0) */
#define REG_TC1_CMR0       REG_ACCESS(RwReg, 0x40014004U) /*  (TC1) Channel Mode Register (channel = 0) */
#define REG_TC1_SMMR0      REG_ACCESS(RwReg, 0x40014008U) /*  (TC1) Stepper Motor Mode Register (channel = 0) */
#define REG_TC1_CV0        REG_ACCESS(RoReg, 0x40014010U) /*  (TC1) Counter Value (channel = 0) */
#define REG_TC1_RA0        REG_ACCESS(RwReg, 0x40014014U) /*  (TC1) Register A (channel = 0) */
#define REG_TC1_RB0        REG_ACCESS(RwReg, 0x40014018U) /*  (TC1) Register B (channel = 0) */
#define REG_TC1_RC0        REG_ACCESS(RwReg, 0x4001401CU) /*  (TC1) Register C (channel = 0) */
#define REG_TC1_SR0        REG_ACCESS(RoReg, 0x40014020U) /*  (TC1) Status Register (channel = 0) */
#define REG_TC1_IER0       REG_ACCESS(WoReg, 0x40014024U) /*  (TC1) Interrupt Enable Register (channel = 0) */
#define REG_TC1_IDR0       REG_ACCESS(WoReg, 0x40014028U) /*  (TC1) Interrupt Disable Register (channel = 0) */
#define REG_TC1_IMR0       REG_ACCESS(RoReg, 0x4001402CU) /*  (TC1) Interrupt Mask Register (channel = 0) */
#define REG_TC1_CCR1       REG_ACCESS(WoReg, 0x40014040U) /*  (TC1) Channel Control Register (channel = 1) */
#define REG_TC1_CMR1       REG_ACCESS(RwReg, 0x40014044U) /*  (TC1) Channel Mode Register (channel = 1) */
#define REG_TC1_SMMR1      REG_ACCESS(RwReg, 0x40014048U) /*  (TC1) Stepper Motor Mode Register (channel = 1) */
#define REG_TC1_CV1        REG_ACCESS(RoReg, 0x40014050U) /*  (TC1) Counter Value (channel = 1) */
#define REG_TC1_RA1        REG_ACCESS(RwReg, 0x40014054U) /*  (TC1) Register A (channel = 1) */
#define REG_TC1_RB1        REG_ACCESS(RwReg, 0x40014058U) /*  (TC1) Register B (channel = 1) */
#define REG_TC1_RC1        REG_ACCESS(RwReg, 0x4001405CU) /*  (TC1) Register C (channel = 1) */
#define REG_TC1_SR1        REG_ACCESS(RoReg, 0x40014060U) /*  (TC1) Status Register (channel = 1) */
#define REG_TC1_IER1       REG_ACCESS(WoReg, 0x40014064U) /*  (TC1) Interrupt Enable Register (channel = 1) */
#define REG_TC1_IDR1       REG_ACCESS(WoReg, 0x40014068U) /*  (TC1) Interrupt Disable Register (channel = 1) */
#define REG_TC1_IMR1       REG_ACCESS(RoReg, 0x4001406CU) /*  (TC1) Interrupt Mask Register (channel = 1) */
#define REG_TC1_CCR2       REG_ACCESS(WoReg, 0x40014080U) /*  (TC1) Channel Control Register (channel = 2) */
#define REG_TC1_CMR2       REG_ACCESS(RwReg, 0x40014084U) /*  (TC1) Channel Mode Register (channel = 2) */
#define REG_TC1_SMMR2      REG_ACCESS(RwReg, 0x40014088U) /*  (TC1) Stepper Motor Mode Register (channel = 2) */
#define REG_TC1_CV2        REG_ACCESS(RoReg, 0x40014090U) /*  (TC1) Counter Value (channel = 2) */
#define REG_TC1_RA2        REG_ACCESS(RwReg, 0x40014094U) /*  (TC1) Register A (channel = 2) */
#define REG_TC1_RB2        REG_ACCESS(RwReg, 0x40014098U) /*  (TC1) Register B (channel = 2) */
#define REG_TC1_RC2        REG_ACCESS(RwReg, 0x4001409CU) /*  (TC1) Register C (channel = 2) */
#define REG_TC1_SR2        REG_ACCESS(RoReg, 0x400140A0U) /*  (TC1) Status Register (channel = 2) */
#define REG_TC1_IER2       REG_ACCESS(WoReg, 0x400140A4U) /*  (TC1) Interrupt Enable Register (channel = 2) */
#define REG_TC1_IDR2       REG_ACCESS(WoReg, 0x400140A8U) /*  (TC1) Interrupt Disable Register (channel = 2) */
#define REG_TC1_IMR2       REG_ACCESS(RoReg, 0x400140ACU) /*  (TC1) Interrupt Mask Register (channel = 2) */
#define REG_TC1_BCR        REG_ACCESS(WoReg, 0x400140C0U) /*  (TC1) Block Control Register */
#define REG_TC1_BMR        REG_ACCESS(RwReg, 0x400140C4U) /*  (TC1) Block Mode Register */
#define REG_TC1_QIER       REG_ACCESS(WoReg, 0x400140C8U) /*  (TC1) QDEC Interrupt Enable Register */
#define REG_TC1_QIDR       REG_ACCESS(WoReg, 0x400140CCU) /*  (TC1) QDEC Interrupt Disable Register */
#define REG_TC1_QIMR       REG_ACCESS(RoReg, 0x400140D0U) /*  (TC1) QDEC Interrupt Mask Register */
#define REG_TC1_QISR       REG_ACCESS(RoReg, 0x400140D4U) /*  (TC1) QDEC Interrupt Status Register */
#define REG_TC1_WPMR       REG_ACCESS(RwReg, 0x400140E4U) /*  (TC1) Write Protect Mode Register */
/* ========== Register definition for TWI0 peripheral ========== */
#define REG_TWI0_CR        REG_ACCESS(WoReg, 0x40018000U) /*  (TWI0) Control Register */
#define REG_TWI0_MMR       REG_ACCESS(RwReg, 0x40018004U) /*  (TWI0) Master Mode Register */
#define REG_TWI0_SMR       REG_ACCESS(RwReg, 0x40018008U) /*  (TWI0) Slave Mode Register */
#define REG_TWI0_IADR      REG_ACCESS(RwReg, 0x4001800CU) /*  (TWI0) Internal Address Register */
#define REG_TWI0_CWGR      REG_ACCESS(RwReg, 0x40018010U) /*  (TWI0) Clock Waveform Generator Register */
#define REG_TWI0_SR        REG_ACCESS(RoReg, 0x40018020U) /*  (TWI0) Status Register */
#define REG_TWI0_IER       REG_ACCESS(WoReg, 0x40018024U) /*  (TWI0) Interrupt Enable Register */
#define REG_TWI0_IDR       REG_ACCESS(WoReg, 0x40018028U) /*  (TWI0) Interrupt Disable Register */
#define REG_TWI0_IMR       REG_ACCESS(RoReg, 0x4001802CU) /*  (TWI0) Interrupt Mask Register */
#define REG_TWI0_RHR       REG_ACCESS(RoReg, 0x40018030U) /*  (TWI0) Receive Holding Register */
#define REG_TWI0_THR       REG_ACCESS(WoReg, 0x40018034U) /*  (TWI0) Transmit Holding Register */
#define REG_TWI0_RPR       REG_ACCESS(RwReg, 0x40018100U) /*  (TWI0) Receive Pointer Register */
#define REG_TWI0_RCR       REG_ACCESS(RwReg, 0x40018104U) /*  (TWI0) Receive Counter Register */
#define REG_TWI0_TPR       REG_ACCESS(RwReg, 0x40018108U) /*  (TWI0) Transmit Pointer Register */
#define REG_TWI0_TCR       REG_ACCESS(RwReg, 0x4001810CU) /*  (TWI0) Transmit Counter Register */
#define REG_TWI0_RNPR      REG_ACCESS(RwReg, 0x40018110U) /*  (TWI0) Receive Next Pointer Register */
#define REG_TWI0_RNCR      REG_ACCESS(RwReg, 0x40018114U) /*  (TWI0) Receive Next Counter Register */
#define REG_TWI0_TNPR      REG_ACCESS(RwReg, 0x40018118U) /*  (TWI0) Transmit Next Pointer Register */
#define REG_TWI0_TNCR      REG_ACCESS(RwReg, 0x4001811CU) /*  (TWI0) Transmit Next Counter Register */
#define REG_TWI0_PTCR      REG_ACCESS(WoReg, 0x40018120U) /*  (TWI0) Transfer Control Register */
#define REG_TWI0_PTSR      REG_ACCESS(RoReg, 0x40018124U) /*  (TWI0) Transfer Status Register */
/* ========== Register definition for TWI1 peripheral ========== */
#define REG_TWI1_CR        REG_ACCESS(WoReg, 0x4001C000U) /*  (TWI1) Control Register */
#define REG_TWI1_MMR       REG_ACCESS(RwReg, 0x4001C004U) /*  (TWI1) Master Mode Register */
#define REG_TWI1_SMR       REG_ACCESS(RwReg, 0x4001C008U) /*  (TWI1) Slave Mode Register */
#define REG_TWI1_IADR      REG_ACCESS(RwReg, 0x4001C00CU) /*  (TWI1) Internal Address Register */
#define REG_TWI1_CWGR      REG_ACCESS(RwReg, 0x4001C010U) /*  (TWI1) Clock Waveform Generator Register */
#define REG_TWI1_SR        REG_ACCESS(RoReg, 0x4001C020U) /*  (TWI1) Status Register */
#define REG_TWI1_IER       REG_ACCESS(WoReg, 0x4001C024U) /*  (TWI1) Interrupt Enable Register */
#define REG_TWI1_IDR       REG_ACCESS(WoReg, 0x4001C028U) /*  (TWI1) Interrupt Disable Register */
#define REG_TWI1_IMR       REG_ACCESS(RoReg, 0x4001C02CU) /*  (TWI1) Interrupt Mask Register */
#define REG_TWI1_RHR       REG_ACCESS(RoReg, 0x4001C030U) /*  (TWI1) Receive Holding Register */
#define REG_TWI1_THR       REG_ACCESS(WoReg, 0x4001C034U) /*  (TWI1) Transmit Holding Register */
/* ========== Register definition for PWM peripheral ========== */
#define REG_PWM_MR         REG_ACCESS(RwReg, 0x40020000U) /*  (PWM) PWM Mode Register */
#define REG_PWM_ENA        REG_ACCESS(WoReg, 0x40020004U) /*  (PWM) PWM Enable Register */
#define REG_PWM_DIS        REG_ACCESS(WoReg, 0x40020008U) /*  (PWM) PWM Disable Register */
#define REG_PWM_SR         REG_ACCESS(RoReg, 0x4002000CU) /*  (PWM) PWM Status Register */
#define REG_PWM_IER        REG_ACCESS(WoReg, 0x40020010U) /*  (PWM) PWM Interrupt Enable Register */
#define REG_PWM_IDR        REG_ACCESS(WoReg, 0x40020014U) /*  (PWM) PWM Interrupt Disable Register */
#define REG_PWM_IMR        REG_ACCESS(RoReg, 0x40020018U) /*  (PWM) PWM Interrupt Mask Register */
#define REG_PWM_ISR        REG_ACCESS(RoReg, 0x4002001CU) /*  (PWM) PWM Interrupt Status Register */
#define REG_PWM_CMR0       REG_ACCESS(RwReg, 0x40020200U) /*  (PWM) PWM Channel Mode Register (ch_num = 0) */
#define REG_PWM_CDTY0      REG_ACCESS(RwReg, 0x40020204U) /*  (PWM) PWM Channel Duty Cycle Register (ch_num = 0) */
#define REG_PWM_CPRD0      REG_ACCESS(RwReg, 0x40020208U) /*  (PWM) PWM Channel Period Register (ch_num = 0) */
#define REG_PWM_CCNT0      REG_ACCESS(RoReg, 0x4002020CU) /*  (PWM) PWM Channel Counter Register (ch_num = 0) */
#define REG_PWM_CUPD0      REG_ACCESS(WoReg, 0x40020210U) /*  (PWM) PWM Channel Update Register (ch_num = 0) */
#define REG_PWM_CMR1       REG_ACCESS(RwReg, 0x40020220U) /*  (PWM) PWM Channel Mode Register (ch_num = 1) */
#define REG_PWM_CDTY1      REG_ACCESS(RwReg, 0x40020224U) /*  (PWM) PWM Channel Duty Cycle Register (ch_num = 1) */
#define REG_PWM_CPRD1      REG_ACCESS(RwReg, 0x40020228U) /*  (PWM) PWM Channel Period Register (ch_num = 1) */
#define REG_PWM_CCNT1      REG_ACCESS(RoReg, 0x4002022CU) /*  (PWM) PWM Channel Counter Register (ch_num = 1) */
#define REG_PWM_CUPD1      REG_ACCESS(WoReg, 0x40020230U) /*  (PWM) PWM Channel Update Register (ch_num = 1) */
#define REG_PWM_CMR2       REG_ACCESS(RwReg, 0x40020240U) /*  (PWM) PWM Channel Mode Register (ch_num = 2) */
#define REG_PWM_CDTY2      REG_ACCESS(RwReg, 0x40020244U) /*  (PWM) PWM Channel Duty Cycle Register (ch_num = 2) */
#define REG_PWM_CPRD2      REG_ACCESS(RwReg, 0x40020248U) /*  (PWM) PWM Channel Period Register (ch_num = 2) */
#define REG_PWM_CCNT2      REG_ACCESS(RoReg, 0x4002024CU) /*  (PWM) PWM Channel Counter Register (ch_num = 2) */
#define REG_PWM_CUPD2      REG_ACCESS(WoReg, 0x40020250U) /*  (PWM) PWM Channel Update Register (ch_num = 2) */
#define REG_PWM_CMR3       REG_ACCESS(RwReg, 0x40020260U) /*  (PWM) PWM Channel Mode Register (ch_num = 3) */
#define REG_PWM_CDTY3      REG_ACCESS(RwReg, 0x40020264U) /*  (PWM) PWM Channel Duty Cycle Register (ch_num = 3) */
#define REG_PWM_CPRD3      REG_ACCESS(RwReg, 0x40020268U) /*  (PWM) PWM Channel Period Register (ch_num = 3) */
#define REG_PWM_CCNT3      REG_ACCESS(RoReg, 0x4002026CU) /*  (PWM) PWM Channel Counter Register (ch_num = 3) */
#define REG_PWM_CUPD3      REG_ACCESS(WoReg, 0x40020270U) /*  (PWM) PWM Channel Update Register (ch_num = 3) */
/* ========== Register definition for USART0 peripheral ========== */
#define REG_USART0_CR      REG_ACCESS(WoReg, 0x40024000U) /*  (USART0) Control Register */
#define REG_USART0_MR      REG_ACCESS(RwReg, 0x40024004U) /*  (USART0) Mode Register */
#define REG_USART0_IER     REG_ACCESS(WoReg, 0x40024008U) /*  (USART0) Interrupt Enable Register */
#define REG_USART0_IDR     REG_ACCESS(WoReg, 0x4002400CU) /*  (USART0) Interrupt Disable Register */
#define REG_USART0_IMR     REG_ACCESS(RoReg, 0x40024010U) /*  (USART0) Interrupt Mask Register */
#define REG_USART0_CSR     REG_ACCESS(RoReg, 0x40024014U) /*  (USART0) Channel Status Register */
#define REG_USART0_RHR     REG_ACCESS(RoReg, 0x40024018U) /*  (USART0) Receiver Holding Register */
#define REG_USART0_THR     REG_ACCESS(WoReg, 0x4002401CU) /*  (USART0) Transmitter Holding Register */
#define REG_USART0_BRGR    REG_ACCESS(RwReg, 0x40024020U) /*  (USART0) Baud Rate Generator Register */
#define REG_USART0_RTOR    REG_ACCESS(RwReg, 0x40024024U) /*  (USART0) Receiver Time-out Register */
#define REG_USART0_TTGR    REG_ACCESS(RwReg, 0x40024028U) /*  (USART0) Transmitter Timeguard Register */
#define REG_USART0_FIDI    REG_ACCESS(RwReg, 0x40024040U) /*  (USART0) FI DI Ratio Register */
#define REG_USART0_NER     REG_ACCESS(RoReg, 0x40024044U) /*  (USART0) Number of Errors Register */
#define REG_USART0_IF      REG_ACCESS(RwReg, 0x4002404CU) /*  (USART0) IrDA Filter Register */
#define REG_USART0_WPMR    REG_ACCESS(RwReg, 0x400240E4U) /*  (USART0) Write Protect Mode Register */
#define REG_USART0_WPSR    REG_ACCESS(RoReg, 0x400240E8U) /*  (USART0) Write Protect Status Register */
#define REG_USART0_RPR     REG_ACCESS(RwReg, 0x40024100U) /*  (USART0) Receive Pointer Register */
#define REG_USART0_RCR     REG_ACCESS(RwReg, 0x40024104U) /*  (USART0) Receive Counter Register */
#define REG_USART0_TPR     REG_ACCESS(RwReg, 0x40024108U) /*  (USART0) Transmit Pointer Register */
#define REG_USART0_TCR     REG_ACCESS(RwReg, 0x4002410CU) /*  (USART0) Transmit Counter Register */
#define REG_USART0_RNPR    REG_ACCESS(RwReg, 0x40024110U) /*  (USART0) Receive Next Pointer Register */
#define REG_USART0_RNCR    REG_ACCESS(RwReg, 0x40024114U) /*  (USART0) Receive Next Counter Register */
#define REG_USART0_TNPR    REG_ACCESS(RwReg, 0x40024118U) /*  (USART0) Transmit Next Pointer Register */
#define REG_USART0_TNCR    REG_ACCESS(RwReg, 0x4002411CU) /*  (USART0) Transmit Next Counter Register */
#define REG_USART0_PTCR    REG_ACCESS(WoReg, 0x40024120U) /*  (USART0) Transfer Control Register */
#define REG_USART0_PTSR    REG_ACCESS(RoReg, 0x40024124U) /*  (USART0) Transfer Status Register */
/* ========== Register definition for USART1 peripheral ========== */
#define REG_USART1_CR      REG_ACCESS(WoReg, 0x40028000U) /*  (USART1) Control Register */
#define REG_USART1_MR      REG_ACCESS(RwReg, 0x40028004U) /*  (USART1) Mode Register */
#define REG_USART1_IER     REG_ACCESS(WoReg, 0x40028008U) /*  (USART1) Interrupt Enable Register */
#define REG_USART1_IDR     REG_ACCESS(WoReg, 0x4002800CU) /*  (USART1) Interrupt Disable Register */
#define REG_USART1_IMR     REG_ACCESS(RoReg, 0x40028010U) /*  (USART1) Interrupt Mask Register */
#define REG_USART1_CSR     REG_ACCESS(RoReg, 0x40028014U) /*  (USART1) Channel Status Register */
#define REG_USART1_RHR     REG_ACCESS(RoReg, 0x40028018U) /*  (USART1) Receiver Holding Register */
#define REG_USART1_THR     REG_ACCESS(WoReg, 0x4002801CU) /*  (USART1) Transmitter Holding Register */
#define REG_USART1_BRGR    REG_ACCESS(RwReg, 0x40028020U) /*  (USART1) Baud Rate Generator Register */
#define REG_USART1_RTOR    REG_ACCESS(RwReg, 0x40028024U) /*  (USART1) Receiver Time-out Register */
#define REG_USART1_TTGR    REG_ACCESS(RwReg, 0x40028028U) /*  (USART1) Transmitter Timeguard Register */
#define REG_USART1_FIDI    REG_ACCESS(RwReg, 0x40028040U) /*  (USART1) FI DI Ratio Register */
#define REG_USART1_NER     REG_ACCESS(RoReg, 0x40028044U) /*  (USART1) Number of Errors Register */
#define REG_USART1_IF      REG_ACCESS(RwReg, 0x4002804CU) /*  (USART1) IrDA Filter Register */
#define REG_USART1_WPMR    REG_ACCESS(RwReg, 0x400280E4U) /*  (USART1) Write Protect Mode Register */
#define REG_USART1_WPSR    REG_ACCESS(RoReg, 0x400280E8U) /*  (USART1) Write Protect Status Register */
/* ========== Register definition for ADC peripheral ========== */
#define REG_ADC_CR         REG_ACCESS(WoReg, 0x40038000U) /*  (ADC) Control Register */
#define REG_ADC_MR         REG_ACCESS(RwReg, 0x40038004U) /*  (ADC) Mode Register */
#define REG_ADC_SEQR1      REG_ACCESS(RwReg, 0x40038008U) /*  (ADC) Channel Sequence Register 1 */
#define REG_ADC_SEQR2      REG_ACCESS(RwReg, 0x4003800CU) /*  (ADC) Channel Sequence Register 2 */
#define REG_ADC_CHER       REG_ACCESS(WoReg, 0x40038010U) /*  (ADC) Channel Enable Register */
#define REG_ADC_CHDR       REG_ACCESS(WoReg, 0x40038014U) /*  (ADC) Channel Disable Register */
#define REG_ADC_CHSR       REG_ACCESS(RoReg, 0x40038018U) /*  (ADC) Channel Status Register */
#define REG_ADC_LCDR       REG_ACCESS(RoReg, 0x40038020U) /*  (ADC) Last Converted Data Register */
#define REG_ADC_IER        REG_ACCESS(WoReg, 0x40038024U) /*  (ADC) Interrupt Enable Register */
#define REG_ADC_IDR        REG_ACCESS(WoReg, 0x40038028U) /*  (ADC) Interrupt Disable Register */
#define REG_ADC_IMR        REG_ACCESS(RoReg, 0x4003802CU) /*  (ADC) Interrupt Mask Register */
#define REG_ADC_ISR        REG_ACCESS(RoReg, 0x40038030U) /*  (ADC) Interrupt Status Register */
#define REG_ADC_OVER       REG_ACCESS(RoReg, 0x4003803CU) /*  (ADC) Overrun Status Register */
#define REG_ADC_EMR        REG_ACCESS(RwReg, 0x40038040U) /*  (ADC) Extended Mode Register */
#define REG_ADC_CWR        REG_ACCESS(RwReg, 0x40038044U) /*  (ADC) Compare Window Register */
#define REG_ADC_CDR        REG_ACCESS(RoReg, 0x40038050U) /*  (ADC) Channel Data Register */
#define REG_ADC_WPMR       REG_ACCESS(RwReg, 0x400380E4U) /*  (ADC) Write Protect Mode Register */
#define REG_ADC_WPSR       REG_ACCESS(RoReg, 0x400380E8U) /*  (ADC) Write Protect Status Register */
#define REG_ADC_RPR        REG_ACCESS(RwReg, 0x40038100U) /*  (ADC) Receive Pointer Register */
#define REG_ADC_RCR        REG_ACCESS(RwReg, 0x40038104U) /*  (ADC) Receive Counter Register */
#define REG_ADC_TPR        REG_ACCESS(RwReg, 0x40038108U) /*  (ADC) Transmit Pointer Register */
#define REG_ADC_TCR        REG_ACCESS(RwReg, 0x4003810CU) /*  (ADC) Transmit Counter Register */
#define REG_ADC_RNPR       REG_ACCESS(RwReg, 0x40038110U) /*  (ADC) Receive Next Pointer Register */
#define REG_ADC_RNCR       REG_ACCESS(RwReg, 0x40038114U) /*  (ADC) Receive Next Counter Register */
#define REG_ADC_TNPR       REG_ACCESS(RwReg, 0x40038118U) /*  (ADC) Transmit Next Pointer Register */
#define REG_ADC_TNCR       REG_ACCESS(RwReg, 0x4003811CU) /*  (ADC) Transmit Next Counter Register */
#define REG_ADC_PTCR       REG_ACCESS(WoReg, 0x40038120U) /*  (ADC) Transfer Control Register */
#define REG_ADC_PTSR       REG_ACCESS(RoReg, 0x40038124U) /*  (ADC) Transfer Status Register */
/* ========== Register definition for DACC peripheral ========== */
#define REG_DACC_CR        REG_ACCESS(WoReg, 0x4003C000U) /*  (DACC) Control Register */
#define REG_DACC_MR        REG_ACCESS(RwReg, 0x4003C004U) /*  (DACC) Mode Register */
#define REG_DACC_CDR       REG_ACCESS(WoReg, 0x4003C008U) /*  (DACC) Conversion Data Register */
#define REG_DACC_IER       REG_ACCESS(WoReg, 0x4003C00CU) /*  (DACC) Interrupt Enable Register */
#define REG_DACC_IDR       REG_ACCESS(WoReg, 0x4003C010U) /*  (DACC) Interrupt Disable Register */
#define REG_DACC_IMR       REG_ACCESS(RoReg, 0x4003C014U) /*  (DACC) Interrupt Mask Register */
#define REG_DACC_ISR       REG_ACCESS(RoReg, 0x4003C018U) /*  (DACC) Interrupt Status Register */
#define REG_DACC_WPMR      REG_ACCESS(RwReg, 0x4003C0E4U) /*  (DACC) Write Protect Mode Register */
#define REG_DACC_WPSR      REG_ACCESS(RoReg, 0x4003C0E8U) /*  (DACC) Write Protect Status Register */
#define REG_DACC_RPR       REG_ACCESS(RwReg, 0x4003C100U) /*  (DACC) Receive Pointer Register */
#define REG_DACC_RCR       REG_ACCESS(RwReg, 0x4003C104U) /*  (DACC) Receive Counter Register */
#define REG_DACC_TPR       REG_ACCESS(RwReg, 0x4003C108U) /*  (DACC) Transmit Pointer Register */
#define REG_DACC_TCR       REG_ACCESS(RwReg, 0x4003C10CU) /*  (DACC) Transmit Counter Register */
#define REG_DACC_RNPR      REG_ACCESS(RwReg, 0x4003C110U) /*  (DACC) Receive Next Pointer Register */
#define REG_DACC_RNCR      REG_ACCESS(RwReg, 0x4003C114U) /*  (DACC) Receive Next Counter Register */
#define REG_DACC_TNPR      REG_ACCESS(RwReg, 0x4003C118U) /*  (DACC) Transmit Next Pointer Register */
#define REG_DACC_TNCR      REG_ACCESS(RwReg, 0x4003C11CU) /*  (DACC) Transmit Next Counter Register */
#define REG_DACC_PTCR      REG_ACCESS(WoReg, 0x4003C120U) /*  (DACC) Transfer Control Register */
#define REG_DACC_PTSR      REG_ACCESS(RoReg, 0x4003C124U) /*  (DACC) Transfer Status Register */
/* ========== Register definition for MATRIX peripheral ========== */
#define REG_MATRIX_MCFG    REG_ACCESS(RwReg, 0x400E0200U) /*  (MATRIX) Master Configuration Register */
#define REG_MATRIX_SCFG    REG_ACCESS(RwReg, 0x400E0240U) /*  (MATRIX) Slave Configuration Register */
#define REG_MATRIX_PRAS0   REG_ACCESS(RwReg, 0x400E0280U) /*  (MATRIX) Priority Register A for Slave 0 */
#define REG_MATRIX_PRAS1   REG_ACCESS(RwReg, 0x400E0288U) /*  (MATRIX) Priority Register A for Slave 1 */
#define REG_MATRIX_PRAS2   REG_ACCESS(RwReg, 0x400E0290U) /*  (MATRIX) Priority Register A for Slave 2 */
#define REG_MATRIX_PRAS3   REG_ACCESS(RwReg, 0x400E0298U) /*  (MATRIX) Priority Register A for Slave 3 */
#define REG_MATRIX_SYSIO   REG_ACCESS(RwReg, 0x400E0314U) /*  (MATRIX) System I/O Configuration register */
#define REG_MATRIX_WPMR    REG_ACCESS(RwReg, 0x400E03E4U) /*  (MATRIX) Write Protect Mode Register */
#define REG_MATRIX_WPSR    REG_ACCESS(RoReg, 0x400E03E8U) /*  (MATRIX) Write Protect Status Register */
/* ========== Register definition for PMC peripheral ========== */
#define REG_PMC_SCER       REG_ACCESS(WoReg, 0x400E0400U) /*  (PMC) System Clock Enable Register */
#define REG_PMC_SCDR       REG_ACCESS(WoReg, 0x400E0404U) /*  (PMC) System Clock Disable Register */
#define REG_PMC_SCSR       REG_ACCESS(RoReg, 0x400E0408U) /*  (PMC) System Clock Status Register */
#define REG_PMC_PCER       REG_ACCESS(WoReg, 0x400E0410U) /*  (PMC) Peripheral Clock Enable Register */
#define REG_PMC_PCDR       REG_ACCESS(WoReg, 0x400E0414U) /*  (PMC) Peripheral Clock Disable Register */
#define REG_PMC_PCSR       REG_ACCESS(RoReg, 0x400E0418U) /*  (PMC) Peripheral Clock Status Register */
#define REG_PMC_MOR        REG_ACCESS(RwReg, 0x400E0420U) /*  (PMC) Main Oscillator Register */
#define REG_PMC_MCFR       REG_ACCESS(RoReg, 0x400E0424U) /*  (PMC) Main Clock Frequency Register */
#define REG_PMC_PLLR       REG_ACCESS(RwReg, 0x400E0428U) /*  (PMC) PLL Register */
#define REG_PMC_MCKR       REG_ACCESS(RwReg, 0x400E0430U) /*  (PMC) Master Clock Register */
#define REG_PMC_PCK        REG_ACCESS(RwReg, 0x400E0440U) /*  (PMC) Programmable Clock 0 Register */
#define REG_PMC_IER        REG_ACCESS(WoReg, 0x400E0460U) /*  (PMC) Interrupt Enable Register */
#define REG_PMC_IDR        REG_ACCESS(WoReg, 0x400E0464U) /*  (PMC) Interrupt Disable Register */
#define REG_PMC_SR         REG_ACCESS(RoReg, 0x400E0468U) /*  (PMC) Status Register */
#define REG_PMC_IMR        REG_ACCESS(RoReg, 0x400E046CU) /*  (PMC) Interrupt Mask Register */
#define REG_PMC_FSMR       REG_ACCESS(RwReg, 0x400E0470U) /*  (PMC) Fast Startup Mode Register */
#define REG_PMC_FSPR       REG_ACCESS(RwReg, 0x400E0474U) /*  (PMC) Fast Startup Polarity Register */
#define REG_PMC_FOCR       REG_ACCESS(WoReg, 0x400E0478U) /*  (PMC) Fault Output Clear Register */
#define REG_PMC_WPMR       REG_ACCESS(RwReg, 0x400E04E4U) /*  (PMC) Write Protect Mode Register */
#define REG_PMC_WPSR       REG_ACCESS(RoReg, 0x400E04E8U) /*  (PMC) Write Protect Status Register */
#define REG_PMC_OCR        REG_ACCESS(RwReg, 0x400E0510U) /*  (PMC) Oscillator Calibration Register */
/* ========== Register definition for UART0 peripheral ========== */
#define REG_UART0_CR       REG_ACCESS(WoReg, 0x400E0600U) /*  (UART0) Control Register */
#define REG_UART0_MR       REG_ACCESS(RwReg, 0x400E0604U) /*  (UART0) Mode Register */
#define REG_UART0_IER      REG_ACCESS(WoReg, 0x400E0608U) /*  (UART0) Interrupt Enable Register */
#define REG_UART0_IDR      REG_ACCESS(WoReg, 0x400E060CU) /*  (UART0) Interrupt Disable Register */
#define REG_UART0_IMR      REG_ACCESS(RoReg, 0x400E0610U) /*  (UART0) Interrupt Mask Register */
#define REG_UART0_SR       REG_ACCESS(RoReg, 0x400E0614U) /*  (UART0) Status Register */
#define REG_UART0_RHR      REG_ACCESS(RoReg, 0x400E0618U) /*  (UART0) Receive Holding Register */
#define REG_UART0_THR      REG_ACCESS(WoReg, 0x400E061CU) /*  (UART0) Transmit Holding Register */
#define REG_UART0_BRGR     REG_ACCESS(RwReg, 0x400E0620U) /*  (UART0) Baud Rate Generator Register */
#define REG_UART0_RPR      REG_ACCESS(RwReg, 0x400E0700U) /*  (UART0) Receive Pointer Register */
#define REG_UART0_RCR      REG_ACCESS(RwReg, 0x400E0704U) /*  (UART0) Receive Counter Register */
#define REG_UART0_TPR      REG_ACCESS(RwReg, 0x400E0708U) /*  (UART0) Transmit Pointer Register */
#define REG_UART0_TCR      REG_ACCESS(RwReg, 0x400E070CU) /*  (UART0) Transmit Counter Register */
#define REG_UART0_RNPR     REG_ACCESS(RwReg, 0x400E0710U) /*  (UART0) Receive Next Pointer Register */
#define REG_UART0_RNCR     REG_ACCESS(RwReg, 0x400E0714U) /*  (UART0) Receive Next Counter Register */
#define REG_UART0_TNPR     REG_ACCESS(RwReg, 0x400E0718U) /*  (UART0) Transmit Next Pointer Register */
#define REG_UART0_TNCR     REG_ACCESS(RwReg, 0x400E071CU) /*  (UART0) Transmit Next Counter Register */
#define REG_UART0_PTCR     REG_ACCESS(WoReg, 0x400E0720U) /*  (UART0) Transfer Control Register */
#define REG_UART0_PTSR     REG_ACCESS(RoReg, 0x400E0724U) /*  (UART0) Transfer Status Register */
/* ========== Register definition for CHIPID peripheral ========== */
#define REG_CHIPID_CIDR    REG_ACCESS(RoReg, 0x400E0740U) /*  (CHIPID) Chip ID Register */
#define REG_CHIPID_EXID    REG_ACCESS(RoReg, 0x400E0744U) /*  (CHIPID) Chip ID Extension Register */
/* ========== Register definition for UART1 peripheral ========== */
#define REG_UART1_CR       REG_ACCESS(WoReg, 0x400E0800U) /*  (UART1) Control Register */
#define REG_UART1_MR       REG_ACCESS(RwReg, 0x400E0804U) /*  (UART1) Mode Register */
#define REG_UART1_IER      REG_ACCESS(WoReg, 0x400E0808U) /*  (UART1) Interrupt Enable Register */
#define REG_UART1_IDR      REG_ACCESS(WoReg, 0x400E080CU) /*  (UART1) Interrupt Disable Register */
#define REG_UART1_IMR      REG_ACCESS(RoReg, 0x400E0810U) /*  (UART1) Interrupt Mask Register */
#define REG_UART1_SR       REG_ACCESS(RoReg, 0x400E0814U) /*  (UART1) Status Register */
#define REG_UART1_RHR      REG_ACCESS(RoReg, 0x400E0818U) /*  (UART1) Receive Holding Register */
#define REG_UART1_THR      REG_ACCESS(WoReg, 0x400E081CU) /*  (UART1) Transmit Holding Register */
#define REG_UART1_BRGR     REG_ACCESS(RwReg, 0x400E0820U) /*  (UART1) Baud Rate Generator Register */
/* ========== Register definition for EFC peripheral ========== */
#define REG_EFC_FMR        REG_ACCESS(RwReg, 0x400E0A00U) /*  (EFC) EEFC Flash Mode Register */
#define REG_EFC_FCR        REG_ACCESS(WoReg, 0x400E0A04U) /*  (EFC) EEFC Flash Command Register */
#define REG_EFC_FSR        REG_ACCESS(RoReg, 0x400E0A08U) /*  (EFC) EEFC Flash Status Register */
#define REG_EFC_FRR        REG_ACCESS(RoReg, 0x400E0A0CU) /*  (EFC) EEFC Flash Result Register */
/* ========== Register definition for PIOA peripheral ========== */
#define REG_PIOA_PER       REG_ACCESS(WoReg, 0x400E0E00U) /*  (PIOA) PIO Enable Register */
#define REG_PIOA_PDR       REG_ACCESS(WoReg, 0x400E0E04U) /*  (PIOA) PIO Disable Register */
#define REG_PIOA_PSR       REG_ACCESS(RoReg, 0x400E0E08U) /*  (PIOA) PIO Status Register */
#define REG_PIOA_OER       REG_ACCESS(WoReg, 0x400E0E10U) /*  (PIOA) Output Enable Register */
#define REG_PIOA_ODR       REG_ACCESS(WoReg, 0x400E0E14U) /*  (PIOA) Output Disable Register */
#define REG_PIOA_OSR       REG_ACCESS(RoReg, 0x400E0E18U) /*  (PIOA) Output Status Register */
#define REG_PIOA_IFER      REG_ACCESS(WoReg, 0x400E0E20U) /*  (PIOA) Glitch Input Filter Enable Register */
#define REG_PIOA_IFDR      REG_ACCESS(WoReg, 0x400E0E24U) /*  (PIOA) Glitch Input Filter Disable Register */
#define REG_PIOA_IFSR      REG_ACCESS(RoReg, 0x400E0E28U) /*  (PIOA) Glitch Input Filter Status Register */
#define REG_PIOA_SODR      REG_ACCESS(WoReg, 0x400E0E30U) /*  (PIOA) Set Output Data Register */
#define REG_PIOA_CODR      REG_ACCESS(WoReg, 0x400E0E34U) /*  (PIOA) Clear Output Data Register */
#define REG_PIOA_ODSR      REG_ACCESS(RwReg, 0x400E0E38U) /*  (PIOA) Output Data Status Register */
#define REG_PIOA_PDSR      REG_ACCESS(RoReg, 0x400E0E3CU) /*  (PIOA) Pin Data Status Register */
#define REG_PIOA_IER       REG_ACCESS(WoReg, 0x400E0E40U) /*  (PIOA) Interrupt Enable Register */
#define REG_PIOA_IDR       REG_ACCESS(WoReg, 0x400E0E44U) /*  (PIOA) Interrupt Disable Register */
#define REG_PIOA_IMR       REG_ACCESS(RoReg, 0x400E0E48U) /*  (PIOA) Interrupt Mask Register */
#define REG_PIOA_ISR       REG_ACCESS(RoReg, 0x400E0E4CU) /*  (PIOA) Interrupt Status Register */
#define REG_PIOA_MDER      REG_ACCESS(WoReg, 0x400E0E50U) /*  (PIOA) Multi-driver Enable Register */
#define REG_PIOA_MDDR      REG_ACCESS(WoReg, 0x400E0E54U) /*  (PIOA) Multi-driver Disable Register */
#define REG_PIOA_MDSR      REG_ACCESS(RoReg, 0x400E0E58U) /*  (PIOA) Multi-driver Status Register */
#define REG_PIOA_PUDR      REG_ACCESS(WoReg, 0x400E0E60U) /*  (PIOA) Pull-up Disable Register */
#define REG_PIOA_PUER      REG_ACCESS(WoReg, 0x400E0E64U) /*  (PIOA) Pull-up Enable Register */
#define REG_PIOA_PUSR      REG_ACCESS(RoReg, 0x400E0E68U) /*  (PIOA) Pad Pull-up Status Register */
#define REG_PIOA_ABCDSR    REG_ACCESS(RwReg, 0x400E0E70U) /*  (PIOA) Peripheral Select Register */
#define REG_PIOA_IFSCDR    REG_ACCESS(WoReg, 0x400E0E80U) /*  (PIOA) Input Filter Slow Clock Disable Register */
#define REG_PIOA_IFSCER    REG_ACCESS(WoReg, 0x400E0E84U) /*  (PIOA) Input Filter Slow Clock Enable Register */
#define REG_PIOA_IFSCSR    REG_ACCESS(RoReg, 0x400E0E88U) /*  (PIOA) Input Filter Slow Clock Status Register */
#define REG_PIOA_SCDR      REG_ACCESS(RwReg, 0x400E0E8CU) /*  (PIOA) Slow Clock Divider Debouncing Register */
#define REG_PIOA_PPDDR     REG_ACCESS(WoReg, 0x400E0E90U) /*  (PIOA) Pad Pull-down Disable Register */
#define REG_PIOA_PPDER     REG_ACCESS(WoReg, 0x400E0E94U) /*  (PIOA) Pad Pull-down Enable Register */
#define REG_PIOA_PPDSR     REG_ACCESS(RoReg, 0x400E0E98U) /*  (PIOA) Pad Pull-down Status Register */
#define REG_PIOA_OWER      REG_ACCESS(WoReg, 0x400E0EA0U) /*  (PIOA) Output Write Enable */
#define REG_PIOA_OWDR      REG_ACCESS(WoReg, 0x400E0EA4U) /*  (PIOA) Output Write Disable */
#define REG_PIOA_OWSR      REG_ACCESS(RoReg, 0x400E0EA8U) /*  (PIOA) Output Write Status Register */
#define REG_PIOA_AIMER     REG_ACCESS(WoReg, 0x400E0EB0U) /*  (PIOA) Additional Interrupt Modes Enable Register */
#define REG_PIOA_AIMDR     REG_ACCESS(WoReg, 0x400E0EB4U) /*  (PIOA) Additional Interrupt Modes Disables Register */
#define REG_PIOA_AIMMR     REG_ACCESS(RoReg, 0x400E0EB8U) /*  (PIOA) Additional Interrupt Modes Mask Register */
#define REG_PIOA_ESR       REG_ACCESS(WoReg, 0x400E0EC0U) /*  (PIOA) Edge Select Register */
#define REG_PIOA_LSR       REG_ACCESS(WoReg, 0x400E0EC4U) /*  (PIOA) Level Select Register */
#define REG_PIOA_ELSR      REG_ACCESS(RoReg, 0x400E0EC8U) /*  (PIOA) Edge/Level Status Register */
#define REG_PIOA_FELLSR    REG_ACCESS(WoReg, 0x400E0ED0U) /*  (PIOA) Falling Edge/Low Level Select Register */
#define REG_PIOA_REHLSR    REG_ACCESS(WoReg, 0x400E0ED4U) /*  (PIOA) Rising Edge/ High Level Select Register */
#define REG_PIOA_FRLHSR    REG_ACCESS(RoReg, 0x400E0ED8U) /*  (PIOA) Fall/Rise - Low/High Status Register */
#define REG_PIOA_LOCKSR    REG_ACCESS(RoReg, 0x400E0EE0U) /*  (PIOA) Lock Status */
#define REG_PIOA_WPMR      REG_ACCESS(RwReg, 0x400E0EE4U) /*  (PIOA) Write Protect Mode Register */
#define REG_PIOA_WPSR      REG_ACCESS(RoReg, 0x400E0EE8U) /*  (PIOA) Write Protect Status Register */
#define REG_PIOA_SCHMITT   REG_ACCESS(RwReg, 0x400E0F00U) /*  (PIOA) Schmitt Trigger Register */
/* ========== Register definition for PIOB peripheral ========== */
#define REG_PIOB_PER       REG_ACCESS(WoReg, 0x400E1000U) /*  (PIOB) PIO Enable Register */
#define REG_PIOB_PDR       REG_ACCESS(WoReg, 0x400E1004U) /*  (PIOB) PIO Disable Register */
#define REG_PIOB_PSR       REG_ACCESS(RoReg, 0x400E1008U) /*  (PIOB) PIO Status Register */
#define REG_PIOB_OER       REG_ACCESS(WoReg, 0x400E1010U) /*  (PIOB) Output Enable Register */
#define REG_PIOB_ODR       REG_ACCESS(WoReg, 0x400E1014U) /*  (PIOB) Output Disable Register */
#define REG_PIOB_OSR       REG_ACCESS(RoReg, 0x400E1018U) /*  (PIOB) Output Status Register */
#define REG_PIOB_IFER      REG_ACCESS(WoReg, 0x400E1020U) /*  (PIOB) Glitch Input Filter Enable Register */
#define REG_PIOB_IFDR      REG_ACCESS(WoReg, 0x400E1024U) /*  (PIOB) Glitch Input Filter Disable Register */
#define REG_PIOB_IFSR      REG_ACCESS(RoReg, 0x400E1028U) /*  (PIOB) Glitch Input Filter Status Register */
#define REG_PIOB_SODR      REG_ACCESS(WoReg, 0x400E1030U) /*  (PIOB) Set Output Data Register */
#define REG_PIOB_CODR      REG_ACCESS(WoReg, 0x400E1034U) /*  (PIOB) Clear Output Data Register */
#define REG_PIOB_ODSR      REG_ACCESS(RwReg, 0x400E1038U) /*  (PIOB) Output Data Status Register */
#define REG_PIOB_PDSR      REG_ACCESS(RoReg, 0x400E103CU) /*  (PIOB) Pin Data Status Register */
#define REG_PIOB_IER       REG_ACCESS(WoReg, 0x400E1040U) /*  (PIOB) Interrupt Enable Register */
#define REG_PIOB_IDR       REG_ACCESS(WoReg, 0x400E1044U) /*  (PIOB) Interrupt Disable Register */
#define REG_PIOB_IMR       REG_ACCESS(RoReg, 0x400E1048U) /*  (PIOB) Interrupt Mask Register */
#define REG_PIOB_ISR       REG_ACCESS(RoReg, 0x400E104CU) /*  (PIOB) Interrupt Status Register */
#define REG_PIOB_MDER      REG_ACCESS(WoReg, 0x400E1050U) /*  (PIOB) Multi-driver Enable Register */
#define REG_PIOB_MDDR      REG_ACCESS(WoReg, 0x400E1054U) /*  (PIOB) Multi-driver Disable Register */
#define REG_PIOB_MDSR      REG_ACCESS(RoReg, 0x400E1058U) /*  (PIOB) Multi-driver Status Register */
#define REG_PIOB_PUDR      REG_ACCESS(WoReg, 0x400E1060U) /*  (PIOB) Pull-up Disable Register */
#define REG_PIOB_PUER      REG_ACCESS(WoReg, 0x400E1064U) /*  (PIOB) Pull-up Enable Register */
#define REG_PIOB_PUSR      REG_ACCESS(RoReg, 0x400E1068U) /*  (PIOB) Pad Pull-up Status Register */
#define REG_PIOB_ABCDSR    REG_ACCESS(RwReg, 0x400E1070U) /*  (PIOB) Peripheral Select Register */
#define REG_PIOB_IFSCDR    REG_ACCESS(WoReg, 0x400E1080U) /*  (PIOB) Input Filter Slow Clock Disable Register */
#define REG_PIOB_IFSCER    REG_ACCESS(WoReg, 0x400E1084U) /*  (PIOB) Input Filter Slow Clock Enable Register */
#define REG_PIOB_IFSCSR    REG_ACCESS(RoReg, 0x400E1088U) /*  (PIOB) Input Filter Slow Clock Status Register */
#define REG_PIOB_SCDR      REG_ACCESS(RwReg, 0x400E108CU) /*  (PIOB) Slow Clock Divider Debouncing Register */
#define REG_PIOB_PPDDR     REG_ACCESS(WoReg, 0x400E1090U) /*  (PIOB) Pad Pull-down Disable Register */
#define REG_PIOB_PPDER     REG_ACCESS(WoReg, 0x400E1094U) /*  (PIOB) Pad Pull-down Enable Register */
#define REG_PIOB_PPDSR     REG_ACCESS(RoReg, 0x400E1098U) /*  (PIOB) Pad Pull-down Status Register */
#define REG_PIOB_OWER      REG_ACCESS(WoReg, 0x400E10A0U) /*  (PIOB) Output Write Enable */
#define REG_PIOB_OWDR      REG_ACCESS(WoReg, 0x400E10A4U) /*  (PIOB) Output Write Disable */
#define REG_PIOB_OWSR      REG_ACCESS(RoReg, 0x400E10A8U) /*  (PIOB) Output Write Status Register */
#define REG_PIOB_AIMER     REG_ACCESS(WoReg, 0x400E10B0U) /*  (PIOB) Additional Interrupt Modes Enable Register */
#define REG_PIOB_AIMDR     REG_ACCESS(WoReg, 0x400E10B4U) /*  (PIOB) Additional Interrupt Modes Disables Register */
#define REG_PIOB_AIMMR     REG_ACCESS(RoReg, 0x400E10B8U) /*  (PIOB) Additional Interrupt Modes Mask Register */
#define REG_PIOB_ESR       REG_ACCESS(WoReg, 0x400E10C0U) /*  (PIOB) Edge Select Register */
#define REG_PIOB_LSR       REG_ACCESS(WoReg, 0x400E10C4U) /*  (PIOB) Level Select Register */
#define REG_PIOB_ELSR      REG_ACCESS(RoReg, 0x400E10C8U) /*  (PIOB) Edge/Level Status Register */
#define REG_PIOB_FELLSR    REG_ACCESS(WoReg, 0x400E10D0U) /*  (PIOB) Falling Edge/Low Level Select Register */
#define REG_PIOB_REHLSR    REG_ACCESS(WoReg, 0x400E10D4U) /*  (PIOB) Rising Edge/ High Level Select Register */
#define REG_PIOB_FRLHSR    REG_ACCESS(RoReg, 0x400E10D8U) /*  (PIOB) Fall/Rise - Low/High Status Register */
#define REG_PIOB_LOCKSR    REG_ACCESS(RoReg, 0x400E10E0U) /*  (PIOB) Lock Status */
#define REG_PIOB_WPMR      REG_ACCESS(RwReg, 0x400E10E4U) /*  (PIOB) Write Protect Mode Register */
#define REG_PIOB_WPSR      REG_ACCESS(RoReg, 0x400E10E8U) /*  (PIOB) Write Protect Status Register */
#define REG_PIOB_SCHMITT   REG_ACCESS(RwReg, 0x400E1100U) /*  (PIOB) Schmitt Trigger Register */
/* ========== Register definition for PIOC peripheral ========== */
#define REG_PIOC_PER       REG_ACCESS(WoReg, 0x400E1200U) /*  (PIOC) PIO Enable Register */
#define REG_PIOC_PDR       REG_ACCESS(WoReg, 0x400E1204U) /*  (PIOC) PIO Disable Register */
#define REG_PIOC_PSR       REG_ACCESS(RoReg, 0x400E1208U) /*  (PIOC) PIO Status Register */
#define REG_PIOC_OER       REG_ACCESS(WoReg, 0x400E1210U) /*  (PIOC) Output Enable Register */
#define REG_PIOC_ODR       REG_ACCESS(WoReg, 0x400E1214U) /*  (PIOC) Output Disable Register */
#define REG_PIOC_OSR       REG_ACCESS(RoReg, 0x400E1218U) /*  (PIOC) Output Status Register */
#define REG_PIOC_IFER      REG_ACCESS(WoReg, 0x400E1220U) /*  (PIOC) Glitch Input Filter Enable Register */
#define REG_PIOC_IFDR      REG_ACCESS(WoReg, 0x400E1224U) /*  (PIOC) Glitch Input Filter Disable Register */
#define REG_PIOC_IFSR      REG_ACCESS(RoReg, 0x400E1228U) /*  (PIOC) Glitch Input Filter Status Register */
#define REG_PIOC_SODR      REG_ACCESS(WoReg, 0x400E1230U) /*  (PIOC) Set Output Data Register */
#define REG_PIOC_CODR      REG_ACCESS(WoReg, 0x400E1234U) /*  (PIOC) Clear Output Data Register */
#define REG_PIOC_ODSR      REG_ACCESS(RwReg, 0x400E1238U) /*  (PIOC) Output Data Status Register */
#define REG_PIOC_PDSR      REG_ACCESS(RoReg, 0x400E123CU) /*  (PIOC) Pin Data Status Register */
#define REG_PIOC_IER       REG_ACCESS(WoReg, 0x400E1240U) /*  (PIOC) Interrupt Enable Register */
#define REG_PIOC_IDR       REG_ACCESS(WoReg, 0x400E1244U) /*  (PIOC) Interrupt Disable Register */
#define REG_PIOC_IMR       REG_ACCESS(RoReg, 0x400E1248U) /*  (PIOC) Interrupt Mask Register */
#define REG_PIOC_ISR       REG_ACCESS(RoReg, 0x400E124CU) /*  (PIOC) Interrupt Status Register */
#define REG_PIOC_MDER      REG_ACCESS(WoReg, 0x400E1250U) /*  (PIOC) Multi-driver Enable Register */
#define REG_PIOC_MDDR      REG_ACCESS(WoReg, 0x400E1254U) /*  (PIOC) Multi-driver Disable Register */
#define REG_PIOC_MDSR      REG_ACCESS(RoReg, 0x400E1258U) /*  (PIOC) Multi-driver Status Register */
#define REG_PIOC_PUDR      REG_ACCESS(WoReg, 0x400E1260U) /*  (PIOC) Pull-up Disable Register */
#define REG_PIOC_PUER      REG_ACCESS(WoReg, 0x400E1264U) /*  (PIOC) Pull-up Enable Register */
#define REG_PIOC_PUSR      REG_ACCESS(RoReg, 0x400E1268U) /*  (PIOC) Pad Pull-up Status Register */
#define REG_PIOC_ABCDSR    REG_ACCESS(RwReg, 0x400E1270U) /*  (PIOC) Peripheral Select Register */
#define REG_PIOC_IFSCDR    REG_ACCESS(WoReg, 0x400E1280U) /*  (PIOC) Input Filter Slow Clock Disable Register */
#define REG_PIOC_IFSCER    REG_ACCESS(WoReg, 0x400E1284U) /*  (PIOC) Input Filter Slow Clock Enable Register */
#define REG_PIOC_IFSCSR    REG_ACCESS(RoReg, 0x400E1288U) /*  (PIOC) Input Filter Slow Clock Status Register */
#define REG_PIOC_SCDR      REG_ACCESS(RwReg, 0x400E128CU) /*  (PIOC) Slow Clock Divider Debouncing Register */
#define REG_PIOC_PPDDR     REG_ACCESS(WoReg, 0x400E1290U) /*  (PIOC) Pad Pull-down Disable Register */
#define REG_PIOC_PPDER     REG_ACCESS(WoReg, 0x400E1294U) /*  (PIOC) Pad Pull-down Enable Register */
#define REG_PIOC_PPDSR     REG_ACCESS(RoReg, 0x400E1298U) /*  (PIOC) Pad Pull-down Status Register */
#define REG_PIOC_OWER      REG_ACCESS(WoReg, 0x400E12A0U) /*  (PIOC) Output Write Enable */
#define REG_PIOC_OWDR      REG_ACCESS(WoReg, 0x400E12A4U) /*  (PIOC) Output Write Disable */
#define REG_PIOC_OWSR      REG_ACCESS(RoReg, 0x400E12A8U) /*  (PIOC) Output Write Status Register */
#define REG_PIOC_AIMER     REG_ACCESS(WoReg, 0x400E12B0U) /*  (PIOC) Additional Interrupt Modes Enable Register */
#define REG_PIOC_AIMDR     REG_ACCESS(WoReg, 0x400E12B4U) /*  (PIOC) Additional Interrupt Modes Disables Register */
#define REG_PIOC_AIMMR     REG_ACCESS(RoReg, 0x400E12B8U) /*  (PIOC) Additional Interrupt Modes Mask Register */
#define REG_PIOC_ESR       REG_ACCESS(WoReg, 0x400E12C0U) /*  (PIOC) Edge Select Register */
#define REG_PIOC_LSR       REG_ACCESS(WoReg, 0x400E12C4U) /*  (PIOC) Level Select Register */
#define REG_PIOC_ELSR      REG_ACCESS(RoReg, 0x400E12C8U) /*  (PIOC) Edge/Level Status Register */
#define REG_PIOC_FELLSR    REG_ACCESS(WoReg, 0x400E12D0U) /*  (PIOC) Falling Edge/Low Level Select Register */
#define REG_PIOC_REHLSR    REG_ACCESS(WoReg, 0x400E12D4U) /*  (PIOC) Rising Edge/ High Level Select Register */
#define REG_PIOC_FRLHSR    REG_ACCESS(RoReg, 0x400E12D8U) /*  (PIOC) Fall/Rise - Low/High Status Register */
#define REG_PIOC_LOCKSR    REG_ACCESS(RoReg, 0x400E12E0U) /*  (PIOC) Lock Status */
#define REG_PIOC_WPMR      REG_ACCESS(RwReg, 0x400E12E4U) /*  (PIOC) Write Protect Mode Register */
#define REG_PIOC_WPSR      REG_ACCESS(RoReg, 0x400E12E8U) /*  (PIOC) Write Protect Status Register */
#define REG_PIOC_SCHMITT   REG_ACCESS(RwReg, 0x400E1300U) /*  (PIOC) Schmitt Trigger Register */
/* ========== Register definition for RSTC peripheral ========== */
#define REG_RSTC_CR        REG_ACCESS(WoReg, 0x400E1400U) /*  (RSTC) Control Register */
#define REG_RSTC_SR        REG_ACCESS(RoReg, 0x400E1404U) /*  (RSTC) Status Register */
#define REG_RSTC_MR        REG_ACCESS(RwReg, 0x400E1408U) /*  (RSTC) Mode Register */
/* ========== Register definition for SUPC peripheral ========== */
#define REG_SUPC_CR        REG_ACCESS(WoReg, 0x400E1410U) /*  (SUPC) Supply Controller Control Register */
#define REG_SUPC_SMMR      REG_ACCESS(RwReg, 0x400E1414U) /*  (SUPC) Supply Controller Supply Monitor Mode Register */
#define REG_SUPC_MR        REG_ACCESS(RwReg, 0x400E1418U) /*  (SUPC) Supply Controller Mode Register */
#define REG_SUPC_WUMR      REG_ACCESS(RwReg, 0x400E141CU) /*  (SUPC) Supply Controller Wake Up Mode Register */
#define REG_SUPC_WUIR      REG_ACCESS(RwReg, 0x400E1420U) /*  (SUPC) Supply Controller Wake Up Inputs Register */
#define REG_SUPC_SR        REG_ACCESS(RoReg, 0x400E1424U) /*  (SUPC) Supply Controller Status Register */
/* ========== Register definition for RTT peripheral ========== */
#define REG_RTT_MR         REG_ACCESS(RwReg, 0x400E1430U) /*  (RTT) Mode Register */
#define REG_RTT_AR         REG_ACCESS(RwReg, 0x400E1434U) /*  (RTT) Alarm Register */
#define REG_RTT_VR         REG_ACCESS(RoReg, 0x400E1438U) /*  (RTT) Value Register */
#define REG_RTT_SR         REG_ACCESS(RoReg, 0x400E143CU) /*  (RTT) Status Register */
/* ========== Register definition for WDT peripheral ========== */
#define REG_WDT_CR         REG_ACCESS(WoReg, 0x400E1450U) /*  (WDT) Control Register */
#define REG_WDT_MR         REG_ACCESS(RwReg, 0x400E1454U) /*  (WDT) Mode Register */
#define REG_WDT_SR         REG_ACCESS(RoReg, 0x400E1458U) /*  (WDT) Status Register */
/* ========== Register definition for RTC peripheral ========== */
#define REG_RTC_CR         REG_ACCESS(RwReg, 0x400E1460U) /*  (RTC) Control Register */
#define REG_RTC_MR         REG_ACCESS(RwReg, 0x400E1464U) /*  (RTC) Mode Register */
#define REG_RTC_TIMR       REG_ACCESS(RwReg, 0x400E1468U) /*  (RTC) Time Register */
#define REG_RTC_CALR       REG_ACCESS(RwReg, 0x400E146CU) /*  (RTC) Calendar Register */
#define REG_RTC_TIMALR     REG_ACCESS(RwReg, 0x400E1470U) /*  (RTC) Time Alarm Register */
#define REG_RTC_CALALR     REG_ACCESS(RwReg, 0x400E1474U) /*  (RTC) Calendar Alarm Register */
#define REG_RTC_SR         REG_ACCESS(RoReg, 0x400E1478U) /*  (RTC) Status Register */
#define REG_RTC_SCCR       REG_ACCESS(WoReg, 0x400E147CU) /*  (RTC) Status Clear Command Register */
#define REG_RTC_IER        REG_ACCESS(WoReg, 0x400E1480U) /*  (RTC) Interrupt Enable Register */
#define REG_RTC_IDR        REG_ACCESS(WoReg, 0x400E1484U) /*  (RTC) Interrupt Disable Register */
#define REG_RTC_IMR        REG_ACCESS(RoReg, 0x400E1488U) /*  (RTC) Interrupt Mask Register */
#define REG_RTC_VER        REG_ACCESS(RoReg, 0x400E148CU) /*  (RTC) Valid Entry Register */
#define REG_RTC_WPMR       REG_ACCESS(RwReg, 0x400E1544U) /*  (RTC) Write Protect Mode Register */
/* ========== Register definition for GPBR peripheral ========== */
#define REG_GPBR_GPBR0     REG_ACCESS(RwReg, 0x400E1490U) /*  (GPBR) General Purpose Backup Register 0 */
#define REG_GPBR_GPBR1     REG_ACCESS(RwReg, 0x400E1494U) /*  (GPBR) General Purpose Backup Register 1 */
#define REG_GPBR_GPBR2     REG_ACCESS(RwReg, 0x400E1498U) /*  (GPBR) General Purpose Backup Register 2 */
#define REG_GPBR_GPBR3     REG_ACCESS(RwReg, 0x400E149CU) /*  (GPBR) General Purpose Backup Register 3 */
#define REG_GPBR_GPBR4     REG_ACCESS(RwReg, 0x400E14A0U) /*  (GPBR) General Purpose Backup Register 4 */
#define REG_GPBR_GPBR5     REG_ACCESS(RwReg, 0x400E14A4U) /*  (GPBR) General Purpose Backup Register 5 */
#define REG_GPBR_GPBR6     REG_ACCESS(RwReg, 0x400E14A8U) /*  (GPBR) General Purpose Backup Register 6 */
#define REG_GPBR_GPBR7     REG_ACCESS(RwReg, 0x400E14ACU) /*  (GPBR) General Purpose Backup Register 7 */

/* ************************************************************************** */
/*   PERIPHERAL ID DEFINITIONS FOR SAM3N */
/* ************************************************************************** */

#define ID_SUPC   ( 0) /*  Supply Controller (SUPC) */
#define ID_RSTC   ( 1) /*  Reset Controller (RSTC) */
#define ID_RTC    ( 2) /*  Real Time Clock (RTC) */
#define ID_RTT    ( 3) /*  Real Time Timer (RTT) */
#define ID_WDT    ( 4) /*  Watchdog Timer (WDT) */
#define ID_PMC    ( 5) /*  Power Management Controller (PMC) */
#define ID_EFC    ( 6) /*  Enhanced Flash Controller (EFC) */
#define ID_UART0  ( 8) /*  UART 0 (UART0) */
#define ID_UART1  ( 9) /*  UART 1 (UART1) */
#define ID_PIOA   (11) /*  Parallel I/O Controller A (PIOA) */
#define ID_PIOB   (12) /*  Parallel I/O Controller B (PIOB) */
#define ID_PIOC   (13) /*  Parallel I/O Controller C (PIOC) */
#define ID_USART0 (14) /*  USART 0 (USART0) */
#define ID_USART1 (15) /*  USART 1 (USART1) */
#define ID_TWI0   (19) /*  Two Wire Interface 0 (TWI0) */
#define ID_TWI1   (20) /*  Two Wire Interface 1 (TWI1) */
#define ID_SPI    (21) /*  Serial Peripheral Interface (SPI) */
#define ID_TC0    (23) /*  Timer/Counter 0 (TC0) */
#define ID_TC1    (24) /*  Timer/Counter 1 (TC1) */
#define ID_TC2    (25) /*  Timer/Counter 2 (TC2) */
#define ID_TC3    (26) /*  Timer/Counter 3 (TC3) */
#define ID_TC4    (27) /*  Timer/Counter 4 (TC4) */
#define ID_TC5    (28) /*  Timer/Counter 5 (TC5) */
#define ID_ADC    (29) /*  Analog To Digital Converter (ADC) */
#define ID_DACC   (30) /*  Digital To Analog Converter (DACC) */
#define ID_PWM    (31) /*  Pulse Width Modulation (PWM) */

/* ************************************************************************** */
/*   BASE ADDRESS DEFINITIONS FOR SAM3N */
/* ************************************************************************** */

#define SPI        CAST(Spi       , 0x40008000U) /*  (SPI       ) Base Address */
#define PDC_SPI    CAST(Pdc       , 0x40008100U) /*  (PDC_SPI   ) Base Address */
#define TC0        CAST(Tc        , 0x40010000U) /*  (TC0       ) Base Address */
#define TC1        CAST(Tc        , 0x40014000U) /*  (TC1       ) Base Address */
#define TWI0       CAST(Twi       , 0x40018000U) /*  (TWI0      ) Base Address */
#define PDC_TWI0   CAST(Pdc       , 0x40018100U) /*  (PDC_TWI0  ) Base Address */
#define TWI1       CAST(Twi       , 0x4001C000U) /*  (TWI1      ) Base Address */
#define PWM        CAST(Pwm       , 0x40020000U) /*  (PWM       ) Base Address */
#define USART0     CAST(Usart     , 0x40024000U) /*  (USART0    ) Base Address */
#define PDC_USART0 CAST(Pdc       , 0x40024100U) /*  (PDC_USART0) Base Address */
#define USART1     CAST(Usart     , 0x40028000U) /*  (USART1    ) Base Address */
#define ADC        CAST(Adc       , 0x40038000U) /*  (ADC       ) Base Address */
#define PDC_ADC    CAST(Pdc       , 0x40038100U) /*  (PDC_ADC   ) Base Address */
#define DACC       CAST(Dacc      , 0x4003C000U) /*  (DACC      ) Base Address */
#define PDC_DACC   CAST(Pdc       , 0x4003C100U) /*  (PDC_DACC  ) Base Address */
#define MATRIX     CAST(Matrix    , 0x400E0200U) /*  (MATRIX    ) Base Address */
#define PMC        CAST(Pmc       , 0x400E0400U) /*  (PMC       ) Base Address */
#define UART0      CAST(Uart      , 0x400E0600U) /*  (UART0     ) Base Address */
#define PDC_UART0  CAST(Pdc       , 0x400E0700U) /*  (PDC_UART0 ) Base Address */
#define CHIPID     CAST(Chipid    , 0x400E0740U) /*  (CHIPID    ) Base Address */
#define UART1      CAST(Uart      , 0x400E0800U) /*  (UART1     ) Base Address */
#define EFC        CAST(Efc       , 0x400E0A00U) /*  (EFC       ) Base Address */
#define PIOA       CAST(Pio       , 0x400E0E00U) /*  (PIOA      ) Base Address */
#define PIOB       CAST(Pio       , 0x400E1000U) /*  (PIOB      ) Base Address */
#define PIOC       CAST(Pio       , 0x400E1200U) /*  (PIOC      ) Base Address */
#define RSTC       CAST(Rstc      , 0x400E1400U) /*  (RSTC      ) Base Address */
#define SUPC       CAST(Supc      , 0x400E1410U) /*  (SUPC      ) Base Address */
#define RTT        CAST(Rtt       , 0x400E1430U) /*  (RTT       ) Base Address */
#define WDT        CAST(Wdt       , 0x400E1450U) /*  (WDT       ) Base Address */
#define RTC        CAST(Rtc       , 0x400E1460U) /*  (RTC       ) Base Address */
#define GPBR       CAST(Gpbr      , 0x400E1490U) /*  (GPBR      ) Base Address */

/* ************************************************************************** */
/*   PIO DEFINITIONS FOR SAM3N */
/* ************************************************************************** */

#define PIO_PA0          (1u << 0) /*  Pin Controlled by PA0 */
#define PIO_PA1          (1u << 1) /*  Pin Controlled by PA1 */
#define PIO_PA2          (1u << 2) /*  Pin Controlled by PA2 */
#define PIO_PA3          (1u << 3) /*  Pin Controlled by PA3 */
#define PIO_PA4          (1u << 4) /*  Pin Controlled by PA4 */
#define PIO_PA5          (1u << 5) /*  Pin Controlled by PA5 */
#define PIO_PA6          (1u << 6) /*  Pin Controlled by PA6 */
#define PIO_PA7          (1u << 7) /*  Pin Controlled by PA7 */
#define PIO_PA8          (1u << 8) /*  Pin Controlled by PA8 */
#define PIO_PA9          (1u << 9) /*  Pin Controlled by PA9 */
#define PIO_PA10         (1u << 10) /*  Pin Controlled by PA10 */
#define PIO_PA11         (1u << 11) /*  Pin Controlled by PA11 */
#define PIO_PA12         (1u << 12) /*  Pin Controlled by PA12 */
#define PIO_PA13         (1u << 13) /*  Pin Controlled by PA13 */
#define PIO_PA14         (1u << 14) /*  Pin Controlled by PA14 */
#define PIO_PA15         (1u << 15) /*  Pin Controlled by PA15 */
#define PIO_PA16         (1u << 16) /*  Pin Controlled by PA16 */
#define PIO_PA17         (1u << 17) /*  Pin Controlled by PA17 */
#define PIO_PA18         (1u << 18) /*  Pin Controlled by PA18 */
#define PIO_PA19         (1u << 19) /*  Pin Controlled by PA19 */
#define PIO_PA20         (1u << 20) /*  Pin Controlled by PA20 */
#define PIO_PA21         (1u << 21) /*  Pin Controlled by PA21 */
#define PIO_PA22         (1u << 22) /*  Pin Controlled by PA22 */
#define PIO_PA23         (1u << 23) /*  Pin Controlled by PA23 */
#define PIO_PA24         (1u << 24) /*  Pin Controlled by PA24 */
#define PIO_PA25         (1u << 25) /*  Pin Controlled by PA25 */
#define PIO_PA26         (1u << 26) /*  Pin Controlled by PA26 */
#define PIO_PA27         (1u << 27) /*  Pin Controlled by PA27 */
#define PIO_PA28         (1u << 28) /*  Pin Controlled by PA28 */
#define PIO_PA29         (1u << 29) /*  Pin Controlled by PA29 */
#define PIO_PA30         (1u << 30) /*  Pin Controlled by PA30 */
#define PIO_PA31         (1u << 31) /*  Pin Controlled by PA31 */
#define PIO_PB0          (1u << 0) /*  Pin Controlled by PB0 */
#define PIO_PB1          (1u << 1) /*  Pin Controlled by PB1 */
#define PIO_PB2          (1u << 2) /*  Pin Controlled by PB2 */
#define PIO_PB3          (1u << 3) /*  Pin Controlled by PB3 */
#define PIO_PB4          (1u << 4) /*  Pin Controlled by PB4 */
#define PIO_PB5          (1u << 5) /*  Pin Controlled by PB5 */
#define PIO_PB6          (1u << 6) /*  Pin Controlled by PB6 */
#define PIO_PB7          (1u << 7) /*  Pin Controlled by PB7 */
#define PIO_PB8          (1u << 8) /*  Pin Controlled by PB8 */
#define PIO_PB9          (1u << 9) /*  Pin Controlled by PB9 */
#define PIO_PB10         (1u << 10) /*  Pin Controlled by PB10 */
#define PIO_PB11         (1u << 11) /*  Pin Controlled by PB11 */
#define PIO_PB12         (1u << 12) /*  Pin Controlled by PB12 */
#define PIO_PB13         (1u << 13) /*  Pin Controlled by PB13 */
#define PIO_PB14         (1u << 14) /*  Pin Controlled by PB14 */
#define PIO_PC0          (1u << 0) /*  Pin Controlled by PC0 */
#define PIO_PC1          (1u << 1) /*  Pin Controlled by PC1 */
#define PIO_PC2          (1u << 2) /*  Pin Controlled by PC2 */
#define PIO_PC3          (1u << 3) /*  Pin Controlled by PC3 */
#define PIO_PC4          (1u << 4) /*  Pin Controlled by PC4 */
#define PIO_PC5          (1u << 5) /*  Pin Controlled by PC5 */
#define PIO_PC6          (1u << 6) /*  Pin Controlled by PC6 */
#define PIO_PC7          (1u << 7) /*  Pin Controlled by PC7 */
#define PIO_PC8          (1u << 8) /*  Pin Controlled by PC8 */
#define PIO_PC9          (1u << 9) /*  Pin Controlled by PC9 */
#define PIO_PC10         (1u << 10) /*  Pin Controlled by PC10 */
#define PIO_PC11         (1u << 11) /*  Pin Controlled by PC11 */
#define PIO_PC12         (1u << 12) /*  Pin Controlled by PC12 */
#define PIO_PC13         (1u << 13) /*  Pin Controlled by PC13 */
#define PIO_PC14         (1u << 14) /*  Pin Controlled by PC14 */
#define PIO_PC15         (1u << 15) /*  Pin Controlled by PC15 */
#define PIO_PC16         (1u << 16) /*  Pin Controlled by PC16 */
#define PIO_PC17         (1u << 17) /*  Pin Controlled by PC17 */
#define PIO_PC18         (1u << 18) /*  Pin Controlled by PC18 */
#define PIO_PC19         (1u << 19) /*  Pin Controlled by PC19 */
#define PIO_PC20         (1u << 20) /*  Pin Controlled by PC20 */
#define PIO_PC21         (1u << 21) /*  Pin Controlled by PC21 */
#define PIO_PC22         (1u << 22) /*  Pin Controlled by PC22 */
#define PIO_PC23         (1u << 23) /*  Pin Controlled by PC23 */
#define PIO_PC24         (1u << 24) /*  Pin Controlled by PC24 */
#define PIO_PC25         (1u << 25) /*  Pin Controlled by PC25 */
#define PIO_PC26         (1u << 26) /*  Pin Controlled by PC26 */
#define PIO_PC27         (1u << 27) /*  Pin Controlled by PC27 */
#define PIO_PC28         (1u << 28) /*  Pin Controlled by PC28 */
#define PIO_PC29         (1u << 29) /*  Pin Controlled by PC29 */
#define PIO_PC30         (1u << 30) /*  Pin Controlled by PC30 */
#define PIO_PC31         (1u << 31) /*  Pin Controlled by PC31 */
/* ========== Pio definition for SPI peripheral ========== */
#define PIO_PA12A_MISO       (1u << 12)  /*  Spi signal: MISO */
#define PIO_PA13A_MOSI       (1u << 13)  /*  Spi signal: MOSI */
#define PIO_PA11A_NPCS0      (1u << 11)  /*  Spi signal: NPCS0 */
#define PIO_PA9B_NPCS1       (1u << 9)   /*  Spi signal: NPCS1 */
#define PIO_PA31A_NPCS1      (1u << 31)  /*  Spi signal: NPCS1 */
#define PIO_PB14A_NPCS1      (1u << 14)  /*  Spi signal: NPCS1 */
#define PIO_PC4B_NPCS1       (1u << 4)   /*  Spi signal: NPCS1 */
#define PIO_PA10B_NPCS2      (1u << 10)  /*  Spi signal: NPCS2 */
#define PIO_PA30B_NPCS2      (1u << 30)  /*  Spi signal: NPCS2 */
#define PIO_PB2B_NPCS2       (1u << 2)   /*  Spi signal: NPCS2 */
#define PIO_PC7B_NPCS2       (1u << 7)   /*  Spi signal: NPCS2 */
#define PIO_PA3B_NPCS3       (1u << 3)   /*  Spi signal: NPCS3 */
#define PIO_PA5B_NPCS3       (1u << 5)   /*  Spi signal: NPCS3 */
#define PIO_PA22B_NPCS3      (1u << 22)  /*  Spi signal: NPCS3 */
#define PIO_PA14A_SPCK       (1u << 14)  /*  Spi signal: SPCK */
/* ========== Pio definition for TC0 peripheral ========== */
#define PIO_PA4B_TCLK0       (1u << 4)   /*  Tc0 signal: TCLK0 */
#define PIO_PA28B_TCLK1      (1u << 28)  /*  Tc0 signal: TCLK1 */
#define PIO_PA29B_TCLK2      (1u << 29)  /*  Tc0 signal: TCLK2 */
#define PIO_PA0B_TIOA0       (1u << 0)   /*  Tc0 signal: TIOA0 */
#define PIO_PA15B_TIOA1      (1u << 15)  /*  Tc0 signal: TIOA1 */
#define PIO_PA26B_TIOA2      (1u << 26)  /*  Tc0 signal: TIOA2 */
#define PIO_PA1B_TIOB0       (1u << 1)   /*  Tc0 signal: TIOB0 */
#define PIO_PA16B_TIOB1      (1u << 16)  /*  Tc0 signal: TIOB1 */
#define PIO_PA27B_TIOB2      (1u << 27)  /*  Tc0 signal: TIOB2 */
/* ========== Pio definition for TC1 peripheral ========== */
#define PIO_PC25B_TCLK3      (1u << 25)  /*  Tc1 signal: TCLK3 */
#define PIO_PC28B_TCLK4      (1u << 28)  /*  Tc1 signal: TCLK4 */
#define PIO_PC31B_TCLK5      (1u << 31)  /*  Tc1 signal: TCLK5 */
#define PIO_PC23B_TIOA3      (1u << 23)  /*  Tc1 signal: TIOA3 */
#define PIO_PC26B_TIOA4      (1u << 26)  /*  Tc1 signal: TIOA4 */
#define PIO_PC29B_TIOA5      (1u << 29)  /*  Tc1 signal: TIOA5 */
#define PIO_PC24B_TIOB3      (1u << 24)  /*  Tc1 signal: TIOB3 */
#define PIO_PC27B_TIOB4      (1u << 27)  /*  Tc1 signal: TIOB4 */
#define PIO_PC30B_TIOB5      (1u << 30)  /*  Tc1 signal: TIOB5 */
/* ========== Pio definition for TWI0 peripheral ========== */
#define PIO_PA4A_TWCK0       (1u << 4)   /*  Twi0 signal: TWCK0 */
#define PIO_PA3A_TWD0        (1u << 3)   /*  Twi0 signal: TWD0 */
/* ========== Pio definition for TWI1 peripheral ========== */
#define PIO_PB5A_TWCK1       (1u << 5)   /*  Twi1 signal: TWCK1 */
#define PIO_PB4A_TWD1        (1u << 4)   /*  Twi1 signal: TWD1 */
/* ========== Pio definition for PWM peripheral ========== */
#define PIO_PA0A_PWM0        (1u << 0)   /*  Pwm signal: PWM0 */
#define PIO_PA11B_PWM0       (1u << 11)  /*  Pwm signal: PWM0 */
#define PIO_PA23B_PWM0       (1u << 23)  /*  Pwm signal: PWM0 */
#define PIO_PB0A_PWM0        (1u << 0)   /*  Pwm signal: PWM0 */
#define PIO_PC8B_PWM0        (1u << 8)   /*  Pwm signal: PWM0 */
#define PIO_PC18B_PWM0       (1u << 18)  /*  Pwm signal: PWM0 */
#define PIO_PC22B_PWM0       (1u << 22)  /*  Pwm signal: PWM0 */
#define PIO_PA1A_PWM1        (1u << 1)   /*  Pwm signal: PWM1 */
#define PIO_PA12B_PWM1       (1u << 12)  /*  Pwm signal: PWM1 */
#define PIO_PA24B_PWM1       (1u << 24)  /*  Pwm signal: PWM1 */
#define PIO_PB1A_PWM1        (1u << 1)   /*  Pwm signal: PWM1 */
#define PIO_PC9B_PWM1        (1u << 9)   /*  Pwm signal: PWM1 */
#define PIO_PC19B_PWM1       (1u << 19)  /*  Pwm signal: PWM1 */
#define PIO_PA2A_PWM2        (1u << 2)   /*  Pwm signal: PWM2 */
#define PIO_PA13B_PWM2       (1u << 13)  /*  Pwm signal: PWM2 */
#define PIO_PA25B_PWM2       (1u << 25)  /*  Pwm signal: PWM2 */
#define PIO_PB4B_PWM2        (1u << 4)   /*  Pwm signal: PWM2 */
#define PIO_PC10B_PWM2       (1u << 10)  /*  Pwm signal: PWM2 */
#define PIO_PC20B_PWM2       (1u << 20)  /*  Pwm signal: PWM2 */
#define PIO_PA7B_PWM3        (1u << 7)   /*  Pwm signal: PWM3 */
#define PIO_PA14B_PWM3       (1u << 14)  /*  Pwm signal: PWM3 */
#define PIO_PB14B_PWM3       (1u << 14)  /*  Pwm signal: PWM3 */
#define PIO_PC11B_PWM3       (1u << 11)  /*  Pwm signal: PWM3 */
#define PIO_PC21B_PWM3       (1u << 21)  /*  Pwm signal: PWM3 */
/* ========== Pio definition for USART0 peripheral ========== */
#define PIO_PA8A_CTS0        (1u << 8)   /*  Usart0 signal: CTS0 */
#define PIO_PA7A_RTS0        (1u << 7)   /*  Usart0 signal: RTS0 */
#define PIO_PA5A_RXD0        (1u << 5)   /*  Usart0 signal: RXD0 */
#define PIO_PA2B_SCK0        (1u << 2)   /*  Usart0 signal: SCK0 */
#define PIO_PA6A_TXD0        (1u << 6)   /*  Usart0 signal: TXD0 */
/* ========== Pio definition for USART1 peripheral ========== */
#define PIO_PA25A_CTS1       (1u << 25)  /*  Usart1 signal: CTS1 */
#define PIO_PA24A_RTS1       (1u << 24)  /*  Usart1 signal: RTS1 */
#define PIO_PA21A_RXD1       (1u << 21)  /*  Usart1 signal: RXD1 */
#define PIO_PA23A_SCK1       (1u << 23)  /*  Usart1 signal: SCK1 */
#define PIO_PA22A_TXD1       (1u << 22)  /*  Usart1 signal: TXD1 */
/* ========== Pio definition for ADC peripheral ========== */
#define PIO_PA17X1_AD0       (1u << 17)  /*  Adc signal: AD0 */
#define PIO_PA18X1_AD1       (1u << 18)  /*  Adc signal: AD1 */
#define PIO_PC13X1_AD10      (1u << 13)  /*  Adc signal: AD10 */
#define PIO_PC15X1_AD11      (1u << 15)  /*  Adc signal: AD11 */
#define PIO_PC12X1_AD12      (1u << 12)  /*  Adc signal: AD12 */
#define PIO_PC29X1_AD13      (1u << 29)  /*  Adc signal: AD13 */
#define PIO_PC30X1_AD14      (1u << 30)  /*  Adc signal: AD14 */
#define PIO_PC31X1_AD15      (1u << 31)  /*  Adc signal: AD15 */
#define PIO_PA19X1_AD2_WKUP9 (1u << 19)  /*  Adc signal: AD2/WKUP9 */
#define PIO_PA20X1_AD3_WKUP10 (1u << 20) /*  Adc signal: AD3/WKUP10 */
#define PIO_PB0X1_AD4        (1u << 0)   /*  Adc signal: AD4 */
#define PIO_PB1X1_AD5        (1u << 1)   /*  Adc signal: AD5 */
#define PIO_PB2X1_AD6_WKUP12 (1u << 2)   /*  Adc signal: AD6/WKUP12 */
#define PIO_PB3X1_AD7        (1u << 3)   /*  Adc signal: AD7 */
#define PIO_PA21X1_AD8       (1u << 21)  /*  Adc signal: AD8 */
#define PIO_PA22X1_AD9       (1u << 22)  /*  Adc signal: AD9 */
#define PIO_PA8B_ADTRG       (1u << 8)   /*  Adc signal: ADTRG */
/* ========== Pio definition for DACC peripheral ========== */
#define PIO_PB13X1_DAC0      (1u << 13)  /*  Dacc signal: DAC0 */
/* ========== Pio definition for PMC peripheral ========== */
#define PIO_PA6B_PCK0        (1u << 6)   /*  Pmc signal: PCK0 */
#define PIO_PB13B_PCK0       (1u << 13)  /*  Pmc signal: PCK0 */
#define PIO_PC16B_PCK0       (1u << 16)  /*  Pmc signal: PCK0 */
#define PIO_PA17B_PCK1       (1u << 17)  /*  Pmc signal: PCK1 */
#define PIO_PA21B_PCK1       (1u << 21)  /*  Pmc signal: PCK1 */
#define PIO_PC17B_PCK1       (1u << 17)  /*  Pmc signal: PCK1 */
#define PIO_PA18B_PCK2       (1u << 18)  /*  Pmc signal: PCK2 */
#define PIO_PA31B_PCK2       (1u << 31)  /*  Pmc signal: PCK2 */
#define PIO_PB3B_PCK2        (1u << 3)   /*  Pmc signal: PCK2 */
#define PIO_PC14B_PCK2       (1u << 14)  /*  Pmc signal: PCK2 */
/* ========== Pio definition for UART0 peripheral ========== */
#define PIO_PA9A_URXD0       (1u << 9)   /*  Uart0 signal: URXD0 */
#define PIO_PA10A_UTXD0      (1u << 10)  /*  Uart0 signal: UTXD0 */
/* ========== Pio definition for UART1 peripheral ========== */
#define PIO_PB2A_URXD1       (1u << 2)   /*  Uart1 signal: URXD1 */
#define PIO_PB3A_UTXD1       (1u << 3)   /*  Uart1 signal: UTXD1 */

/* ************************************************************************** */
/*   MEMORY MAPPING DEFINITIONS FOR SAM3N */
/* ************************************************************************** */

#define IFLASH_ADDR (0x00400000u) /* Internal Flash base address */
#define IROM_ADDR   (0x00800000u) /* Internal ROM base address */
#define IRAM_ADDR   (0x20000000u) /* Internal RAM base address */

#if CPU_CM3_SAM3N1
#define IFLASH_SIZE 0x10000
#define IFLASH_PAGE_SIZE              (256) /* Internal FLASH 0 Page Size: 256 bytes */
#define IFLASH_LOCK_REGION_SIZE     (16384) /* Internal FLASH 0 Lock Region Size: 16 Kbytes */
#define IFLASH_NB_OF_PAGES            (256) /* Internal FLASH 0 Number of Pages: 256 */
#define IFLASH_NB_OF_LOCK_BITS          (4) /* Internal FLASH 0 Number of Lock Bits: 4 */
#define IRAM_SIZE 0x2000
#elif CPU_CM3_SAM3N2
#define IFLASH_SIZE 0x20000
#define IFLASH_PAGE_SIZE              (256) /* Internal FLASH 0 Page Size: 256 bytes */
#define IFLASH_LOCK_REGION_SIZE     (16384) /* Internal FLASH 0 Lock Region Size: 16 Kbytes */
#define IFLASH_NB_OF_PAGES            (512) /* Internal FLASH 0 Number of Pages: 512 */
#define IFLASH_NB_OF_LOCK_BITS          (8) /* Internal FLASH 0 Number of Lock Bits: 8 */
#define IRAM_SIZE 0x4000
#elif CPU_CM3_SAM3N4
#define IFLASH_SIZE 0x40000
#define IFLASH_PAGE_SIZE              (256) /* Internal FLASH 0 Page Size: 256 bytes */
#define IFLASH_LOCK_REGION_SIZE     (16384) /* Internal FLASH 0 Lock Region Size: 16 Kbytes */
#define IFLASH_NB_OF_PAGES           (1024) /* Internal FLASH 0 Number of Pages: 1024 */
#define IFLASH_NB_OF_LOCK_BITS         (16) /* Internal FLASH 0 Number of Lock Bits: 16 */
#define IRAM_SIZE 0x6000
#else
  #error Library does not support the specified device.
#endif

#ifdef __cplusplus
}
#endif


#endif /* SAM3N_H */
