/**
 * \file
 * <!--
 * This file is part of BeRTOS.
 *
 * Bertos is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 * As a special exception, you may use this file as part of a free software
 * library without restriction.  Specifically, if other files instantiate
 * templates or use macros or inline functions from this file, or you compile
 * this file and link it with other files to produce an executable, this
 * file does not by itself cause the resulting executable to be covered by
 * the GNU General Public License.  This exception does not however
 * invalidate any other reasons why the executable file might be covered by
 * the GNU General Public License.
 *
 * Copyright 2010 Develer S.r.l. (http://www.develer.com/)
 *
 * -->
 *
 * \brief LM3S1968 UART hardware.
 */

#ifndef LM3S_UART_H
#define LM3S_UART_H

/**
 * The following are defines for the UART register offsets.
 */
/*\{*/
#define UART_O_DR               0x00000000  //< UART Data
#define UART_O_RSR              0x00000004  //< UART Receive Status/Error Clear
#define UART_O_ECR              0x00000004  //< UART Receive Status/Error Clear
#define UART_O_FR               0x00000018  //< UART Flag
#define UART_O_ILPR             0x00000020  //< UART IrDA Low-Power Register
#define UART_O_IBRD             0x00000024  //< UART Integer Baud-Rate Divisor
#define UART_O_FBRD             0x00000028  //< UART Fractional Baud-Rate
                                            //< Divisor
#define UART_O_LCRH             0x0000002C  //< UART Line Control
#define UART_O_CTL              0x00000030  //< UART Control
#define UART_O_IFLS             0x00000034  //< UART Interrupt FIFO Level Select
#define UART_O_IM               0x00000038  //< UART Interrupt Mask
#define UART_O_RIS              0x0000003C  //< UART Raw Interrupt Status
#define UART_O_MIS              0x00000040  //< UART Masked Interrupt Status
#define UART_O_ICR              0x00000044  //< UART Interrupt Clear
#define UART_O_DMACTL           0x00000048  //< UART DMA Control
#define UART_O_LCTL             0x00000090  //< UART LIN Control
#define UART_O_LSS              0x00000094  //< UART LIN Snap Shot
#define UART_O_LTIM             0x00000098  //< UART LIN Timer
/*\}*/

/**
 * The following are defines for the bit fields in the UART_O_DR register.
 */
/*\{*/
#define UART_DR_OE              0x00000800  //< UART Overrun Error
#define UART_DR_BE              0x00000400  //< UART Break Error
#define UART_DR_PE              0x00000200  //< UART Parity Error
#define UART_DR_FE              0x00000100  //< UART Framing Error
#define UART_DR_DATA_M          0x000000FF  //< Data Transmitted or Received
#define UART_DR_DATA_S          0
/*\}*/

/**
 * The following are defines for the bit fields in the UART_O_RSR register.
 */
/*\{*/
#define UART_RSR_OE             0x00000008  //< UART Overrun Error
#define UART_RSR_BE             0x00000004  //< UART Break Error
#define UART_RSR_PE             0x00000002  //< UART Parity Error
#define UART_RSR_FE             0x00000001  //< UART Framing Error
/*\}*/

/**
 * The following are defines for the bit fields in the UART_O_ECR register.
 */
/*\{*/
#define UART_ECR_DATA_M         0x000000FF  //< Error Clear
#define UART_ECR_DATA_S         0
/*\}*/

/**
 * The following are defines for the bit fields in the UART_O_FR register.
 */
/*\{*/
#define UART_FR_RI              0x00000100  //< Ring Indicator
#define UART_FR_TXFE            0x00000080  //< UART Transmit FIFO Empty
#define UART_FR_RXFF            0x00000040  //< UART Receive FIFO Full
#define UART_FR_TXFF            0x00000020  //< UART Transmit FIFO Full
#define UART_FR_RXFE            0x00000010  //< UART Receive FIFO Empty
#define UART_FR_BUSY            0x00000008  //< UART Busy
#define UART_FR_DCD             0x00000004  //< Data Carrier Detect
#define UART_FR_DSR             0x00000002  //< Data Set Ready
#define UART_FR_CTS             0x00000001  //< Clear To Send
/*\}*/

/**
 * The following are defines for the bit fields in the UART_O_ILPR register.
 */
/*\{*/
#define UART_ILPR_ILPDVSR_M     0x000000FF  //< IrDA Low-Power Divisor
#define UART_ILPR_ILPDVSR_S     0
/*\}*/

/**
 * The following are defines for the bit fields in the UART_O_IBRD register.
 */
/*\{*/
#define UART_IBRD_DIVINT_M      0x0000FFFF  //< Integer Baud-Rate Divisor
#define UART_IBRD_DIVINT_S      0
/*\}*/

/**
 * The following are defines for the bit fields in the UART_O_FBRD register.
 */
/*\{*/
#define UART_FBRD_DIVFRAC_M     0x0000003F  //< Fractional Baud-Rate Divisor
#define UART_FBRD_DIVFRAC_S     0
/*\}*/

/**
 * The following are defines for the bit fields in the UART_O_LCRH register.
 */
/*\{*/
#define UART_LCRH_SPS           0x00000080  //< UART Stick Parity Select
#define UART_LCRH_WLEN_M        0x00000060  //< UART Word Length
#define UART_LCRH_WLEN_5        0x00000000  //< 5 bits (default)
#define UART_LCRH_WLEN_6        0x00000020  //< 6 bits
#define UART_LCRH_WLEN_7        0x00000040  //< 7 bits
#define UART_LCRH_WLEN_8        0x00000060  //< 8 bits
#define UART_LCRH_FEN           0x00000010  //< UART Enable FIFOs
#define UART_LCRH_STP2          0x00000008  //< UART Two Stop Bits Select
#define UART_LCRH_EPS           0x00000004  //< UART Even Parity Select
#define UART_LCRH_PEN           0x00000002  //< UART Parity Enable
#define UART_LCRH_BRK           0x00000001  //< UART Send Break
/*\}*/

/**
 * The following are defines for the bit fields in the UART_O_CTL register.
 */
/*\{*/
#define UART_CTL_CTSEN          0x00008000  //< Enable Clear To Send
#define UART_CTL_RTSEN          0x00004000  //< Enable Request to Send
#define UART_CTL_RTS            0x00000800  //< Request to Send
#define UART_CTL_DTR            0x00000400  //< Data Terminal Ready
#define UART_CTL_RXE            0x00000200  //< UART Receive Enable
#define UART_CTL_TXE            0x00000100  //< UART Transmit Enable
#define UART_CTL_LBE            0x00000080  //< UART Loop Back Enable
#define UART_CTL_LIN            0x00000040  //< LIN Mode Enable
#define UART_CTL_HSE            0x00000020  //< High-Speed Enable
#define UART_CTL_EOT            0x00000010  //< End of Transmission
#define UART_CTL_SMART          0x00000008  //< ISO 7816 Smart Card Support
#define UART_CTL_SIRLP          0x00000004  //< UART SIR Low-Power Mode
#define UART_CTL_SIREN          0x00000002  //< UART SIR Enable
#define UART_CTL_UARTEN         0x00000001  //< UART Enable
/*\}*/

/**
 * The following are defines for the bit fields in the UART_O_IFLS register.
 */
/*\{*/
#define UART_IFLS_RX_M          0x00000038  //< UART Receive Interrupt FIFO
                                            //< Level Select
#define UART_IFLS_RX1_8         0x00000000  //< RX FIFO >= 1/8 full
#define UART_IFLS_RX2_8         0x00000008  //< RX FIFO >= 1/4 full
#define UART_IFLS_RX4_8         0x00000010  //< RX FIFO >= 1/2 full (default)
#define UART_IFLS_RX6_8         0x00000018  //< RX FIFO >= 3/4 full
#define UART_IFLS_RX7_8         0x00000020  //< RX FIFO >= 7/8 full
#define UART_IFLS_TX_M          0x00000007  //< UART Transmit Interrupt FIFO
                                            //< Level Select
#define UART_IFLS_TX1_8         0x00000000  //< TX FIFO <= 1/8 full
#define UART_IFLS_TX2_8         0x00000001  //< TX FIFO <= 1/4 full
#define UART_IFLS_TX4_8         0x00000002  //< TX FIFO <= 1/2 full (default)
#define UART_IFLS_TX6_8         0x00000003  //< TX FIFO <= 3/4 full
#define UART_IFLS_TX7_8         0x00000004  //< TX FIFO <= 7/8 full
/*\}*/

/**
 * The following are defines for the bit fields in the UART_O_IM register.
 */
/*\{*/
#define UART_IM_LME5IM          0x00008000  //< LIN Mode Edge 5 Interrupt Mask
#define UART_IM_LME1IM          0x00004000  //< LIN Mode Edge 1 Interrupt Mask
#define UART_IM_LMSBIM          0x00002000  //< LIN Mode Sync Break Interrupt
                                            //< Mask
#define UART_IM_OEIM            0x00000400  //< UART Overrun Error Interrupt
                                            //< Mask
#define UART_IM_BEIM            0x00000200  //< UART Break Error Interrupt Mask
#define UART_IM_PEIM            0x00000100  //< UART Parity Error Interrupt Mask
#define UART_IM_FEIM            0x00000080  //< UART Framing Error Interrupt
                                            //< Mask
#define UART_IM_RTIM            0x00000040  //< UART Receive Time-Out Interrupt
                                            //< Mask
#define UART_IM_TXIM            0x00000020  //< UART Transmit Interrupt Mask
#define UART_IM_RXIM            0x00000010  //< UART Receive Interrupt Mask
#define UART_IM_DSRMIM          0x00000008  //< UART Data Set Ready Modem
                                            //< Interrupt Mask
#define UART_IM_DCDMIM          0x00000004  //< UART Data Carrier Detect Modem
                                            //< Interrupt Mask
#define UART_IM_CTSMIM          0x00000002  //< UART Clear to Send Modem
                                            //< Interrupt Mask
#define UART_IM_RIMIM           0x00000001  //< UART Ring Indicator Modem
                                            //< Interrupt Mask
/*\}*/

/**
 * The following are defines for the bit fields in the UART_O_RIS register.
 */
/*\{*/
#define UART_RIS_LME5RIS        0x00008000  //< LIN Mode Edge 5 Raw Interrupt
                                            //< Status
#define UART_RIS_LME1RIS        0x00004000  //< LIN Mode Edge 1 Raw Interrupt
                                            //< Status
#define UART_RIS_LMSBRIS        0x00002000  //< LIN Mode Sync Break Raw
                                            //< Interrupt Status
#define UART_RIS_OERIS          0x00000400  //< UART Overrun Error Raw Interrupt
                                            //< Status
#define UART_RIS_BERIS          0x00000200  //< UART Break Error Raw Interrupt
                                            //< Status
#define UART_RIS_PERIS          0x00000100  //< UART Parity Error Raw Interrupt
                                            //< Status
#define UART_RIS_FERIS          0x00000080  //< UART Framing Error Raw Interrupt
                                            //< Status
#define UART_RIS_RTRIS          0x00000040  //< UART Receive Time-Out Raw
                                            //< Interrupt Status
#define UART_RIS_TXRIS          0x00000020  //< UART Transmit Raw Interrupt
                                            //< Status
#define UART_RIS_RXRIS          0x00000010  //< UART Receive Raw Interrupt
                                            //< Status
#define UART_RIS_DSRRIS         0x00000008  //< UART Data Set Ready Modem Raw
                                            //< Interrupt Status
#define UART_RIS_DCDRIS         0x00000004  //< UART Data Carrier Detect Modem
                                            //< Raw Interrupt Status
#define UART_RIS_CTSRIS         0x00000002  //< UART Clear to Send Modem Raw
                                            //< Interrupt Status
#define UART_RIS_RIRIS          0x00000001  //< UART Ring Indicator Modem Raw
                                            //< Interrupt Status
/*\}*/

/**
 * The following are defines for the bit fields in the UART_O_MIS register.
 */
/*\{*/
#define UART_MIS_LME5MIS        0x00008000  //< LIN Mode Edge 5 Masked Interrupt
                                            //< Status
#define UART_MIS_LME1MIS        0x00004000  //< LIN Mode Edge 1 Masked Interrupt
                                            //< Status
#define UART_MIS_LMSBMIS        0x00002000  //< LIN Mode Sync Break Masked
                                            //< Interrupt Status
#define UART_MIS_OEMIS          0x00000400  //< UART Overrun Error Masked
                                            //< Interrupt Status
#define UART_MIS_BEMIS          0x00000200  //< UART Break Error Masked
                                            //< Interrupt Status
#define UART_MIS_PEMIS          0x00000100  //< UART Parity Error Masked
                                            //< Interrupt Status
#define UART_MIS_FEMIS          0x00000080  //< UART Framing Error Masked
                                            //< Interrupt Status
#define UART_MIS_RTMIS          0x00000040  //< UART Receive Time-Out Masked
                                            //< Interrupt Status
#define UART_MIS_TXMIS          0x00000020  //< UART Transmit Masked Interrupt
                                            //< Status
#define UART_MIS_RXMIS          0x00000010  //< UART Receive Masked Interrupt
                                            //< Status
#define UART_MIS_DSRMIS         0x00000008  //< UART Data Set Ready Modem Masked
                                            //< Interrupt Status
#define UART_MIS_DCDMIS         0x00000004  //< UART Data Carrier Detect Modem
                                            //< Masked Interrupt Status
#define UART_MIS_CTSMIS         0x00000002  //< UART Clear to Send Modem Masked
                                            //< Interrupt Status
#define UART_MIS_RIMIS          0x00000001  //< UART Ring Indicator Modem Masked
                                            //< Interrupt Status
/*\}*/

/**
 * The following are defines for the bit fields in the UART_O_ICR register.
 */
/*\{*/
#define UART_ICR_LME5MIC        0x00008000  //< LIN Mode Edge 5 Interrupt Clear
#define UART_ICR_LME1MIC        0x00004000  //< LIN Mode Edge 1 Interrupt Clear
#define UART_ICR_LMSBMIC        0x00002000  //< LIN Mode Sync Break Interrupt
                                            //< Clear
#define UART_ICR_OEIC           0x00000400  //< Overrun Error Interrupt Clear
#define UART_ICR_BEIC           0x00000200  //< Break Error Interrupt Clear
#define UART_ICR_PEIC           0x00000100  //< Parity Error Interrupt Clear
#define UART_ICR_FEIC           0x00000080  //< Framing Error Interrupt Clear
#define UART_ICR_RTIC           0x00000040  //< Receive Time-Out Interrupt Clear
#define UART_ICR_TXIC           0x00000020  //< Transmit Interrupt Clear
#define UART_ICR_RXIC           0x00000010  //< Receive Interrupt Clear
#define UART_ICR_DSRMIC         0x00000008  //< UART Data Set Ready Modem
                                            //< Interrupt Clear
#define UART_ICR_DCDMIC         0x00000004  //< UART Data Carrier Detect Modem
                                            //< Interrupt Clear
#define UART_ICR_CTSMIC         0x00000002  //< UART Clear to Send Modem
                                            //< Interrupt Clear
#define UART_ICR_RIMIC          0x00000001  //< UART Ring Indicator Modem
                                            //< Interrupt Clear
/*\}*/

/**
 * The following are defines for the bit fields in the UART_O_DMACTL register.
 */
/*\{*/
#define UART_DMACTL_DMAERR      0x00000004  //< DMA on Error
#define UART_DMACTL_TXDMAE      0x00000002  //< Transmit DMA Enable
#define UART_DMACTL_RXDMAE      0x00000001  //< Receive DMA Enable
/*\}*/

/**
 * The following are defines for the bit fields in the UART_O_LCTL register.
 */
/*\{*/
#define UART_LCTL_BLEN_M        0x00000030  //< Sync Break Length
#define UART_LCTL_BLEN_13T      0x00000000  //< Sync break length is 13T bits
                                            //< (default)
#define UART_LCTL_BLEN_14T      0x00000010  //< Sync break length is 14T bits
#define UART_LCTL_BLEN_15T      0x00000020  //< Sync break length is 15T bits
#define UART_LCTL_BLEN_16T      0x00000030  //< Sync break length is 16T bits
#define UART_LCTL_MASTER        0x00000001  //< LIN Master Enable
/*\}*/

/**
 * The following are defines for the bit fields in the UART_O_LSS register.
 */
/*\{*/
#define UART_LSS_TSS_M          0x0000FFFF  //< Timer Snap Shot
#define UART_LSS_TSS_S          0
/*\}*/

/**
 * The following are defines for the bit fields in the UART_O_LTIM register.
 */
/*\{*/
#define UART_LTIM_TIMER_M       0x0000FFFF  //< Timer Value
#define UART_LTIM_TIMER_S       0
/*\}*/

/**
 * The following definitions are deprecated.
 */
/*\{*/
#ifndef DEPRECATED
/*\}*/

/**
 * The following are deprecated defines for the UART register offsets.
 */
/*\{*/
#define UART_O_LCR_H            0x0000002C  //< Line Control Register, HIGH byte
#define UART_O_PeriphID4        0x00000FD0
#define UART_O_PeriphID5        0x00000FD4
#define UART_O_PeriphID6        0x00000FD8
#define UART_O_PeriphID7        0x00000FDC
#define UART_O_PeriphID0        0x00000FE0
#define UART_O_PeriphID1        0x00000FE4
#define UART_O_PeriphID2        0x00000FE8
#define UART_O_PeriphID3        0x00000FEC
#define UART_O_PCellID0         0x00000FF0
#define UART_O_PCellID1         0x00000FF4
#define UART_O_PCellID2         0x00000FF8
#define UART_O_PCellID3         0x00000FFC
/*\}*/

/**
 * The following are deprecated defines for the bit fields in the UART_O_DR
 * register.
 */
/*\{*/
#define UART_DR_DATA_MASK       0x000000FF  //< UART data
/*\}*/

/**
 * The following are deprecated defines for the bit fields in the UART_O_IBRD
 * register.
 */
/*\{*/
#define UART_IBRD_DIVINT_MASK   0x0000FFFF  //< Integer baud-rate divisor
/*\}*/

/**
 * The following are deprecated defines for the bit fields in the UART_O_FBRD
 * register.
 */
/*\{*/
#define UART_FBRD_DIVFRAC_MASK  0x0000003F  //< Fractional baud-rate divisor
/*\}*/

/**
 * The following are deprecated defines for the bit fields in the UART_O_LCR_H
 * register.
 */
/*\{*/
#define UART_LCR_H_SPS          0x00000080  //< Stick Parity Select
#define UART_LCR_H_WLEN         0x00000060  //< Word length
#define UART_LCR_H_WLEN_5       0x00000000  //< 5 bit data
#define UART_LCR_H_WLEN_6       0x00000020  //< 6 bit data
#define UART_LCR_H_WLEN_7       0x00000040  //< 7 bit data
#define UART_LCR_H_WLEN_8       0x00000060  //< 8 bit data
#define UART_LCR_H_FEN          0x00000010  //< Enable FIFO
#define UART_LCR_H_STP2         0x00000008  //< Two Stop Bits Select
#define UART_LCR_H_EPS          0x00000004  //< Even Parity Select
#define UART_LCR_H_PEN          0x00000002  //< Parity Enable
#define UART_LCR_H_BRK          0x00000001  //< Send Break
/*\}*/

/**
 * The following are deprecated defines for the bit fields in the UART_O_IFLS
 * register.
 */
/*\{*/
#define UART_IFLS_RX_MASK       0x00000038  //< RX FIFO level mask
#define UART_IFLS_TX_MASK       0x00000007  //< TX FIFO level mask
/*\}*/

/**
 * The following are deprecated defines for the bit fields in the UART_O_ICR
 * register.
 */
/*\{*/
#define UART_RSR_ANY            (UART_RSR_OE | UART_RSR_BE | UART_RSR_PE | \
                                 UART_RSR_FE)
/*\}*/

/**
 * The following are deprecated defines for the Reset Values for UART
 * Registers.
 */
/*\{*/
#define UART_RV_CTL             0x00000300
#define UART_RV_PCellID1        0x000000F0
#define UART_RV_PCellID3        0x000000B1
#define UART_RV_FR              0x00000090
#define UART_RV_PeriphID2       0x00000018
#define UART_RV_IFLS            0x00000012
#define UART_RV_PeriphID0       0x00000011
#define UART_RV_PCellID0        0x0000000D
#define UART_RV_PCellID2        0x00000005
#define UART_RV_PeriphID3       0x00000001
#define UART_RV_PeriphID4       0x00000000
#define UART_RV_LCR_H           0x00000000
#define UART_RV_PeriphID6       0x00000000
#define UART_RV_DR              0x00000000
#define UART_RV_RSR             0x00000000
#define UART_RV_ECR             0x00000000
#define UART_RV_PeriphID5       0x00000000
#define UART_RV_RIS             0x00000000
#define UART_RV_FBRD            0x00000000
#define UART_RV_IM              0x00000000
#define UART_RV_MIS             0x00000000
#define UART_RV_ICR             0x00000000
#define UART_RV_PeriphID1       0x00000000
#define UART_RV_PeriphID7       0x00000000
#define UART_RV_IBRD            0x00000000
/*\}*/

#endif /* DEPRECATED */

#endif /* LM3S_UART_H */
